### Name: maPlot
### Title: Scatter-plots for cDNA microarray spot statistics
### Aliases: maPlot
### Keywords: hplot

### ** Examples


# To see the demo type demo(marrayPlots)

# Examples use swirl dataset, for description type ? swirl
data(swirl)

# Pre-normalization MA-plot for the Swirl 93 array, with the lowess fits for 
# individual print-tip-groups. 
# - Default arguments
maPlot(swirl[,3])

# Lowess fit using all spots
maPlot(swirl[,3], z=NULL, legend.func=NULL)

# Loess fit using all spots
maPlot(swirl[,3], z=NULL, legend.func=maLegendLines(legend="All spots",col="green"), lines.func=maLoessLines(loess.args=list(span=0.3),col="green"))

# Pre-normalization MA-plot for the Swirl 81 array, with the lowess fits for 
# individual grid columns and 1% tails of M highlighted
defs <- maDefaultPar(swirl[, 1], x = "maA", y = "maM", z = "maGridCol")
legend.func <- do.call("maLegendLines", defs$def.legend)
lines.func <- do.call("maLowessLines", c(list(TRUE, f = 0.3), defs$def.lines))
text.func<-maText(subset=maTop(maM(swirl)[,1],h=0.01,l=0.01), labels="o", col="violet")
maPlot(swirl[, 1], x = "maA", y = "maM", z = "maGridCol", lines.func=lines.func, text.func = text.func, legend.func=legend.func, main = "Swirl array 81: pre-normalization MA-plot")




