### Name: kooperberg
### Title: Kooperberg Model-Based Background Correction
### Aliases: kooperberg
### Keywords: models

### ** Examples

#  This is example code for reading and background correcting GenePix data
#  given GenePix Results (gpr) files in the working directory (data not
#  provided).
## Not run: 
##D genepixFiles <- dir(pattern="\\.gpr") # get the names of the GenePix image analysis output files in the current directory
##D read.series(genepixFiles, suffix=NULL, skip=26, sep="\t") # read in GenePix files
##D layout <- list(ngrid.r=12, ngrid.c=4, nspot.r=26, nspot.c=26) # specify array layout
##D RGmodel <- kooperberg(genepixFiles, layout=layout) # model-based background correction
##D MA <- normalizeWithinArrays(RGModel, layout) # normalize the data
## End(Not run)



