### Name: erode.hexbin
### Title: Erosion of a Hexagon Count Image
### Aliases: erode.hexbin
### Keywords: hplot

### ** Examples


set.seed(153)
x <- rnorm(10000)
y <- rnorm(10000)
bin <- hexbin(x,y)

## bivariate boxplot
smbin  <- smooth.hexbin(bin)
erodebin <- erode.hexbin(smbin,cdfcut=.5)
hboxplot(erodebin)

# show erosion order
oldpar <- par(no.readonly=TRUE)
screenpar <- plot.hexbin(bin,style= "lat", minarea=1, maxarea=1,
                         legend=FALSE, border=gray(.7))
par(screenpar)      # reset to the plot on the screen

hexagons(erodebin,style= "lat", minarea=1, maxarea=1,pen="green")
xy <- hcell2xy(erodebin)
text(xy, lab = as.character(erodebin$erode),col="white",cex=.65)
par(oldpar)



