### Name: contrastTest
### Title: 'contrastTest' performs simultaneous tests of linear contrasts
###   on the parameters estimates from a linear model.
### Aliases: contrastTest
### Keywords: models design htest

### ** Examples


data(estrogen)
ES <- pData(estrogen)[["ES"]]
TIME <- pData(estrogen)[["TIME"]]   
fit <- lm(exprs(estrogen)[6,] ~ ES + TIME + ES*TIME)
betaNames <- names(fit[["coef"]])
betas <- list(c("TIME48h","ESP:TIME48h"))
coefs <- list(c(1,1))
lambda <- par2lambda(betaNames,betas,coefs)
contrastTest(fit,lambda)






