.packageName <- "Ruuid"
#Copyright R. Gentleman, 2003, All rights reserved

getuuid <- function(cur)
{
    if (missing(cur))
        x <- .Call("Ruuid_getuuid")
    else if (inherits(cur,"uuidt")) {
        y <- .Call("Ruuid_uuid2str", cur)
        x <- new("Ruuid",stringRep=y, uuid=cur)
    }
    else if (is.character(cur)) {
        y <- .Call("Ruuid_str2uuid", cur)
        x <- new("Ruuid",stringRep=cur,uuid=y)
    }
    else {
        stop("Incorrect parameter type")
    }
    x
}

.initRuuidMethods <- function(where) {
    if (is.null(getGeneric("stringRep")))
        setGeneric("stringRep", function(object)
                   standardGeneric("stringRep"), where=where)

    setMethod("stringRep", "Ruuid", function(object)
              object@stringRep, where=where)

    setMethod("print", "Ruuid", function(x)
              print(stringRep(x)),where=where)

    setMethod("as.character", "Ruuid", function(x) stringRep(x), where=where)


    setMethod("==", signature("Ruuid", "Ruuid"),
              function(e1, e2) stringRep(e1) == stringRep(e2), where=where)

    setMethod("!=", signature("Ruuid", "Ruuid"),
              function(e1, e2) stringRep(e1) != stringRep(e2), where=where)

    setMethod("print", "uuidt", function(x) {
        z <- .Call("Ruuid_printuuid", x)
        print(z)
    }, where=where)
}

setGeneric("Ruuid", function(object)
           standardGeneric("Ruuid"))

setClass("Ruuid", representation(stringRep="character",
                                 uuid="uuidt"))


if (is.null(getGeneric("uuid")))
    setGeneric("uuid", function(object)
               standardGeneric("uuid"))

setMethod("uuid", "Ruuid", function(object)
          object@uuid)

## uuid_t class
setGeneric("uuidt", function(object)
           standardGeneric("uuidt"))
setClass("uuidt", representation(uuid="character"))

setMethod("uuid", "uuidt", function(object)
          object@uuid)
.First.lib <-
function(libname, pkgname,where)
{
     if (missing(where)) {
        where <- match(paste("package:", pkgname, sep=""), search())
        if(is.na(where)) {
            warning(paste("Not a package name: ",pkgname))
            return()
        }
        where <- pos.to.env(where)
    }

 library.dynam("Ruuid", pkgname, libname)
 .initRuuidMethods(where)
}

