\name{AUC}
\alias{AUC}
\alias{AUCi}
\alias{pAUC}
\alias{pAUCi}
\alias{ROC}
\title{ functionals of ROC curve }
\description{various functionals of ROC curves
}
\usage{
AUC(rocobj)
pAUC(rocobj,t0)
}
\arguments{
  \item{rocobj}{ element of class rocc}
  \item{t0}{ FPR point at which TPR is evaluated 
          or limit in (0,1) to integrate to}
}
\details{
AUC employs trapezoidal rule.  AUCi uses integrate().
}
\value{
}
\references{  }
\author{  }
\note{  }


\seealso{  }

\examples{
set.seed(123)
R1 <- rocdemo.sca( rbinom(40,1,.3), rnorm(40), dxrule.sca,
   caseLabel="new case", markerLabel="demo Marker" )
print(AUC(R1))
print(pAUC(R1,.3))
print(pAUCi(R1,.3))
print(ROC(R1,.3))
}
\keyword{ models }


\eof
\name{plot-methods}
\docType{methods}
\title{plot method for ROC curves}
\description{plot method for ROC curves}
\alias{plot,rocc,missing-method}
\section{Methods}{\describe{
\item{x = rocc, y = missing}{ plots an ROC curve object, with
additional parameters available:
 {
 \describe{
  \item{show.thresh (logical):}{should marker threshold values be plotted?}
  \item{jit (logical):}{should plotted points be jittered?}
  \item{add (logical):}{increment to current plot?}
  \item{line (logical):}{plot points or lines?}
}}}}}
\examples{
set.seed(123)
R1 <- rocdemo.sca( rbinom(40,1,.3), rnorm(40), dxrule.sca,
   caseLabel="new case", markerLabel="demo Marker" )
plot(R1, line=TRUE, show.thresh=TRUE)
}
\keyword{methods}


\eof
\name{rocc-class}
\docType{class}
\alias{rocc-class}
\alias{.initClasses}
\title{Class rocc, ROC curve representation }
\description{object representing ROC curve, typically created using rocdemo.sca }
\section{Creating Objects}{
\code{  new('rocc',}\cr
\code{    sens        = ...., # Object of class numeric}\cr
\code{    spec        = ...., # Object of class numeric}\cr
\code{    rule        = ...., # Object of class function}\cr
\code{    cuts        = ...., # Object of class numeric}\cr
\code{    markerLabel = ...., # Object of class character}\cr
\code{    caseLabel   = ...., # Object of class character}\cr
\code{  )}}
\section{Slots}{
  \describe{
    \item{\code{sens}:}{Object of class "numeric" sensitivity values }
    \item{\code{spec}:}{Object of class "numeric" specificity values }
    \item{\code{rule}:}{Object of class "function" rule to classify objects }
    \item{\code{cuts}:}{Object of class "numeric" thresholds defining curve }
    \item{\code{markerLabel}:}{Object of class "character" name of measured marker }
    \item{\code{caseLabel}:}{Object of class "character" name of condition }
  }
}

\section{Methods}{
  \describe{
    \item{plot}{(rocc, missing): a plotting function with some additional parameters }
  }
}

\examples{
set.seed(123)
R1 <- rocdemo.sca( rbinom(40,1,.3), rnorm(40), dxrule.sca,
   caseLabel="new case", markerLabel="demo Marker" )
plot( R1, show.thresh=TRUE )
}

\keyword{methods}


\eof
\name{rocdemo.sca}
\alias{rocdemo.sca}
\alias{dxrule.sca}
\title{ function to build objects of class 'rocc'  }
\description{
rocdemo.sca -- demonstrate 'rocc' class construction
using a scalar marker and simple functional rule
}
\usage{
rocdemo.sca(truth, data, rule, 
       seqlen=20, cutpts=seq(min(data), max(data), length = seqlen), 
       markerLabel="unnamed marker", caseLabel="unnamed diagnosis")
}
\arguments{
  \item{truth}{ true classification of objects}
  \item{data}{ quantitative markers used to classify}
  \item{rule}{ rule: a function with arguments}
  \item{seqlen}{ number of thresholds}
  \item{cutpts}{ values of thresholds}
  \item{markerLabel}{ textual label describing marker}
  \item{caseLabel}{ textual label describing classification}
}
\details{

dxrule.sca is function (x, thresh) ifelse(x > thresh, 1, 0)

}
\value{
an object of S4 class rocc
}
\references{  }
\author{Vince Carey (stvjc@channing.harvard.edu)  }
\note{  }


\seealso{  }

\examples{
set.seed(123)
R1 <- rocdemo.sca( rbinom(40,1,.3), rnorm(40), dxrule.sca,
   caseLabel="new case", markerLabel="demo Marker" )
plot(R1, line=TRUE, show.thresh=TRUE)
}
\keyword{ models }


\eof
\name{trapezint}
\alias{trapezint}
\title{trapezoidal rule for AUC  }
\description{trapezoidal rule for AUC
}
\usage{
trapezint(x, y, a, b)
}
\arguments{
  \item{x}{ x - abscissae}
  \item{y}{ y - ordinates}
  \item{a}{ a - lower limit of integration}
  \item{b}{ b - upper limit of integration}
}
\details{
uses approx
}
\value{
estimated AUC
}
\references{  }
\author{  }
\note{  }
\seealso{  }
\examples{
x <- sort(runif(30))
y <- sin(x)
print(trapezint(x,y,0,1))
}
\keyword{ models }


\eof
