package com.abien.winery.presentation.table;

import com.abien.winery.business.winesearch.domain.Wine;
import com.abien.winery.business.winesearch.facade.WineSearch;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.faces.model.ListDataModel;

/**
 *
 * @author blog.adam-bien.com
 */
public class WineDataModel extends ListDataModel {
    public static final String AGE = "AGE";
    public static final String IMAGE = "IMAGE";
    public static final String NAME = "NAME";
    public static final String PRICE = "PRICE";

    private String wineName;
    private WineSearch search;
    private List rows = new ArrayList();

	public WineDataModel() {
        this.setWrappedData(initialData());
    }

    public WineDataModel(WineSearch search) {
        this.search = search;
        this.setWrappedData(rows);
    }


    public void setWineName(String wineName) {
        this.wineName = wineName;
        this.refreshTable();
    }

    public String getWineName() {
        return wineName;
    }


    public void refreshTable() {
        rows.clear();
        List<Wine> foundWines = this.search.findByName(this.wineName);
        for (Wine wine : foundWines) {
        Map<String,String> row = new TreeMap<String, String>();
            row.put(NAME, wine.getName());
            row.put(AGE, String.valueOf(wine.getAge()));
            row.put(IMAGE, wine.getImageUrl());
            row.put(PRICE, wine.getPrice().toPlainString());
            rows.add(row);
        }
    }

	public List initialData() {
        List initialRows = new ArrayList();
        for (int i = 0; i < 2; i++) {
            Map<String,String> row = new TreeMap<String, String>();
            row.put(NAME, "Name");
            row.put(AGE, "Age");
            row.put(IMAGE, "Image");
            row.put(PRICE, "Price");
            initialRows.add(row);
        }
        return initialRows;
	}

}