/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.abien.winery.business.winesearch.facade;

import com.abien.winery.business.PersistenceTestSupport;
import static com.abien.winery.business.winesearch.WineryBuilder.*;
import com.abien.winery.business.winesearch.domain.Wine;
import com.abien.winery.business.winesearch.domain.Winery;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author blog.adam-bien.com
 */
public class WineSearchBeanTest extends PersistenceTestSupport{

    private WineSearchBean searchBean;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.searchBean = new WineSearchBean();
        this.searchBean.em = this.em;
    }

    @Test
    public void testFindByName() {
        Winery winery = getWinery();
        this.et.begin();
        this.searchBean.update(winery);
        this.et.commit();
        List<Wine> result = this.searchBean.findByName("wine");
        assertEquals(2,result.size());
        result = this.searchBean.findByName("nice");
        assertEquals(1,result.size());

        result = this.searchBean.findByName("red");
        assertEquals(1,result.size());

        result = this.searchBean.findByName("NOT EXISTING");
        assertEquals(0,result.size());
    }

}