
package com.abien.winery.business.winesearch.facade;

import com.abien.winery.business.winesearch.domain.Wine;
import com.abien.winery.business.winesearch.domain.Winery;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/**
 *
 * @author blog.adam-bien.com
 */
@Stateless
@Local(WineSearch.class)
public class WineSearchBean implements WineSearch {

    @PersistenceContext
    EntityManager em;

    private final static String WILD_CARD ="%";

    public Winery update(Winery winery){
        return this.em.merge(winery);
    }

    public List<Wine> findByName(String name) {
       return this.em.createNamedQuery(Wine.findWineByName).
               setParameter("name",prepareName(name)).
               getResultList();
    }

    private String prepareName(String name) {
        return WILD_CARD + name.toUpperCase() + WILD_CARD;
    }
}
