/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.rowset.internal;

import com.sun.sql.rowset.CachedRowSetX;
import com.sun.sql.rowset.CachedRowSetXImpl;
import com.sun.sql.rowset.RowSetMetaDataXImpl;
import com.sun.sql.rowset.internal.CachedRowSetXReader;
import com.sun.sql.rowset.internal.SyncResolverXImpl;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.sql.RowSetInternal;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.spi.SyncProviderException;
import javax.sql.rowset.spi.TransactionalWriter;

public class CachedRowSetXWriter
implements TransactionalWriter,
Serializable {
    private static ResourceBundle rb = ResourceBundle.getBundle("com.sun.sql.rowset.internal.Bundle", Locale.getDefault());
    private Connection con;
    private String selectCmd;
    private String updateCmd;
    private String updateWhere;
    private String deleteCmd;
    private String deleteWhere;
    private String insertCmd;
    private List insertableColumnsInThisTable;
    private List updatableColumnsInThisTable;
    private List whereColumnsInThisTable;
    private String[] realColumnNames;
    private int[] keyCols;
    private Object[] params;
    private CachedRowSetXReader reader;
    private ResultSetMetaData callerMd;
    private int callerColumnCount;
    private CachedRowSetXImpl crsResolve;
    private ArrayList status;
    private ArrayList exceptions;
    private int iChangedValsInDbAndCRS;
    private int iChangedValsinDbOnly;

    public boolean writeData(RowSetInternal caller) throws SQLException {
        boolean conflict = false;
        boolean showDel = false;
        PreparedStatement pstmtIns = null;
        this.iChangedValsInDbAndCRS = 0;
        this.iChangedValsinDbOnly = 0;
        CachedRowSetXImpl crs = (CachedRowSetXImpl)caller;
        this.crsResolve = CachedRowSetXImpl.createInternalUseInstance();
        this.con = this.reader.connect(caller);
        if (this.con == null) {
            throw new SQLException(rb.getString("UNABLE_TO_GET_CONNECTION"));
        }
        if (this.con.getAutoCommit()) {
            this.con.setAutoCommit(false);
        }
        this.con.setTransactionIsolation(crs.getTransactionIsolation());
        this.initSQLStatements(crs);
        RowSetMetaDataXImpl rsmdWrite = (RowSetMetaDataXImpl)crs.getMetaData();
        RowSetMetaDataXImpl rsmdResolv = new RowSetMetaDataXImpl();
        int iColCount = rsmdWrite.getColumnCount();
        int sz = crs.size() + 1;
        this.status = new ArrayList(sz);
        this.exceptions = new ArrayList(sz);
        this.status.add(0, null);
        this.exceptions.add(0, null);
        rsmdResolv.setColumnCount(iColCount);
        boolean[] insertableColumns = crs.getInsertableColumns();
        boolean[] updatableColumns = crs.getUpdatableColumns();
        for (int i = 1; i <= iColCount; ++i) {
            rsmdResolv.setColumnType(i, rsmdWrite.getColumnType(i));
            rsmdResolv.setColumnName(i, rsmdWrite.getColumnName(i));
            rsmdResolv.setColumnLabel(i, rsmdWrite.getColumnLabel(i));
            rsmdResolv.setNullable(i, 2);
            rsmdResolv.setColumnClassName(i, rsmdWrite.getColumnClassName(i));
            if (insertableColumns != null && insertableColumns.length >= i) {
                rsmdResolv.setWritable(i, insertableColumns[i - 1]);
                rsmdResolv.setDefinitelyWritable(i, insertableColumns[i - 1]);
                rsmdResolv.setReadOnly(i, !insertableColumns[i - 1]);
                continue;
            }
            if (updatableColumns != null && updatableColumns.length >= i) {
                rsmdResolv.setWritable(i, updatableColumns[i - 1]);
                rsmdResolv.setDefinitelyWritable(i, updatableColumns[i - 1]);
                rsmdResolv.setReadOnly(i, !updatableColumns[i - 1]);
                continue;
            }
            rsmdResolv.setWritable(i, true);
            rsmdResolv.setDefinitelyWritable(i, false);
            rsmdResolv.setReadOnly(i, false);
        }
        this.crsResolve.setMetaData(rsmdResolv);
        if (crs.getPrintStatements()) {
            System.out.println(this.insertCmd);
        }
        pstmtIns = this.con.prepareStatement(this.insertCmd);
        if (this.callerColumnCount < 1) {
            if (crs.getPrintStatements()) {
                System.out.println("No columns found (callerColumnCount==0).");
            }
            if (this.reader.getCloseConnection()) {
                try {
                    if (!this.con.getAutoCommit()) {
                        this.con.rollback();
                    }
                }
                catch (Exception dummy) {
                    // empty catch block
                }
                this.con.close();
                this.con = null;
            }
            return true;
        }
        showDel = crs.getShowDeleted();
        crs.setShowDeleted(true);
        crs.beforeFirst();
        int rows = 1;
        while (crs.next()) {
            if (crs.rowDeleted()) {
                if (crs.rowInserted()) {
                    this.status.add(rows, new Integer(3));
                    this.exceptions.add(rows, null);
                } else {
                    try {
                        this.deleteOriginalRow(crs, this.crsResolve);
                        this.status.add(rows, new Integer(3));
                        this.exceptions.add(rows, null);
                    }
                    catch (SQLException sqle) {
                        this.status.add(rows, new Integer(1));
                        this.exceptions.add(rows, sqle);
                    }
                }
            } else if (crs.rowInserted()) {
                try {
                    this.insertNewRow(crs, pstmtIns, this.crsResolve);
                    this.status.add(rows, new Integer(3));
                    this.exceptions.add(rows, null);
                }
                catch (SQLException sqle) {
                    this.status.add(rows, new Integer(2));
                    this.exceptions.add(rows, sqle);
                }
            } else if (crs.rowUpdated()) {
                try {
                    this.updateOriginalRow(crs);
                    this.status.add(rows, new Integer(3));
                    this.exceptions.add(rows, null);
                }
                catch (SQLException sqle) {
                    this.status.add(rows, new Integer(0));
                    this.exceptions.add(rows, sqle);
                }
            } else {
                int icolCount = crs.getMetaData().getColumnCount();
                this.status.add(rows, new Integer(3));
                this.exceptions.add(rows, null);
                this.crsResolve.moveToInsertRow();
                for (int cols = 0; cols < iColCount; ++cols) {
                    this.crsResolve.updateNull(cols + 1);
                }
                this.crsResolve.insertRow();
                this.crsResolve.moveToCurrentRow();
            }
            ++rows;
        }
        try {
            pstmtIns.close();
        }
        catch (SQLException e) {
            System.err.println(MessageFormat.format(rb.getString("NON_FATAL_ERROR"), e));
        }
        crs.setShowDeleted(showDel);
        boolean boolConf = false;
        int noOfConflicts = 0;
        for (int j = 1; j < this.status.size(); ++j) {
            if (this.status.get(j).equals(new Integer(3))) continue;
            boolConf = true;
            ++noOfConflicts;
        }
        crs.beforeFirst();
        this.crsResolve.beforeFirst();
        if (boolConf) {
            SyncProviderException spe = new SyncProviderException(MessageFormat.format(rb.getString("NO_OF_CONFLICTS"), new Integer(noOfConflicts)));
            spe.setSyncResolver(new SyncResolverXImpl());
            SyncResolverXImpl syncResImpl = (SyncResolverXImpl)spe.getSyncResolver();
            syncResImpl.setCachedRowSet(crs);
            syncResImpl.setCachedRowSetResolver(this.crsResolve);
            syncResImpl.setStatus(this.status);
            syncResImpl.setExceptions(this.exceptions);
            syncResImpl.setCachedRowSetXWriter(this);
            throw spe;
        }
        return true;
    }

    private void updateOriginalRow(CachedRowSet crs) throws SQLException {
        int i = 0;
        int idx = 0;
        ResultSet origVals = crs.getOriginalRow();
        origVals.next();
        try {
            this.updateWhere = this.buildWhereClause(this.updateWhere, origVals);
            if (((CachedRowSetX)crs).getPrintStatements()) {
                System.out.println(this.selectCmd + this.updateWhere);
            }
            PreparedStatement pstmt = this.con.prepareStatement(this.selectCmd + this.updateWhere, 1005, 1007);
            StringBuffer msg = null;
            for (i = 0; i < this.keyCols.length; ++i) {
                if (((CachedRowSetX)crs).getPrintStatements()) {
                    if (msg == null) {
                        msg = new StringBuffer(100);
                    }
                    msg.append("  Paramm[" + (idx + 1) + "]=(");
                    if (this.params[i] != null) {
                        msg.append(this.params[i].getClass().getName() + "," + this.params[i].toString() + ")");
                    } else {
                        msg.append("null)");
                    }
                }
                if (this.params[i] == null) continue;
                pstmt.setObject(++idx, this.params[i]);
            }
            if (msg != null) {
                System.out.println(msg);
            }
            try {
                pstmt.setMaxRows(2);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                pstmt.setMaxFieldSize(crs.getMaxFieldSize());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                pstmt.setEscapeProcessing(crs.getEscapeProcessing());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                pstmt.setQueryTimeout(crs.getQueryTimeout());
            }
            catch (Exception ex) {
                // empty catch block
            }
            ResultSet rs = null;
            if (((CachedRowSetX)crs).getPrintStatements()) {
                System.out.println("Writer:  executing pre-update SELECT");
            }
            if ((rs = pstmt.executeQuery()).next()) {
                if (rs.next()) {
                    if (((CachedRowSetX)crs).getPrintStatements()) {
                        System.out.println("   Writer: pre-update SELECT returned >1 row:  BAD");
                    }
                    return;
                }
                rs.first();
                int colsNotChanged = 0;
                Vector<Integer> cols = new Vector<Integer>();
                String updateExec = new String(this.updateCmd);
                boolean boolNull = true;
                Object objVal = null;
                boolean first = true;
                this.crsResolve.moveToInsertRow();
                for (i = 1; i <= this.callerColumnCount; ++i) {
                    if (!this.updatableColumnsInThisTable.contains(new Integer(i))) {
                        ++colsNotChanged;
                        continue;
                    }
                    Object orig = origVals.getObject(i);
                    Object curr = crs.getObject(i);
                    Object rsval = rs.getObject(this.whereColumnsInThisTable.indexOf(new Integer(i)) + 1);
                    boolNull = true;
                    if (rsval == null && orig != null || rsval != null && !rsval.equals(orig)) {
                        ++this.iChangedValsinDbOnly;
                        boolNull = false;
                        objVal = rsval;
                    } else if (orig == null || curr == null) {
                        if (!first) {
                            updateExec = updateExec + ", ";
                        }
                        updateExec = updateExec + crs.getMetaData().getColumnName(i);
                        cols.add(new Integer(i));
                        updateExec = updateExec + " = ? ";
                        first = false;
                    } else if (orig == null && curr == null || orig != null && orig.equals(curr)) {
                        ++colsNotChanged;
                    } else if ((orig == null && curr != null || !orig.equals(curr)) && crs.columnUpdated(i)) {
                        if (rsval.equals(orig)) {
                            if (!first) {
                                updateExec = updateExec + ", ";
                            }
                            updateExec = updateExec + crs.getMetaData().getColumnName(i);
                            cols.add(new Integer(i));
                            updateExec = updateExec + " = ? ";
                            first = false;
                        } else {
                            boolNull = false;
                            objVal = rsval;
                            ++this.iChangedValsInDbAndCRS;
                        }
                    }
                    if (!boolNull) {
                        this.crsResolve.updateObject(i, objVal);
                        continue;
                    }
                    this.crsResolve.updateNull(i);
                }
                if (!first && cols.size() == 0 || colsNotChanged == this.callerColumnCount) {
                    if (((CachedRowSetX)crs).getPrintStatements()) {
                        System.out.println("Writer: no columns changed, nothing to update");
                    }
                    return;
                }
                if (this.iChangedValsInDbAndCRS != 0 || this.iChangedValsinDbOnly != 0) {
                    throw new SQLException(rb.getString("VALUES_CHANGED_IN_DB"));
                }
                updateExec = updateExec + this.updateWhere;
                if (((CachedRowSetX)crs).getPrintStatements()) {
                    System.out.println("Writer:  " + updateExec);
                }
                pstmt = this.con.prepareStatement(updateExec);
                msg = null;
                for (i = 0; i < cols.size(); ++i) {
                    if (!this.updatableColumnsInThisTable.contains((Integer)cols.get(i))) continue;
                    Object obj = crs.getObject((Integer)cols.get(i));
                    if (((CachedRowSetX)crs).getPrintStatements()) {
                        if (msg == null) {
                            msg = new StringBuffer(100);
                        }
                        msg.append(" UpdateCol[" + (i + 1) + "]=(");
                        if (obj != null) {
                            msg.append(obj.getClass().getName() + "," + obj.toString() + ")");
                        } else {
                            msg.append("null:" + crs.getMetaData().getColumnType((Integer)cols.get(i)) + ")");
                        }
                    }
                    if (obj != null) {
                        pstmt.setObject(i + 1, obj);
                        continue;
                    }
                    pstmt.setNull(i + 1, crs.getMetaData().getColumnType((Integer)cols.get(i)));
                }
                if (msg != null) {
                    System.out.println(msg);
                }
                idx = i;
                for (i = 0; i < this.keyCols.length; ++i) {
                    if (this.params[i] == null) continue;
                    pstmt.setObject(++idx, this.params[i]);
                }
                if (((CachedRowSetX)crs).getPrintStatements()) {
                    System.out.println("Writer:  executing update() ");
                }
                i = pstmt.executeUpdate();
                this.crsResolve.insertRow();
                this.crsResolve.moveToCurrentRow();
                return;
            }
            if (((CachedRowSetX)crs).getPrintStatements()) {
                System.out.println("   Writer: pre-update SELECT returned 0 rows");
            }
            throw new SQLException(rb.getString("ATTEMPT_TO_UPDATE_ROW_UP_OR_DEL"));
        }
        catch (SQLException ex) {
            this.crsResolve.moveToInsertRow();
            for (i = 1; i <= this.callerColumnCount; ++i) {
                this.crsResolve.updateNull(i);
            }
            this.crsResolve.insertRow();
            this.crsResolve.moveToCurrentRow();
            throw ex;
        }
    }

    private void insertNewRow(CachedRowSet crs, PreparedStatement pstmt, CachedRowSetXImpl crsRes) throws SQLException {
        int i = 0;
        int icolCount = 0;
        try {
            icolCount = crs.getMetaData().getColumnCount();
            int pstmtColIdx = 1;
            StringBuffer msg = null;
            for (i = 1; i <= icolCount; ++i) {
                if (!this.insertableColumnsInThisTable.contains(new Integer(i))) continue;
                Object obj = crs.getObject(i);
                if (((CachedRowSetX)crs).getPrintStatements()) {
                    if (msg == null) {
                        msg = new StringBuffer(", params: ");
                    }
                    msg.append("  Col[" + i + "]=(");
                    if (obj != null) {
                        msg.append(obj.getClass().getName() + "," + obj.toString() + ")");
                    } else {
                        msg.append("null:" + crs.getMetaData().getColumnType(i) + ")");
                    }
                }
                if (obj != null) {
                    pstmt.setObject(pstmtColIdx++, obj);
                    continue;
                }
                pstmt.setNull(pstmtColIdx++, crs.getMetaData().getColumnType(i));
            }
            if (((CachedRowSetX)crs).getPrintStatements()) {
                System.out.println("Writer:  executing insert " + (msg == null ? "." : msg.toString()));
            }
            i = pstmt.executeUpdate();
            this.crsResolve.moveToInsertRow();
            this.crsResolve.insertRow();
            this.crsResolve.moveToCurrentRow();
        }
        catch (SQLException ex) {
            this.crsResolve.moveToInsertRow();
            for (i = 1; i <= icolCount; ++i) {
                this.crsResolve.updateNull(i);
            }
            this.crsResolve.insertRow();
            this.crsResolve.moveToCurrentRow();
            throw ex;
        }
    }

    private void deleteOriginalRow(CachedRowSet crs, CachedRowSetXImpl crsRes) throws SQLException {
        ResultSet rs;
        int i;
        int idx = 0;
        ResultSet origVals = crs.getOriginalRow();
        origVals.next();
        this.deleteWhere = this.buildWhereClause(this.deleteWhere, origVals);
        if (((CachedRowSetX)crs).getPrintStatements()) {
            System.out.println("Writer:  pre-delete select " + this.selectCmd + this.deleteWhere);
        }
        PreparedStatement pstmt = this.con.prepareStatement(this.selectCmd + this.deleteWhere, 1005, 1007);
        StringBuffer msg = null;
        for (i = 0; i < this.keyCols.length; ++i) {
            if (this.params[i] == null) continue;
            pstmt.setObject(++idx, this.params[i]);
            if (!((CachedRowSetX)crs).getPrintStatements()) continue;
            if (msg == null) {
                msg = new StringBuffer(100);
            }
            msg.append(" DeleteParam[" + idx + "]=(");
            if (this.params[i] != null) {
                msg.append(this.params[i].getClass().getName() + "," + this.params[i].toString() + ")");
                continue;
            }
            msg.append("null");
        }
        if (msg != null) {
            System.out.println(msg);
        }
        try {
            pstmt.setMaxRows(2);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            pstmt.setMaxFieldSize(crs.getMaxFieldSize());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            pstmt.setEscapeProcessing(crs.getEscapeProcessing());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            pstmt.setQueryTimeout(crs.getQueryTimeout());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (((CachedRowSetX)crs).getPrintStatements()) {
            System.out.println("Writer: executing pre-delete select");
        }
        if ((rs = pstmt.executeQuery()).next()) {
            if (rs.next()) {
                throw new SQLException(rb.getString("MORE_THAN_ONE_ROW_MATCHED_DELETE"));
            }
            rs.first();
            boolean boolChanged = false;
            crsRes.moveToInsertRow();
            int rsColIdx = 1;
            for (i = 1; i <= crs.getMetaData().getColumnCount(); ++i) {
                if (!this.whereColumnsInThisTable.contains(new Integer(i))) continue;
                if (origVals.getObject(i) == null && rs.getObject(rsColIdx) == null) {
                    crsRes.updateNull(i);
                } else if (origVals.getObject(i) == null && rs.getObject(rsColIdx) != null || origVals.getObject(i) != null && rs.getObject(rsColIdx) == null || !origVals.getObject(i).toString().equals(rs.getObject(rsColIdx).toString())) {
                    boolChanged = true;
                    crsRes.updateObject(i, origVals.getObject(i));
                } else {
                    crsRes.updateNull(i);
                }
                ++rsColIdx;
            }
            crsRes.insertRow();
            crsRes.moveToCurrentRow();
            if (boolChanged) {
                throw new SQLException(rb.getString("WILL_NOT_DELETE_AS_DB_VALS_CHANGED"));
            }
            String cmd = this.deleteCmd + this.deleteWhere;
            pstmt = this.con.prepareStatement(cmd);
            idx = 0;
            for (i = 0; i < this.keyCols.length; ++i) {
                if (this.params[i] == null) continue;
                pstmt.setObject(++idx, this.params[i]);
            }
            if (((CachedRowSetX)crs).getPrintStatements()) {
                System.out.println("Writer:  executing delete " + cmd);
            }
            if (pstmt.executeUpdate() != 1) {
                throw new SQLException(rb.getString("DELETED_MORE_THAN_ONE_ROW"));
            }
        } else {
            throw new SQLException(rb.getString("DID_NOT_FIND_ROW_TO_DELETE"));
        }
        pstmt.close();
    }

    public void setReader(CachedRowSetXReader reader) throws SQLException {
        this.reader = reader;
    }

    public CachedRowSetXReader getReader() throws SQLException {
        return this.reader;
    }

    private void initSQLStatements(CachedRowSet caller) throws SQLException {
        int i;
        String schema;
        this.callerMd = caller.getMetaData();
        this.callerColumnCount = this.callerMd.getColumnCount();
        if (this.callerColumnCount < 1) {
            return;
        }
        String table = caller.getTableName();
        if (table == null && ((table = this.callerMd.getTableName(1)) == null || table.length() == 0)) {
            throw new SQLException(rb.getString("CANNOT_DETERMINE_TABLE_NAME"));
        }
        String catalog = ((CachedRowSetX)caller).getCatalogName();
        if (catalog == null && (catalog = this.callerMd.getCatalogName(1)) != null && catalog.length() == 0) {
            catalog = null;
        }
        if ((schema = ((CachedRowSetX)caller).getSchemaName()) == null && (schema = this.callerMd.getSchemaName(1)) != null && schema.length() == 0) {
            schema = null;
        }
        DatabaseMetaData dbmd = this.con.getMetaData();
        this.realColumnNames = new String[this.callerColumnCount];
        String[] callerColumnNames = ((CachedRowSetX)caller).getColumnNames();
        for (i = 0; i < this.callerColumnCount; ++i) {
            this.realColumnNames[i] = this.callerMd.getColumnName(i + 1);
            if (callerColumnNames == null || callerColumnNames.length <= i || callerColumnNames[i] == null) continue;
            this.realColumnNames[i] = callerColumnNames[i];
        }
        this.whereColumnsInThisTable = new ArrayList();
        String[] columnCatalogNames = ((CachedRowSetX)caller).getColumnCatalogNames();
        String[] columnSchemaNames = ((CachedRowSetX)caller).getColumnSchemaNames();
        String[] columnTableNames = ((CachedRowSetX)caller).getColumnTableNames();
        boolean relaxed = columnCatalogNames == null && columnSchemaNames == null && columnTableNames == null && ((CachedRowSetX)caller).getCatalogName() == null && ((CachedRowSetX)caller).getSchemaName() == null;
        for (i = 0; i < this.callerColumnCount; ++i) {
            if (!this.matcher(i, catalog, columnCatalogNames, this.callerMd.getCatalogName(i + 1), relaxed) || !this.matcher(i, schema, columnSchemaNames, this.callerMd.getSchemaName(i + 1), relaxed) || !this.matcher(i, table, columnTableNames, this.callerMd.getTableName(i + 1), relaxed)) continue;
            boolean match = true;
            if (columnCatalogNames == null && columnSchemaNames == null && columnTableNames == null) {
                match = CachedRowSetXWriter.isColumnPartOfTable(dbmd, this.realColumnNames[i], catalog, schema, table, this.callerMd.getTableName(i + 1));
            }
            if (!match) continue;
            this.whereColumnsInThisTable.add(new Integer(i + 1));
        }
        this.updatableColumnsInThisTable = new ArrayList();
        boolean[] callerUpdatableColumns = ((CachedRowSetX)caller).getUpdatableColumns();
        for (i = 0; i < this.callerColumnCount; ++i) {
            boolean match = callerUpdatableColumns != null && callerUpdatableColumns.length > i ? callerUpdatableColumns[i] : this.whereColumnsInThisTable.contains(new Integer(i + 1));
            if (!match) continue;
            this.updatableColumnsInThisTable.add(new Integer(i + 1));
        }
        this.insertableColumnsInThisTable = new ArrayList();
        boolean[] callerInsertableColumns = ((CachedRowSetX)caller).getInsertableColumns();
        for (i = 0; i < this.callerColumnCount; ++i) {
            boolean match = callerInsertableColumns != null && callerInsertableColumns.length > i ? callerInsertableColumns[i] : this.updatableColumnsInThisTable.contains(new Integer(i + 1));
            if (!match) continue;
            this.insertableColumnsInThisTable.add(new Integer(i + 1));
        }
        boolean firstTime = true;
        this.selectCmd = "SELECT ";
        if (this.whereColumnsInThisTable.size() == 0) {
            throw new SQLException(MessageFormat.format(rb.getString("NO_COLS_IN_TABLE"), table));
        }
        for (i = 0; i < this.callerColumnCount; ++i) {
            if (!this.whereColumnsInThisTable.contains(new Integer(i + 1))) continue;
            if (firstTime) {
                firstTime = false;
            } else {
                this.selectCmd = this.selectCmd + ", ";
            }
            this.selectCmd = this.selectCmd + this.realColumnNames[i];
        }
        this.selectCmd = this.selectCmd + " ";
        this.selectCmd = this.selectCmd + "FROM " + this.buildTableName(dbmd, catalog, schema, table);
        this.updateCmd = "UPDATE " + this.buildTableName(dbmd, catalog, schema, table);
        this.updateCmd = this.updateCmd + "SET ";
        this.insertCmd = "INSERT INTO " + this.buildTableName(dbmd, catalog, schema, table);
        this.insertCmd = this.insertCmd + "(";
        firstTime = true;
        for (i = 0; i < this.callerColumnCount; ++i) {
            if (!this.insertableColumnsInThisTable.contains(new Integer(i + 1))) continue;
            if (firstTime) {
                firstTime = false;
            } else {
                this.insertCmd = this.insertCmd + ", ";
            }
            this.insertCmd = this.insertCmd + this.realColumnNames[i];
        }
        this.insertCmd = this.insertCmd + ") VALUES (";
        firstTime = true;
        for (i = 0; i < this.callerColumnCount; ++i) {
            if (!this.insertableColumnsInThisTable.contains(new Integer(i + 1))) continue;
            if (firstTime) {
                firstTime = false;
            } else {
                this.insertCmd = this.insertCmd + ", ";
            }
            this.insertCmd = this.insertCmd + "?";
        }
        this.insertCmd = this.insertCmd + ")";
        this.deleteCmd = "DELETE FROM " + this.buildTableName(dbmd, catalog, schema, table);
        this.buildKeyDesc(caller);
    }

    private String buildTableName(DatabaseMetaData dbmd, String catalog, String schema, String table) throws SQLException {
        String cmd = new String();
        if (catalog != null) {
            catalog = catalog.trim();
        }
        if (schema != null) {
            schema = schema.trim();
        }
        if (table != null) {
            table = table.trim();
        }
        if (dbmd.isCatalogAtStart()) {
            if (catalog != null && catalog.length() > 0) {
                cmd = cmd + catalog + dbmd.getCatalogSeparator();
            }
            if (schema != null && schema.length() > 0) {
                cmd = cmd + schema + ".";
            }
            cmd = cmd + table;
        } else {
            if (schema != null && schema.length() > 0) {
                cmd = cmd + schema + ".";
            }
            cmd = cmd + table;
            if (catalog != null && catalog.length() > 0) {
                cmd = cmd + dbmd.getCatalogSeparator() + catalog;
            }
        }
        cmd = cmd + " ";
        return cmd;
    }

    private boolean matcher(int idx, String value, String[] columnValueNames, String rsmdName, boolean relaxedMatch) {
        int pos = rsmdName.lastIndexOf(46);
        if (pos != -1) {
            rsmdName = rsmdName.substring(pos + 1);
        }
        String columnValue = null;
        if (columnValueNames != null && columnValueNames.length > idx && columnValueNames[idx] != null) {
            columnValue = columnValueNames[idx];
        }
        if (columnValue == null && (columnValue = rsmdName) != null && columnValue.length() == 0) {
            columnValue = null;
        }
        if (value == null && columnValue != null || value != null && columnValue == null) {
            return relaxedMatch;
        }
        return value == null && columnValue == null || columnValue.equals(value);
    }

    private void buildKeyDesc(CachedRowSet crs) throws SQLException {
        this.keyCols = new int[this.whereColumnsInThisTable.size()];
        int idx = 0;
        Iterator i = this.whereColumnsInThisTable.iterator();
        while (i.hasNext()) {
            this.keyCols[idx++] = (Integer)i.next();
        }
        this.params = new Object[this.keyCols.length];
    }

    private String buildWhereClause(String whereClause, ResultSet rs) throws SQLException {
        whereClause = "WHERE ";
        boolean firstTime = true;
        for (int i = 0; i < this.keyCols.length; ++i) {
            if (firstTime) {
                firstTime = false;
            } else {
                whereClause = whereClause + "AND ";
            }
            whereClause = whereClause + this.callerMd.getColumnName(this.keyCols[i]);
            this.params[i] = rs.getObject(this.keyCols[i]);
            whereClause = rs.wasNull() ? whereClause + " IS NULL " : whereClause + " = ? ";
        }
        return whereClause;
    }

    private static boolean isColumnPartOfTable(DatabaseMetaData dbmd, String columnName, String catalogName, String schemaName, String tableName, String columnTableName) throws SQLException {
        int idx = columnTableName.lastIndexOf(46);
        if (idx != -1) {
            columnTableName = columnTableName.substring(idx + 1);
        }
        ResultSet colRs = dbmd.getColumns(catalogName == null || catalogName.equals("") ? null : catalogName, schemaName == null || schemaName.equals("") ? null : schemaName, tableName, columnName);
        boolean rc = colRs.next();
        colRs.close();
        if (rc) {
            rc = columnTableName == null || columnTableName.equals("") || columnTableName.equals(tableName);
        }
        return rc;
    }

    void updateResolvedConflictToDB(CachedRowSet crs, Connection con) throws SQLException {
        int i;
        int i2;
        String strWhere = "WHERE ";
        String strExec = " ";
        String strUpdate = "UPDATE ";
        int icolCount = crs.getMetaData().getColumnCount();
        int[] keyColumns = crs.getKeyColumns();
        String strSet = "";
        strWhere = this.buildWhereClause(strWhere, crs);
        if (keyColumns == null || keyColumns.length == 0) {
            keyColumns = new int[icolCount];
            int i3 = 0;
            while (i3 < keyColumns.length) {
                keyColumns[i3++] = i3;
            }
        }
        Object[] param = new Object[keyColumns.length];
        strUpdate = "UPDATE " + this.buildTableName(con.getMetaData(), crs.getMetaData().getCatalogName(1), crs.getMetaData().getSchemaName(1), crs.getTableName());
        strUpdate = strUpdate + "SET ";
        boolean first = true;
        for (i2 = 1; i2 <= icolCount; ++i2) {
            if (!crs.columnUpdated(i2)) continue;
            if (!first) {
                strSet = strSet + ", ";
            }
            strSet = strSet + crs.getMetaData().getColumnName(i2);
            strSet = strSet + " = ? ";
            first = false;
        }
        strUpdate = strUpdate + strSet;
        strWhere = "WHERE ";
        for (i2 = 0; i2 < keyColumns.length; ++i2) {
            if (i2 > 0) {
                strWhere = strWhere + "AND ";
            }
            strWhere = strWhere + crs.getMetaData().getColumnName(keyColumns[i2]);
            param[i2] = crs.getObject(keyColumns[i2]);
            strWhere = crs.wasNull() ? strWhere + " IS NULL " : strWhere + " = ? ";
        }
        strUpdate = strUpdate + strWhere;
        if (((CachedRowSetX)crs).getPrintStatements()) {
            System.out.println(strUpdate);
        }
        PreparedStatement pStmt = con.prepareStatement(strUpdate);
        int idx = 0;
        for (i = 0; i < icolCount; ++i) {
            if (!crs.columnUpdated(i + 1)) continue;
            Object obj = crs.getObject(i + 1);
            if (obj != null) {
                pStmt.setObject(++idx, obj);
                continue;
            }
            pStmt.setNull(++idx, crs.getMetaData().getColumnType(i + 1));
        }
        for (i = 0; i < keyColumns.length; ++i) {
            if (param[i] == null) continue;
            pStmt.setObject(++idx, param[i]);
        }
        int id = pStmt.executeUpdate();
    }

    public void commit() throws SQLException {
        this.con.commit();
        if (this.reader.getCloseConnection()) {
            this.con.close();
            this.con = null;
        }
    }

    public void rollback() throws SQLException {
        this.con.rollback();
        if (this.reader.getCloseConnection()) {
            this.con.close();
            this.con = null;
        }
    }

    public void rollback(Savepoint s) throws SQLException {
        this.con.rollback(s);
        if (this.reader.getCloseConnection()) {
            this.con.close();
            this.con = null;
        }
    }

    public void closeConnection() throws SQLException {
        if (this.con != null && this.reader.getCloseConnection()) {
            try {
                if (!this.con.getAutoCommit()) {
                    this.con.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.con.close();
        }
    }
}

