/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.axisChart.BarChart;
import org.krysalis.jcharts.axisChart.customRenderers.axisValue.AxisValueRenderEvent;
import org.krysalis.jcharts.chartData.interfaces.IAxisChartDataSet;
import org.krysalis.jcharts.imageMap.RectMapArea;
import org.krysalis.jcharts.properties.BarChartProperties;
import org.krysalis.jcharts.properties.ClusteredBarChartProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;

abstract class ClusteredBarChart {
    ClusteredBarChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) {
        Graphics2D graphics2D = axisChart.getGraphics2D();
        ClusteredBarChartProperties clusteredBarChartProperties = (ClusteredBarChartProperties)iAxisChartDataSet.getChartTypeProperties();
        if (axisChart.getAxisProperties().isPlotHorizontal()) {
            DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getXAxisProperties();
            float f = axisChart.getYAxis().getScalePixelWidth() * clusteredBarChartProperties.getPercentage();
            float f2 = f / (float)iAxisChartDataSet.getNumberOfDataSets();
            float f3 = axisChart.getXAxis().getZeroLineCoordinate();
            float f4 = axisChart.getYAxis().getLastTickY() - f / 2.0f;
            float f5 = 0.0f;
            float f6 = f2;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f3, f4, f5, f6);
            ClusteredBarChart.horizontalPlot(axisChart, iAxisChartDataSet, clusteredBarChartProperties, dataAxisProperties, graphics2D, float_, f3, f4, f2);
        } else {
            DataAxisProperties dataAxisProperties = (DataAxisProperties)axisChart.getAxisProperties().getYAxisProperties();
            float f = axisChart.getXAxis().getScalePixelWidth() * clusteredBarChartProperties.getPercentage();
            float f7 = f / (float)iAxisChartDataSet.getNumberOfDataSets();
            float f8 = axisChart.getXAxis().getTickStart() - f / 2.0f;
            float f9 = axisChart.getYAxis().getZeroLineCoordinate();
            float f10 = f7;
            float f11 = 0.0f;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f8, f9, f10, f11);
            ClusteredBarChart.verticalPlot(axisChart, iAxisChartDataSet, clusteredBarChartProperties, dataAxisProperties, graphics2D, float_, f8, f9, f7);
        }
    }

    private static void horizontalPlot(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet, ClusteredBarChartProperties clusteredBarChartProperties, DataAxisProperties dataAxisProperties, Graphics2D graphics2D, Rectangle2D.Float float_, float f, float f2, float f3) {
        int n = axisChart.getYAxis().getNumberOfScaleItems() - 1;
        Rectangle2D.Float float_2 = new Rectangle2D.Float();
        float_2.y = axisChart.getYAxis().getOrigin() - axisChart.getYAxis().getPixelLength() + 1.0f;
        float_2.height = axisChart.getYAxis().getScalePixelWidth() - 1.0f;
        float_2.x = axisChart.getXAxis().getOrigin() + 1.0f;
        float_2.width = axisChart.getXAxis().getPixelLength() - 1.0f;
        AxisValueRenderEvent axisValueRenderEvent = new AxisValueRenderEvent(axisChart, iAxisChartDataSet, graphics2D, float_2, axisChart.getXAxis().getZeroLineCoordinate());
        for (int i = 0; i < iAxisChartDataSet.getNumberOfDataItems(); ++i) {
            for (int j = 0; j < iAxisChartDataSet.getNumberOfDataSets(); ++j) {
                graphics2D.setPaint(iAxisChartDataSet.getPaint(j));
                axisValueRenderEvent.setDataSetIndex(j);
                axisValueRenderEvent.setValueX(axisChart.getXAxis().getZeroLineCoordinate());
                axisValueRenderEvent.setValueY((float)float_.getCenterY());
                axisValueRenderEvent.setValueIndex(i);
                clusteredBarChartProperties.firePreRender(axisValueRenderEvent);
                if (iAxisChartDataSet.getValue(j, i) != 0.0) {
                    if (iAxisChartDataSet.getValue(j, i) < 0.0) {
                        float_.x = axisChart.getXAxis().computeAxisCoordinate(axisChart.getXAxis().getOrigin(), iAxisChartDataSet.getValue(j, i), axisChart.getXAxis().getScaleCalculator().getMinValue());
                        float_.width = f - float_.x;
                        axisValueRenderEvent.setValueX(float_.x);
                    } else {
                        float_.x = f;
                        float_.width = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(j, i), axisChart.getXAxis().getOneUnitPixelSize());
                        axisValueRenderEvent.setValueX(float_.x + float_.width);
                    }
                    if (float_.width != 0.0f) {
                        graphics2D.fill(float_);
                        if (clusteredBarChartProperties.getShowOutlinesFlag()) {
                            clusteredBarChartProperties.getBarOutlineStroke().draw(graphics2D, float_);
                        }
                        if (axisChart.getGenerateImageMapFlag()) {
                            String string = axisChart.getYAxis().getAxisLabelsGroup() != null ? axisChart.getYAxis().getAxisLabelsGroup().getTextTag(n).getText() : null;
                            axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(j, i), string, iAxisChartDataSet.getLegendLabel(j)));
                        }
                    }
                }
                clusteredBarChartProperties.firePostRender(axisValueRenderEvent);
                float_.y += f3;
            }
            --n;
            float_.y = f2 += axisChart.getYAxis().getScalePixelWidth();
            float_2.y += axisChart.getYAxis().getScalePixelWidth();
        }
    }

    private static void verticalPlot(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet, BarChartProperties barChartProperties, DataAxisProperties dataAxisProperties, Graphics2D graphics2D, Rectangle2D.Float float_, float f, float f2, float f3) {
        Rectangle2D.Float float_2 = new Rectangle2D.Float();
        float_2.x = axisChart.getXAxis().getOrigin() + 1.0f;
        float_2.y = axisChart.getYAxis().getOrigin() - axisChart.getYAxis().getPixelLength() + 1.0f;
        float_2.width = axisChart.getXAxis().getScalePixelWidth() - 1.0f;
        float_2.height = axisChart.getYAxis().getPixelLength() - 1.0f;
        AxisValueRenderEvent axisValueRenderEvent = new AxisValueRenderEvent(axisChart, iAxisChartDataSet, graphics2D, float_2, axisChart.getYAxis().getZeroLineCoordinate());
        for (int i = 0; i < iAxisChartDataSet.getNumberOfDataItems(); ++i) {
            for (int j = 0; j < iAxisChartDataSet.getNumberOfDataSets(); ++j) {
                graphics2D.setPaint(iAxisChartDataSet.getPaint(j));
                axisValueRenderEvent.setDataSetIndex(j);
                if (iAxisChartDataSet.getValue(j, i) != 0.0) {
                    axisValueRenderEvent.setValueX((float)float_.getCenterX());
                    axisValueRenderEvent.setValueY(axisChart.getYAxis().getZeroLineCoordinate());
                    axisValueRenderEvent.setValueIndex(i);
                    barChartProperties.firePreRender(axisValueRenderEvent);
                    if (iAxisChartDataSet.getValue(j, i) < 0.0) {
                        float_.y = f2;
                        float_.height = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(j, i), axisChart.getYAxis().getOneUnitPixelSize());
                        axisValueRenderEvent.setValueY(float_.y + float_.height);
                    } else {
                        float_.y = axisChart.getYAxis().computeAxisCoordinate(axisChart.getYAxis().getOrigin(), iAxisChartDataSet.getValue(j, i), axisChart.getYAxis().getScaleCalculator().getMinValue());
                        float_.height = f2 - float_.y;
                        axisValueRenderEvent.setValueY(float_.y);
                    }
                    if (float_.height != 0.0f) {
                        graphics2D.fill(float_);
                        if (barChartProperties.getShowOutlinesFlag()) {
                            barChartProperties.getBarOutlineStroke().draw(graphics2D, float_);
                        }
                        if (axisChart.getGenerateImageMapFlag()) {
                            String string = axisChart.getXAxis().getAxisLabelsGroup() != null ? axisChart.getXAxis().getAxisLabelsGroup().getTextTag(i).getText() : null;
                            axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(j, i), string, iAxisChartDataSet.getLegendLabel(j)));
                        }
                    }
                    barChartProperties.firePostRender(axisValueRenderEvent);
                }
                float_.x += f3;
            }
            float_2.x += axisChart.getXAxis().getScalePixelWidth();
            float_.x = f += axisChart.getXAxis().getScalePixelWidth();
        }
    }
}

