/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.env.AuthenticationVerifier;
import com.icesoft.faces.env.CommonEnvironmentRequest;
import com.icesoft.faces.env.RequestAttributes;
import com.icesoft.jasper.Constants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ServletEnvironmentRequest
extends CommonEnvironmentRequest
implements HttpServletRequest {
    private static final Log log = LogFactory.getLog((Class)ServletEnvironmentRequest.class);
    private Map headers;
    private Cookie[] cookies;
    private String method;
    private String pathInfo;
    private String pathTranslated;
    private String queryString;
    private String requestURI;
    private StringBuffer requestURL;
    private String servletPath;
    private HttpSession servletSession;
    private boolean isRequestedSessionIdFromCookie;
    private boolean isRequestedSessionIdFromURL;
    private String characterEncoding;
    private int contentLength;
    private String contentType;
    private String protocol;
    private String remoteAddr;
    private int remotePort;
    private String remoteHost;
    private String localName;
    private String localAddr;
    private int localPort;
    private HttpSession session;

    public ServletEnvironmentRequest(Object request, HttpSession session) {
        HttpServletRequest initialRequest = (HttpServletRequest)request;
        this.session = session;
        this.authType = initialRequest.getAuthType();
        this.contextPath = initialRequest.getContextPath();
        this.remoteUser = initialRequest.getRemoteUser();
        this.userPrincipal = initialRequest.getUserPrincipal();
        this.requestedSessionId = initialRequest.getRequestedSessionId();
        this.requestedSessionIdValid = initialRequest.isRequestedSessionIdValid();
        this.attributes = new HashMap();
        Enumeration attributeNames = initialRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            Object attribute = initialRequest.getAttribute(name);
            if (null == name || null == attribute) continue;
            this.attributes.put(name, attribute);
        }
        String[] incAttrKeys = Constants.INC_CONSTANTS;
        for (int index = 0; index < incAttrKeys.length; ++index) {
            String incAttrKey = incAttrKeys[index];
            Object incAttrVal = initialRequest.getAttribute(incAttrKey);
            if (incAttrVal == null) continue;
            this.attributes.put(incAttrKey, initialRequest.getAttribute(incAttrKey));
        }
        this.headers = new HashMap();
        Enumeration headerNames = initialRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration values = initialRequest.getHeaders(name);
            this.headers.put(name, Collections.list(values));
        }
        this.parameters = new HashMap();
        Enumeration parameterNames = initialRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            this.parameters.put(name, initialRequest.getParameterValues(name));
        }
        this.scheme = initialRequest.getScheme();
        this.serverName = initialRequest.getServerName();
        this.serverPort = initialRequest.getServerPort();
        this.secure = initialRequest.isSecure();
        this.cookies = initialRequest.getCookies();
        this.method = initialRequest.getMethod();
        this.pathInfo = initialRequest.getPathInfo();
        this.pathTranslated = initialRequest.getPathTranslated();
        this.queryString = initialRequest.getQueryString();
        this.requestURI = initialRequest.getRequestURI();
        try {
            this.requestURL = initialRequest.getRequestURL();
        }
        catch (NullPointerException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Null Protocol Scheme in request", (Throwable)e);
            }
            HttpServletRequest req = initialRequest;
            this.requestURL = new StringBuffer("http://" + req.getServerName() + ":" + req.getServerPort() + req.getRequestURI());
        }
        this.servletPath = initialRequest.getServletPath();
        this.servletSession = initialRequest.getSession();
        this.isRequestedSessionIdFromCookie = initialRequest.isRequestedSessionIdFromCookie();
        this.isRequestedSessionIdFromURL = initialRequest.isRequestedSessionIdFromURL();
        this.characterEncoding = initialRequest.getCharacterEncoding();
        this.contentLength = initialRequest.getContentLength();
        this.contentType = initialRequest.getContentType();
        this.protocol = initialRequest.getProtocol();
        this.remoteAddr = initialRequest.getRemoteAddr();
        this.remoteHost = initialRequest.getRemoteHost();
        this.initializeServlet2point4Properties(initialRequest);
    }

    private void initializeServlet2point4Properties(HttpServletRequest servletRequest) {
        ServletContext context = servletRequest.getSession().getServletContext();
        if (context.getMajorVersion() > 1 && context.getMinorVersion() > 3) {
            this.remotePort = servletRequest.getRemotePort();
            this.localName = servletRequest.getLocalName();
            this.localAddr = servletRequest.getLocalAddr();
            this.localPort = servletRequest.getLocalPort();
        }
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setParameters(HttpServletRequest request) {
        this.parameters = new HashMap();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            this.parameters.put(name, request.getParameterValues(name));
        }
    }

    public boolean isUserInRole(String role) {
        return this.authenticationVerifier().isUserInRole(role);
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        this.requestAttributes().setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        super.removeAttribute(name);
        this.requestAttributes().removeAttribute(name);
    }

    public long getDateHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1L;
        }
        return -1L;
    }

    public String getHeader(String name) {
        List values = (List)this.headers.get(name);
        return values == null || values.isEmpty() ? null : (String)values.get(0);
    }

    public Enumeration getHeaders(String name) {
        List values = (List)this.headers.get(name);
        return Collections.enumeration(values);
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(name, -1);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        return this.session;
    }

    public HttpSession getSession() {
        return this.servletSession;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.isRequestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.isRequestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.characterEncoding = encoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Use ResponseWriter instead");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public RequestDispatcher getRequestDispatcher(String name) {
        throw new UnsupportedOperationException("Use navigation rules instead");
    }

    public String getRealPath(String path) {
        return this.session.getServletContext().getRealPath(path);
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public abstract RequestAttributes requestAttributes();

    public abstract AuthenticationVerifier authenticationVerifier();
}

