/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.faces.data;

import com.sun.rave.faces.data.DataCache;
import com.sun.rave.faces.util.ComponentBundle;
import java.beans.Beans;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;

public class RowSetDataModel
extends DataModel {
    private static final int DESIGN_TIME_ROWS = 5;
    private static final ComponentBundle bundle = ComponentBundle.getBundle(RowSetDataModel.class);
    private List columnNames = new ArrayList();
    private boolean useConditionalWhereClause = true;
    private List columnTypes = new ArrayList();
    private List columnJavaTypes = new ArrayList();
    private DataCache dataCache = null;
    private String dataCacheKey = null;
    private RowSetListener listener = new CachedRowSetListener();
    private ResultSetMetaData metadata = null;
    private int rowIndex;
    private RowSet rowSet = null;
    private String schemaName = null;
    private List schemaNames = new ArrayList();
    private String tableName = null;
    private List tableNames = new ArrayList();

    public RowSetDataModel() {
        this(null);
    }

    public RowSetDataModel(RowSet rowSet) {
        this.setWrappedData(rowSet);
    }

    public DataCache getDataCache() {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        this.dataCache = (DataCache)sessionMap.get(this.getDataCacheKey());
        if (this.dataCache == null) {
            this.dataCache = new DataCache();
            sessionMap.put(this.getDataCacheKey(), this.dataCache);
        }
        return this.dataCache;
    }

    public String getDataCacheKey() {
        return this.dataCacheKey;
    }

    public void setDataCacheKey(String dataCacheKey) {
        this.dataCacheKey = dataCacheKey;
    }

    public RowSet getRowSet() {
        return (RowSet)this.getWrappedData();
    }

    public void setRowSet(RowSet rowSet) {
        this.setWrappedData(rowSet);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void clear() {
        this.getDataCache().clear();
    }

    public void commit() throws SQLException {
        Statement dstmt;
        Statement ustmt;
        SQLException exception;
        Connection conn;
        block48: {
            if (this.tableName == null) {
                throw new IllegalArgumentException(bundle.getMessage("noTableName"));
            }
            if (!this.connected()) {
                throw new IllegalStateException(bundle.getMessage("notConnected"));
            }
            conn = null;
            exception = null;
            ustmt = null;
            dstmt = null;
            String extracted = null;
            List names = null;
            try {
                if (this.getTableName() == null || this.getTableName().length() < 1) {
                    extracted = this.extract(this.getRowSet().getCommand());
                }
                try {
                    conn = this.getRowSet().getStatement().getConnection();
                }
                catch (NullPointerException e) {
                    exception = new SQLException(bundle.getMessage("noConnection"));
                    throw new FacesException((Throwable)exception);
                }
                DatabaseMetaData dbmd = conn.getMetaData();
                String driverName = dbmd.getDriverName();
                this.useConditionalWhereClause = driverName == null || !driverName.equals("DB2");
                names = this.columns(dbmd, extracted != null ? extracted : this.getTableName(), this.columnNames);
                String[] statements = this.composeStatements(extracted, names, this.useConditionalWhereClause, null);
                ustmt = conn.prepareStatement(statements[0]);
                dstmt = conn.prepareStatement(statements[1]);
            }
            catch (SQLException e) {
                exception = e;
            }
            try {
                if (exception != null) break block48;
                Iterator keys = this.getDataCache().iterator();
                while (keys.hasNext()) {
                    int i;
                    Statement tmpStmt;
                    Integer key = (Integer)keys.next();
                    DataCache.Row row = this.getDataCache().get(key);
                    DataCache.Column[] columns = row.getColumns();
                    if (row.isDeleted()) {
                        tmpStmt = dstmt;
                        boolean requiresCustomDeleteStatement = false;
                        int dindex = 1;
                        if (this.useConditionalWhereClause) {
                            for (i = 0; i < columns.length; ++i) {
                                if (!this.match(i, names)) continue;
                                tmpStmt.setObject(dindex++, columns[i].getOriginal(), columns[i].getSqlType());
                                tmpStmt.setObject(dindex++, columns[i].getOriginal(), columns[i].getSqlType());
                            }
                        } else {
                            for (i = 0; i < columns.length; ++i) {
                                if (!this.match(i, names) || columns[i].getOriginal() != null) continue;
                                requiresCustomDeleteStatement = true;
                                break;
                            }
                            if (requiresCustomDeleteStatement) {
                                tmpStmt = conn.prepareStatement(this.composeStatements(extracted, names, false, columns)[1]);
                            }
                            for (i = 0; i < columns.length; ++i) {
                                if (!this.match(i, names) || columns[i].getOriginal() == null) continue;
                                tmpStmt.setObject(dindex++, columns[i].getOriginal());
                            }
                        }
                        int dresult = tmpStmt.executeUpdate();
                        if (requiresCustomDeleteStatement) {
                            try {
                                tmpStmt.close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        if (dresult < 1) {
                            exception = new SQLException(bundle.getMessage("deleteFailedMissing", key));
                        } else {
                            if (dresult <= 1) continue;
                            exception = new SQLException(bundle.getMessage("deleteFailedMultiple", key));
                        }
                        break;
                    }
                    if (!row.isUpdated()) continue;
                    tmpStmt = ustmt;
                    boolean requiresCustomUpdateStatement = false;
                    if (!this.useConditionalWhereClause) {
                        for (int i2 = 0; i2 < columns.length; ++i2) {
                            if (!this.match(i2, names) || columns[i2].getOriginal() != null) continue;
                            requiresCustomUpdateStatement = true;
                            break;
                        }
                        if (requiresCustomUpdateStatement) {
                            tmpStmt = conn.prepareStatement(this.composeStatements(extracted, names, false, columns)[0]);
                        }
                    }
                    int uindex = 1;
                    for (i = 0; i < columns.length; ++i) {
                        if (!this.match(i, names)) continue;
                        tmpStmt.setObject(uindex++, columns[i].getValue(), columns[i].getSqlType());
                    }
                    if (this.useConditionalWhereClause) {
                        for (i = 0; i < columns.length; ++i) {
                            if (!this.match(i, names)) continue;
                            tmpStmt.setObject(uindex++, columns[i].getOriginal(), columns[i].getSqlType());
                            tmpStmt.setObject(uindex++, columns[i].getOriginal(), columns[i].getSqlType());
                        }
                    } else {
                        for (i = 0; i < columns.length; ++i) {
                            if (!this.match(i, names) || columns[i].getOriginal() == null) continue;
                            ustmt.setObject(uindex++, columns[i].getOriginal());
                        }
                    }
                    int uresult = tmpStmt.executeUpdate();
                    if (requiresCustomUpdateStatement) {
                        try {
                            tmpStmt.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (uresult < 1) {
                        exception = new SQLException(bundle.getMessage("updateFailedMissing", key));
                    } else {
                        if (uresult <= 1) continue;
                        exception = new SQLException(bundle.getMessage("updateFailedMultiple", key));
                    }
                    break;
                }
            }
            catch (SQLException e) {
                exception = e;
            }
        }
        try {
            if (exception == null) {
                conn.commit();
                this.getDataCache().commit();
            }
        }
        catch (SQLException e) {
            exception = e;
        }
        if (exception != null) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.getDataCache().reset();
        }
        if (ustmt != null) {
            try {
                ustmt.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            ustmt = null;
        }
        if (dstmt != null) {
            try {
                dstmt.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            dstmt = null;
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void execute() throws SQLException {
        if (!this.connected()) {
            throw new IllegalStateException(bundle.getMessage("notConnected"));
        }
        this.getDataCache().clear();
        this.getRowSet().execute();
    }

    public void reset() {
        this.getDataCache().reset();
    }

    public void rollback() throws SQLException {
        if (!this.connected()) {
            throw new IllegalStateException(bundle.getMessage("notConnected"));
        }
        this.getDataCache().reset();
        this.getRowSet().getStatement().getConnection().rollback();
    }

    public void setObject(int index, Object value) throws SQLException {
        if (!this.connected()) {
            throw new IllegalStateException(bundle.getMessage("notConnected"));
        }
        this.getRowSet().setObject(index, value);
    }

    public void setObject(int index, Object value, int type) throws SQLException {
        if (!this.connected()) {
            throw new IllegalStateException(bundle.getMessage("notConnected"));
        }
        this.getRowSet().setObject(index, value, type);
    }

    public void setObject(int index, Object value, int type, int scale) throws SQLException {
        if (!this.connected()) {
            throw new IllegalStateException(bundle.getMessage("notConnected"));
        }
        this.getRowSet().setObject(index, value, type, scale);
    }

    public int getRowCount() {
        if (Beans.isDesignTime()) {
            return 5;
        }
        return -1;
    }

    public Object getRowData() {
        DataCache.Row row = this.getDataCache().get(this.rowIndex);
        if (row == null) {
            throw new IllegalArgumentException("" + this.rowIndex);
        }
        return row;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Object getWrappedData() {
        return this.rowSet;
    }

    public boolean isRowAvailable() {
        if (Beans.isDesignTime() && (this.rowIndex < 0 || this.rowIndex >= 5)) {
            return false;
        }
        if (this.rowIndex >= 0) {
            return this.getDataCache().get(this.rowIndex) != null;
        }
        return false;
    }

    private boolean shouldRowBeAvailable() {
        return this.rowIndex >= 0 && this.rowIndex < 5;
    }

    public void setRowIndex(int rowIndex) {
        DataCache.Row row;
        if (rowIndex < -1) {
            throw new IllegalArgumentException(bundle.getMessage("invalidRowIndex", new Integer(rowIndex)));
        }
        int oldIndex = this.rowIndex;
        this.rowIndex = rowIndex;
        if (!this.connected()) {
            return;
        }
        if (rowIndex >= 0 && this.connected() && !Beans.isDesignTime() && this.getDataCache().get(rowIndex) == null && (row = this.create()) != null) {
            this.getDataCache().add(rowIndex, row);
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (oldIndex != rowIndex && listeners != null) {
            Object rowData = null;
            if (Beans.isDesignTime() && this.shouldRowBeAvailable() && !this.isRowAvailable()) {
                this.synchronize();
            }
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, rowIndex, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    public void setWrappedData(Object rowSet) {
        if (rowSet == null) {
            this.disconnect();
        } else {
            this.disconnect();
            this.connect((RowSet)rowSet);
        }
    }

    private List columns(DatabaseMetaData dbmd, String extracted, List columns) throws SQLException {
        ResultSet trs;
        String driverName = dbmd.getDriverName();
        this.useConditionalWhereClause = driverName == null || !driverName.equals("DB2");
        String schemaName = null;
        String tableName = extracted;
        int period = tableName.lastIndexOf(46);
        if (period >= 0) {
            schemaName = tableName.substring(0, period);
            tableName = tableName.substring(period + 1);
        }
        if (!(trs = dbmd.getTables(null, schemaName, tableName, null)).next()) {
            throw new SQLException(tableName + " not found");
        }
        ResultSet crs = dbmd.getColumns(trs.getString("TABLE_CAT"), trs.getString("TABLE_SCHEM"), trs.getString("TABLE_NAME"), "%");
        trs.close();
        ArrayList<String> results = new ArrayList<String>();
        int n = columns.size();
        block0: while (crs.next()) {
            String name = crs.getString("COLUMN_NAME");
            for (int i = 0; i < n; ++i) {
                if (!name.equalsIgnoreCase((String)columns.get(i))) continue;
                results.add(name);
                continue block0;
            }
        }
        crs.close();
        return results;
    }

    private void connect(RowSet rowSet) {
        this.rowSet = rowSet;
        this.getRowSet().addRowSetListener(this.listener);
        this.synchronize();
    }

    private boolean connected() {
        return this.rowSet != null;
    }

    private DataCache.Row create() {
        this.initialize();
        try {
            if (!this.getRowSet().absolute(this.rowIndex + 1)) {
                return null;
            }
            DataCache.Column[] columns = new DataCache.Column[this.columnNames.size()];
            for (int i = 0; i < this.columnNames.size(); ++i) {
                columns[i] = this.getDataCache().createColumn((String)this.schemaNames.get(i), (String)this.tableNames.get(i), (String)this.columnNames.get(i), (Integer)this.columnTypes.get(i), (Class)this.columnJavaTypes.get(i), this.getRowSet().getObject(i + 1));
            }
            DataCache.Row row = this.getDataCache().createRow(columns);
            return row;
        }
        catch (SQLException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private void disconnect() {
        if (!this.connected()) {
            return;
        }
        this.getRowSet().removeRowSetListener(this.listener);
        this.metadata = null;
        this.rowSet = null;
    }

    private String extract(String command) {
        boolean next = false;
        command = command.trim();
        while (command.length() > 0) {
            String word;
            int space = command.indexOf(32);
            if (space >= 0) {
                word = command.substring(0, space).trim();
                command = command.substring(space + 1).trim();
            } else {
                word = command.trim();
                command = "";
            }
            if (next) {
                int comma = word.indexOf(44);
                if (comma >= 0) {
                    word = word.substring(0, comma);
                }
                return word;
            }
            if (!"FROM".equalsIgnoreCase(word)) continue;
            next = true;
        }
        return "";
    }

    private void initialize() {
        if (Beans.isDesignTime()) {
            return;
        }
        RowSet rowSet = this.getRowSet();
        try {
            if (rowSet.isBeforeFirst()) {
                try {
                    rowSet.first();
                }
                catch (SQLException x) {}
            }
        }
        catch (SQLException x1) {
            try {
                rowSet.execute();
            }
            catch (SQLException x2) {
                throw new FacesException((Throwable)x2);
            }
        }
    }

    private boolean match(int index, List names) {
        if (names != null) {
            String name = (String)this.columnNames.get(index);
            for (int i = 0; i < names.size(); ++i) {
                if (!name.equalsIgnoreCase((String)names.get(i))) continue;
                return true;
            }
            return false;
        }
        if (this.schemaName != null && !this.schemaName.equalsIgnoreCase((String)this.schemaNames.get(index))) {
            return false;
        }
        return this.tableName == null || this.tableName.equalsIgnoreCase((String)this.tableNames.get(index));
    }

    private String quoted(String value) {
        boolean required = false;
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isWhitespace(value.charAt(i))) continue;
            required = true;
            break;
        }
        if (required) {
            return '\"' + value + '\"';
        }
        return value;
    }

    private void synchronize() {
        boolean changed = false;
        try {
            DataCache.Column[] previous = new DataCache.Column[]{};
            DataCache.Row row = null;
            Iterator keys = this.getDataCache().iterator();
            if (keys.hasNext()) {
                row = this.getDataCache().get((Integer)keys.next());
                previous = row.getColumns();
            }
            int m = previous.length;
            this.metadata = this.getRowSet().getMetaData();
            int n = this.metadata.getColumnCount();
            if (m != n) {
                changed = true;
            }
            this.columnNames.clear();
            this.columnTypes.clear();
            this.columnJavaTypes.clear();
            this.schemaNames.clear();
            this.tableNames.clear();
            for (int i = 1; i <= n; ++i) {
                if (!(previous.length < i || previous[i - 1].getColumnName().equals(this.metadata.getColumnName(i)) && previous[i - 1].getSchemaName().equals(this.metadata.getSchemaName(i)) && previous[i - 1].getTableName().equals(this.metadata.getTableName(i)))) {
                    changed = true;
                }
                this.columnNames.add(this.metadata.getColumnName(i));
                this.columnTypes.add(new Integer(this.metadata.getColumnType(i)));
                Class<?> javaType = null;
                try {
                    String javaTypeName = this.metadata.getColumnClassName(i);
                    javaType = Class.forName(javaTypeName);
                }
                catch (Exception jte) {
                    // empty catch block
                }
                this.columnJavaTypes.add(javaType);
                this.schemaNames.add(this.metadata.getSchemaName(i));
                this.tableNames.add(this.metadata.getTableName(i));
            }
        }
        catch (SQLException e) {
            throw new FacesException((Throwable)e);
        }
        if (!Beans.isDesignTime() && changed) {
            this.getDataCache().clear();
        }
        if (!Beans.isDesignTime()) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            DataCache.Column[] columns = new DataCache.Column[this.columnNames.size()];
            for (int j = 0; j < this.columnNames.size(); ++j) {
                Object fakeData;
                String schemaName = "";
                String tableName = "";
                String columnName = (String)this.columnNames.get(j);
                int columnType = (Integer)this.columnTypes.get(j);
                Class columnJavaType = (Class)this.columnJavaTypes.get(j);
                try {
                    fakeData = RowSetDataModel.getFakeData(this.metadata, columnName);
                }
                catch (SQLException e) {
                    throw new FacesException((Throwable)e);
                }
                columns[j] = this.getDataCache().createColumn(schemaName, tableName, columnName, columnType, columnJavaType, fakeData);
            }
            DataCache.Row row = this.getDataCache().createRow(columns);
            this.getDataCache().add(i, row);
        }
    }

    private static Object getFakeData(ResultSetMetaData rsmd, String colName) throws SQLException {
        int colIndex = -1;
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            if (!rsmd.getColumnName(i).equals(colName)) continue;
            colIndex = i;
            break;
        }
        switch (rsmd.getColumnType(colIndex)) {
            case 2003: {
                return new Array(){

                    public Object getArray() {
                        return null;
                    }

                    public Object getArray(long index, int count) {
                        return null;
                    }

                    public Object getArray(long index, int count, Map map) {
                        return null;
                    }

                    public Object getArray(Map map) {
                        return null;
                    }

                    public int getBaseType() {
                        return 1;
                    }

                    public String getBaseTypeName() {
                        return "CHAR";
                    }

                    public ResultSet getResultSet() {
                        return null;
                    }

                    public ResultSet getResultSet(long index, int count) {
                        return null;
                    }

                    public ResultSet getResultSet(long index, int count, Map map) {
                        return null;
                    }

                    public ResultSet getResultSet(Map map) {
                        return null;
                    }

                    public void free() {
                    }
                };
            }
            case -5: {
                return new Long(123L);
            }
            case -2: {
                return new byte[]{1, 2, 3, 4, 5};
            }
            case -7: {
                return new Boolean(true);
            }
            case 2004: {
                return new SerialBlob(new byte[]{1, 2, 3, 4, 5});
            }
            case 16: {
                return new Boolean(true);
            }
            case 1: {
                return new String(bundle.getMessage("arbitraryCharData"));
            }
            case 2005: {
                return new SerialClob(bundle.getMessage("arbitraryClobData").toCharArray());
            }
            case 70: {
                try {
                    return new URL("http://www.sun.com");
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            case 91: {
                return new Date(new java.util.Date().getTime());
            }
            case 3: {
                return new BigDecimal(BigInteger.ONE);
            }
            case 2001: {
                return null;
            }
            case 8: {
                return new Double(123.0);
            }
            case 6: {
                return new Double(123.0);
            }
            case 4: {
                return new Integer(123);
            }
            case 2000: {
                return new String(bundle.getMessage("arbitraryCharData"));
            }
            case -4: {
                return new byte[]{1, 2, 3, 4, 5};
            }
            case -1: {
                return new String(bundle.getMessage("arbitraryCharData"));
            }
            case 0: {
                return null;
            }
            case 2: {
                return new BigDecimal(BigInteger.ONE);
            }
            case 1111: {
                return null;
            }
            case 7: {
                return new Float(123.0f);
            }
            case 2006: {
                return new Ref(){
                    private Object data = new String(RowSetDataModel.access$200().getMessage("arbitraryCharData"));

                    public String getBaseTypeName() {
                        return "CHAR";
                    }

                    public Object getObject() {
                        return this.data;
                    }

                    public Object getObject(Map map) {
                        return this.data;
                    }

                    public void setObject(Object value) {
                        this.data = value;
                    }
                };
            }
            case 5: {
                return new Short(123);
            }
            case 2002: {
                return new Struct(){
                    private String[] data = new String[]{RowSetDataModel.access$200().getMessage("arbitraryCharData"), RowSetDataModel.access$200().getMessage("arbitraryCharData2"), RowSetDataModel.access$200().getMessage("arbitraryCharData3")};

                    public Object[] getAttributes() {
                        return this.data;
                    }

                    public Object[] getAttributes(Map map) {
                        return this.data;
                    }

                    public String getSQLTypeName() {
                        return "CHAR";
                    }
                };
            }
            case 92: {
                return new Time(new java.util.Date().getTime());
            }
            case 93: {
                return new Timestamp(new java.util.Date().getTime());
            }
            case -6: {
                return new Byte(123);
            }
            case -3: {
                return new byte[]{1, 2, 3, 4, 5};
            }
            case 12: {
                return new String(bundle.getMessage("arbitraryCharData"));
            }
        }
        return null;
    }

    private String[] composeStatements(String extracted, List names, boolean useConditionalWhereClause, DataCache.Column[] columns) {
        int i;
        StringBuffer dsb = new StringBuffer("DELETE FROM ");
        if (extracted != null) {
            dsb.append(extracted);
        } else {
            if (this.getSchemaName() != null && this.getSchemaName().length() > 0) {
                dsb.append(this.quoted(this.getSchemaName()));
                dsb.append(".");
            }
            dsb.append(this.quoted(this.getTableName()));
        }
        StringBuffer usb = new StringBuffer("UPDATE ");
        if (extracted != null) {
            usb.append(extracted);
        } else {
            if (this.getSchemaName() != null && this.getSchemaName().length() > 0) {
                usb.append(this.quoted(this.getSchemaName()));
                usb.append(".");
            }
            usb.append(this.quoted(this.getTableName()));
        }
        usb.append(" SET ");
        int m = 0;
        int n = this.columnNames.size();
        for (i = 0; i < n; ++i) {
            if (!this.match(i, names)) continue;
            if (m > 0) {
                usb.append(", ");
            }
            usb.append(this.quoted((String)this.columnNames.get(i)));
            usb.append(" = ?");
            ++m;
        }
        dsb.append(" WHERE ");
        usb.append(" WHERE ");
        m = 0;
        for (i = 0; i < n; ++i) {
            if (!this.match(i, names)) continue;
            if (m > 0) {
                dsb.append(" AND ");
                usb.append(" AND ");
            }
            if (useConditionalWhereClause) {
                dsb.append("((? IS NULL AND ");
                usb.append("((? IS NULL AND ");
                dsb.append(this.quoted((String)this.columnNames.get(i)));
                usb.append(this.quoted((String)this.columnNames.get(i)));
                dsb.append(" IS NULL) OR ");
                usb.append(" IS NULL) OR ");
                dsb.append(this.quoted((String)this.columnNames.get(i)));
                usb.append(this.quoted((String)this.columnNames.get(i)));
                dsb.append(" = ?)");
                usb.append(" = ?)");
            } else if (columns != null && columns[i].getOriginal() == null) {
                dsb.append(this.quoted((String)this.columnNames.get(i)));
                usb.append(this.quoted((String)this.columnNames.get(i)));
                dsb.append(" IS NULL");
                usb.append(" IS NULL");
            } else {
                dsb.append(this.quoted((String)this.columnNames.get(i)));
                usb.append(this.quoted((String)this.columnNames.get(i)));
                dsb.append(" = ?");
                usb.append(" = ?");
            }
            ++m;
        }
        String[] statements = new String[]{usb.toString(), dsb.toString()};
        return statements;
    }

    static /* synthetic */ ComponentBundle access$200() {
        return bundle;
    }

    private class CachedRowSetListener
    implements RowSetListener {
        private CachedRowSetListener() {
        }

        public void cursorMoved(RowSetEvent event) {
        }

        public void rowChanged(RowSetEvent event) {
        }

        public void rowSetChanged(RowSetEvent event) {
            RowSetDataModel.this.synchronize();
        }
    }
}

