/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.LocalEffectEncoder;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;

public class GroupRenderer
extends DomBasicRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element rootSpan;
        String style = (String)uiComponent.getAttributes().get("style");
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        boolean requiresSpan = this.requiresRootElement(style, styleClass, uiComponent);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (requiresSpan) {
            if (!domContext.isInitialized()) {
                rootSpan = this.createRootElement(domContext);
                domContext.setRootNode(rootSpan);
                GroupRenderer.setRootElementId(facesContext, rootSpan, uiComponent);
            }
            rootSpan = (Element)domContext.getRootNode();
            DOMContext.removeChildren(rootSpan);
            this.renderStyleAndStyleClass(style, styleClass, rootSpan);
        }
        rootSpan = (Element)domContext.getRootNode();
        LocalEffectEncoder.encodeLocalEffects(uiComponent, rootSpan, facesContext);
        domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), rootSpan);
        domContext.stepInto(uiComponent);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Iterator children = uiComponent.getChildren().iterator();
        while (children.hasNext()) {
            UIComponent nextChild = (UIComponent)children.next();
            if (!nextChild.isRendered()) continue;
            GroupRenderer.encodeParentAndChildren(facesContext, nextChild);
        }
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
    }

    protected Element createRootElement(DOMContext domContext) {
        return domContext.createElement("span");
    }

    protected void renderStyleAndStyleClass(String style, String styleClass, Element root) {
        if (styleClass != null) {
            root.setAttribute("class", styleClass);
        }
        if (style != null && style.length() > 0) {
            root.setAttribute("style", style);
        } else {
            root.removeAttribute("style");
        }
    }

    private boolean requiresRootElement(String style, String styleClass, UIComponent uiComponent) {
        return GroupRenderer.idNotNull(uiComponent) || style != null || styleClass != null;
    }
}

