/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.application.StartupTime;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.BundleResolver;
import com.icesoft.faces.context.DOMSerializer;
import com.icesoft.faces.context.FailoverBundleResolver;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.util.DOMUtils;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.ConfigurationException;
import java.beans.Beans;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMResponseWriter
extends ResponseWriter {
    private static final Log log = LogFactory.getLog((Class)DOMResponseWriter.class);
    public static final String DOCTYPE_PUBLIC = "com.icesoft.doctype.public";
    public static final String DOCTYPE_SYSTEM = "com.icesoft.doctype.system";
    public static final String DOCTYPE_ROOT = "com.icesoft.doctype.root";
    public static final String DOCTYPE_OUTPUT = "com.icesoft.doctype.output";
    public static final String DOCTYPE_PRETTY_PRINTING = "com.icesoft.doctype.prettyprinting";
    private static final BundleResolver bridgeMessageResolver = new FailoverBundleResolver("bridge-messages", new ListResourceBundle(){

        protected Object[][] getContents() {
            return new Object[][]{{"session-expired", "User Session Expired"}, {"connection-lost", "Network Connection Interrupted"}, {"server-error", "Server Internal Error"}, {"description", "To reconnect click the Reload button on the browser or click the button below"}, {"button-text", "Reload"}};
        }
    });
    private static DocumentBuilder DOCUMENT_BUILDER;
    private static boolean isStreamWritingFlag;
    private final Map domContexts = new HashMap();
    private final Document document = DOCUMENT_BUILDER.newDocument();
    private final BridgeFacesContext context;
    private final DOMSerializer serializer;
    private final Configuration configuration;
    private final Collection jsCode;
    private final Collection cssCode;
    private Node cursor = this.document;

    public DOMResponseWriter(FacesContext context, DOMSerializer serializer, Configuration configuration, Collection jsCode, Collection cssCode) {
        this.serializer = serializer;
        this.configuration = configuration;
        this.jsCode = jsCode;
        this.cssCode = cssCode;
        try {
            this.context = (BridgeFacesContext)context;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("ICEfaces requires the PersistentFacesServlet. Please check your web.xml servlet mappings");
        }
        boolean streamWritingParam = configuration.getAttributeAsBoolean("streamWriting", false);
        isStreamWritingFlag = Beans.isDesignTime() || streamWritingParam;
    }

    Map getDomContexts() {
        return this.domContexts;
    }

    public Node getCursorParent() {
        return this.cursor;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getContentType() {
        return "text/html; charset=UTF-8";
    }

    public String getCharacterEncoding() {
        return "UTF-8";
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
        if (!DOMResponseWriter.isStreamWriting()) {
            this.enhanceAndFixDocument();
            this.serializer.serialize(this.document);
        }
    }

    public void flush() throws IOException {
    }

    public void startElement(String name, UIComponent componentForElement) throws IOException {
        this.moveCursorOn(this.appendToCursor(this.document.createElement(name)));
    }

    public void endElement(String name) throws IOException {
        this.moveCursorOn(this.cursor.getParentNode());
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        Attr attribute = this.document.createAttribute(name.trim());
        attribute.setValue(String.valueOf(value));
        this.appendToCursor(attribute);
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        String stringValue = String.valueOf(value);
        if (stringValue.startsWith("javascript:")) {
            this.writeAttribute(name, stringValue, componentPropertyName);
        } else {
            this.writeAttribute(name, stringValue.replace(' ', '+'), componentPropertyName);
        }
    }

    public void writeComment(Object comment) throws IOException {
        this.appendToCursor(this.document.createComment(String.valueOf(comment)));
    }

    public void writeText(Object text, String componentPropertyName) throws IOException {
        this.appendToCursor(this.document.createTextNode(String.valueOf(text)));
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.appendToCursor(this.document.createTextNode(new String(text, off, len)));
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        if (null != this.document) {
            try {
                this.endDocument();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        try {
            return new DOMResponseWriter(this.context, this.serializer, this.configuration, this.jsCode, this.cssCode);
        }
        catch (FacesException e) {
            throw new IllegalStateException();
        }
    }

    public void close() throws IOException {
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.appendToCursor(this.document.createTextNode(new String(cbuf, off, len)));
    }

    public void write(int c) throws IOException {
        this.appendToCursor(this.document.createTextNode(String.valueOf((char)c)));
    }

    public void write(String str) throws IOException {
        this.appendToCursor(this.document.createTextNode(str));
    }

    public void write(String str, int off, int len) throws IOException {
        this.appendToCursor(this.document.createTextNode(str.substring(off, len)));
    }

    public Element getHtmlElement() {
        Element html = this.document.getDocumentElement();
        if (html == null) {
            html = this.document.createElement("html");
            this.document.appendChild(html);
        }
        if (html.getTagName().equals("html")) {
            return html;
        }
        return this.fixHtml();
    }

    public Element getHeadElement() {
        Element head = (Element)this.document.getElementsByTagName("head").item(0);
        if (head == null) {
            head = this.fixHead();
        }
        return head;
    }

    public Element getBodyElement() {
        Element body = (Element)this.document.getElementsByTagName("body").item(0);
        if (body == null) {
            body = this.fixBody();
        }
        return body;
    }

    private void enhanceAndFixDocument() {
        Element html = this.document.getDocumentElement();
        html = "html".equals(html.getTagName()) ? html : this.fixHtml();
        this.enhanceHtml(html);
        Element head = (Element)this.document.getElementsByTagName("head").item(0);
        this.enhanceHead(head == null ? this.fixHead() : head);
        Element body = (Element)this.document.getElementsByTagName("body").item(0);
        this.enhanceBody(body == null ? this.fixBody() : body);
    }

    private void enhanceHtml(Element html) {
        Locale locale = this.context.getViewRoot().getLocale();
        html.setAttribute("id", "document:html");
        html.setAttribute("lang", locale.getLanguage());
    }

    private void enhanceBody(Element body) {
        HttpServletRequest httpRequest;
        String sessionExpiredRedirectURI;
        String connectionLostRedirectURI;
        body.setAttribute("id", "document:body");
        String focusId = this.context.getFocusId();
        if (focusId != null && !focusId.equals("null")) {
            JavascriptContext.focus(this.context, focusId);
        }
        ViewHandler handler = this.context.getApplication().getViewHandler();
        String sessionIdentifier = this.context.getIceFacesId();
        String viewIdentifier = this.context.getViewNumber();
        String prefix = sessionIdentifier + ':' + viewIdentifier + ':';
        Element script = (Element)body.appendChild(this.document.createElement("script"));
        script.setAttribute("id", prefix + "dynamic-code");
        script.setAttribute("type", "text/javascript");
        String calls = JavascriptContext.getJavascriptCalls(this.context);
        script.appendChild(this.document.createTextNode(calls));
        String contextPath = handler.getResourceURL((FacesContext)this.context, "/");
        String ahsContextPath = URI.create("/").resolve(this.configuration.getAttribute("blockingRequestHandlerContext", this.configuration.getAttribute("asyncServerContext", !this.isAsyncHttpServiceAvailable() ? contextPath.replaceAll("/", "") : "async-http-server")) + "/").toString();
        try {
            connectionLostRedirectURI = "'" + this.configuration.getAttribute("connectionLostRedirectURI").replaceAll("'", "") + "'";
        }
        catch (ConfigurationException e) {
            connectionLostRedirectURI = "null";
        }
        try {
            sessionExpiredRedirectURI = "'" + this.configuration.getAttribute("sessionExpiredRedirectURI").replaceAll("'", "") + "'";
        }
        catch (ConfigurationException e) {
            sessionExpiredRedirectURI = "null";
        }
        String configurationID = prefix + "configuration-script";
        ResourceBundle localizedBundle = bridgeMessageResolver.bundleFor(this.context.getViewRoot().getLocale());
        String startupScript = "if (!window.sessions) window.sessions = []; window.sessions.push('" + sessionIdentifier + "');\n" + "window.disposeViewsURI = '" + ahsContextPath + "block/dispose-views';\n" + "var container = '" + configurationID + "'.asElement().parentNode;\n" + "container.bridge = new Ice.Community.Application({" + "session: '" + sessionIdentifier + "'," + "view: " + viewIdentifier + "," + "synchronous: " + this.configuration.getAttribute("synchronousUpdate", "false") + "," + "connectionLostRedirectURI: " + connectionLostRedirectURI + "," + "sessionExpiredRedirectURI: " + sessionExpiredRedirectURI + "," + "connection: {" + "context: {" + "current: '" + contextPath + "'," + "async: '" + ahsContextPath + "'}," + "timeout: " + this.configuration.getAttributeAsLong("connectionTimeout", 60000L) + "," + "heartbeat: {" + "interval: " + this.configuration.getAttributeAsLong("heartbeatInterval", 50000L) + "," + "timeout: " + this.configuration.getAttributeAsLong("heartbeatTimeout", 30000L) + "," + "retries: " + this.configuration.getAttributeAsLong("heartbeatRetries", 3L) + "}" + "}," + "messages: {" + "sessionExpired: '" + localizedBundle.getString("session-expired") + "'," + "connectionLost: '" + localizedBundle.getString("connection-lost") + "'," + "serverError: '" + localizedBundle.getString("server-error") + "'," + "description: '" + localizedBundle.getString("description") + "'," + "buttonText: '" + localizedBundle.getString("button-text") + "'" + "}" + "}, container);";
        Element configurationElement = (Element)body.appendChild(this.document.createElement("script"));
        configurationElement.setAttribute("id", configurationID);
        configurationElement.setAttribute("type", "text/javascript");
        configurationElement.appendChild(this.document.createTextNode(startupScript));
        body.insertBefore(configurationElement, body.getFirstChild());
        Element iframe = this.document.createElement("iframe");
        body.insertBefore(iframe, body.getFirstChild());
        String iframeID = "history-frame:" + sessionIdentifier + ":" + viewIdentifier;
        iframe.setAttribute("id", iframeID);
        iframe.setAttribute("name", iframeID);
        Object request = this.context.getExternalContext().getRequest();
        String frameURI = request instanceof HttpServletRequest ? ((httpRequest = (HttpServletRequest)request).getRequestURI() == null ? "about:blank" : CoreUtils.resolveResourceURL(FacesContext.getCurrentInstance(), "/xmlhttp/blank")) : CoreUtils.resolveResourceURL(FacesContext.getCurrentInstance(), "/xmlhttp/blank");
        iframe.setAttribute("title", "Icefaces Redirect");
        iframe.setAttribute("src", frameURI);
        iframe.setAttribute("frameborder", "0");
        iframe.setAttribute("style", "z-index: 10000; visibility: hidden; width: 0; height: 0; position: absolute; opacity: 0.22; filter: alpha(opacity=22);");
        Element noscript = (Element)body.appendChild(this.document.createElement("noscript"));
        Element noscriptMeta = (Element)noscript.appendChild(this.document.createElement("meta"));
        noscriptMeta.setAttribute("http-equiv", "refresh");
        noscriptMeta.setAttribute("content", "0;url=" + handler.getResourceURL((FacesContext)this.context, "/xmlhttp/javascript-blocked"));
        if (this.context.isContentIncluded()) {
            Element element = (Element)body.insertBefore(this.document.createElement("div"), configurationElement);
            element.setAttribute("style", "display: none;");
            element.setAttribute("id", "cntIncDiv");
            this.appendContentReferences(element);
        }
    }

    private void enhanceHead(Element head) {
        Element meta = (Element)head.appendChild(this.document.createElement("meta"));
        meta.setAttribute("name", "icefaces");
        meta.setAttribute("content", "Rendered by ICEFaces D2D");
        Element title = (Element)head.getElementsByTagName("title").item(0);
        if (title != null && !title.hasAttribute("id")) {
            title.setAttribute("id", "document:title");
        }
        if (!this.context.isContentIncluded()) {
            this.appendContentReferences(head);
        }
    }

    private void appendContentReferences(Element container) {
        ArrayList<String> libs = new ArrayList<String>();
        if (this.configuration.getAttributeAsBoolean("openAjaxHub", false)) {
            libs.add("/xmlhttp/openajax.js");
        }
        libs.add("/xmlhttp" + StartupTime.getStartupInc() + "icefaces-d2d.js");
        libs.add("/xmlhttp" + StartupTime.getStartupInc() + "ice-extras.js");
        String[] componentLibs = JavascriptContext.getIncludedLibs(this.context);
        for (int i = 0; i < componentLibs.length; ++i) {
            String componentLib = componentLibs[i];
            if (libs.contains(componentLib)) continue;
            libs.add(componentLib);
        }
        libs.addAll(this.jsCode);
        ViewHandler handler = this.context.getApplication().getViewHandler();
        Iterator libIterator = libs.iterator();
        while (libIterator.hasNext()) {
            String lib = (String)libIterator.next();
            Element script = (Element)container.appendChild(this.document.createElement("script"));
            script.setAttribute("type", "text/javascript");
            script.setAttribute("src", handler.getResourceURL((FacesContext)this.context, lib));
        }
        Iterator cssIterator = this.cssCode.iterator();
        while (cssIterator.hasNext()) {
            String css = (String)cssIterator.next();
            Element link = (Element)container.appendChild(this.document.createElement("link"));
            link.setAttribute("rel", "stylesheet");
            link.setAttribute("type", "text/css");
            link.setAttribute("href", handler.getResourceURL((FacesContext)this.context, css));
        }
        Element link = (Element)container.appendChild(this.document.createElement("script"));
        link.setAttribute("type", "text/javascript");
        link.appendChild(this.document.createTextNode("try { document.execCommand('BackgroundImageCache', false, true); } catch(e) {}"));
    }

    private Element fixHtml() {
        Element root = this.document.getDocumentElement();
        Element html = this.document.createElement("html");
        this.document.replaceChild(html, root);
        html.appendChild(root);
        return html;
    }

    private Element fixBody() {
        int i;
        Element html = this.document.getDocumentElement();
        Element body = this.document.createElement("body");
        NodeList children = html.getChildNodes();
        int length = children.getLength();
        Node[] nodes = new Node[length];
        for (i = 0; i < nodes.length; ++i) {
            nodes[i] = children.item(i);
        }
        for (i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (node instanceof Element && "head".equals(((Element)node).getTagName())) continue;
            body.appendChild(node);
        }
        html.appendChild(body);
        return body;
    }

    private Element fixHead() {
        Element html = this.document.getDocumentElement();
        Element head = this.document.createElement("head");
        html.insertBefore(head, html.getFirstChild());
        return head;
    }

    protected void setCursorParent(Node cursorParent) {
        this.cursor = cursorParent;
    }

    public static boolean isStreamWriting() {
        return isStreamWritingFlag;
    }

    private void moveCursorOn(Node node) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("moving cursor on " + DOMUtils.toDebugString(node)));
        }
        this.cursor = node;
    }

    private Node appendToCursor(Node node) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Appending " + DOMUtils.toDebugString(node) + " into " + DOMUtils.toDebugString(this.cursor)));
            }
            return this.cursor.appendChild(node);
        }
        catch (DOMException e) {
            String message = "Failed to append " + DOMUtils.toDebugString(node) + " into " + DOMUtils.toDebugString(this.cursor);
            log.error((Object)message);
            throw new RuntimeException(message, e);
        }
    }

    private Node appendToCursor(Attr node) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Appending " + DOMUtils.toDebugString(node) + " into " + DOMUtils.toDebugString(this.cursor)));
            }
            return ((Element)this.cursor).setAttributeNode(node);
        }
        catch (DOMException e) {
            String message = "Failed to append " + DOMUtils.toDebugString(node) + " into " + DOMUtils.toDebugString(this.cursor);
            log.error((Object)message);
            throw new RuntimeException(message, e);
        }
        catch (ClassCastException e) {
            String message = "The cursor is not an element: " + DOMUtils.toDebugString(this.cursor);
            log.error((Object)message);
            throw new RuntimeException(message, e);
        }
    }

    private boolean isAsyncHttpServiceAvailable() {
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.icesoft.faces.async.server.AsyncHttpServerAdaptingServlet");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    static {
        try {
            DOCUMENT_BUILDER = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Cannot acquire a DocumentBuilder", (Throwable)e);
        }
        isStreamWritingFlag = false;
    }
}

