/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util;

import edu.emory.mathcs.backport.java.util.AbstractMap;
import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.Deque;
import edu.emory.mathcs.backport.java.util.Queue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    private static final int BINARYSEARCH_THRESHOLD = 5000;
    private static final int REVERSE_THRESHOLD = 18;
    private static final int SHUFFLE_THRESHOLD = 5;
    private static final int FILL_THRESHOLD = 25;
    private static final int ROTATE_THRESHOLD = 100;
    private static final int COPY_THRESHOLD = 10;
    private static final int REPLACEALL_THRESHOLD = 11;
    private static final int INDEXOFSUBLIST_THRESHOLD = 35;
    private static Random r;
    public static final Set EMPTY_SET;
    public static final List EMPTY_LIST;
    public static final Map EMPTY_MAP;
    private static final Comparator REVERSE_ORDER;
    static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$Collections$CheckedMap$CheckedEntrySet$CheckedEntry;
    static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$Collections;

    private Collections() {
    }

    public static void sort(List list) {
        Object[] a = list.toArray();
        Arrays.sort(a);
        ListIterator<Object> i = list.listIterator();
        for (int j = 0; j < a.length; ++j) {
            i.next();
            i.set(a[j]);
        }
    }

    public static void sort(List list, Comparator c) {
        Object[] a = list.toArray();
        Arrays.sort(a, c);
        ListIterator<Object> i = list.listIterator();
        for (int j = 0; j < a.length; ++j) {
            i.next();
            i.set(a[j]);
        }
    }

    public static int binarySearch(List list, Object key) {
        if (list instanceof RandomAccess || list.size() < 5000) {
            return Collections.indexedBinarySearch(list, key);
        }
        return Collections.iteratorBinarySearch(list, key);
    }

    private static int indexedBinarySearch(List list, Object key) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Comparable midVal = (Comparable)list.get(mid);
            int cmp = midVal.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int iteratorBinarySearch(List list, Object key) {
        int low = 0;
        int high = list.size() - 1;
        ListIterator i = list.listIterator();
        while (low <= high) {
            int mid = low + high >> 1;
            Comparable midVal = (Comparable)Collections.get(i, mid);
            int cmp = midVal.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static Object get(ListIterator i, int index) {
        Object obj = null;
        int pos = i.nextIndex();
        if (pos <= index) {
            do {
                obj = i.next();
            } while (pos++ < index);
        } else {
            do {
                obj = i.previous();
            } while (--pos > index);
        }
        return obj;
    }

    public static int binarySearch(List list, Object key, Comparator c) {
        if (c == null) {
            return Collections.binarySearch(list, key);
        }
        if (list instanceof RandomAccess || list.size() < 5000) {
            return Collections.indexedBinarySearch(list, key, c);
        }
        return Collections.iteratorBinarySearch(list, key, c);
    }

    private static int indexedBinarySearch(List l, Object key, Comparator c) {
        int low = 0;
        int high = l.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = l.get(mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int iteratorBinarySearch(List l, Object key, Comparator c) {
        int low = 0;
        int high = l.size() - 1;
        ListIterator i = l.listIterator();
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = Collections.get(i, mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static void reverse(List list) {
        int size = list.size();
        if (size < 18 || list instanceof RandomAccess) {
            int i = 0;
            int mid = size >> 1;
            int j = size - 1;
            while (i < mid) {
                Collections.swap(list, i, j);
                ++i;
                --j;
            }
        } else {
            ListIterator fwd = list.listIterator();
            ListIterator rev = list.listIterator(size);
            int mid = list.size() >> 1;
            for (int i = 0; i < mid; ++i) {
                Object tmp = fwd.next();
                fwd.set(rev.previous());
                rev.set(tmp);
            }
        }
    }

    public static void shuffle(List list) {
        if (r == null) {
            r = new Random();
        }
        Collections.shuffle(list, r);
    }

    public static void shuffle(List list, Random rnd) {
        int size = list.size();
        if (size < 5 || list instanceof RandomAccess) {
            for (int i = size; i > 1; --i) {
                Collections.swap(list, i - 1, rnd.nextInt(i));
            }
        } else {
            Object[] arr = list.toArray();
            for (int i = size; i > 1; --i) {
                Collections.swap(arr, i - 1, rnd.nextInt(i));
            }
            ListIterator<Object> it = list.listIterator();
            for (int i = 0; i < arr.length; ++i) {
                it.next();
                it.set(arr[i]);
            }
        }
    }

    public static void swap(List list, int i, int j) {
        List l = list;
        l.set(i, l.set(j, l.get(i)));
    }

    private static void swap(Object[] arr, int i, int j) {
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static void fill(List list, Object obj) {
        int size = list.size();
        if (size < 25 || list instanceof RandomAccess) {
            for (int i = 0; i < size; ++i) {
                list.set(i, obj);
            }
        } else {
            ListIterator<Object> itr = list.listIterator();
            for (int i = 0; i < size; ++i) {
                itr.next();
                itr.set(obj);
            }
        }
    }

    public static void copy(List dest, List src) {
        int srcSize = src.size();
        if (srcSize > dest.size()) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        if (srcSize < 10 || src instanceof RandomAccess && dest instanceof RandomAccess) {
            for (int i = 0; i < srcSize; ++i) {
                dest.set(i, src.get(i));
            }
        } else {
            ListIterator di = dest.listIterator();
            ListIterator si = src.listIterator();
            for (int i = 0; i < srcSize; ++i) {
                di.next();
                di.set(si.next());
            }
        }
    }

    public static Object min(Collection coll) {
        Iterator i = coll.iterator();
        Object candidate = i.next();
        while (i.hasNext()) {
            Object next = i.next();
            if (((Comparable)next).compareTo(candidate) >= 0) continue;
            candidate = next;
        }
        return candidate;
    }

    public static Object min(Collection coll, Comparator comp) {
        if (comp == null) {
            return Collections.min(coll);
        }
        Iterator i = coll.iterator();
        Object candidate = i.next();
        while (i.hasNext()) {
            Object next = i.next();
            if (comp.compare(next, candidate) >= 0) continue;
            candidate = next;
        }
        return candidate;
    }

    public static Object max(Collection coll) {
        Iterator i = coll.iterator();
        Object candidate = i.next();
        while (i.hasNext()) {
            Object next = i.next();
            if (((Comparable)next).compareTo(candidate) <= 0) continue;
            candidate = next;
        }
        return candidate;
    }

    public static Object max(Collection coll, Comparator comp) {
        if (comp == null) {
            return Collections.max(coll);
        }
        Iterator i = coll.iterator();
        Object candidate = i.next();
        while (i.hasNext()) {
            Object next = i.next();
            if (comp.compare(next, candidate) <= 0) continue;
            candidate = next;
        }
        return candidate;
    }

    public static void rotate(List list, int distance) {
        if (list instanceof RandomAccess || list.size() < 100) {
            Collections.rotate1(list, distance);
        } else {
            Collections.rotate2(list, distance);
        }
    }

    private static void rotate1(List list, int distance) {
        int size = list.size();
        if (size == 0) {
            return;
        }
        if ((distance %= size) < 0) {
            distance += size;
        }
        if (distance == 0) {
            return;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != size) {
            Object displaced = list.get(cycleStart);
            int i = cycleStart;
            do {
                if ((i += distance) >= size) {
                    i -= size;
                }
                displaced = list.set(i, displaced);
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
    }

    private static void rotate2(List list, int distance) {
        int size = list.size();
        if (size == 0) {
            return;
        }
        int mid = -distance % size;
        if (mid < 0) {
            mid += size;
        }
        if (mid == 0) {
            return;
        }
        Collections.reverse(list.subList(0, mid));
        Collections.reverse(list.subList(mid, size));
        Collections.reverse(list);
    }

    public static boolean replaceAll(List list, Object oldVal, Object newVal) {
        boolean result = false;
        int size = list.size();
        if (size < 11 || list instanceof RandomAccess) {
            if (oldVal == null) {
                for (int i = 0; i < size; ++i) {
                    if (list.get(i) != null) continue;
                    list.set(i, newVal);
                    result = true;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (!oldVal.equals(list.get(i))) continue;
                    list.set(i, newVal);
                    result = true;
                }
            }
        } else {
            ListIterator<Object> itr = list.listIterator();
            if (oldVal == null) {
                for (int i = 0; i < size; ++i) {
                    if (itr.next() != null) continue;
                    itr.set(newVal);
                    result = true;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (!oldVal.equals(itr.next())) continue;
                    itr.set(newVal);
                    result = true;
                }
            }
        }
        return result;
    }

    public static int indexOfSubList(List source, List target) {
        int sourceSize = source.size();
        int targetSize = target.size();
        int maxCandidate = sourceSize - targetSize;
        if (sourceSize < 35 || source instanceof RandomAccess && target instanceof RandomAccess) {
            block0: for (int candidate = 0; candidate <= maxCandidate; ++candidate) {
                int i = 0;
                int j = candidate;
                while (i < targetSize) {
                    if (!Collections.eq(target.get(i), source.get(j))) continue block0;
                    ++i;
                    ++j;
                }
                return candidate;
            }
        } else {
            ListIterator si = source.listIterator();
            block2: for (int candidate = 0; candidate <= maxCandidate; ++candidate) {
                ListIterator ti = target.listIterator();
                for (int i = 0; i < targetSize; ++i) {
                    if (Collections.eq(ti.next(), si.next())) continue;
                    for (int j = 0; j < i; ++j) {
                        si.previous();
                    }
                    continue block2;
                }
                return candidate;
            }
        }
        return -1;
    }

    public static int lastIndexOfSubList(List source, List target) {
        int sourceSize = source.size();
        int targetSize = target.size();
        int maxCandidate = sourceSize - targetSize;
        if (sourceSize < 35 || source instanceof RandomAccess) {
            block0: for (int candidate = maxCandidate; candidate >= 0; --candidate) {
                int i = 0;
                int j = candidate;
                while (i < targetSize) {
                    if (!Collections.eq(target.get(i), source.get(j))) continue block0;
                    ++i;
                    ++j;
                }
                return candidate;
            }
        } else {
            if (maxCandidate < 0) {
                return -1;
            }
            ListIterator si = source.listIterator(maxCandidate);
            block2: for (int candidate = maxCandidate; candidate >= 0; --candidate) {
                ListIterator ti = target.listIterator();
                for (int i = 0; i < targetSize; ++i) {
                    if (Collections.eq(ti.next(), si.next())) continue;
                    if (candidate == 0) continue block2;
                    for (int j = 0; j <= i + 1; ++j) {
                        si.previous();
                    }
                    continue block2;
                }
                return candidate;
            }
        }
        return -1;
    }

    public static Collection unmodifiableCollection(Collection c) {
        return new UnmodifiableCollection(c);
    }

    public static Set unmodifiableSet(Set s) {
        return new UnmodifiableSet(s);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    public static List unmodifiableList(List list) {
        return list instanceof RandomAccess ? new UnmodifiableRandomAccessList(list) : new UnmodifiableList(list);
    }

    public static Map unmodifiableMap(Map m) {
        return new UnmodifiableMap(m);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static Collection synchronizedCollection(Collection c) {
        return new SynchronizedCollection(c);
    }

    static Collection synchronizedCollection(Collection c, Object mutex) {
        return new SynchronizedCollection(c, mutex);
    }

    public static Set synchronizedSet(Set s) {
        return new SynchronizedSet(s);
    }

    static Set synchronizedSet(Set s, Object mutex) {
        return new SynchronizedSet(s, mutex);
    }

    public static SortedSet synchronizedSortedSet(SortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static List synchronizedList(List list) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList(list) : new SynchronizedList(list);
    }

    static List synchronizedList(List list, Object mutex) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList(list, mutex) : new SynchronizedList(list, mutex);
    }

    public static Map synchronizedMap(Map m) {
        return new SynchronizedMap(m);
    }

    public static SortedMap synchronizedSortedMap(SortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Collection checkedCollection(Collection c, Class type) {
        return new CheckedCollection(c, type);
    }

    public static Set checkedSet(Set s, Class type) {
        return new CheckedSet(s, type);
    }

    public static SortedSet checkedSortedSet(SortedSet s, Class type) {
        return new CheckedSortedSet(s, type);
    }

    public static List checkedList(List list, Class type) {
        return list instanceof RandomAccess ? new CheckedRandomAccessList(list, type) : new CheckedList(list, type);
    }

    public static Map checkedMap(Map m, Class keyType, Class valueType) {
        return new CheckedMap(m, keyType, valueType);
    }

    public static SortedMap checkedSortedMap(SortedMap m, Class keyType, Class valueType) {
        return new CheckedSortedMap(m, keyType, valueType);
    }

    public static final Set emptySet() {
        return EMPTY_SET;
    }

    public static final List emptyList() {
        return EMPTY_LIST;
    }

    public static final Map emptyMap() {
        return EMPTY_MAP;
    }

    public static Set singleton(Object o) {
        return new SingletonSet(o);
    }

    public static List singletonList(Object o) {
        return new SingletonList(o);
    }

    public static Map singletonMap(Object key, Object value) {
        return new SingletonMap(key, value);
    }

    public static List nCopies(int n, Object o) {
        return new CopiesList(n, o);
    }

    public static Comparator reverseOrder() {
        return REVERSE_ORDER;
    }

    public static Comparator reverseOrder(Comparator cmp) {
        if (cmp == null) {
            return new ReverseComparator();
        }
        return new ReverseComparator2(cmp);
    }

    public static Enumeration enumeration(final Collection c) {
        return new Enumeration(){
            Iterator i;
            {
                this.i = c.iterator();
            }

            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            public Object nextElement() {
                return this.i.next();
            }
        };
    }

    public static ArrayList list(Enumeration e) {
        ArrayList l = new ArrayList();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static int frequency(Collection c, Object o) {
        int result = 0;
        if (o == null) {
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                Object e = itr.next();
                if (e != null) continue;
                ++result;
            }
        } else {
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                Object e = itr.next();
                if (!o.equals(e)) continue;
                ++result;
            }
        }
        return result;
    }

    public static boolean disjoint(Collection c1, Collection c2) {
        if (c1 instanceof Set && !(c2 instanceof Set) || c1.size() > c2.size()) {
            Collection tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        Iterator itr = c1.iterator();
        while (itr.hasNext()) {
            Object e = itr.next();
            if (!c2.contains(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean addAll(Collection c, Object[] a) {
        boolean result = false;
        for (int i = 0; i < a.length; ++i) {
            Object e = a[i];
            result |= c.add(e);
        }
        return result;
    }

    public static Set asSet(Map map) {
        return new MapAsSet(map);
    }

    public static Queue asLifoQueue(Deque deque) {
        return new AsLIFOQueue(deque);
    }

    static {
        EMPTY_SET = new EmptySet();
        EMPTY_LIST = new EmptyList();
        EMPTY_MAP = new EmptyMap();
        REVERSE_ORDER = new ReverseComparator();
    }

    static class AsLIFOQueue
    extends AbstractQueue
    implements Queue,
    Serializable {
        private static final long serialVersionUID = 1802017725587941708L;
        private final Deque q;

        AsLIFOQueue(Deque q) {
            this.q = q;
        }

        public boolean offer(Object e) {
            return this.q.offerFirst(e);
        }

        public Object poll() {
            return this.q.pollFirst();
        }

        public Object remove() {
            return this.q.removeFirst();
        }

        public Object peek() {
            return this.q.peekFirst();
        }

        public Object element() {
            return this.q.getFirst();
        }

        public int size() {
            return this.q.size();
        }

        public boolean isEmpty() {
            return this.q.isEmpty();
        }

        public boolean contains(Object o) {
            return this.q.contains(o);
        }

        public Iterator iterator() {
            return this.q.iterator();
        }

        public Object[] toArray() {
            return this.q.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.q.toArray(a);
        }

        public boolean add(Object e) {
            return this.q.offerFirst(e);
        }

        public boolean remove(Object o) {
            return this.q.remove(o);
        }

        public void clear() {
            this.q.clear();
        }
    }

    private static class MapAsSet
    extends AbstractSet
    implements Set,
    Serializable {
        private final Map m;
        private transient Set keySet;
        private static final long serialVersionUID = 2454657854757543876L;

        MapAsSet(Map map) {
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("Map is non-empty");
            }
            this.m = map;
            this.keySet = map.keySet();
        }

        public int size() {
            return this.m.size();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        public Iterator iterator() {
            return this.keySet.iterator();
        }

        public Object[] toArray() {
            return this.keySet.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.keySet.toArray(a);
        }

        public boolean add(Object e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        public boolean removeAll(Collection c) {
            return this.keySet.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            return this.keySet.retainAll(c);
        }

        public void clear() {
            this.m.clear();
        }

        public boolean equals(Object o) {
            return ((Object)this.keySet).equals(o);
        }

        public int hashCode() {
            return ((Object)this.keySet).hashCode();
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.keySet = this.m.keySet();
        }
    }

    private static class ReverseComparator2
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 4374092139857L;
        private Comparator cmp;
        static final /* synthetic */ boolean $assertionsDisabled;

        ReverseComparator2(Comparator cmp) {
            if (!$assertionsDisabled && cmp == null) {
                throw new AssertionError();
            }
            this.cmp = cmp;
        }

        public int compare(Object t1, Object t2) {
            return this.cmp.compare(t2, t1);
        }

        static {
            $assertionsDisabled = !(class$edu$emory$mathcs$backport$java$util$Collections == null ? (class$edu$emory$mathcs$backport$java$util$Collections = Collections.class$("edu.emory.mathcs.backport.java.util.Collections")) : class$edu$emory$mathcs$backport$java$util$Collections).desiredAssertionStatus();
        }
    }

    private static class ReverseComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;

        private ReverseComparator() {
        }

        public int compare(Object c1, Object c2) {
            return ((Comparable)c2).compareTo(c1);
        }
    }

    private static class CopiesList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        static final long serialVersionUID = 2739099268398711800L;
        int n;
        Object element;

        CopiesList(int n, Object e) {
            if (n < 0) {
                throw new IllegalArgumentException("List length = " + n);
            }
            this.n = n;
            this.element = e;
        }

        public int size() {
            return this.n;
        }

        public boolean contains(Object obj) {
            return this.n != 0 && Collections.eq(obj, this.element);
        }

        public Object get(int index) {
            if (index < 0 || index >= this.n) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.n);
            }
            return this.element;
        }
    }

    private static class SingletonMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final Object k;
        private final Object v;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        SingletonMap(Object key, Object value) {
            this.k = key;
            this.v = value;
        }

        public int size() {
            return 1;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean containsKey(Object key) {
            return Collections.eq(key, this.k);
        }

        public boolean containsValue(Object value) {
            return Collections.eq(value, this.v);
        }

        public Object get(Object key) {
            return Collections.eq(key, this.k) ? this.v : null;
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.singleton(this.k);
            }
            return this.keySet;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.singleton(new AbstractMap.SimpleImmutableEntry(this.k, this.v));
            }
            return this.entrySet;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }
    }

    private static class SingletonList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        static final long serialVersionUID = 3093736618740652951L;
        private final Object element;

        SingletonList(Object obj) {
            this.element = obj;
        }

        public int size() {
            return 1;
        }

        public boolean contains(Object obj) {
            return Collections.eq(obj, this.element);
        }

        public Object get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
            }
            return this.element;
        }
    }

    private static class SingletonSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        private final Object element;

        SingletonSet(Object e) {
            this.element = e;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private boolean hasNext;
                private final /* synthetic */ SingletonSet this$0;
                {
                    this.this$0 = this$0;
                    this.hasNext = true;
                }

                public boolean hasNext() {
                    return this.hasNext;
                }

                public Object next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonSet.access$400(this.this$0);
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int size() {
            return 1;
        }

        public boolean contains(Object o) {
            return Collections.eq(o, this.element);
        }

        static /* synthetic */ Object access$400(SingletonSet x0) {
            return x0.element;
        }
    }

    private static class EmptyMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        private EmptyMap() {
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean containsKey(Object key) {
            return false;
        }

        public boolean containsValue(Object value) {
            return false;
        }

        public Object get(Object key) {
            return null;
        }

        public Set keySet() {
            return Collections.emptySet();
        }

        public Collection values() {
            return Collections.emptySet();
        }

        public Set entrySet() {
            return Collections.emptySet();
        }

        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).size() == 0;
        }

        public int hashCode() {
            return 0;
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }
    }

    private static class EmptyList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 8842843931221139166L;

        private EmptyList() {
        }

        public int size() {
            return 0;
        }

        public boolean contains(Object obj) {
            return false;
        }

        public Object get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }
    }

    private static class EmptySet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        private EmptySet() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                private final /* synthetic */ EmptySet this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int size() {
            return 0;
        }

        public boolean contains(Object obj) {
            return false;
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }

    static class CheckedSortedMap
    extends CheckedMap
    implements SortedMap,
    Serializable {
        private static final long serialVersionUID = 1599671320688067438L;
        private final SortedMap sm;

        CheckedSortedMap(SortedMap m, Class keyType, Class valueType) {
            super(m, keyType, valueType);
            this.sm = m;
        }

        public Comparator comparator() {
            return this.sm.comparator();
        }

        public Object firstKey() {
            return this.sm.firstKey();
        }

        public Object lastKey() {
            return this.sm.lastKey();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return new CheckedSortedMap(this.sm.subMap(fromKey, toKey), this.keyType, this.valueType);
        }

        public SortedMap headMap(Object toKey) {
            return new CheckedSortedMap(this.sm.headMap(toKey), this.keyType, this.valueType);
        }

        public SortedMap tailMap(Object fromKey) {
            return new CheckedSortedMap(this.sm.tailMap(fromKey), this.keyType, this.valueType);
        }
    }

    private static class CheckedMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = 5742860141034234728L;
        private final Map m;
        final Class keyType;
        final Class valueType;
        private Object[] zeroLengthKeyArray = null;
        private Object[] zeroLengthValueArray = null;
        private transient Set entrySet = null;

        private void typeCheck(Object key, Object value) {
            if (!this.keyType.isInstance(key)) {
                throw new ClassCastException("Attempt to insert " + key.getClass() + " key into collection with key type " + this.keyType);
            }
            if (!this.valueType.isInstance(value)) {
                throw new ClassCastException("Attempt to insert " + value.getClass() + " value into collection with value type " + this.valueType);
            }
        }

        CheckedMap(Map m, Class keyType, Class valueType) {
            if (m == null || keyType == null || valueType == null) {
                throw new NullPointerException();
            }
            this.m = m;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public int size() {
            return this.m.size();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        public boolean containsValue(Object v) {
            return this.m.containsValue(v);
        }

        public Object get(Object key) {
            return this.m.get(key);
        }

        public Object remove(Object key) {
            return this.m.remove(key);
        }

        public void clear() {
            this.m.clear();
        }

        public Set keySet() {
            return this.m.keySet();
        }

        public Collection values() {
            return this.m.values();
        }

        public boolean equals(Object o) {
            return ((Object)this.m).equals(o);
        }

        public int hashCode() {
            return ((Object)this.m).hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        public Object put(Object key, Object value) {
            this.typeCheck(key, value);
            return this.m.put(key, value);
        }

        public void putAll(Map t) {
            Object[] keys = null;
            try {
                keys = t.keySet().toArray(this.zeroLengthKeyArray());
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException();
            }
            Object[] values = null;
            try {
                values = t.values().toArray(this.zeroLengthValueArray());
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException();
            }
            if (keys.length != values.length) {
                throw new ConcurrentModificationException();
            }
            for (int i = 0; i < keys.length; ++i) {
                this.m.put(keys[i], values[i]);
            }
        }

        private Object[] zeroLengthKeyArray() {
            if (this.zeroLengthKeyArray == null) {
                this.zeroLengthKeyArray = (Object[])Array.newInstance(this.keyType, 0);
            }
            return this.zeroLengthKeyArray;
        }

        private Object[] zeroLengthValueArray() {
            if (this.zeroLengthValueArray == null) {
                this.zeroLengthValueArray = (Object[])Array.newInstance(this.valueType, 0);
            }
            return this.zeroLengthValueArray;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new CheckedEntrySet(this.m.entrySet(), this.valueType);
            }
            return this.entrySet;
        }

        static class CheckedEntrySet
        implements Set {
            Set s;
            Class valueType;

            CheckedEntrySet(Set s, Class valueType) {
                this.s = s;
                this.valueType = valueType;
            }

            public int size() {
                return this.s.size();
            }

            public boolean isEmpty() {
                return this.s.isEmpty();
            }

            public String toString() {
                return this.s.toString();
            }

            public int hashCode() {
                return ((Object)this.s).hashCode();
            }

            public boolean remove(Object o) {
                return this.s.remove(o);
            }

            public boolean removeAll(Collection coll) {
                return this.s.removeAll(coll);
            }

            public boolean retainAll(Collection coll) {
                return this.s.retainAll(coll);
            }

            public void clear() {
                this.s.clear();
            }

            public boolean add(Object e) {
                throw new UnsupportedOperationException();
            }

            public boolean addAll(Collection coll) {
                throw new UnsupportedOperationException();
            }

            public Iterator iterator() {
                return new Iterator(this){
                    Iterator i;
                    private final /* synthetic */ CheckedEntrySet this$0;
                    {
                        this.this$0 = this$0;
                        this.i = this.this$0.s.iterator();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public void remove() {
                        this.i.remove();
                    }

                    public Object next() {
                        return new CheckedEntry((Map.Entry)this.i.next(), this.this$0.valueType);
                    }
                };
            }

            public Object[] toArray() {
                Object[] source = this.s.toArray();
                Object[] dest = (class$edu$emory$mathcs$backport$java$util$Collections$CheckedMap$CheckedEntrySet$CheckedEntry == null ? (class$edu$emory$mathcs$backport$java$util$Collections$CheckedMap$CheckedEntrySet$CheckedEntry = Collections.class$("edu.emory.mathcs.backport.java.util.Collections$CheckedMap$CheckedEntrySet$CheckedEntry")) : class$edu$emory$mathcs$backport$java$util$Collections$CheckedMap$CheckedEntrySet$CheckedEntry).isInstance(source.getClass().getComponentType()) ? source : new Object[source.length];
                for (int i = 0; i < source.length; ++i) {
                    dest[i] = new CheckedEntry((Map.Entry)source[i], this.valueType);
                }
                return dest;
            }

            public Object[] toArray(Object[] a) {
                Object[] arr = this.s.toArray(a.length == 0 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 0));
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = new CheckedEntry((Map.Entry)arr[i], this.valueType);
                }
                if (arr.length > a.length) {
                    return arr;
                }
                System.arraycopy(arr, 0, a, 0, arr.length);
                if (a.length > arr.length) {
                    a[arr.length] = null;
                }
                return a;
            }

            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return this.s.contains(new CheckedEntry((Map.Entry)o, this.valueType));
            }

            public boolean containsAll(Collection coll) {
                Iterator e = coll.iterator();
                while (e.hasNext()) {
                    if (this.contains(e.next())) continue;
                    return false;
                }
                return true;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Set)) {
                    return false;
                }
                Set that = (Set)o;
                if (that.size() != this.s.size()) {
                    return false;
                }
                return this.containsAll((Collection)that);
            }

            private static class CheckedEntry
            implements Map.Entry {
                private Map.Entry e;
                private Class valueType;

                CheckedEntry(Map.Entry e, Class valueType) {
                    this.e = e;
                    this.valueType = valueType;
                }

                public Object getKey() {
                    return this.e.getKey();
                }

                public Object getValue() {
                    return this.e.getValue();
                }

                public int hashCode() {
                    return ((Object)this.e).hashCode();
                }

                public String toString() {
                    return this.e.toString();
                }

                public Object setValue(Object value) {
                    if (!this.valueType.isInstance(value)) {
                        throw new ClassCastException("Attempt to insert " + value.getClass() + " value into collection with value type " + this.valueType);
                    }
                    return this.e.setValue(value);
                }

                public boolean equals(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry t = (Map.Entry)o;
                    return Collections.eq(this.e.getKey(), t.getKey()) && Collections.eq(this.e.getValue(), t.getValue());
                }
            }
        }
    }

    static class CheckedRandomAccessList
    extends CheckedList
    implements RandomAccess {
        private static final long serialVersionUID = 1638200125423088369L;

        CheckedRandomAccessList(List list, Class type) {
            super(list, type);
        }

        public List subList(int fromIndex, int toIndex) {
            return new CheckedRandomAccessList(this.list.subList(fromIndex, toIndex), this.type);
        }
    }

    static class CheckedList
    extends CheckedCollection
    implements List {
        static final long serialVersionUID = 65247728283967356L;
        final List list;

        CheckedList(List list, Class type) {
            super(list, type);
            this.list = list;
        }

        public boolean equals(Object o) {
            return ((Object)this.list).equals(o);
        }

        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        public Object get(int index) {
            return this.list.get(index);
        }

        public Object remove(int index) {
            return this.list.remove(index);
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public Object set(int index, Object element) {
            this.typeCheck(element);
            return this.list.set(index, element);
        }

        public void add(int index, Object element) {
            this.typeCheck(element);
            this.list.add(index, element);
        }

        public boolean addAll(int index, Collection c) {
            Object[] a = null;
            try {
                a = c.toArray(this.zeroLengthElementArray());
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException();
            }
            return this.list.addAll(index, Arrays.asList(a));
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int index) {
            return new ListIterator(this, index){
                ListIterator i;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ CheckedList this$0;
                {
                    this.this$0 = this$0;
                    this.val$index = val$index;
                    this.i = this.this$0.list.listIterator(this.val$index);
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }

                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                public Object previous() {
                    return this.i.previous();
                }

                public int nextIndex() {
                    return this.i.nextIndex();
                }

                public int previousIndex() {
                    return this.i.previousIndex();
                }

                public void remove() {
                    this.i.remove();
                }

                public void set(Object e) {
                    this.this$0.typeCheck(e);
                    this.i.set(e);
                }

                public void add(Object e) {
                    this.this$0.typeCheck(e);
                    this.i.add(e);
                }
            };
        }

        public List subList(int fromIndex, int toIndex) {
            return new CheckedList(this.list.subList(fromIndex, toIndex), this.type);
        }
    }

    static class CheckedSortedSet
    extends CheckedSet
    implements SortedSet,
    Serializable {
        private static final long serialVersionUID = 1599911165492914959L;
        private final SortedSet ss;

        CheckedSortedSet(SortedSet s, Class type) {
            super(s, type);
            this.ss = s;
        }

        public Comparator comparator() {
            return this.ss.comparator();
        }

        public Object first() {
            return this.ss.first();
        }

        public Object last() {
            return this.ss.last();
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            return new CheckedSortedSet(this.ss.subSet(fromElement, toElement), this.type);
        }

        public SortedSet headSet(Object toElement) {
            return new CheckedSortedSet(this.ss.headSet(toElement), this.type);
        }

        public SortedSet tailSet(Object fromElement) {
            return new CheckedSortedSet(this.ss.tailSet(fromElement), this.type);
        }
    }

    static class CheckedSet
    extends CheckedCollection
    implements Set,
    Serializable {
        private static final long serialVersionUID = 4694047833775013803L;

        CheckedSet(Set s, Class elementType) {
            super(s, elementType);
        }

        public boolean equals(Object o) {
            return ((Object)this.c).equals(o);
        }

        public int hashCode() {
            return ((Object)this.c).hashCode();
        }
    }

    static class CheckedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 1578914078182001775L;
        final Collection c;
        final Class type;
        private Object[] zeroLengthElementArray = null;

        void typeCheck(Object o) {
            if (!this.type.isInstance(o)) {
                throw new ClassCastException("Attempt to insert " + o.getClass() + " element into collection with element type " + this.type);
            }
        }

        CheckedCollection(Collection c, Class type) {
            if (c == null || type == null) {
                throw new NullPointerException();
            }
            this.c = c;
            this.type = type;
        }

        public int size() {
            return this.c.size();
        }

        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        public Object[] toArray() {
            return this.c.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.c.toArray(a);
        }

        public String toString() {
            return this.c.toString();
        }

        public Iterator iterator() {
            return this.c.iterator();
        }

        public boolean remove(Object o) {
            return this.c.remove(o);
        }

        public boolean containsAll(Collection coll) {
            return this.c.containsAll(coll);
        }

        public boolean removeAll(Collection coll) {
            return this.c.removeAll(coll);
        }

        public boolean retainAll(Collection coll) {
            return this.c.retainAll(coll);
        }

        public void clear() {
            this.c.clear();
        }

        public boolean add(Object e) {
            this.typeCheck(e);
            return this.c.add(e);
        }

        public boolean addAll(Collection coll) {
            Object[] a = null;
            try {
                a = coll.toArray(this.zeroLengthElementArray());
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException();
            }
            boolean result = false;
            for (int i = 0; i < a.length; ++i) {
                Object e = a[i];
                result |= this.c.add(e);
            }
            return result;
        }

        Object[] zeroLengthElementArray() {
            if (this.zeroLengthElementArray == null) {
                this.zeroLengthElementArray = (Object[])Array.newInstance(this.type, 0);
            }
            return this.zeroLengthElementArray;
        }
    }

    static class SynchronizedSortedMap
    extends SynchronizedMap
    implements SortedMap {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap sm;

        SynchronizedSortedMap(SortedMap m) {
            super(m);
            this.sm = m;
        }

        SynchronizedSortedMap(SortedMap m, Object mutex) {
            super(m, mutex);
            this.sm = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap subMap(Object fromKey, Object toKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap(this.sm.subMap(fromKey, toKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap headMap(Object toKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap(this.sm.headMap(toKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedMap tailMap(Object fromKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap(this.sm.tailMap(fromKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }
    }

    private static class SynchronizedMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map m;
        final Object mutex;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        SynchronizedMap(Map m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.m = m;
            this.mutex = this;
        }

        SynchronizedMap(Map m, Object mutex) {
            this.m = m;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = new SynchronizedSet(this.m.keySet(), this.mutex);
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = new SynchronizedSet(this.m.entrySet(), this.mutex);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.values == null) {
                    this.values = new SynchronizedCollection(this.m.values(), this.mutex);
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.m).equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.m).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                s.defaultWriteObject();
            }
        }
    }

    static class SynchronizedRandomAccessList
    extends SynchronizedList
    implements RandomAccess {
        static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List list) {
            super(list);
        }

        SynchronizedRandomAccessList(List list, Object mutex) {
            super(list, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.list.subList(fromIndex, toIndex), this.mutex);
            }
        }

        private Object writeReplace() {
            return new SynchronizedList(this.list);
        }
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        static final long serialVersionUID = -7754090372962971524L;
        final List list;

        SynchronizedList(List list) {
            super(list);
            this.list = list;
        }

        SynchronizedList(List list, Object mutex) {
            super(list, mutex);
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.list).equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.list).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object element) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.set(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, Object element) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.add(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        public ListIterator listIterator() {
            return this.list.listIterator();
        }

        public ListIterator listIterator(int index) {
            return this.list.listIterator(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList(this.list.subList(fromIndex, toIndex), this.mutex);
            }
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new SynchronizedRandomAccessList(this.list) : this;
        }
    }

    static class SynchronizedSortedSet
    extends SynchronizedSet
    implements SortedSet {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet ss;

        SynchronizedSortedSet(SortedSet s) {
            super(s);
            this.ss = s;
        }

        SynchronizedSortedSet(SortedSet s, Object mutex) {
            super(s, mutex);
            this.ss = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet subSet(Object fromElement, Object toElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet(this.ss.subSet(fromElement, toElement), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet headSet(Object toElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet(this.ss.headSet(toElement), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SortedSet tailSet(Object fromElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet(this.ss.tailSet(fromElement), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set s) {
            super(s);
        }

        SynchronizedSet(Set s, Object mutex) {
            super(s, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.c).equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.c).hashCode();
            }
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection c;
        final Object mutex;

        SynchronizedCollection(Collection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.c = c;
            this.mutex = this;
        }

        SynchronizedCollection(Collection c, Object mutex) {
            this.c = c;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(a);
            }
        }

        public Iterator iterator() {
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                s.defaultWriteObject();
            }
        }
    }

    static class UnmodifiableSortedMap
    extends UnmodifiableMap
    implements SortedMap,
    Serializable {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap sm;

        UnmodifiableSortedMap(SortedMap m) {
            super(m);
            this.sm = m;
        }

        public Comparator comparator() {
            return this.sm.comparator();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return new UnmodifiableSortedMap(this.sm.subMap(fromKey, toKey));
        }

        public SortedMap headMap(Object toKey) {
            return new UnmodifiableSortedMap(this.sm.headMap(toKey));
        }

        public SortedMap tailMap(Object fromKey) {
            return new UnmodifiableSortedMap(this.sm.tailMap(fromKey));
        }

        public Object firstKey() {
            return this.sm.firstKey();
        }

        public Object lastKey() {
            return this.sm.lastKey();
        }
    }

    private static class UnmodifiableMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map m;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        UnmodifiableMap(Map m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.m = m;
        }

        public int size() {
            return this.m.size();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        public boolean containsValue(Object val) {
            return this.m.containsValue(val);
        }

        public Object get(Object key) {
            return this.m.get(key);
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.m.keySet());
            }
            return this.keySet;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifiableEntrySet(this.m.entrySet());
            }
            return this.entrySet;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        public boolean equals(Object o) {
            return ((Object)this.m).equals(o);
        }

        public int hashCode() {
            return ((Object)this.m).hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        static class UnmodifiableEntrySet
        extends UnmodifiableSet {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set s) {
                super(s);
            }

            public Iterator iterator() {
                return new Iterator(this){
                    Iterator i;
                    private final /* synthetic */ UnmodifiableEntrySet this$0;
                    {
                        this.this$0 = this$0;
                        this.i = this.this$0.c.iterator();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public Object next() {
                        return new UnmodifiableEntry((Map.Entry)this.i.next());
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public Object[] toArray() {
                Object[] a = this.c.toArray();
                for (int i = 0; i < a.length; ++i) {
                    a[i] = new UnmodifiableEntry((Map.Entry)a[i]);
                }
                return a;
            }

            public Object[] toArray(Object[] a) {
                Object[] arr = this.c.toArray(a.length == 0 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 0));
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = new UnmodifiableEntry((Map.Entry)arr[i]);
                }
                if (arr.length > a.length) {
                    return arr;
                }
                System.arraycopy(arr, 0, a, 0, arr.length);
                if (a.length > arr.length) {
                    a[arr.length] = null;
                }
                return a;
            }

            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return this.c.contains(new UnmodifiableEntry((Map.Entry)o));
            }

            public boolean containsAll(Collection coll) {
                Iterator e = coll.iterator();
                while (e.hasNext()) {
                    if (this.contains(e.next())) continue;
                    return false;
                }
                return true;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Set)) {
                    return false;
                }
                Set s = (Set)o;
                if (s.size() != this.c.size()) {
                    return false;
                }
                return this.containsAll((Collection)s);
            }

            private static class UnmodifiableEntry
            implements Map.Entry {
                private Map.Entry e;

                UnmodifiableEntry(Map.Entry e) {
                    this.e = e;
                }

                public Object getKey() {
                    return this.e.getKey();
                }

                public Object getValue() {
                    return this.e.getValue();
                }

                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }

                public int hashCode() {
                    return ((Object)this.e).hashCode();
                }

                public boolean equals(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry t = (Map.Entry)o;
                    return Collections.eq(this.e.getKey(), t.getKey()) && Collections.eq(this.e.getValue(), t.getValue());
                }

                public String toString() {
                    return this.e.toString();
                }
            }
        }
    }

    static class UnmodifiableRandomAccessList
    extends UnmodifiableList
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List list) {
            super(list);
        }

        public List subList(int fromIndex, int toIndex) {
            return new UnmodifiableRandomAccessList(this.list.subList(fromIndex, toIndex));
        }

        private Object writeReplace() {
            return new UnmodifiableList(this.list);
        }
    }

    static class UnmodifiableList
    extends UnmodifiableCollection
    implements List {
        static final long serialVersionUID = -283967356065247728L;
        final List list;

        UnmodifiableList(List list) {
            super(list);
            this.list = list;
        }

        public boolean equals(Object o) {
            return ((Object)this.list).equals(o);
        }

        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        public Object get(int index) {
            return this.list.get(index);
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int index) {
            return new ListIterator(this, index){
                ListIterator i;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ UnmodifiableList this$0;
                {
                    this.this$0 = this$0;
                    this.val$index = val$index;
                    this.i = this.this$0.list.listIterator(this.val$index);
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }

                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                public Object previous() {
                    return this.i.previous();
                }

                public int nextIndex() {
                    return this.i.nextIndex();
                }

                public int previousIndex() {
                    return this.i.previousIndex();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public void set(Object e) {
                    throw new UnsupportedOperationException();
                }

                public void add(Object e) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List subList(int fromIndex, int toIndex) {
            return new UnmodifiableList(this.list.subList(fromIndex, toIndex));
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new UnmodifiableRandomAccessList(this.list) : this;
        }
    }

    static class UnmodifiableSortedSet
    extends UnmodifiableSet
    implements SortedSet,
    Serializable {
        private static final long serialVersionUID = -4929149591599911165L;
        private final SortedSet ss;

        UnmodifiableSortedSet(SortedSet s) {
            super(s);
            this.ss = s;
        }

        public Comparator comparator() {
            return this.ss.comparator();
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            return new UnmodifiableSortedSet(this.ss.subSet(fromElement, toElement));
        }

        public SortedSet headSet(Object toElement) {
            return new UnmodifiableSortedSet(this.ss.headSet(toElement));
        }

        public SortedSet tailSet(Object fromElement) {
            return new UnmodifiableSortedSet(this.ss.tailSet(fromElement));
        }

        public Object first() {
            return this.ss.first();
        }

        public Object last() {
            return this.ss.last();
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCollection
    implements Set,
    Serializable {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set s) {
            super(s);
        }

        public boolean equals(Object o) {
            return ((Object)this.c).equals(o);
        }

        public int hashCode() {
            return ((Object)this.c).hashCode();
        }
    }

    static class UnmodifiableCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection c;

        UnmodifiableCollection(Collection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.c = c;
        }

        public int size() {
            return this.c.size();
        }

        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        public Object[] toArray() {
            return this.c.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.c.toArray(a);
        }

        public String toString() {
            return this.c.toString();
        }

        public Iterator iterator() {
            return new Iterator(){
                Iterator i;
                {
                    this.i = c.iterator();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection coll) {
            return this.c.containsAll(coll);
        }

        public boolean addAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface SelfComparable
    extends Comparable {
    }
}

