/*
Copyright (c) 2011, David Linner <david.linner@tu-berlin.de>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class Main {
		
	public static void main(String[] args){
				
		try {
			
			int port = 8080;
			if (args.length > 0){
				try{
					port = Integer.parseInt(args[0]);
				}catch (NumberFormatException e){
					System.err.println(String.format("'%s' is not a valid port number. Using port %s instead.", args[0], port));
				}
			}
			
			Server server = new Server(port);			
					 
	        ServletContextHandler servletContext = new ServletContextHandler();	     	        	        
	        servletContext.addServlet(new ServletHolder(new ForwardServlet()), "/forward");       
	        
	        ResourceHandler files = new ResourceHandler();
	        files.setResourceBase("./WebContent/");
	        
	        HandlerList handlers = new HandlerList();
	        handlers.addHandler(servletContext);
	        handlers.addHandler(files);
	        
	        server.setHandler(handlers);
	        
	        server.start();			
			server.join();
	       			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
