/*
Copyright (c) 2011, David Linner <david.linner@tu-berlin.de>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. 
*/

function Operation(own, ref, typ, off, chr){
	this.own = own;
	this.ref = ref;
	this.typ = typ;
	if (typeof off != "undefined"){
		this.off = off;
	}
	if (typeof chr != "undefined"){
		this.chr = chr;
	}	
}

function OperationContext(){
	this._history_offset = 0;
	this._history = [];	
	this._reference = 0;
}

OperationContext.prototype.transform = function(op){
	// update history
	var shift = op.ref - this._history_offset ;	
	this._history.splice(0, shift);
	this._history_offset += shift;
	
	// include op and history
	for (var i = 0; i < this._history.length; i++){
		var tmp = op;
		op = this._include(op, this._history[i]);
		this._history[i] = this._include(this._history[i], tmp); 
	}
	
	// update pointer to most recent remote operation 
	this._reference = op.own; 
	
	return op;
};

OperationContext.prototype._include = function(op1, op2){
 
	if (op1.typ === "nop" || op2.typ === "nop"){
		return op1;
	} else if (op1.typ === "ins" && op2.typ === "ins"){
		var off = (op2.off < op1.off || (op2.off == op1.off && op2.chr < op1.chr) ? op1.off + 1 : op1.off);
		return new Operation(op1.own, op1.ref, op1.typ, off, op1.chr);
	} else if (op1.typ === "ins" && op2.typ === "rem"){
		var off = (op2.off < op1.off ? op1.off - 1 : op1.off);
		return new Operation(op1.own, op1.ref, op1.typ, off, op1.chr);
	} else if (op1.typ === "rem" && op2.typ === "ins"){
		var off = (op2.off <= op1.off ? op1.off + 1 : op1.off);
		return new Operation(op1.own, op1.ref, op1.typ, off);
	} else if (op1.typ === "rem" && op2.typ === "rem"){
		var off;
		if (op2.off < op1.off) {
			off = op1.off - 1;
		} else if ( op2.off > op1.off){
			off = op1.off; 
		} else {
			return new Operation(op1.own, op1.ref, "nop");
		}
		return new Operation(op1.own, op1.ref, op1.typ, off);
	}
	
};

OperationContext.prototype.createOperation = function (typ, off, chr){
	var op = new Operation(this._history_offset + this._history.length + 1, this._reference, typ, off, chr);
	
	this._history.push(op);
	
	return op;
};