/*
 * Created on Apr 15, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatagramSender extends Thread {
    private Log log = LogFactory.getLog(DatagramSender.class);

    /**
     * The interval in which the KeysDatagram is submitted.
     */
    public final static long IDLE_SENDING_INTERVAL = 20;

    private DatagramSocket socket;
    private KeysDatagram keysDatagram;
    private ConnectionStatus connectionStatus;

    private long lastSentTimestamp = 0;

    public void run() {
        log.debug("Thread running");

        try {
            while(true) {
                if ( (lastSentTimestamp + IDLE_SENDING_INTERVAL) < System.currentTimeMillis()) {
                    // Send idle packet
                    //log.debug("Send idle packet");
                    sendPacket();
                }

                Thread.sleep(IDLE_SENDING_INTERVAL);
            }
        } catch (SocketException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void sendPacket() throws IOException {
        DatagramPacket dgram = new DatagramPacket(keysDatagram.getData(), 8);
        dgram.setAddress(InetAddress.getByName(ConnectionInfo.IP_ADDRESS));
        dgram.setPort(ConnectionInfo.PORT);

        //log.debug("Sending datagram " + keysDatagram.getSentSerial());
        socket.send(dgram);

        // Save sent timestamp for latency calculation
        connectionStatus.addSentTimestamp(keysDatagram.getSentSerial(), System.currentTimeMillis());

        // Package was sent
        keysDatagram.packageSent();

        lastSentTimestamp = System.currentTimeMillis();
    }

    /*
     * Injected spring beans.
     */

    /**
     * @param socket the socket to set
     */
    public void setSocket(DatagramSocket socket) {
        this.socket = socket;
    }

    /**
     * @param keysDatagram the keysDatagram to set
     */
    public void setKeysDatagram(KeysDatagram keysDatagram) {
        this.keysDatagram = keysDatagram;
    }

    /**
     * @param connectionStatus the connectionStatus to set
     */
    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }
}
