/*
 * Created on Apr 18, 2008
 *
 * (c) 2006-2007 dka - edv, media, webdesign
 *
 */
package com.dkaedv.asteroids.gui;

import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.dkaedv.asteroids.data.GameStatus;
import com.dkaedv.asteroids.data.IPositionable;
import com.dkaedv.asteroids.data.Vector;
import com.dkaedv.asteroids.ki.TargetList;
import com.dkaedv.asteroids.net.ConnectionStatus;
import com.dkaedv.asteroids.util.VectorCalculations;


public class MainFrame extends JFrame {

    private static final long serialVersionUID = 1L;

    private GameStatus gameStatus;
    private TargetList targetList;
    private ConnectionStatus connectionStatus;

    private JLabel livesTextfield;
    private JLabel shipSpeedTextfield;
    private JLabel latencyTextfield;
    private JLabel targetDistanceTextfield;
    private JLabel targetAngleTextfield;
    private JLabel shotSpeedTextfield;

    public MainFrame() {
        setTitle("Asteroid Client");
    }

    public void init() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.PAGE_AXIS));
        getContentPane().add(mainPanel);

        SpaceComponent display = new SpaceComponent(640, gameStatus, targetList);
        mainPanel.add(display);

        JPanel infoPanel = new JPanel(new FlowLayout());

        infoPanel.add(new JLabel("Lives:"));
        livesTextfield = new JLabel(String.valueOf(gameStatus.getLives()));
        infoPanel.add(livesTextfield);

        infoPanel.add(new JLabel("Ship Speed:"));
        shipSpeedTextfield = new JLabel("000");
        infoPanel.add(shipSpeedTextfield);

        infoPanel.add(new JLabel("Latency:"));
        latencyTextfield = new JLabel("00");
        infoPanel.add(latencyTextfield);

        infoPanel.add(new JLabel("Target Distance:"));
        targetDistanceTextfield = new JLabel("000");
        infoPanel.add(targetDistanceTextfield);

        infoPanel.add(new JLabel("Target Angle:"));
        targetAngleTextfield = new JLabel("000");
        infoPanel.add(targetAngleTextfield);

        infoPanel.add(new JLabel("Avg Shot Speed:"));
        shotSpeedTextfield = new JLabel("000");
        infoPanel.add(shotSpeedTextfield);

        mainPanel.add(infoPanel);

        pack();
        setVisible(true);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

    @Override
    public void repaint() {
        livesTextfield.setText(String.valueOf(gameStatus.getLives()));

        if (gameStatus.getShip() != null) {
            shipSpeedTextfield.setText(String.format("%03d", (int)gameStatus.getShip().getPosition().getSpeed()));

            IPositionable target = targetList.getFirstTarget();
            if (target != null) {
                Vector targetVector = VectorCalculations.getDifferenceNormalized(gameStatus.getShip().getPosition().getCurVector(), target.getPosition().getCurVector());
                targetDistanceTextfield.setText(String.format("%03.0f", VectorCalculations.getNorm(targetVector)));
                targetAngleTextfield.setText(String.format("%01.2f", Math.atan2(targetVector.y, targetVector.x)));
            }
        }

        latencyTextfield.setText(String.format("%03d", connectionStatus.getLatency()) + "ms");

        shotSpeedTextfield.setText(String.format("%03.0f", gameStatus.getAverageShotSpeed()));


        super.repaint();
    }

    /*
     * Injected Spring beans.
     */

    /**
     * @param gameStatus the gameStatus to set
     */
    public void setGameStatus(GameStatus gameStatus) {
        this.gameStatus = gameStatus;
    }

    /**
     * @param targetList the targetList to set
     */
    public void setTargetList(TargetList targetList) {
        this.targetList = targetList;
    }

    /**
     * @param connectionStatus the connectionStatus to set
     */
    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

}
