/*
 * Decompiled with CFR 0.152.
 */
package com.dkaedv.asteroids.net;

import com.dkaedv.asteroids.net.FrameInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeysDatagram {
    private Log log = LogFactory.getLog(KeysDatagram.class);
    private int sentSerial = 0;
    private long lastSentTimestamp = 0L;
    private static final int MAX_SENT_SERIAL = 256;
    private long leftCycles = 0L;
    private long rightCycles = 0L;
    private long fireCycles = 0L;
    private long warpCycles = 0L;
    private long thrustCycles = 0L;

    public synchronized void packageSent() {
        this.lastSentTimestamp = System.currentTimeMillis();
        ++this.sentSerial;
        if (this.sentSerial == 256) {
            this.sentSerial = 0;
        }
        if (this.leftCycles > 0L) {
            --this.leftCycles;
        }
        if (this.rightCycles > 0L) {
            --this.rightCycles;
        }
        if (this.fireCycles > 0L) {
            --this.fireCycles;
        }
        if (this.warpCycles > 0L) {
            --this.warpCycles;
        }
        if (this.thrustCycles > 0L) {
            --this.thrustCycles;
        }
    }

    public int getSentSerial() {
        return this.sentSerial;
    }

    public synchronized void left(long time) {
        this.leftCycles = this.calcCycles(time);
        this.rightCycles = 0L;
    }

    public synchronized void right(long time) {
        this.rightCycles = this.calcCycles(time);
        this.leftCycles = 0L;
    }

    public synchronized void fire(long time) {
        this.fireCycles = this.calcCycles(time);
    }

    public synchronized void warp(long time) {
        this.warpCycles = this.calcCycles(time);
    }

    public synchronized void thrust(long time) {
        this.thrustCycles = this.calcCycles(time);
    }

    public synchronized boolean isLeft() {
        return this.leftCycles > 0L;
    }

    public synchronized boolean isRight() {
        return this.rightCycles > 0L;
    }

    public synchronized boolean isWarp() {
        return this.warpCycles > 0L;
    }

    public synchronized void stopTurning() {
        this.rightCycles = 0L;
        this.leftCycles = 0L;
    }

    public synchronized byte[] getData() {
        byte[] data = new byte[8];
        System.arraycopy(FrameInfo.KEYS_SIGNATURE, 0, data, 0, 6);
        data[6] = 0;
        if (this.leftCycles > 0L) {
            data[6] = (byte)(data[6] | 0x10);
        }
        if (this.rightCycles > 0L) {
            data[6] = (byte)(data[6] | 8);
        }
        if (this.fireCycles > 0L) {
            data[6] = (byte)(data[6] | 2);
        }
        if (this.warpCycles > 0L) {
            data[6] = (byte)(data[6] | 1);
        }
        if (this.thrustCycles > 0L) {
            data[6] = (byte)(data[6] | 4);
        }
        data[7] = (byte)(this.sentSerial & 0xFF);
        return data;
    }

    private long calcCycles(long time) {
        if (time == 0L) {
            return 0L;
        }
        return 1L;
    }
}

