#include "player.h"

using namespace std;

extern HGE* hge;
extern hgeFont* fnt;
extern bool RenderFunc();
extern bool FrameFunc();

HGE* hge = NULL;
hgeFont* fnt;

LRESULT CALLBACK HGEProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);


//int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR, int iCmdShow)
bool DebugWindow::Create()
{
    HWND hwndHGE;   // handle to HGE's parent window
    MSG msg;
    WNDCLASS wndclass;
    char szHGEName[] = "Asteroids Debug Window";
    wndclass.style = CS_HREDRAW | CS_VREDRAW;
    wndclass.cbClsExtra = 0;
    wndclass.cbWndExtra = 0;
    wndclass.hInstance = NULL; // hInstance;

    wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wndclass.hbrBackground = (HBRUSH)(COLOR_BTNFACE+1);;
    wndclass.lpszMenuName = NULL;
    wndclass.lpfnWndProc = HGEProc;
    wndclass.lpszClassName = szHGEName;

    if ( !RegisterClass(&wndclass) )
    {
        MessageBox(NULL, "Unable to open the Debug window!", szHGEName, MB_ICONERROR);
        return false;
    }

    hwndHGE = CreateWindowEx(WS_EX_STATICEDGE,
        szHGEName,
        szHGEName,
        WS_OVERLAPPEDWINDOW | WS_VISIBLE,
        1680-1034, 10,
        1024+10,768+30,
        NULL,
        NULL,
        NULL,   // hInstance,
        NULL);

    if (hwndHGE == NULL)
    {
        MessageBox(NULL, "HGE Window Creation Failed!", "Error!", MB_ICONEXCLAMATION | MB_OK);
        return false;
    }

    ShowWindow(hwndHGE, SW_SHOW);
    UpdateWindow(hwndHGE);

    RECT hgeClient;
    GetClientRect(hwndHGE, &hgeClient);

    // Get HGE interface
    hge = hgeCreate(HGE_VERSION);

    hge->System_SetState(HGE_FRAMEFUNC, FrameFunc);
    hge->System_SetState(HGE_RENDERFUNC, RenderFunc);
    hge->System_SetState(HGE_USESOUND, false);   // with this set, we don't need bass.dll
    hge->System_SetState(HGE_WINDOWED, true);
    hge->System_SetState(HGE_SCREENWIDTH, hgeClient.right);
    hge->System_SetState(HGE_SCREENHEIGHT, hgeClient.bottom);
    hge->System_SetState(HGE_SCREENBPP, 32);
    hge->System_SetState(HGE_HIDEMOUSE, false);
    hge->System_SetState(HGE_SHOWSPLASH, false);
//    hge->System_SetState(HGE_FPS, 1);
    hge->System_SetState(HGE_HWNDPARENT, hwndHGE );    // set parent window

    if (! hge->System_Initiate() )
        return false;

    fnt=new hgeFont("font1.fnt");
    fnt->SetScale(1.0);

    return true;
}


void DebugWindow::Close()
{
    delete fnt;
    hge->System_Shutdown();
    hge->Release();
}


bool DebugWindow::CheckMsgs()
{
    if(hge->System_GetState(HGE_HWND))
        hge->System_Start();
    if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
    {
        if(msg.message == WM_QUIT)
            return false;
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return true;
}



LRESULT CALLBACK HGEProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
   HDC         hdc;
   PAINTSTRUCT   ps;


   switch (msg)
   {
   case WM_CREATE:



      return 0;

   case WM_PAINT:
      hdc = BeginPaint(hwnd, &ps);
      EndPaint(hwnd, &ps);
      return 0;

   case WM_DESTROY:

      return 0;

   default:
      return DefWindowProc(hwnd, msg, wParam, lParam);

   }

   return 0;
}
