/**
 * © 2008 by Andreas Kielkopf Diese Datei wurde für den c't creativ08 Wettbewerb programmiert, und
 * darf von jedem frei verwendet werden
 */
package de.uhingen.kielkopf.andreas.player;

import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import de.uhingen.kielkopf.andreas.UdpHandler;
import de.uhingen.kielkopf.andreas.UdpInterpreter;
import de.uhingen.kielkopf.andreas.exceptions.NotFallException;
import de.uhingen.kielkopf.andreas.modell.Schiff;
import de.uhingen.kielkopf.andreas.modell.Ziel;

/**
 * @author andreas
 * 
 */
public class Player extends Thread {
    private Schiff           schiff = null;
    final private UdpHandler udpHandler;

    /**
     * @param handler
     */
    public Player(final UdpHandler handler) {
        this.udpHandler = handler;
        setName("Player");
    }
    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Thread#run()
     */
    @Override
    public void run() {
        do {
            try {
                act();
            } catch (final RuntimeException e) {
                e.printStackTrace();
            } catch (final SocketException e) {
                e.printStackTrace();
            } catch (final IOException e) {
                e.printStackTrace();
            }
        } while (true);
    }
    /**
     * @throws SocketException
     * @throws IOException
     * @throws InterruptedException
     */
    private void act() throws SocketException, IOException {
        while (true) {
            zielschuß();
            // sleep(10);
        }
    }

    private enum Richtung {
        rechts, links, gerade, schuss;
    };

    final private int maxzeit = 50;
    private Richtung  lastRichtung;

    /**
     * @param ziel
     */
    private void zielschuß() {
        final Ziel ziel = Ziel.getZielVector();
        if (ziel == null) {
            sende((byte) 0);
            return;
        }
        double toleranz = 8.5d * Math.PI / 180d; // +/- ein Grad
        double vorhaltewinkel = 0.1d * Math.PI / 180d; // +/- ein Grad
        if (schiff == null) schiff = Schiff.getSchiff();
        // berechne Zielwinkel
        try {
            double diffwinkel = -schiff.schussWinkel(ziel);
            if (diffwinkel > toleranz) { // Winkel ist im plus
                rechts();
                for (int i = 0; i < maxzeit; i += 1) {
                    diffwinkel = -schiff.schussWinkel(ziel);
                    if (diffwinkel <= (toleranz + vorhaltewinkel)) {
                        if (schuss()) return;
                    } else if (diffwinkel < 0) return;
                    else if (diffwinkel > Math.PI) return;
                }
            } else if (diffwinkel < -toleranz) {// winkel ist im Minus
                links();
                for (int i = 0; i < maxzeit; i += 1) {
                    diffwinkel = -schiff.schussWinkel(ziel);
                    if (diffwinkel >= -(toleranz + vorhaltewinkel)) {
                        if (schuss()) return;
                    } else if (diffwinkel > 0) return;
                    else if (diffwinkel < -Math.PI) return;
                }
            } else {
                if (schuss()) return;
            }
        } catch (NotFallException e) {
            springe();
            // System.out.println("s");
        }
        return;
    }

    private long lastpackettime;

    /**
     * 
     */
    private void erwarteNeueDaten(int maxtime) {
        int timeout = 0;
        while (udpHandler.getPacketTime() == lastpackettime) {
            warte(1);
            timeout++;
            if (timeout > maxtime) return;
        }
        lastpackettime = udpHandler.getPacketTime();
    }
    /**
     * @param i
     * 
     */
    private void warte(final int i) {
        try {
            sleep(i);
        } catch (final InterruptedException e) {
            e.printStackTrace();
        }
    }
    /**
     * @return
     * 
     */
    private boolean gibgas() {
        return sende(UdpHandler.Taste.SCHUB);
    }
    /**
     * @return
     * 
     */
    private boolean springe() {
        return sende(UdpHandler.Taste.HYPERSPACE);
    }
    /**
     * @return
     * 
     */
    private boolean halt() {
        boolean erg = sende(UdpHandler.Taste.BIT6);
        if (erg) lastRichtung = Richtung.gerade;
        return erg;
    }
    /**
     * @return
     * 
     */
    private boolean links() {
        boolean erg = sende(UdpHandler.Taste.LINKS);
        if (erg) lastRichtung = Richtung.links;
        return erg;
    }
    /**
     * @return
     * 
     */
    private boolean rechts() {
        boolean erg = sende(UdpHandler.Taste.RECHTS);
        if (erg) lastRichtung = Richtung.rechts;
        return erg;
    }
    /**
     * @return
     * 
     */
    private boolean schusshalt() {
        return sende(UdpHandler.Taste.FEUER);
        // if (!erg) System.out.print("x");
    }
    /**
     * 
     */
    private void schussdoppel() {
        sende(UdpHandler.Taste.FEUER, UdpHandler.Taste.BIT6);
        sende(UdpHandler.Taste.BIT6);
        warte(100);
        sende(UdpHandler.Taste.FEUER, UdpHandler.Taste.BIT6);
        sende(UdpHandler.Taste.BIT6);
    }

    private byte zuletztGesendetByte;

    /**
     * @return
     * 
     */
    private boolean schuss() {
        if (System.currentTimeMillis() % 9 == 1) {
            return sendePlus(UdpHandler.Taste.FEUER, UdpHandler.Taste.SCHUB);
        } else {
            return sendePlus(UdpHandler.Taste.FEUER);
        }
        /*
         * if ((zuletztGesendetByte & UdpHandler.Taste.FEUER.maske) != 0) { sende((byte) 0);
         * sende(UdpHandler.Taste.FEUER); } else { sendePlus(UdpHandler.Taste.FEUER); }
         */
    }
    /**
     * @return
     * 
     */
    private boolean sende(final UdpHandler.Taste... tasten) {
        byte b = UdpHandler.Taste.getMaske(tasten);
        return sende(b);
    }
    /**
     * @return
     * 
     */
    private boolean sendePlus(final UdpHandler.Taste... tasten) {
        byte b = UdpHandler.Taste.getMaske(tasten);
        return sende((byte) (b | zuletztGesendetByte));
    }
    // private long zuletztGesendetTime;
    /**
     * @param b
     */
    private boolean sende(byte b) {
        try {
            udpHandler.sendPing(b);
            zuletztGesendetByte = b;
            return true;
        } catch (final SocketException e) {} catch (final IOException e) {}
        // }
        return false;
    }
}
