/**
 * © 2008 by Andreas Kielkopf Diese Datei wurde für den c't creativ08 Wettbewerb programmiert, und
 * darf von jedem frei verwendet werden
 */
package de.uhingen.kielkopf.andreas.modell;

/**
 * @author andreas
 * 
 */
public class FlugKoerper {
    Position      pos          = new Position();
    Position      dpos         = new Position();
    double        naeherung    = 0;
    byte          ismeinschuss = 0;
    double        flugwinkel   = 0;
    protected int size;

    /**
     * @return
     */
    public int getX0() {
        return pos.x;
    }
    /**
     * @return
     */
    public int getY0() {
        return pos.y;
    }
    /**
     * @return
     */
    public int getdX() {
        return dpos.x;
    }
    /**
     * @return
     */
    public int getdY() {
        return dpos.y;
    }
    /**
     * @return
     */
    public long dTime() {
        return dpos.z;
    }
    /**
     * @param zukunft
     * @return
     */
    public int getX0(final int zukunft) {
        int erg = pos.x;
        if (dpos.z > 0) {
            erg += dpos.x * zukunft / dpos.z;
        }
        return erg;
    }
    /**
     * @param zukunft
     * @return
     */
    public int getY0(final int zukunft) {
        int erg = pos.y;
        if (dpos.z > 0) {
            erg += dpos.y * zukunft / dpos.z;
        }
        return erg;
    }
    /**
     * @return
     */
    public int getSize() {
        return size;
    }
    /**
     * @param xpos2
     * @param ypos2
     * @param deltaPacketTime
     */
    public void addDelta(int xpos2, int ypos2, long deltaPacketTime, int maske) {
        int dx = xpos2 - pos.x;
        int dy = ypos2 - pos.y;
        dx = dx % maske;
        if (dx > (maske >> 1)) dx = maske - dx;
        else if (dx < -(maske >> 1)) dx = maske + dx;
        dy = dy % maske;
        if (dy > (maske >> 1)) dy = maske - dy;
        else if (dy < -(maske >> 1)) dy = maske + dy;
        dpos.x -= dpos.x / 20;
        dpos.y -= dpos.y / 20;
        dpos.z -= dpos.z / 20;
        dpos.x += 100 * (dx);
        dpos.y += 100 * (dy);
        dpos.z += 100 * deltaPacketTime;
    }
    /**
     * @param i
     * @param j
     */
    public void setPos(int x, int y) {
        pos.x = x;
        pos.y = y;
    }
    /**
     * @return
     */
    public Position getPos() {
        return pos;
    }
    /**
     * @return
     */
    public int getSpeed() {
        double erg = 100d * Math.sqrt(dpos.x * dpos.x + dpos.y * dpos.y) / dpos.z;
        // System.out.println((int) (erg));
        return (int) erg;
    }
}
