//
//  APShip.h
//  APlayer
//
//  Created by Holger Sadewasser on 4/26/08.
//  Copyright 2008. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APObject.h"


typedef struct APAngleStruct {
  int angleByte;
  int rotation;
  int visX;
  int visY;
  int intX;
  int intY;
  double intXd;
  double intYd;
  double startX;
  double startY;
  double angle;
} APAngleStruct_t;



@interface APShip : APObject {

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Attributes
// -------------------------------------------------------------------------------------
  
  @public
  
  int mViewX;
  int mViewY;  
  BOOL mFlgNeedsCalibration;
  BOOL mFlgAngleReset;
  
  uint8_t mAngleByte;  
  APAngleStruct_t * mAngles;
  
  uint8_t * mKeysBuf;
  
  NSMutableDictionary * mAngleByteDict;
  NSMutableDictionary * mAngleByteRangeDict;
}

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

-(id)init;
-(id)initWithKeysBuffer:(uint8_t *)iKeys;
-(void)dealloc;


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(void)setPosX:(int)iPosX posY:(int)iPosY viewX:(int)iViewX viewY:(int)iViewY;
-(void)updateWithPosX:(int)iPosX posY:(int)iPosY viewX:(int)iViewX viewY:(int)iViewY frame:(uint8_t)iFrame frames:(uint8_t)iFrames ping:(uint8_t)iPing lastPing:(uint8_t)iLastPing;
-(APAngleStruct_t *)angles;
-(uint8_t)angleByte;
-(void)setAngleByte:(uint8_t)iAngleByte;
-(double)timeOfCollisionWithPosX:(double)a0 posY:(double)b0 dirX:(double)iDirX dirY:(double)iDirY radius:(double)iRadius headingStable:(BOOL)iFlgHeadingStable;
-(void)synchronizeAngleByteFromHeadingX:(int)iHeadingX headingY:(int)iHeadingY;


@end
