//
//  APKeystroke.h
//  APlayer
//
//  Created by Holger Sadewasser on 5/10/08.
//  Copyright 2008. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APTarget.h"


enum APKey {
  cKeyNone       = 0x00,
  cKeyHyperspace = 0x01,
  cKeyFire       = 0x02,
  cKeyThrust     = 0x04,
  cKeyRight      = 0x08,
  cKeyLeft       = 0x10
};


@interface APKeystroke : NSObject {

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Attributes
// -------------------------------------------------------------------------------------
  
  uint8_t mKeys;
  unsigned mRepeatCount;
  APTarget * mTarget;
  
}

// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Initializers/Clean up
// -------------------------------------------------------------------------------------

+(id)keystrokeWithKeys:(uint8_t)iKeys repeat:(unsigned)iRepeatCount target:(APTarget *)iTarget;
+(id)keystrokeWithKeys:(uint8_t)iKeys repeat:(unsigned)iRepeatCount;
-(id)initWithKeys:(uint8_t)iKeys repeat:(unsigned)iRepeatCount target:(APTarget *)iTarget;
-(id)initWithKeys:(uint8_t)iKeys repeat:(unsigned)iRepeatCount;
-(void)dealloc;


// -------------------------------------------------------------------------------------
#pragma mark -
#pragma mark Instance Methods
// -------------------------------------------------------------------------------------

-(void)setKeys:(uint8_t)iKeys;
-(uint8_t)keys;
-(void)setRepeatCount:(unsigned)iRepeatCount;
-(unsigned)repeatCount;
-(void)setTarget:(APTarget *)iTarget;
-(APTarget *)target;
-(void)sent;


@end
