
#pragma once


#include "MovingEntity.h"


class KeysPacket;
class Steering;
class TargetSystem;


class SpaceShip : public MovingEntity
{
public:
	static const unsigned char syncSteps = 4;

	SpaceShip(bool withoutNewId = false);
	virtual ~SpaceShip(void);

	SpaceShip& operator=(const SpaceShip& rhs);

	void update(int time, KeysPacket* keys);

	virtual float getRadius(void) const;

	virtual Vector2D getHeading(void) const;
	void setScreenHeading(const Vector2D& heading);
	Vector2D getScreenHeading(void) const;

	void writeStatusToLog() const;

	unsigned char getRotationCounter(void) const;
	void setRotationCounter(unsigned char counter);

	int getUpdateCounter(void) const;

private:
    SpaceShip(const SpaceShip& rhs); // Copy Constructor verbieten
	Steering* mSteering;
	TargetSystem* mTargetSystem;

	void fillRotationArrays(void);
	unsigned short mScreenRotation[256];

	bool synchronizeRotation(void);

	unsigned char mSyncStartPos;
	unsigned char mSyncCounter;
	unsigned short mSyncBuffer[256];
	bool mLeftRotation;

	unsigned char mRotationCounter;

	int mUpdateCounter;
};
