
#include "StdAfx.h"
#include <math.h>

#include "GameEngine.h"
#include "Steering.h"
#include "TargetSystem.h"
#include "Calculator.h"
#include "Matrix2D.h"
#include "GlobalSettings.h"
#include "PositionCalculator.h"

#include "SpaceShip.h"



SpaceShip::SpaceShip(bool withoutNewId)
: MovingEntity(withoutNewId), mSteering(0), mTargetSystem(0), mRotationCounter(0), 
  mSyncStartPos(0), mSyncCounter(0), mLeftRotation(true), mUpdateCounter(0)
{
	if (!withoutNewId)
	{
		mSteering = new Steering(this);
		mSteering->setEmergencyJumpOn(true);
		mSteering->setObstacleAvoidanceOn(false);
		mSteering->setSeekOn(false);

		mTargetSystem = new TargetSystem(this);

		fillRotationArrays();
	}

//	mUpdateCounter = 45;
}

SpaceShip::~SpaceShip(void)
{
	if (mSteering != 0) { delete mSteering; }
	if (mTargetSystem != 0) { delete mTargetSystem; }
}

SpaceShip& SpaceShip::operator=(const SpaceShip& rhs)
{
    if (&rhs == this) { return *this; }
	
	*(dynamic_cast<MovingEntity*>(this)) = *(dynamic_cast<MovingEntity*>(const_cast<SpaceShip*>(&rhs)));

	// TODO: Inhalt von mSteering kopieren
	// *mSteering = *(rhs.mSteering);

	mRotationCounter = rhs.mRotationCounter;

    return *this; 
}

float SpaceShip::getRadius(void) const
{
	return 20;
}

Vector2D SpaceShip::getHeading(void) const
{
	double alpha = PositionCalculator::getRotation(mRotationCounter);

	double x = cos(alpha);
	double y = sin(alpha);

	return Vector2D(x, y);
}

Vector2D SpaceShip::getScreenHeading(void) const
{
	return MovingEntity::getHeading();
}

void SpaceShip::setScreenHeading(const Vector2D& heading)
{
	MovingEntity::setHeading(heading);
}

unsigned char SpaceShip::getRotationCounter(void) const
{
	return mRotationCounter;
}

void SpaceShip::setRotationCounter(unsigned char counter)
{
	mRotationCounter = counter;
}


bool SpaceShip::synchronizeRotation(void)
{
	bool retValue = false;

	// erstmal von einer Linksdrehung ausgehen
	unsigned char startPos = 0, endPos = 255 - (syncSteps - 1);
	char step = 1;

	if (!mLeftRotation)
	{	// bei einer Rechtsdrehung wird von unten angefangen im Array zu suchen
		startPos = 255; 
		endPos = syncSteps - 1;
		step = -1;
	}

	unsigned short valuesToSearch[syncSteps];

	for (int i = 0; i < syncSteps; i++)
	{
		valuesToSearch[i] = mSyncBuffer[mSyncStartPos++];
	}

	for (int i = startPos; i != endPos; i += step)
	{
		if ((mScreenRotation[i] == valuesToSearch[0]) && (mScreenRotation[i + step] == valuesToSearch[1]) &&
			(mScreenRotation[i + 2 * step] == valuesToSearch[2]) && (mScreenRotation[i + 3 * step] == valuesToSearch[3]))
		{
			mRotationCounter = i;
			if (mLeftRotation)
			{
				mRotationCounter += syncSteps;
			}
			else
			{
				mRotationCounter -= syncSteps;
			}

			retValue = true;
			break;
		}
	}

	return retValue;
}

int SpaceShip::getUpdateCounter(void) const
{
	return mUpdateCounter;
}

void SpaceShip::update(int time, KeysPacket* keys)
{
	mUpdateCounter++;

	// alle Tasten lschen
	keys->clear();   

	// Test, ob ein Notfall vorliegt. In diesem Fall wird gar nicht erst weiter berechnet
	if (mSteering->emergencyJump())
	{
		keys->hyperspace(true);
		return;
	}

	//////////////////////////////////////////////////////////////
	// Erstmal drehen wir uns 7 Schritte nach links, um die Rotation zu synchronisieren
	if (mUpdateCounter < 8)
	{
		keys->left(true);
	}
	else
	{	// Danach werden wirklich die Ziele bercksichtigt
		mTargetSystem->takeAimAndShot(time, keys);
	}

	/////////////////////////////////////////////////////////////////////////////////
	// Rotation synchronisieren
	if (keys->isLeft())
	{
		mRotationCounter++; 
		mSyncCounter++;

		mSyncBuffer[mSyncCounter] = static_cast<unsigned short>(Calculator::calculateRotationInDeg(MovingEntity::getHeading()));

		if (!mLeftRotation)
		{
			mSyncStartPos = mSyncCounter;
			mLeftRotation = true;
		}
	}

	else if (keys->isRight())
	{
		mRotationCounter--; 
		mSyncCounter++;

		mSyncBuffer[mSyncCounter] = static_cast<unsigned short>(Calculator::calculateRotationInDeg(MovingEntity::getHeading()));

		if (mLeftRotation)
		{
			mSyncStartPos = mSyncCounter;
			mLeftRotation = false;
		}
	}
	else
	{
//		mSyncStartPos = mSyncCounter;
		mSyncStartPos = mSyncCounter + 2;
	}

	if ((mSyncCounter - mSyncStartPos) == (syncSteps - 1))
	{	// Synchronisierung durchfhren
		if (synchronizeRotation())
		{
			// Nach der Synchronisierung geht ein Schritt verloren, der muss jtzt wieder bercksichtigt 
			// werden
			if (keys->isLeft())
			{
				mRotationCounter++; 
			}
			else if (keys->isRight())
			{
				mRotationCounter--; 
			}
		}
	}
}


void SpaceShip::writeStatusToLog() const
{
	char buffer[255] = { 0 };
	DWORD bytesWritten = 0;
	DWORD msgSize = sprintf_s(buffer, 255, 
			  "SpaceShip: Position=[%4.2f, %4.2f], Heading=[%4.4f, %4.4f], Velocity=[%4.4f, %4.4f], Speed=%4.4f, Rotation Ship=%4.4f, Rotation Entity=%4.4f\n"
			  "   mRotationCounter=%d\n", 
			  getPosition().getX(), 
			  getPosition().getY(), 
			  getHeading().getX(), 
			  getHeading().getY(),
			  getVelocity().getX(),
			  getVelocity().getY(),
			  getSpeed(),
			  Calculator::calculateRotationInDeg(getHeading()),
			  Calculator::calculateRotationInDeg(MovingEntity::getHeading()),
			  mRotationCounter
			 );

	GameEngine::log(buffer);
}

void SpaceShip::fillRotationArrays(void)
{
	mScreenRotation[0] = 0;
	mScreenRotation[1] = 0;
	mScreenRotation[2] = 5;
	mScreenRotation[3] = 11;
	mScreenRotation[4] = 16;
	mScreenRotation[5] = 16;
	mScreenRotation[6] = 22;
	mScreenRotation[7] = 27;
	mScreenRotation[8] = 33;
	mScreenRotation[9] = 33;
	mScreenRotation[10] = 39;
	mScreenRotation[11] = 45;
	mScreenRotation[12] = 50;
	mScreenRotation[13] = 50;
	mScreenRotation[14] = 56;
	mScreenRotation[15] = 62;
	mScreenRotation[16] = 67;
	mScreenRotation[17] = 67;
	mScreenRotation[18] = 73;
	mScreenRotation[19] = 78;
	mScreenRotation[20] = 84;
	mScreenRotation[21] = 84;
	mScreenRotation[22] = 95;
	mScreenRotation[23] = 101;
	mScreenRotation[24] = 101;
	mScreenRotation[25] = 106;
	mScreenRotation[26] = 112;
	mScreenRotation[27] = 117;
	mScreenRotation[28] = 117;
	mScreenRotation[29] = 123;
	mScreenRotation[30] = 129;
	mScreenRotation[31] = 135;
	mScreenRotation[32] = 135;
	mScreenRotation[33] = 140;
	mScreenRotation[34] = 146;
	mScreenRotation[35] = 152;
	mScreenRotation[36] = 152;
	mScreenRotation[37] = 157;
	mScreenRotation[38] = 163;
	mScreenRotation[39] = 168;
	mScreenRotation[40] = 168;
	mScreenRotation[41] = 174;
	mScreenRotation[42] = 180;
	mScreenRotation[43] = 180;
	mScreenRotation[44] = 185;
	mScreenRotation[45] = 185;
	mScreenRotation[46] = 191;
	mScreenRotation[47] = 196;
	mScreenRotation[48] = 202;
	mScreenRotation[49] = 202;
	mScreenRotation[50] = 207;
	mScreenRotation[51] = 213;
	mScreenRotation[52] = 219;
	mScreenRotation[53] = 219;
	mScreenRotation[54] = 225;
	mScreenRotation[55] = 230;
	mScreenRotation[56] = 236;
	mScreenRotation[57] = 236;
	mScreenRotation[58] = 242;
	mScreenRotation[59] = 247;
	mScreenRotation[60] = 253;
	mScreenRotation[61] = 253;
	mScreenRotation[62] = 258;
	mScreenRotation[63] = 264;
	mScreenRotation[64] = 270;
	mScreenRotation[65] = 275;
	mScreenRotation[66] = 281;
	mScreenRotation[67] = 286;
	mScreenRotation[68] = 286;
	mScreenRotation[69] = 292;
	mScreenRotation[70] = 297;
	mScreenRotation[71] = 303;
	mScreenRotation[72] = 303;
	mScreenRotation[73] = 309;
	mScreenRotation[74] = 315;
	mScreenRotation[75] = 320;
	mScreenRotation[76] = 320;
	mScreenRotation[77] = 326;
	mScreenRotation[78] = 332;
	mScreenRotation[79] = 337;
	mScreenRotation[80] = 337;
	mScreenRotation[81] = 343;
	mScreenRotation[82] = 348;
	mScreenRotation[83] = 354;
	mScreenRotation[84] = 354;
	mScreenRotation[85] = 0;
	mScreenRotation[86] = 0;
	mScreenRotation[87] = 5;
	mScreenRotation[88] = 11;
	mScreenRotation[89] = 11;
	mScreenRotation[90] = 16;
	mScreenRotation[91] = 22;
	mScreenRotation[92] = 27;
	mScreenRotation[93] = 27;
	mScreenRotation[94] = 33;
	mScreenRotation[95] = 39;
	mScreenRotation[96] = 45;
	mScreenRotation[97] = 45;
	mScreenRotation[98] = 50;
	mScreenRotation[99] = 56;
	mScreenRotation[100] = 62;
	mScreenRotation[101] = 62;
	mScreenRotation[102] = 67;
	mScreenRotation[103] = 73;
	mScreenRotation[104] = 78;
	mScreenRotation[105] = 78;
	mScreenRotation[106] = 84;
	mScreenRotation[107] = 95;
	mScreenRotation[108] = 95;
	mScreenRotation[109] = 101;
	mScreenRotation[110] = 106;
	mScreenRotation[111] = 112;
	mScreenRotation[112] = 112;
	mScreenRotation[113] = 117;
	mScreenRotation[114] = 123;
	mScreenRotation[115] = 129;
	mScreenRotation[116] = 129;
	mScreenRotation[117] = 135;
	mScreenRotation[118] = 140;
	mScreenRotation[119] = 146;
	mScreenRotation[120] = 146;
	mScreenRotation[121] = 152;
	mScreenRotation[122] = 157;
	mScreenRotation[123] = 163;
	mScreenRotation[124] = 163;
	mScreenRotation[125] = 168;
	mScreenRotation[126] = 174;
	mScreenRotation[127] = 180;
	mScreenRotation[128] = 180;
	mScreenRotation[129] = 180;
	mScreenRotation[130] = 185;
	mScreenRotation[131] = 191;
	mScreenRotation[132] = 196;
	mScreenRotation[133] = 196;
	mScreenRotation[134] = 202;
	mScreenRotation[135] = 207;
	mScreenRotation[136] = 213;
	mScreenRotation[137] = 213;
	mScreenRotation[138] = 219;
	mScreenRotation[139] = 225;
	mScreenRotation[140] = 230;
	mScreenRotation[141] = 230;
	mScreenRotation[142] = 236;
	mScreenRotation[143] = 242;
	mScreenRotation[144] = 247;
	mScreenRotation[145] = 247;
	mScreenRotation[146] = 253;
	mScreenRotation[147] = 258;
	mScreenRotation[148] = 264;
	mScreenRotation[149] = 264;
	mScreenRotation[150] = 275;
	mScreenRotation[151] = 281;
	mScreenRotation[152] = 281;
	mScreenRotation[153] = 286;
	mScreenRotation[154] = 292;
	mScreenRotation[155] = 297;
	mScreenRotation[156] = 297;
	mScreenRotation[157] = 303;
	mScreenRotation[158] = 309;
	mScreenRotation[159] = 315;
	mScreenRotation[160] = 315;
	mScreenRotation[161] = 320;
	mScreenRotation[162] = 326;
	mScreenRotation[163] = 332;
	mScreenRotation[164] = 332;
	mScreenRotation[165] = 337;
	mScreenRotation[166] = 343;
	mScreenRotation[167] = 348;
	mScreenRotation[168] = 348;
	mScreenRotation[169] = 354;
	mScreenRotation[170] = 0;
	mScreenRotation[171] = 0;
	mScreenRotation[172] = 5;
	mScreenRotation[173] = 5;
	mScreenRotation[174] = 11;
	mScreenRotation[175] = 16;
	mScreenRotation[176] = 22;
	mScreenRotation[177] = 22;
	mScreenRotation[178] = 27;
	mScreenRotation[179] = 33;
	mScreenRotation[180] = 39;
	mScreenRotation[181] = 39;
	mScreenRotation[182] = 45;
	mScreenRotation[183] = 50;
	mScreenRotation[184] = 56;
	mScreenRotation[185] = 56;
	mScreenRotation[186] = 62;
	mScreenRotation[187] = 67;
	mScreenRotation[188] = 73;
	mScreenRotation[189] = 73;
	mScreenRotation[190] = 78;
	mScreenRotation[191] = 84;
	mScreenRotation[192] = 90;
	mScreenRotation[193] = 95;
	mScreenRotation[194] = 101;
	mScreenRotation[195] = 106;
	mScreenRotation[196] = 106;
	mScreenRotation[197] = 112;
	mScreenRotation[198] = 117;
	mScreenRotation[199] = 123;
	mScreenRotation[200] = 123;
	mScreenRotation[201] = 129;
	mScreenRotation[202] = 135;
	mScreenRotation[203] = 140;
	mScreenRotation[204] = 140;
	mScreenRotation[205] = 146;
	mScreenRotation[206] = 152;
	mScreenRotation[207] = 157;
	mScreenRotation[208] = 157;
	mScreenRotation[209] = 163;
	mScreenRotation[210] = 168;
	mScreenRotation[211] = 174;
	mScreenRotation[212] = 174;
	mScreenRotation[213] = 180;
	mScreenRotation[214] = 180;
	mScreenRotation[215] = 185;
	mScreenRotation[216] = 191;
	mScreenRotation[217] = 191;
	mScreenRotation[218] = 196;
	mScreenRotation[219] = 202;
	mScreenRotation[220] = 207;
	mScreenRotation[221] = 207;
	mScreenRotation[222] = 213;
	mScreenRotation[223] = 219;
	mScreenRotation[224] = 225;
	mScreenRotation[225] = 225;
	mScreenRotation[226] = 230;
	mScreenRotation[227] = 236;
	mScreenRotation[228] = 242;
	mScreenRotation[229] = 242;
	mScreenRotation[230] = 247;
	mScreenRotation[231] = 253;
	mScreenRotation[232] = 258;
	mScreenRotation[233] = 258;
	mScreenRotation[234] = 264;
	mScreenRotation[235] = 275;
	mScreenRotation[236] = 275;
	mScreenRotation[237] = 281;
	mScreenRotation[238] = 286;
	mScreenRotation[239] = 292;
	mScreenRotation[240] = 292;
	mScreenRotation[241] = 297;
	mScreenRotation[242] = 303;
	mScreenRotation[243] = 309;
	mScreenRotation[244] = 309;
	mScreenRotation[245] = 315;
	mScreenRotation[246] = 320;
	mScreenRotation[247] = 326;
	mScreenRotation[248] = 326;
	mScreenRotation[249] = 332;
	mScreenRotation[250] = 337;
	mScreenRotation[251] = 343;
	mScreenRotation[252] = 343;
	mScreenRotation[253] = 348;
	mScreenRotation[254] = 354;
	mScreenRotation[255] = 0;

	for (int i= 0; i <= 255; i++)
	{
		mSyncBuffer[i] = 0;
	}
}
