
#pragma once

#include <winsock2.h>
#include "GameStatus.h"

#define ADDRESS DWORD


#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
	void clearNavigationCommands(void);

	bool isLeft(void) const;
	bool isRight(void) const;
	bool isFire(void) const;

	void writeStatusToLog() const;
};

#pragma pack()


class GameEngine
{
public:
	static GameEngine* Instance();
	static void log(char* msg);

	virtual ~GameEngine(void);

	void SetConnection(SOCKET sd, ADDRESS server_ip);
	void Run();
	GameStatus* getGameStatus();

	static HANDLE mLogFile;

private:
	static GameEngine mInstance;

	GameEngine();

	void SendPacket(KeysPacket &packet);
	void ReceivePacket(FramePacket &packet);
	void InterpretScreen(FramePacket &packet);

	void calculateVelocities(const int& frameRate, const int& latenz);

	void dump(const unsigned  char& frameNo, const char* startMsg);

	SOCKET mSd;
	ADDRESS mServerIp;

	GameStatus mGameStatus;
	Vector2D mPrevSpaceShipPosition;
	Vector2D mPrevSaucerPosition;
};
