// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fstream>
#include <iostream>
#include <string>
#include <math.h>

using namespace std;

#if defined(WINDOWS) || defined(_WIN32)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "player.h"

void Player::Run(void)
{
	//***********************************
	// Variablen
	FramePacket frame;
	KeysPacket keys;
	GameStatus gs[ANZAHL_GS];
	char prevframe = 0;
	int t = 0;

	int t_dist = 99999;
	Vector target(0,0);
	double pi = 3.1415926;
	bool ts = false;
	int apos = 0;
	int sw = 0;
	bool alarm = false;
	int minutes = 0;
	bool found = false;

	//*********************************************************
	// Vor Spielstart die bentigten Tabellen laden
	string fbuff;
	ifstream f("sw_data.txt");
	int e = 0;
	int z = 0;
	while (!f.eof() && !f.fail())
	{
		getline(f, fbuff);
		e = fbuff.find("\t");
		gs[0].ship.sa[z].d.x = atoi(fbuff.substr(0,e).data());
		fbuff.erase(0,e+1);
		e = fbuff.find("\t");
		gs[0].ship.sa[z].d.y = atoi(fbuff.substr(0,e).data());
		fbuff.erase(0,e+1);
		e = fbuff.find("\t");
		gs[0].ship.sa[z].p.x = atoi(fbuff.substr(0,e).data());
		fbuff.erase(0,e+1);
		e = fbuff.find("\t");
		gs[0].ship.sa[z].p.y = atoi(fbuff.substr(0,e).data());
		fbuff.erase(0,e+1);
		e = fbuff.find("\t");
		gs[0].ship.sa[z].v.x = atof(fbuff.substr(0,e).data());
		fbuff.erase(0,e+1);
		e = fbuff.find("\t");
		gs[0].ship.sa[z].v.y = atof(fbuff.substr(0,e).data());
		z++;
	}
	f.close();
	std::cout << "\nsw_data eingelesen..\n";
	//*/

	/**********************************
	// Eine Datei ffnen fr dumpfile
	ofstream of;
	of.open("my.dmp", std::ios_base::out | std::ios_base::binary);
	char obuff[25];
	obuff[0] = 0x63;	obuff[1] = 0x74;	obuff[2] = 0x6D;	obuff[3] = 0x61;	obuff[4] = 0x6D;
	obuff[5] = 0x65;	obuff[6] = 0x31;	obuff[7] = 0x0D;	obuff[8] = 0x0A;	obuff[9] = 0x02;
	obuff[10] = 0x00;	obuff[11] = 0x13;	obuff[12] = 0x4F;	obuff[13] = 0x7f;	obuff[14] = 0x00;
	obuff[15] = 0x00;	obuff[16] = 0x01;	obuff[17] = 0x00;	obuff[18] = 0x00;	obuff[19] = 0x00;
	obuff[20] = 0x00;	obuff[21] = 0x00;	obuff[22] = 0x00;	obuff[23] = 0x00;	obuff[24] = 0x00;
	std::copy(obuff, obuff + sizeof(obuff), std::ostreambuf_iterator<char>(of));
	//*/

	// Einmal sendpackets zum Spiel starten
	SendPacket(keys);

	//***********************************
	// Endlosschleife fr das Spiel
	for (;;)
	{
		// Kram fr Aufzeichnungen && Stop nach 5 Minuten
		//if (t >= 18126) {of.close(); return;}
		if (t%3600 == 0) printf("%i: %i Minuten\n", t, minutes++);

		//******************************
		// Netzwerkgesocks
		++t;         // Zeit
		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
		ReceivePacket(frame);
		SendPacket(keys);

		// Kram fr Aufzeichnungen
		//std::copy(frame.vectorram, frame.vectorram + sizeof(frame.vectorram), std::ostreambuf_iterator<char>(of));
		//std::copy(&keys.keys, &keys.keys + sizeof(keys.keys), std::ostreambuf_iterator<char>(of));

		keys.clear();
		if (frame.frameno != ++prevframe  || frame.ping != keys.ping-1)
		{
			//printf("Latenz %d. %d Frames verloren.\n", keys.ping - frame.ping, frame.frameno - prevframe);
			prevframe = frame.frameno;
		}
		//*/

		//****************************************************************************
		// Alte GameStates zuordnen & neuen GameState ermitteln & latenz berechnen
		for(int i=ANZAHL_GS-1; i > 0; i--)
		{		
			gs[i]=gs[i-1];
		}
		InterpretScreen(frame, gs[0]);
		gs[0].latenz = keys.ping - frame.ping;
		//*/

		//***************************
		// Ship ist da, los gehts!!
		if (gs[0].ship.present && t > 5)
		{
			//***************
			// Ship tracken
			gs[0].ship.track(gs[1].ship, gs[3].ship);
			//*/

			//**************
			// Ufo tracken
			if (gs[0].ufo.present)
			{
				gs[0].ufo.setK(gs[0].ship.p);
				gs[0].ufo.track(gs[1].ufo);
			}
			//*/

			//****************
			// Shots tracken
			for (int i=0; i < gs[0].nshots; i++)							// Fr jeden Shot..
			{
				found = false;
				gs[0].shots[i].setK(gs[0].ship.p);							// Koords umrechnen
				if (gs[0].shots[i].track(gs[1].shots[i], gs[0]))			// an alter Posi im Vektorram nachsehen
					found = true;											
				else														// nicht an alter Posi im VRAM gefunden
					for (int j=0; j<gs[1].nshots; j++)	
						if (gs[0].shots[i].track(gs[1].shots[j], gs[0]))	// alle alten Shots durchgehen
							found = true;									
				if (found)													// wenn er gefunden wurde, dann
				{
					if (gs[0].shots[i].tracked >= 4)					// Kollisionskurs ?
					{
						if (gs[0].shots[i].v.sprod(gs[0].shots[i].p) < 0)
						{
							if (fabs(gs[0].shots[i].v.vprod(gs[0].shots[i].p).z)/gs[0].shots[i].v.Length() < gs[0].ship.r)
							{
								gs[0].shots[i].kk = 1;
								gs[0].ship.status = 7;
								if (gs[0].shots[i].dist < gs[0].ship.r*2)					// bei Kollisionsgefahr wegbeamen
								{
									if (gs[2].shots[i].dist > gs[0].shots[i].dist)
									{
										gs[0].ship.hyperspace = true;
									}
								}
							}
							if (gs[0].shots[i].dist < gs[0].ship.r*2 && gs[0].ufo.present)					// bei Kollisionsgefahr wegbeamen
							{
								if (gs[2].shots[i].dist > gs[0].shots[i].dist)
								{
									gs[0].ship.hyperspace = true;
								}
							}
						}
					}
				}
			}
			//*/

			//***********************************
			// Asteroiden tracken
			alarm = false;
			for (int i=0; i<gs[0].nasteroids; i++)							// Jeden Asteroiden
			{
				found = false;
				gs[0].asteroids[i].setK(gs[0].ship.p);						// Koords normalisieren
				if (gs[0].asteroids[i].track(gs[1].asteroids[i], gs[0].latenz))		// an alter Pos im VRAM nachsehen
					found = true;
				else														// nicht an alter Posi gefunden
					for (int j=0; j<gs[1].nasteroids; j++)					// alle alten Asterioden durchgehen
						if (gs[0].asteroids[i].type == gs[1].asteroids[j].type && gs[0].asteroids[i].sf == gs[1].asteroids[j].sf)
							if (gs[0].asteroids[i].track(gs[1].asteroids[j], gs[0].latenz))
								found = true;
				if (found)
					if (gs[0].asteroids[i].tracked >= 8)					// Kollisionskurs ?
						if (gs[0].asteroids[i].v.sprod(gs[0].asteroids[i].p) < 0)
						{
							Vector tp;
							tp.x = gs[0].asteroids[i].p.x;
							tp.y = gs[0].asteroids[i].p.y;
							Vector tv = gs[0].asteroids[i].v;
							for (int x = 0; x < 200; x++)
							{
								tp = tp + tv;
								if (sqrt(tp.x*tp.x + tp.y*tp.y) < gs[0].asteroids[i].r + gs[0].ship.r)
								{
									gs[0].asteroids[i].kk = 1;
									alarm = true;
								}
							}
						}
			}
			//*/
			double smallT = 999;
			//****************************
			// Drehrichtung festlegen
			switch (gs[0].ship.status)
			{
			case 7:		// Shot ausweichen
				{
					for (int i=0; i<gs[0].nshots; i++)
					{
						if (gs[0].shots[i].kk)
						{
							gs[0].ship.trust = true;
							if (gs[0].ship.willHitObject(gs[0].shots[i], gs[0].ship.sw) > 0)
								gs[0].ship.turnDir = 1;
							else
								gs[0].ship.turnDir = -1;
						}
					}
					break;
				}
			default:
			if (gs[0].ufo.present && !alarm)
			{
				target.x = gs[0].ufo.nextPos(gs[0].latenz).x + gs[0].ufo.v.x * gs[0].ufo.dist / 8;
				target.y = gs[0].ufo.nextPos(gs[0].latenz).y + gs[0].ufo.v.y * gs[0].ufo.dist / 8;
				t_dist = gs[0].ship.r;
			}
			else
			{
				t_dist = 99999;
			}
			for (int i=0; i<gs[0].nasteroids; i++)	// Jeden neuen Asteroiden untersuchen
			{
				if (gs[0].asteroids[i].ws > 0) continue;
				if (gs[0].asteroids[i].dist < t_dist && !alarm)
				{
					t_dist = gs[0].asteroids[i].dist - gs[0].asteroids[i].r;
					//target.x = gs[0].asteroids[i].nextPos(gs[0].latenz).x + gs[0].asteroids[i].v.x * gs[0].asteroids[i].dist / 8;
					//target.y = gs[0].asteroids[i].nextPos(gs[0].latenz).y + gs[0].asteroids[i].v.y * gs[0].asteroids[i].dist / 8;
					if (t_dist < gs[0].ship.r + 4) gs[0].ship.hyperspace = true;
					double x1 = gs[0].ship.d.x;
					double y1 = gs[0].ship.d.y;
					double x2 = gs[0].asteroids[i].p.x;
					double y2 = gs[0].asteroids[i].p.y;
					// Blickvektor und Asteroidenvektor vergleichen
					double w = (acos((x1 * x2 + y1 * y2) / (sqrt(x1 * x1 + y1 * y1) * sqrt(x2 * x2 + y2 * y2))) * 180 / pi);
					int t_turn = w / 4.1 + gs[0].asteroids[i].dist / 8;
					if (t_turn < smallT)
					{
						target.x = gs[0].asteroids[i].nextPos(gs[0].latenz).x + gs[0].asteroids[i].v.x * gs[0].asteroids[i].dist / 8;
						target.y = gs[0].asteroids[i].nextPos(gs[0].latenz).y + gs[0].asteroids[i].v.y * gs[0].asteroids[i].dist / 8;
						//printf("Frame: %i, Ast: %i, TurnTime: %i\n", t, i, t_turn);
						smallT = t_turn;
					}
				}
				if (gs[0].asteroids[i].kk == 1)
				{
					if (gs[0].asteroids[i].dist < t_dist)
					{
						t_dist = gs[0].asteroids[i].dist - gs[0].asteroids[i].r;
						target.x = gs[0].asteroids[i].nextPos(gs[0].latenz).x + gs[0].asteroids[i].v.x * gs[0].asteroids[i].dist / 8;
						target.y = gs[0].asteroids[i].nextPos(gs[0].latenz).y + gs[0].asteroids[i].v.y * gs[0].asteroids[i].dist / 8;
						if (t_dist < gs[0].ship.r) gs[0].ship.hyperspace = true;
					}
				}
			}
			if (gs[0].nasteroids == 0 && !gs[0].ufo.present)
			{
				target.x = 800 - gs[0].ship.p.x;
				target.y = 800 - gs[0].ship.p.y;
			}
			if (gs[0].ship.d.vprod(target).z > 0)
				gs[0].ship.turnDir = 1;
			else
				gs[0].ship.turnDir = -1;
			//*/

			if (!alarm)
			{
			//double smallT = 999;
			/****************************
			// Winkel Test-Bereich
			for (int i=0; i<gs[0].nasteroids; i++)	// Jeden Asteroiden untersuchen
			{
				double x1 = gs[0].ship.d.x;
				double y1 = gs[0].ship.d.y;
				double x2 = gs[0].asteroids[i].p.x;
				double y2 = gs[0].asteroids[i].p.y;
				// Blickvektor und Asteroidenvektor vergleichen
				double w = (acos((x1 * x2 + y1 * y2) / (sqrt(x1 * x1 + y1 * y1) * sqrt(x2 * x2 + y2 * y2))) * 180 / pi);
				int t_turn = w / 4.1 + gs[0].asteroids[i].dist / 8;
				if (t_turn < smallT)
				{
					target.x = gs[0].asteroids[i].nextPos(gs[0].latenz).x + gs[0].asteroids[i].v.x * gs[0].asteroids[i].dist / 8;
					target.y = gs[0].asteroids[i].nextPos(gs[0].latenz).y + gs[0].asteroids[i].v.y * gs[0].asteroids[i].dist / 8;
					printf("Frame: %i, Ast: %i, TurnTime: %i\n", t, i, t_turn);
					smallT = t_turn;
				}
			}
			if (gs[0].ship.d.vprod(target).z > 0)
				gs[0].ship.turnDir = 1;
			else
				gs[0].ship.turnDir = -1;
			//*/
			}
			}
			//****************************
			// Object abschieen
			sw = gs[0].ship.sw + 3 * gs[1].ship.turnDir + 3 * gs[2].ship.turnDir;
			while (sw > 255) sw -= 256;
			while (sw < 0) sw += 256;
			for (int i=0; i<gs[0].nasteroids; i++)	// Jeden neuen Asteroiden untersuchen
			{
				//if (gs[0].asteroids[i].tracked >= 8 && gs[0].asteroids[i].ws != 1)
				if (gs[0].asteroids[i].tracked >= 4 && gs[0].asteroids[i].ws < 11)
				{
					if (!(gs[0].nasteroids > 23 && gs[0].asteroids[i].r == 31))
					{
						if (gs[0].ship.willHitObject(gs[0].asteroids[i], sw) && !gs[1].ship.fire)
						{
							gs[0].ship.fire = true;
							gs[0].asteroids[i].ws += 70;
						}
					}
				}
			}
			if (gs[0].ship.willHitObject(gs[0].ufo, sw) && !gs[1].ship.fire)
			{
				gs[0].ship.fire = true;
			}
			if (gs[0].nasteroids == 0 && !gs[0].ufo.present)
			{
				gs[0].ship.trust = true;
			}
			//*/

			//******************************
			// Tastendruck senden
			if (t < 20) keys.left(true);
			if (gs[0].ship.turnDir == 1) keys.left(true);
			if (gs[0].ship.turnDir == -1) keys.right(true);
			if (gs[0].ship.fire && ! gs[1].ship.fire) keys.fire(true);
			if (gs[0].ship.hyperspace) keys.hyperspace(true);
			if ((t%24 == 0 || t%24 == 1) && gs[0].nasteroids < 8) keys.thrust(true);

		} // Ship.present Ende
		else
		{
			keys.onePlayer(true);
		}
	} // Endlosschleife Ende
}

void Player::InterpretScreen(FramePacket &packet, GameStatus &_gs)
{
	unsigned short *vector_ram = (unsigned short *)packet.vectorram;
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	_gs.clear();
	if ((unsigned char)packet.vectorram[1] != 0xe0 && (unsigned char)packet.vectorram[1] != 0xe2)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	for (;;)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				_gs.asteroids[_gs.nasteroids++].set(vx, vy, 1, vs);
				break;
			case 0x8ff:
				_gs.asteroids[_gs.nasteroids++].set(vx, vy, 2, vs);
				break;
			case 0x90d:
				_gs.asteroids[_gs.nasteroids++].set(vx, vy, 3, vs);
				break;
			case 0x91a:
				_gs.asteroids[_gs.nasteroids++].set(vx, vy, 4, vs);
				break;
			case 0x929:
				_gs.ufo.set(vx, vy, vs);
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				_gs.shots[_gs.nshots++].set(vx, vy);
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					_gs.ship.set(vx, vy, v1x - dx, v1y - dy);
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;
			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}
}

//*************************
// GameObjects
Point GameObject::nextPos(int _latenz)
{
	return this->p + this->v * _latenz;
}
void GameObject::setK(Point _p)
{
	this->p = this->p - _p;
	while (this->p.x < -512) this->p.x += 1024;
	while (this->p.x > 511) this->p.x -= 1024;
	while (this->p.y < -384) this->p.y += 768;
	while (this->p.y > 383) this->p.y -= 768;
	this->dist = sqrt(this->p.x * this->p.x + this->p.y * this->p.y);
}

void Asteroid::set(int _x, int _y, int _type, int _sf)
{
	// Rechnen im groen Koordinatensystem
	this->p.x = _x;
	this->p.y = _y;
	this->oldp = this->p;
	this->v.x = 0;
	this->v.y = 0;
	this->type = _type;
	this->sf = _sf;
	switch (_sf)
	{
	case 0:
		{
			r = 31;
			break;
		}
	case 15:
		{
			r = 15;
			break;
		}
	case 14:
		{
			r = 7;
			break;
		}
	default:
		{
			r = 7;
			break;
		}
	}
	this->tracked = -1;
	this->kk = 0;
	this->ws = 0;
}
bool Asteroid::track(Asteroid &_ast, int _latenz)
{
	if(this->type == _ast.type && this->sf == _ast.sf)
	{
		double f = (_ast.nextPos(_latenz) - this->p).Length();
		if (_ast.tracked >= 1 && f < 3) // getracked & stimmt die Position mit kleinem Fehler (abhngig von Tracking-Zeitraum) berein?
		{
			this->tracked = _ast.tracked;
			if (this->tracked < 8)
			{
				this->tracked++;
				this->oldp = _ast.oldp;
				this->kk = _ast.kk;
				this->ws = _ast.ws - 1;
				this->v = (this->p - this->oldp) / this->tracked;
			}
			else
			{
				this->v = _ast.v;
				this->kk = _ast.kk;
				this->ws = _ast.ws - 1;
			}
			return true;
		}
		else if (_ast.tracked == -1 && f < 7) // noch nicht getracked & Fehler kleiner als maximale Asteroidenbewegung
		{
			this->tracked = 1;
			this->oldp = _ast.p;
			this->v = this->p - this->oldp;
			return true;
		}
	}
	return false;
}

void Shot::set(int &_x, int &_y)
{
	this->p.x = _x;
	this->p.y = _y;
	this->oldp = this->p;
	this->v.x = 0;
	this->v.y = 0;
	this->r = 1;
	this->tracked = -1;
	this->kk = 0;
}
bool Shot::track(Shot &_sh, GameStatus &_gs)
{
	double f = (_sh.nextPos(_gs.latenz) - this->p).Length();
	if (f < 5)
	{
		this->tracked = _sh.tracked;
		if (this->tracked < 8)
		{
			this->tracked++;
			this->oldp = _sh.oldp;
			this->kk = _sh.kk;
			this->v = (this->p - this->oldp) / this->tracked;
		}
		else
		{
			this->v = _sh.v;
		}
		return true;
	}
	else if (_sh.tracked == -1 && f < 12)
	{
			this->tracked = 1;
			this->oldp = _sh.p;
			this->v = this->p - this->oldp;
			return true;
	}
	return false;
}

void Ufo::set(int &_x, int &_y, int &_sf)
{
	this->p.x = _x;
	this->p.y = _y;
	this->oldp = this->p;
	this->v.x = 0;
	this->v.y = 0;
	if (_sf == 15) this->r = 15;
	if (_sf == 14) this->r = 9;
	this->tracked = -1;
	this->present = true;
}
bool Ufo::track(Ufo &_ufo)
{
	if ((this->p.x - _ufo.p.x) < 0) this->v.x = -2;		// links
	else if ((this->p.x - _ufo.p.x) > 0) this->v.x = 2;	// rechts

	if ((this->p.y - _ufo.p.y) < 0) this->v.y = -2;		// runter
	else if ((this->p.y - _ufo.p.y) > 0) this->v.y = 2;	// hoch

	return true;
}

void Ship::set(int _x, int _y, int _dx, int _dy)
{
	// Rechnen im groen Koordinatensystem
	this->p.x = _x;
	this->p.y = _y;
	this->oldp = this->p;
	this->v.x = 0;
	this->v.y = 0;
	this->d.x = _dx;
	this->d.y = _dy;
	this->r = 24;
	this->tracked = -1;
	this->present = true;
	this->fire = false;
	this->hyperspace = false;
	this->trust = false;
	this->turnDir = 0;
	this->sw = 0;
	this->status = 0;
}
bool Ship::track(Ship &_ship1, Ship &_ship3)
{
	//*******************************
	// Schusswinkel synchronisieren
	if (_ship3.turnDir == 1) // bei Linksdrehung
	{
		if (this->d == _ship1.d)
		{
			for (int i=255; i>=0; i--)
			{
				if (this->d == this->sa[i].d)
				{
					_ship1.sw = i;
				}
			}
		}
	}
	else if (_ship3.turnDir == -1) // bei Rechtsdrehung
	{
		if (this->d == _ship1.d)
		{
			for (int i=0; i<256; i++)
			{
				if (this->d == this->sa[i].d)
				{
					_ship1.sw = i;
				}
			}
		}
	}
	this->sw = _ship1.sw + 3 * _ship3.turnDir;
	while (this->sw > 255) this->sw -= 256;
	while (this->sw < 0) this->sw += 256;
	//*/

	//*******************************
	// Status setzen
	//this->status = _ship1.status;	
	//*/

	return false;
}
Point tp;
Vector tv;
bool Ship::willHitObject(GameObject &_go, int _sw)
{
	// 1. Objekt ins Bezugssystem zum Schu setzten und Latenz mit einberechnen
	tp = _go.nextPos(2) - this->sa[_sw].p;
	tv = _go.v - this->sa[_sw].v;
	// 2. Skalarprodukt zeigt, ob berhaupt getroffen werden kann (Richtung)
	// Todo: schussentfernung mit einbringen
	if (tp.x * tv.x + tp.y * tv.y < 0)
	{
		// 3. Vektorprodukt gibt an ob trifft (Entfernung)
		if (fabs(tp.x * tv.y - tp.y * tv.x) / tv.Length() < _go.r)
		{
			//printf("%4.3f - %4.3f\n", fabs(v.vprod(p).z), _go.r);
			return true;
		}
	}

	return false;
}

void GameStatus::clear(void)
{
	ship.present = false;
	ufo.present = false;
	nasteroids = 0;
	nshots = 0;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::onePlayer(bool b)
{
	if (b)
		keys |= KEY_ONEPLAYER;
	else
		keys &= ~KEY_ONEPLAYER;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}
