require 'stringio'

class GameStartup
  def initialize
    force = $force
    debug = $debug
    $force = true # need to override game start detection
    $debug = false # suppress any debug output
    
    tracker = Tracker.new
    ringbuffer = GameStateRingbuffer.new(10)
    player_state = PlayerState.new
    Player.new(ringbuffer, player_state)
    puts "Warming up JVM with pre-recorded data (this will take approx. 60s)..."
    frame_counter = 0
    File.open(File.join(File.dirname(__FILE__),'data','system-check.dat')) do |file|
      file.seek(0x39,IO::SEEK_SET) # position to first frame
      until file.eof?
        ringbuffer << tracker.parse(file.read(1024) + (frame_counter & 0xff).chr + ((frame_counter - 2) & 0xff).chr) 
        file.seek(1,IO::SEEK_CUR) # skip control byte
        frame_counter += 1
        print '.' if frame_counter % 240 == 0
      end
    end
    tracker, ringbuffer, player_state = nil # free object references
    GC.start # start GC now
    puts "\nReady."
    
    $force = force
    $debug = debug
  end
end