class Controls

  KEY_HYPERSPACE = 0x1
  KEY_FIRE       = 0x2
  KEY_THRUST     = 0x4
  KEY_RIGHT      = 0x8
  KEY_LEFT       = 0x10
  KEY_START      = 0x20

  def self.fire?(status)
    status & KEY_FIRE != 0
  end

  def self.left?(status)
    status & KEY_LEFT != 0
  end

  def self.right?(status)
    status & KEY_RIGHT != 0
  end

  def reset
    @keyboard_state &= KEY_FIRE # clear, but leave fire key alone
  end

  def fire
    @fire_requested = true
    @keyboard_state ^= KEY_FIRE # toggle
  end
  
  def left
    @keyboard_state |= KEY_LEFT
  end
  
  def right
    @keyboard_state |= KEY_RIGHT
  end
  
  def thrust
    @keyboard_state |= KEY_THRUST
  end
  
  def hyperspace
    @keyboard_state |= KEY_HYPERSPACE
  end
  
  def start
    @keyboard_state |= KEY_START if $autostart
  end
  
  def status
    @keyboard_state
  end
  
  def prepare_command(ping = 0)
    @keyboard_state &= ~KEY_FIRE unless @fire_requested # reset fire to 0
    @fire_requested = false
    "ctmame" + @keyboard_state.chr + (ping & 0xff).chr
  end

  def send_command(ping = 0)
    @socket.send(prepare_command(ping), 0)
  end
  
  def self.send_command(socket, command)
    socket.send(command, 0)
  end

  def initialize(socket)
    @socket = socket
    @keyboard_state = 0x0
  end
  
end