/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CallBlock
extends BlockBody {
    private Arity arity;
    private BlockCallback callback;
    private RubyModule imClass;
    private ThreadContext context;

    public static Block newCallClosure(IRubyObject self, RubyModule imClass, Arity arity, BlockCallback callback, ThreadContext context) {
        Binding binding = new Binding(self, context.getCurrentFrame(), Visibility.PUBLIC, context.getRubyClass(), context.getCurrentScope());
        CallBlock body = new CallBlock(imClass, arity, callback, context);
        return new Block(body, binding);
    }

    private CallBlock(RubyModule imClass, Arity arity, BlockCallback callback, ThreadContext context) {
        super(3);
        this.arity = arity;
        this.callback = callback;
        this.imClass = imClass;
        this.context = context;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args, Binding binding, Block.Type type) {
        return this.callback.call(context, args, Block.NULL_BLOCK);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value, Binding binding, Block.Type type) {
        return this.yield(context, value, null, null, false, binding, type);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue, Binding binding, Block.Type type) {
        if (klass == null) {
            self = binding.getSelf();
            binding.getFrame().setSelf(self);
        }
        return this.callback.call(context, new IRubyObject[]{value}, Block.NULL_BLOCK);
    }

    public StaticScope getStaticScope() {
        throw new RuntimeException("CallBlock does not have a static scope; this should not be called");
    }

    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), this.context.getCurrentFrame().duplicate(), Visibility.PUBLIC, this.context.getRubyClass(), this.context.getCurrentScope());
        return new Block(this, binding);
    }

    public Arity arity() {
        return this.arity;
    }
}

