/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectedJavaMethod
extends JavaMethod {
    private final Method method;
    private final boolean needsBlock;
    private final boolean isStatic;
    private final int required;
    private final int optional;
    private final boolean rest;
    private final int max;
    private final boolean argsAsIs;
    private final boolean needsThreadContext;

    public ReflectedJavaMethod(RubyModule implementationClass, Method method, JRubyMethod annotation) {
        super(implementationClass, annotation.visibility());
        this.method = method;
        Class[] params = method.getParameterTypes();
        this.needsBlock = params.length > 0 && params[params.length - 1] == Block.class;
        this.isStatic = Modifier.isStatic(method.getModifiers());
        Arity arity = Arity.fromAnnotation(annotation, params, this.isStatic);
        this.setArity(arity);
        this.required = arity.getValue() >= 0 ? arity.getValue() : Math.abs(arity.getValue()) - 1;
        this.optional = annotation.optional();
        this.rest = annotation.rest();
        this.needsThreadContext = params.length > 0 && params[0] == ThreadContext.class;
        this.argsAsIs = !this.isStatic && this.optional == 0 && !this.rest && !this.needsBlock && !this.needsThreadContext;
        this.max = this.rest ? -1 : this.required + this.optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        runtime = context.getRuntime();
        Arity.checkArgumentCount(runtime, args, this.required, this.max);
        this.callConfig.pre(context, self, this.getImplementationClass(), this.arity, name, args, block, null, this);
        if (!this.isStatic && !this.method.getDeclaringClass().isAssignableFrom(self.getClass())) {
            throw new ClassCastException(self.getClass().getName() + " cannot be converted to " + this.method.getDeclaringClass().getName());
        }
        if (this.argsAsIs) {
            isTrace = runtime.hasEventHooks();
            if (isTrace) {
                runtime.callEventHooks(context, 5, context.getFile(), context.getLine(), name, this.getImplementationClass());
            }
            var9_12 = (IRubyObject)this.method.invoke((Object)self, (Object[])args);
            return var9_12;
        }
        argsLength = this.calcArgsLength();
        ** GOTO lbl34
        {
            catch (IllegalArgumentException e) {
                throw RaiseException.createNativeRaiseException(runtime, e);
            }
            catch (IllegalAccessException e) {
                throw RaiseException.createNativeRaiseException(runtime, e);
            }
            catch (InvocationTargetException e) {
                cause = e.getCause();
                if (cause instanceof JumpException.ReturnJump) {
                    f = (JumpException.FlowControlException)cause;
                    if (f.getTarget() != this) throw f;
                    var11_18 = (IRubyObject)f.getValue();
                    return var11_18;
                }
                if (cause instanceof JumpException.RedoJump) {
                    throw runtime.newLocalJumpError("redo", runtime.getNil(), "unexpected redo");
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error == false) throw RaiseException.createNativeRaiseException(runtime, cause);
                throw (Error)cause;
            }
lbl34:
            // 1 sources

            params = new Object[argsLength];
            offset = 0;
            if (this.needsThreadContext) {
                params[offset++] = context;
            }
            if (this.isStatic) {
                params[offset++] = self;
            }
            if (this.optional == 0 && !this.rest) {
                for (i = 0; i < args.length; ++i) {
                    params[offset++] = args[i];
                }
            } else {
                params[offset++] = args;
            }
            if (this.needsBlock) {
                params[offset++] = block;
            }
            isTrace = runtime.hasEventHooks();
            try {
                if (isTrace) {
                    runtime.callEventHooks(context, 5, context.getFile(), context.getLine(), name, this.getImplementationClass());
                }
                if (this.isStatic) {
                    var12_19 = (IRubyObject)this.method.invoke(null, params);
                    if (isTrace == false) return var12_19;
                    runtime.callEventHooks(context, 6, context.getFile(), context.getLine(), name, this.getImplementationClass());
                    return var12_19;
                }
            }
            catch (Throwable var13_21) {}
            {
                if (isTrace == false) throw var13_21;
                runtime.callEventHooks(context, 6, context.getFile(), context.getLine(), name, this.getImplementationClass());
                throw var13_21;
            }
        }
        {
            var12_20 = (IRubyObject)this.method.invoke((Object)self, params);
            if (isTrace == false) return var12_20;
            runtime.callEventHooks(context, 6, context.getFile(), context.getLine(), name, this.getImplementationClass());
            return var12_20;
        }
        finally {
            if (isTrace) {
                runtime.callEventHooks(context, 6, context.getFile(), context.getLine(), name, this.getImplementationClass());
            }
        }
        finally {
            this.callConfig.post(context);
        }
    }

    private int calcArgsLength() {
        int argsLength = 0;
        if (this.needsThreadContext) {
            ++argsLength;
        }
        if (this.isStatic) {
            ++argsLength;
        }
        argsLength = this.optional == 0 && !this.rest ? (argsLength += this.required) : ++argsLength;
        if (this.needsBlock) {
            ++argsLength;
        }
        return argsLength;
    }
}

