/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.RubyDateFormat;

public class RubyTime
extends RubyObject {
    public static final String UTC = "UTC";
    private DateTime dt;
    private long usec;
    private static final DateTimeFormatter ONE_DAY_CTIME_FORMATTER = DateTimeFormat.forPattern("EEE MMM  d HH:mm:ss yyyy");
    private static final DateTimeFormatter TWO_DAY_CTIME_FORMATTER = DateTimeFormat.forPattern("EEE MMM dd HH:mm:ss yyyy");
    private static final DateTimeFormatter TO_S_FORMATTER = DateTimeFormat.forPattern("EEE MMM dd HH:mm:ss Z yyyy");
    private static final DateTimeFormatter TO_S_UTC_FORMATTER = DateTimeFormat.forPattern("EEE MMM dd HH:mm:ss 'UTC' yyyy");
    private static final Pattern TZ_PATTERN = Pattern.compile("(\\D+?)([\\+-]?)(\\d+)(:\\d+)?(:\\d+)?");
    private static final ByteList TZ_STRING = ByteList.create("TZ");
    private static SoftReference<Map<String, DateTimeZone>> LOCAL_ZONES_CACHE = new SoftReference(new HashMap());
    private static final long BASE_TIME_MILLIS = System.currentTimeMillis();
    private static final long BASE_TIME_NANOS = System.nanoTime();
    private static ObjectAllocator TIME_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            long nanosPassed = System.nanoTime() - BASE_TIME_NANOS;
            long millisTime = BASE_TIME_MILLIS + nanosPassed / 1000000L;
            long usecs = nanosPassed % 1000L;
            DateTimeZone dtz = RubyTime.getLocalTimeZone(runtime);
            DateTime dt = new DateTime(millisTime, dtz);
            RubyTime rt = new RubyTime(runtime, klass, dt);
            rt.setUSec(usecs);
            return rt;
        }
    };
    private static final String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final int[] time_min = new int[]{1, 0, 0, 0, Integer.MIN_VALUE};
    private static final int[] time_max = new int[]{31, 23, 59, 60, Integer.MAX_VALUE};
    private static final int ARG_SIZE = 7;

    public static DateTimeZone getLocalTimeZone(Ruby runtime) {
        RubyString tzVar = runtime.newString(TZ_STRING);
        RubyHash h = (RubyHash)runtime.getObject().fastGetConstant("ENV");
        IRubyObject tz = h.op_aref(runtime.getCurrentContext(), tzVar);
        if (tz == null || !(tz instanceof RubyString)) {
            return DateTimeZone.getDefault();
        }
        String zone = tz.toString();
        Map<String, DateTimeZone> zonesCache = LOCAL_ZONES_CACHE.get();
        if (zonesCache != null) {
            DateTimeZone cachedZone = zonesCache.get(zone);
            if (cachedZone != null) {
                return cachedZone;
            }
        } else {
            zonesCache = new HashMap<String, DateTimeZone>();
            LOCAL_ZONES_CACHE = new SoftReference<Map<String, DateTimeZone>>(zonesCache);
        }
        String originalZone = zone;
        Matcher tzMatcher = TZ_PATTERN.matcher(zone);
        if (tzMatcher.matches()) {
            String sign = tzMatcher.group(2);
            String hours = tzMatcher.group(3);
            String minutes = tzMatcher.group(4);
            if (("00".equals(hours) || "0".equals(hours)) && (minutes == null || ":00".equals(minutes) || ":0".equals(minutes))) {
                zone = "Etc/GMT";
            } else {
                sign = "-".equals(sign) ? "+" : "-";
                zone = "GMT" + sign + hours;
                if (minutes != null) {
                    zone = zone + minutes;
                }
            }
        }
        if ("GMT".equalsIgnoreCase(zone) || UTC.equalsIgnoreCase(zone)) {
            zone = "Etc/" + zone;
        }
        DateTimeZone dtz = DateTimeZone.forTimeZone(TimeZone.getTimeZone(zone));
        zonesCache.put(originalZone, dtz);
        return dtz;
    }

    public RubyTime(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public RubyTime(Ruby runtime, RubyClass rubyClass, DateTime dt) {
        super(runtime, rubyClass);
        this.dt = dt;
    }

    public static RubyClass createTimeClass(Ruby runtime) {
        RubyClass timeClass = runtime.defineClass("Time", runtime.getObject(), TIME_ALLOCATOR);
        runtime.setTime(timeClass);
        timeClass.includeModule(runtime.getComparable());
        timeClass.defineAnnotatedMethods(RubyTime.class);
        return timeClass;
    }

    public void setUSec(long usec) {
        this.usec = usec;
    }

    public long getUSec() {
        return this.usec;
    }

    public void updateCal(DateTime dt) {
        this.dt = dt;
    }

    protected long getTimeInMillis() {
        return this.dt.getMillis();
    }

    public static RubyTime newTime(Ruby runtime, long milliseconds) {
        return RubyTime.newTime(runtime, new DateTime(milliseconds));
    }

    public static RubyTime newTime(Ruby runtime, DateTime dt) {
        return new RubyTime(runtime, runtime.getTime(), dt);
    }

    public static RubyTime newTime(Ruby runtime, DateTime dt, long usec) {
        RubyTime t = new RubyTime(runtime, runtime.getTime(), dt);
        t.setUSec(usec);
        return t;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (!(original instanceof RubyTime)) {
            throw this.getRuntime().newTypeError("Expecting an instance of class Time");
        }
        RubyTime originalTime = (RubyTime)original;
        this.dt = originalTime.dt;
        this.usec = originalTime.usec;
        return this;
    }

    @JRubyMethod(name={"succ"})
    public RubyTime succ() {
        return RubyTime.newTime(this.getRuntime(), this.dt.plusSeconds(1));
    }

    @JRubyMethod(name={"gmtime", "utc"})
    public RubyTime gmtime() {
        this.dt = new DateTime(this.dt.getMillis()).withZone(DateTimeZone.UTC);
        return this;
    }

    @JRubyMethod(name={"localtime"})
    public RubyTime localtime() {
        this.dt = this.dt.withZone(RubyTime.getLocalTimeZone(this.getRuntime()));
        return this;
    }

    @JRubyMethod(name={"gmt?", "utc?", "gmtime?"})
    public RubyBoolean gmt() {
        return this.getRuntime().newBoolean(this.dt.getZone().getID().equals(UTC));
    }

    @JRubyMethod(name={"getgm", "getutc"})
    public RubyTime getgm() {
        return RubyTime.newTime(this.getRuntime(), this.dt.withZone(DateTimeZone.UTC), this.getUSec());
    }

    @JRubyMethod(name={"getlocal"})
    public RubyTime getlocal() {
        return RubyTime.newTime(this.getRuntime(), this.dt.withZone(RubyTime.getLocalTimeZone(this.getRuntime())), this.getUSec());
    }

    @JRubyMethod(name={"strftime"}, required=1)
    public RubyString strftime(IRubyObject format) {
        RubyDateFormat rubyDateFormat = new RubyDateFormat("-", Locale.US);
        rubyDateFormat.applyPattern(format.toString());
        rubyDateFormat.setDateTime(this.dt);
        String result = rubyDateFormat.format(null);
        return this.getRuntime().newString(result);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) < 0);
        }
        return RubyComparable.op_lt(context, this, other);
    }

    private int cmp(RubyTime other) {
        long millis = this.getTimeInMillis();
        long millis_other = other.getTimeInMillis();
        long usec_other = other.usec;
        if (millis > millis_other || millis == millis_other && this.usec > usec_other) {
            return 1;
        }
        if (millis < millis_other || millis == millis_other && this.usec < usec_other) {
            return -1;
        }
        return 0;
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject other) {
        long time = this.getTimeInMillis();
        if (other instanceof RubyTime) {
            throw this.getRuntime().newTypeError("time + time ?");
        }
        long adjustment = (long)(RubyNumeric.num2dbl(other) * 1000000.0);
        int micro = (int)(adjustment % 1000L);
        RubyTime newTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        newTime.dt = new DateTime(time += (adjustment /= 1000L)).withZone(this.dt.getZone());
        newTime.setUSec(micro);
        return newTime;
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(IRubyObject other) {
        long time = this.getTimeInMillis();
        if (other instanceof RubyTime) {
            return RubyFloat.newFloat(this.getRuntime(), (double)(time -= ((RubyTime)other).getTimeInMillis()) * 0.001);
        }
        long adjustment = (long)(RubyNumeric.num2dbl(other) * 1000000.0);
        int micro = (int)(adjustment % 1000L);
        RubyTime newTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        newTime.dt = new DateTime(time -= (adjustment /= 1000L)).withZone(this.dt.getZone());
        newTime.setUSec(micro);
        return newTime;
    }

    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return RubyNumeric.fix2int(this.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", other)) == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject other) {
        if (other.isNil()) {
            return other;
        }
        if (other instanceof RubyTime) {
            return this.getRuntime().newFixnum(this.cmp((RubyTime)other));
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        if (other instanceof RubyTime) {
            RubyTime otherTime = (RubyTime)other;
            return this.usec == otherTime.usec && this.getTimeInMillis() == otherTime.getTimeInMillis() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"asctime", "ctime"})
    public RubyString asctime() {
        DateTimeFormatter simpleDateFormat = this.dt.getDayOfMonth() < 10 ? ONE_DAY_CTIME_FORMATTER : TWO_DAY_CTIME_FORMATTER;
        String result = simpleDateFormat.print(this.dt);
        return this.getRuntime().newString(result);
    }

    @JRubyMethod(name={"to_s", "inspect"})
    public IRubyObject to_s() {
        DateTimeFormatter simpleDateFormat = this.dt.getZone().equals(DateTimeZone.UTC) ? TO_S_UTC_FORMATTER : TO_S_FORMATTER;
        String result = simpleDateFormat.print(this.dt);
        return this.getRuntime().newString(result);
    }

    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        return this.getRuntime().newArrayNoCopy(new IRubyObject[]{this.sec(), this.min(), this.hour(), this.mday(), this.month(), this.year(), this.wday(), this.yday(), this.isdst(), this.zone()});
    }

    @JRubyMethod(name={"to_f"})
    public RubyFloat to_f() {
        long time = this.getTimeInMillis();
        time = time * 1000L + this.usec;
        return RubyFloat.newFloat(this.getRuntime(), (double)time / 1000000.0);
    }

    @JRubyMethod(name={"to_i", "tv_sec"})
    public RubyInteger to_i() {
        return this.getRuntime().newFixnum(this.getTimeInMillis() / 1000L);
    }

    @JRubyMethod(name={"usec", "tv_usec"})
    public RubyInteger usec() {
        return this.getRuntime().newFixnum((long)(this.dt.getMillisOfSecond() * 1000) + this.getUSec());
    }

    public void setMicroseconds(long mic) {
        long millis = this.getTimeInMillis() % 1000L;
        long withoutMillis = this.getTimeInMillis() - millis;
        this.dt = this.dt.withMillis(withoutMillis += mic / 1000L);
        this.usec = mic % 1000L;
    }

    public long microseconds() {
        return this.getTimeInMillis() % 1000L * 1000L + this.usec;
    }

    @JRubyMethod(name={"sec"})
    public RubyInteger sec() {
        return this.getRuntime().newFixnum(this.dt.getSecondOfMinute());
    }

    @JRubyMethod(name={"min"})
    public RubyInteger min() {
        return this.getRuntime().newFixnum(this.dt.getMinuteOfHour());
    }

    @JRubyMethod(name={"hour"})
    public RubyInteger hour() {
        return this.getRuntime().newFixnum(this.dt.getHourOfDay());
    }

    @JRubyMethod(name={"mday", "day"})
    public RubyInteger mday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfMonth());
    }

    @JRubyMethod(name={"month", "mon"})
    public RubyInteger month() {
        return this.getRuntime().newFixnum(this.dt.getMonthOfYear());
    }

    @JRubyMethod(name={"year"})
    public RubyInteger year() {
        return this.getRuntime().newFixnum(this.dt.getYear());
    }

    @JRubyMethod(name={"wday"})
    public RubyInteger wday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfWeek() % 7);
    }

    @JRubyMethod(name={"yday"})
    public RubyInteger yday() {
        return this.getRuntime().newFixnum(this.dt.getDayOfYear());
    }

    @JRubyMethod(name={"gmt_offset", "gmtoff", "utc_offset"})
    public RubyInteger gmt_offset() {
        int offset = this.dt.getZone().getOffsetFromLocal(this.dt.getMillis());
        return this.getRuntime().newFixnum(offset / 1000);
    }

    @JRubyMethod(name={"isdst", "dst?"})
    public RubyBoolean isdst() {
        return this.getRuntime().newBoolean(!this.dt.getZone().isStandardOffset(this.dt.getMillis()));
    }

    @JRubyMethod(name={"zone"})
    public RubyString zone() {
        String zone = this.dt.getZone().getShortName(this.dt.getMillis());
        if (zone.equals("+00:00")) {
            zone = "GMT";
        }
        return this.getRuntime().newString(zone);
    }

    public void setDateTime(DateTime dt) {
        this.dt = dt;
    }

    public DateTime getDateTime() {
        return this.dt;
    }

    public Date getJavaDate() {
        return this.dt.toDate();
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum((int)((this.dt.getMillis() / 1000L ^ this.microseconds()) << 1) >> 1);
    }

    @JRubyMethod(name={"_dump"}, optional=1, frame=true)
    public RubyString dump(IRubyObject[] args, Block unusedBlock) {
        RubyString str = (RubyString)this.mdump(new IRubyObject[]{this});
        str.syncVariables(this.getVariableList());
        return str;
    }

    public RubyObject mdump(IRubyObject[] args) {
        int i;
        RubyTime obj = (RubyTime)args[0];
        DateTime dt = obj.gmtime().dt;
        byte[] dumpValue = new byte[8];
        int pe = Integer.MIN_VALUE | dt.getYear() - 1900 << 14 | dt.getMonthOfYear() - 1 << 10 | dt.getDayOfMonth() << 5 | dt.getHourOfDay();
        int se = dt.getMinuteOfHour() << 26 | dt.getSecondOfMinute() << 20 | dt.getMillisOfSecond() * 1000 + (int)this.usec;
        for (i = 0; i < 4; ++i) {
            dumpValue[i] = (byte)(pe & 0xFF);
            pe >>>= 8;
        }
        for (i = 4; i < 8; ++i) {
            dumpValue[i] = (byte)(se & 0xFF);
            se >>>= 8;
        }
        return RubyString.newString(obj.getRuntime(), new ByteList(dumpValue, false));
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(Block block) {
        return this;
    }

    public static IRubyObject s_new(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyTime time = new RubyTime(runtime, (RubyClass)recv, new DateTime());
        time.callInit(args, block);
        return time;
    }

    @JRubyMethod(name={"new", "now"}, rest=true, frame=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject obj = ((RubyClass)recv).allocate();
        obj.callMethod(context, "initialize", args, block);
        return obj;
    }

    @JRubyMethod(name={"at"}, required=1, optional=1, meta=true)
    public static IRubyObject at(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        RubyTime time = new RubyTime(runtime, (RubyClass)recv, new DateTime(RubyTime.getLocalTimeZone(runtime)));
        if (args[0] instanceof RubyTime) {
            RubyTime other = (RubyTime)args[0];
            time.dt = other.dt;
            time.setUSec(other.getUSec());
        } else {
            long seconds = RubyNumeric.num2long(args[0]);
            long millisecs = 0L;
            long microsecs = 0L;
            if (args.length > 1) {
                long tmp = RubyNumeric.num2long(args[1]);
                millisecs = tmp / 1000L;
                microsecs = tmp % 1000L;
            } else if (args[0] instanceof RubyFloat) {
                double dbl = ((RubyFloat)args[0]).getDoubleValue();
                long micro = (long)((dbl - (double)seconds) * 1000000.0);
                millisecs = micro / 1000L;
                microsecs = micro % 1000L;
            }
            time.setUSec(microsecs);
            time.dt = time.dt.withMillis(seconds * 1000L + millisecs);
        }
        time.callInit(IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        return time;
    }

    @JRubyMethod(name={"local", "mktime"}, required=1, optional=9, meta=true)
    public static RubyTime new_local(IRubyObject recv, IRubyObject[] args) {
        return RubyTime.createTime(recv, args, false);
    }

    @JRubyMethod(name={"utc", "gm"}, required=1, optional=9, meta=true)
    public static RubyTime new_utc(IRubyObject recv, IRubyObject[] args) {
        return RubyTime.createTime(recv, args, true);
    }

    @JRubyMethod(name={"_load"}, required=1, frame=true, meta=true)
    public static RubyTime load(IRubyObject recv, IRubyObject from, Block block) {
        return RubyTime.s_mload(recv, (RubyTime)((RubyClass)recv).allocate(), from);
    }

    protected static RubyTime s_mload(IRubyObject recv, RubyTime time, IRubyObject from) {
        int i;
        Ruby runtime = recv.getRuntime();
        DateTime dt = new DateTime(DateTimeZone.UTC);
        byte[] fromAsBytes = null;
        fromAsBytes = from.convertToString().getBytes();
        if (fromAsBytes.length != 8) {
            throw runtime.newTypeError("marshaled time format differ");
        }
        int p = 0;
        int s = 0;
        for (i = 0; i < 4; ++i) {
            p |= (fromAsBytes[i] & 0xFF) << 8 * i;
        }
        for (i = 4; i < 8; ++i) {
            s |= (fromAsBytes[i] & 0xFF) << 8 * (i - 4);
        }
        if ((p & Integer.MIN_VALUE) == 0) {
            dt = dt.withMillis((long)p * 1000L + (long)s);
        } else {
            dt = dt.withYear(((p &= Integer.MAX_VALUE) >>> 14 & 0xFFFF) + 1900);
            dt = dt.withMonthOfYear((p >>> 10 & 0xF) + 1);
            dt = dt.withDayOfMonth(p >>> 5 & 0x1F);
            dt = dt.withHourOfDay(p & 0x1F);
            dt = dt.withMinuteOfHour(s >>> 26 & 0x3F);
            dt = dt.withSecondOfMinute(s >>> 20 & 0x3F);
            dt = dt.withMillisOfSecond((s & 0xFFFFF) / 1000);
            time.setUSec((s & 0xFFFFF) % 1000);
        }
        time.setDateTime(dt);
        return time;
    }

    private static RubyTime createTime(IRubyObject recv, IRubyObject[] args, boolean gmt) {
        Ruby runtime = recv.getRuntime();
        int len = 7;
        if (args.length == 10) {
            args = new IRubyObject[]{args[5], args[4], args[3], args[2], args[1], args[0], runtime.getNil()};
        } else {
            len = args.length;
            if (len < 7) {
                IRubyObject[] newArgs = new IRubyObject[7];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                for (int i = len; i < 7; ++i) {
                    newArgs[i] = runtime.getNil();
                }
                args = newArgs;
                len = 7;
            }
        }
        ThreadContext context = runtime.getCurrentContext();
        if (args[0] instanceof RubyString) {
            args[0] = RubyNumeric.str2inum(runtime, (RubyString)args[0], 10, false);
        }
        int year = (int)RubyNumeric.num2long(args[0]);
        int month = 1;
        if (len > 1) {
            if (!args[1].isNil()) {
                IRubyObject tmp = args[1].checkStringType();
                if (!tmp.isNil()) {
                    String monthString = tmp.toString();
                    month = -1;
                    for (int i = 0; i < 12; ++i) {
                        if (!months[i].equalsIgnoreCase(monthString)) continue;
                        month = i + 1;
                    }
                    if (month == -1) {
                        try {
                            month = Integer.parseInt(monthString);
                        }
                        catch (NumberFormatException nfExcptn) {
                            throw runtime.newArgumentError("Argument out of range.");
                        }
                    }
                } else {
                    month = (int)RubyNumeric.num2long(args[1]);
                }
            }
            if (1 > month || month > 12) {
                throw runtime.newArgumentError("Argument out of range: for month: " + month);
            }
        }
        int[] int_args = new int[]{1, 0, 0, 0, 0, 0};
        int i = 0;
        while (int_args.length >= i + 2) {
            if (!args[i + 2].isNil()) {
                long value;
                if (!(args[i + 2] instanceof RubyNumeric)) {
                    args[i + 2] = args[i + 2].callMethod(context, "to_i");
                }
                if ((long)time_min[i] > (value = RubyNumeric.num2long(args[i + 2])) || value > (long)time_max[i]) {
                    throw runtime.newArgumentError("argument out of range.");
                }
                int_args[i] = (int)value;
            }
            ++i;
        }
        if (0 <= year && year < 39) {
            year += 2000;
        } else if (69 <= year && year < 139) {
            year += 1900;
        }
        DateTime dt = new DateTime();
        dt = gmt ? dt.withZone(DateTimeZone.UTC) : dt.withZone(RubyTime.getLocalTimeZone(runtime));
        try {
            dt = dt.withDate(year, 1, 1).withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
            dt = dt.plusMonths(month - 1).plusDays(int_args[0] - 1).plusHours(int_args[1]).plusMinutes(int_args[2]).plusSeconds(int_args[3]);
        }
        catch (IllegalFieldValueException e) {
            throw runtime.newArgumentError("time out of range");
        }
        RubyTime time = new RubyTime(runtime, (RubyClass)recv, dt);
        if (args.length != 8 && !args[6].isNil()) {
            int usec = int_args[4] % 1000;
            int msec = int_args[4] / 1000;
            if (int_args[4] < 0) {
                --msec;
                usec += 1000;
            }
            time.dt = dt.withMillis(dt.getMillis() + (long)msec);
            time.setUSec(usec);
        }
        time.callInit(IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        return time;
    }
}

