package de.caff.asteroid;

import junit.framework.TestCase;

public class GeorgsFirstAsteroidPlayerTest extends TestCase {

	GeorgsFirstAsteroidPlayer player;
	
	public void setUp() throws Exception {
		super.setUp();
		
		Communication com = new Communication();
		player = new GeorgsFirstAsteroidPlayer(com);
	}

	public void testObjectsCollidingInFrames() {
		SpaceShip ship = new SpaceShip(100, 100, 5, 5);
		Asteroid asteroid = new Asteroid(200, 100, 0, 0);
		
		ship.setVelocity(5, 5);
		asteroid.setVelocity(-5, 5);
		
		int timeToCollision = player.objectsCollidingInFrames(ship, asteroid);
		
		assertEquals(7, timeToCollision);

		ship.setVelocity(0, 0);
		asteroid.setVelocity(-5, 5);
		
		timeToCollision = player.objectsCollidingInFrames(ship, asteroid);
		
		assertEquals(-1, timeToCollision);

		Asteroid asteroid2 = new Asteroid(101, 50, 0, 0);
		
		ship.setVelocity(0, 5);
		asteroid2.setVelocity(0, 5);
		timeToCollision = player.objectsCollidingInFrames(ship, asteroid2);
		
		assertEquals(-1, timeToCollision);

		asteroid2.setVelocity(0, 6);
		timeToCollision = player.objectsCollidingInFrames(ship, asteroid2);
		
		assertEquals(53, timeToCollision);
	}
	
	/*
	 * asteroid Asteroid@(323,275)*8?0 in 30
asteroid Asteroid@(324,274)*8?0 in 29
no collision
asteroid Asteroid@(327,273)*8?0 in 44
asteroid Asteroid@(329,272)*8?0 in 35
asteroid Asteroid@(330,271)*8?0 in 26
no collision
asteroid Asteroid@(333,270)*8?0 in 39
asteroid Asteroid@(335,269)*8?0 in 30
asteroid Asteroid@(336,268)*8?0 in 22
no collision
no collision
asteroid Asteroid@(341,266)*8?0 in 20
asteroid Asteroid@(342,265)*8?0 in 19
no collision
asteroid Asteroid@(345,264)*8?0 in 30
asteroid Asteroid@(347,263)*8?0 in 16
asteroid Asteroid@(348,262)*8?0 in 20
no collision
asteroid Asteroid@(351,261)*8?0 in 39
asteroid Asteroid@(353,260)*8?0 in 13
asteroid Asteroid@(354,259)*8?0 in 12
no collision
asteroid Asteroid@(357,258)*8?0 in 21
no collision
asteroid Asteroid@(360,256)*8?0 in 9
no collision
asteroid Asteroid@(363,255)*8?0 in 17
asteroid Asteroid@(365,254)*8?0 in 8
asteroid Asteroid@(366,253)*8?0 in 6
no collision
asteroid Asteroid@(369,252)*8?0 in 12
no collision
asteroid Asteroid@(372,250)*8?0 in 2
no collision
asteroid Asteroid@(375,249)*8?0 in 8
	 */

	public void testCollisionDetection() {
		Asteroid ast = new Asteroid(323, 275, 8, 0);
		ast.setVelocity(3, -1);
	}
}
