/*
 * Decompiled with CFR 0.152.
 */
package de.oflebbe.monitor;

import de.oflebbe.asteroids.Asteroid;
import de.oflebbe.asteroids.MovingObject;
import de.oflebbe.asteroids.Saucer;
import de.oflebbe.asteroids.Screen;
import de.oflebbe.asteroids.Ship;
import de.oflebbe.asteroids.Shot;
import de.oflebbe.asteroids.Tacticvisualiser;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class MonitorComponent
extends JComponent {
    private Screen currentScreen = null;
    private Tacticvisualiser visualise;

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2.translate(0, this.getHeight());
        g2.scale((double)this.getWidth() / 1024.0, (double)(-this.getHeight()) / 1024.0);
        Screen current = this.currentScreen;
        if (current == null) {
            return;
        }
        for (Asteroid ast : current.getAsteroids()) {
            this.drawMovable(g2, ast);
        }
        this.drawMovable(g2, current.getSaucer());
        this.drawMovable(g2, current.getShip());
        g2.setPaint(new Color(1.0f, 0.0f, 1.0f));
        for (Shot sh : current.getShots()) {
            this.drawMovable(g2, sh);
        }
        if (this.visualise != null) {
            this.visualise.visualiseTactic(g2);
        }
    }

    public void setCurrentScreen(Screen currentScreen) {
        this.currentScreen = currentScreen;
    }

    private void drawMovable(Graphics2D g2, MovingObject m) {
        if (m == null) {
            return;
        }
        if (m instanceof Asteroid) {
            Asteroid ast = (Asteroid)m;
            int size = ast.getSize();
            g2.drawOval(ast.getX() - size / 2, ast.getY() - size / 2, size, size);
            g2.drawString(Integer.toString(ast.getSize()), ast.getX(), ast.getY());
        } else if (m instanceof Saucer) {
            Saucer sau = (Saucer)m;
            g2.drawRect(sau.getX() - 10, sau.getY() - 10, 20, 20);
        } else if (m instanceof Ship) {
            Ship shi = (Ship)m;
            g2.drawLine(shi.getX(), shi.getY(), shi.getDx() * 10, shi.getDy() * 10);
        }
        g2.drawLine(m.getX(), m.getY(), (int)((double)m.getX() + m.getVx() * 10.0), (int)((double)m.getY() + m.getVy() * 10.0));
    }

    public void setVisualise(Tacticvisualiser tictac) {
        this.visualise = tictac;
    }
}

