package Asteroid;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public abstract class VecObject {
	
	int x;
	int y;
	int oid=0;
	int dx;
	int dy;
	int radius = 2;
	int ox;
	int oy;
	int q;
	int distanz; // Distanz zum Schiff
	int neededFrames; // Ntige Frames, um das schiff in die Richtung zu drehen;
	
	int shipx;
	int shipy;
	
	
	Point vorhalteziel; // cache
	boolean willKollide = false;
	
	static int OID = 1;
	static int MIN_X = -1024;
	static int MAX_X = 1023;
	static int MIN_Y = -768;
	static int MAX_Y = 767;
	
	
	static boolean showOID = true;
	static boolean showQual = false;
	static boolean showXY = true;
	static boolean showDxDy = false;
	static boolean showDxDyNorm = false;
	static boolean showSpeed = true;
	
	public String getIdString()
	{
		StringBuilder s = new StringBuilder();
		if (showOID)
			s.append(Integer.toString(oid)).append(", ");
		if (showQual)
			s.append(Integer.toString(q)).append(", ");
		if (showXY)
			s.append("[").
  			  append(Integer.toString(x)).append(",").
  			  append(Integer.toString(y)).append("], ");
		if (showDxDy)
			s.append("[d").
			  append(Integer.toString(dx)).append(",d").
			  append(Integer.toString(dy)).append("]");
		if (showDxDyNorm)
			s.append("[d").
			  append(Integer.toString(dx * 10 / q)).append(",d").
			  append(Integer.toString(dy * 10 / q)).append("]");
		if (showSpeed && oid>0)
			s.append("[s");
			double rdx = dx;
			rdx = rdx / q;
			double rdy = dy;
			rdy = rdy / q;
			double speed = Math.sqrt(rdx*rdx+rdy*rdy);
			s.append(Double.toString(speed)).append("]");

		return s.toString();
		
	}
	
	public boolean isAsteroid()
	{
		return false;
	}
	
	void set(int x, int y)
	{
		this.x = x;
		this.y = y;
	}
	
	void setOid(int oid)
	{
		this.oid = oid;
	}

	void relocate(int shipx, int shipy)
	{
		this.shipx = shipx;
		this.shipy = shipy;
		x =  x - shipx;
		y =  y - shipy;
		while (x < -512) x += 1024; // dx normalisieren auf -512 ... 511
		while (x > 511) x -= 1024;
		while (y < -384) y += 768;  // dy normalisieren auf -384 ... 383
		while (y > 383) y -= 768;
	}
	
	
	VecObject findeVorgaengerIn(ArrayList<VecObject> objInDerNaehe, ArrayList<VecObject> vorVorgaenger)
	{
		ArrayList<VecObject> objMitVorgaenger = new ArrayList<VecObject>(objInDerNaehe.size());
		ArrayList<VecObject> objOhneVorgaenger = new ArrayList<VecObject>(objInDerNaehe.size());
		VecObject vorgaenger;
		for (VecObject a: objInDerNaehe)
		{
			if (a.oid > 0)
				{
				objMitVorgaenger.add(a);
				} else
				{
				objOhneVorgaenger.add(a);
				}
				
		}
		if (objMitVorgaenger.size()>0)
		{
			vorgaenger = findeVorgaengerMitOid(objMitVorgaenger);
			if (vorgaenger != null)
					return vorgaenger;
		} 
		// mehrere Objekte in der nhe, aber keines liess sich zuordnen...
		// Nu wirds kompliziert...
		if (objOhneVorgaenger.size()>0)
		{
			vorgaenger = findeVorgaengerOhneOid(objMitVorgaenger, vorVorgaenger);
			if (vorgaenger != null)
					return vorgaenger;
			
			// ok, bekommen ich halt irgend eine OID
			return objOhneVorgaenger.get(0);
			
			
		}
		
		
		
		
		
		return null;
		
	}
	
	
	void findeVorgaenger(ArrayList<VecObject> vorgaengerListe, ArrayList<VecObject> vorVorgaengerListe)
	{
		ArrayList<VecObject> objInDerNaehe = new ArrayList<VecObject>(10);
		VecObject vorgaenger;
		for (VecObject a: vorgaengerListe)
		{
			if (isImRadius(a, 10))
			{
				objInDerNaehe.add(a);
			}
		}
		if (objInDerNaehe.size()==0)
		{
			return;
		}
		
		if (objInDerNaehe.size()>1)
		{
			vorgaenger = findeVorgaengerIn(objInDerNaehe, vorVorgaengerListe);
			if (vorgaenger != null)
				{
					setVorgaenger(vorgaenger);
					return;
				}
		} else 
		{
			VecObject v = objInDerNaehe.get(0);
			setVorgaenger(v);
			return;
		};
	}
	
	
	
	protected void setVorgaenger(VecObject v)
	{
		if (v.oid == 0)
		{
		v.oid=OID++;
		oid=v.oid;
		dx  = x-v.x;
		dy  = y-v.y;
		ox = v.x;
		oy = v.y;
		q  = 1;
		} else
		{
		oid = v.oid;
		
		ox = v.ox;
		oy = v.oy;
		q = v.q+1;
		dx = x - ox;
		dy = y - oy;
		}
		
	}
	
	
	boolean isImRadius(VecObject a, int radius)
	{
		int min_x = x-radius;
		while (min_x < MIN_X) min_x += (MAX_X - MIN_X);
		if (min_x>a.x) return false;
		int max_x = x+radius;
		while (max_x > MAX_X) max_x -= (MAX_X - MIN_X);
		if (max_x<a.x) return false;
		int min_y = y-radius;
		while (min_y < MIN_Y) min_y += (MAX_Y - MIN_Y);
		if (min_y>a.y) return false;
		int max_y = y+radius;
		while (max_y > MAX_Y) max_y -= (MAX_Y - MIN_Y);
		if (max_y<a.y) return false;
		return true;
	}
	
	boolean isImRadius(int x1, int y1, int radius)
	{
		int min_x = x-radius;
		while (min_x < -512) min_x += 1024;
		if (min_x>x1) return false;
		int max_x = x+radius;
		while (max_x > 511) max_x -= 1024;
		if (max_x<x1) return false;
		int min_y = y-radius;
		while (min_y < -512) min_y += 1024;
		if (min_y>y1) return false;
		int max_y = y+radius;
		while (max_y > 511) max_y -= 1024;
		if (max_y<y1) return false;
		return true;
	}
	
	
	protected VecObject findeMitOid(ArrayList<VecObject> liste, int oid) {
		for (VecObject a: liste)
		{
			if (a.oid == oid) return a;
		}
		return null;
	}
	
	protected VecObject findeVorgaengerMitOid(ArrayList<VecObject> objMitVorgaenger)
	{
		for (VecObject a: objMitVorgaenger)
		{
			if (isImRadius(a.x+a.dx, a.y+a.dy, 3))
				return a;
		}
		return null;
	}

	protected VecObject findeVorgaengerOhneOid(ArrayList<VecObject> objOhneVorgaenger, ArrayList<VecObject> vorVorgaengerListe)
	{
		for (VecObject a1: objOhneVorgaenger)
		{
			for (VecObject a2: vorVorgaengerListe)
			{
				if (isImRadius(a1.x - a2.x + a1.x, a1.y - a2.y + a1.y , 3))
				{
					a2.setOid(OID++);
					a1.setVorgaenger(a2);
					return a1;
				}
			}

		}
		return null;
	}
	
	public int willKollideWithInFrames(Rectangle r)
	{
		if (oid==0) return 0; // Ich weiss noch nix
		if (dx>0 && x-radius > r.x+r.width)
			return 0;
		if (dx<0 && x+radius < r.x)
			return 0;
		if (dy>0 && y-radius > r.y+r.height)
			return 0;
		if (dy<0 && y+radius < r.y)
			return 0;
		
		int x1 = 0, y1 = 0, x2 = 0, y2 = 0;
		double rdxy = dx;
		rdxy = rdxy / dy;
		double rdyx = 1 / rdxy;
		
		if (dx != 0) // keine Senkrechte
			{	
			  y1 = (int) Math.round((r.x - x - radius) * rdyx + y);
			  y2 = (int) Math.round(((r.x + r.width + radius ) - x ) * rdyx + y);
			} else 
			{
				if (x+radius < r.x || x-radius > r.x+r.width)
					return 0;
			}
		
		if (dy != 0) // keine Horizontale
		{	
		  x1 = (int) Math.round((r.y - y - radius) * rdxy + x);
		  x2 = (int) Math.round(((r.y + r.height + radius ) - y) * rdxy + x);
		} else
		{
			if (y+radius < r.y || x-radius > r.y+r.height)
				return 0;
		}

		
		if (x1>x2) 
		{
			int tmp = x1;
			x1 = x2;
			x2 = tmp;
		}
		
		if (y1>y2) 
		{
			int tmp = y1;
			y1 = y2;
			y2 = tmp;
		}
		
		if (dx == 0) // senkrecht
		{
			if ((x1>r.x && x1<r.x+r.width ) || (x2>r.x && x2<r.x+r.width ))
				return 1;
		}
		
		if (dy == 0) // Horizontal 
		{
			if ((y1>r.y && y1<r.y+r.height ) || (y2>r.y && y2<r.y+r.height ))
				return 1;
		}
		
		// eckschnitt
		if (((y1<r.y && y2>r.y ) || (y1<r.y+r.height && y2>r.y+r.height ))
			&& ((x1<r.x && x2>r.x ) || (x1<r.x+r.width && x2>r.x+r.width )))
			return 1;
		
		// durchstoss
		if ((y1>= r.y && y2<r.y+r.height) || (x1>= r.x && x2<r.x+r.width))
			return 1;
			
	return 0;
	}
	
	

	
	void drawAsTargetOn(Graphics g)
	{
		int rx,ry;
		
		rx = x+shipx;
		ry = y+shipy;
		
		if (rx<0) rx += 1024;
		if (ry<0) ry += 768;
		if (rx>1023) rx -= 1024;
		if (ry>767) ry -= 768;
				
		g.setColor(Color.red);
		g.drawOval(	(rx / FramepaketDisplay.SCALE),
					FramepaketDisplay.SIZEY - (ry / FramepaketDisplay.SCALE),
					3 ,
					3 );

		if (vorhalteziel != null)
		{
			
			rx = vorhalteziel.x+shipx;
			ry = vorhalteziel.y+shipy;
			
			if (rx<0) rx += 1024;
			if (ry<0) ry += 768;
			if (rx>1023) rx -= 1024;
			if (ry>767) ry -= 768;
			
			g.drawLine(	((rx-10) / FramepaketDisplay.SCALE),
					FramepaketDisplay.SIZEY - (ry / FramepaketDisplay.SCALE),
					((rx+10) / FramepaketDisplay.SCALE),
					FramepaketDisplay.SIZEY - (ry / FramepaketDisplay.SCALE));
			g.drawLine(	(rx / FramepaketDisplay.SCALE),
					FramepaketDisplay.SIZEY - ((ry-10) / FramepaketDisplay.SCALE),
					(rx / FramepaketDisplay.SCALE),
					FramepaketDisplay.SIZEY - ((ry+10) / FramepaketDisplay.SCALE));
			
			
		}
			
			 
		
		
		
	}
	
	
}
