package Asteroid;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;

public class FramepaketDisplay extends JFrame
{
  /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
    GameStatus gamestatus;
	static int SCALE = 2;
	static int SIZEX = 1024 / SCALE;
	static int SIZEY = 1024 / SCALE;
	
	static boolean zeigeAsteroiden = true;
	static boolean zeigeSchuesse = true;
	static boolean zeigeTexte = true;
	static boolean zeigeGitter = true;
	
	
	
  void showDisplay()
  {
    setTitle( "Asteroid-Player Diagnostics" );
    setResizable(false);
    setSize(518, 544);
    
    setVisible( true );
  }

  public FramepaketDisplay()
  {
    addWindowListener(
      new WindowAdapter() {
        public void windowClosing( WindowEvent ev ) {
          dispose();
          System.exit( 0 ); } } );
  }

  public void setGamestatus( GameStatus gamestatus )
  {
	  this.gamestatus = gamestatus;
	  this.repaint();
  }
  
  
  
  public void paint( Graphics g )
  {
    Insets insts = getInsets();
    int iOriginX = insts.left;
    int iOriginY = insts.top;
    if (gamestatus != null)
    {
    	g.clearRect(iOriginX, iOriginY, SIZEX, SIZEY);
    	
    	if (zeigeGitter)
    	{
    	g.setColor( Color.green );
    	for (int x = 100; x < 1000 ; x = x + 100)
    	{
    		g.drawString( "X:"+Integer.toString(x), (x / FramepaketDisplay.SCALE), FramepaketDisplay.SIZEY  );
    		g.drawLine(x / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEY - 30, x / FramepaketDisplay.SCALE , 0 );
    	}
    	for (int y = 100; y < 1000; y = y + 100)
    	{
    		g.drawString( "Y:"+Integer.toString(y), 10, FramepaketDisplay.SIZEY  - y / FramepaketDisplay.SCALE);
    		g.drawLine(30, FramepaketDisplay.SIZEY - y / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEX , FramepaketDisplay.SIZEY - y / FramepaketDisplay.SCALE );
    	}
    	};
    	
    	if (zeigeAsteroiden)
    	{
				for (Asteroid a : gamestatus.asteroids) {
					a.drawOn(g);
				}
			}
    	if (zeigeSchuesse)
    	{
				for (Shot s : gamestatus.shots) {
					s.drawOn(g);
				}
			}
    	if (gamestatus.ship_present)
    	{
    		g.setColor( Color.black);
    		Rectangle shipRect = new Rectangle(gamestatus.ship_x - 18,gamestatus.ship_y - 18,36,36);
    		g.drawRect(	((shipRect.x) / FramepaketDisplay.SCALE),
						FramepaketDisplay.SIZEY - ( ( shipRect.y + shipRect.height ) / FramepaketDisplay.SCALE),
						shipRect.width / FramepaketDisplay.SCALE, 
						shipRect.height / FramepaketDisplay.SCALE);
    		
    		g.drawLine(	gamestatus.ship_x / FramepaketDisplay.SCALE,
    					FramepaketDisplay.SIZEY - (gamestatus.ship_y/ FramepaketDisplay.SCALE),
    					(gamestatus.ship_dx + gamestatus.ship_x) / FramepaketDisplay.SCALE,
    					FramepaketDisplay.SIZEY - ((gamestatus.ship_y + gamestatus.ship_dy)/ FramepaketDisplay.SCALE));
    		
    		if (zeigeTexte)
    		{
    		StringBuilder sb = new StringBuilder();
    		sb .append("(").append(Integer.toString(gamestatus.ship_x))
    		   .append(",").append(Integer.toString(gamestatus.ship_y))
    		   .append(") - [").append(Integer.toString(gamestatus.ship_dx))
    		   .append(",").append(Integer.toString(gamestatus.ship_dy)).append("] Dir=").append(Integer.toString(gamestatus.ship_dir));
    		g.drawString( sb.toString(), gamestatus.ship_x / FramepaketDisplay.SCALE, FramepaketDisplay.SIZEY  - gamestatus.ship_y / FramepaketDisplay.SCALE);
    		}
    		
    		if (gamestatus.feuerziel != null)
    		{
    			gamestatus.feuerziel.drawAsTargetOn(g);
    		}
    		
    		
    	}	
    	
    	
    	
    	if (gamestatus.saucer_present)
    	{
    		gamestatus.ufo.drawOn(g);
    		
    	}	
    	
    	
    	
    }
    
    
  }
}

