package Asteroid;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedList;

public class AsteroidPlayer implements Runnable {
	final DatagramSocket socket;
	final InetAddress serverAdress;
	final FramePacket framepaket;
	final KeysPacket keyspaket;
	GameStatus game2, game1, game0, gameDiag;
	FramepaketDisplay display;
	static int[]    DIR_VAL ={0,152,296,440,584,720,856,976,1088,1192,1280,1360,1416,1472,1504,1528,1536};
	final double[] W_VAL;
	static int MAXIMALE_FD_Q = 300000;
	boolean lastfire;
	LinkedList<GameStatus> gameHist = new LinkedList<GameStatus>();
	
	AsteroidPlayer(InetAddress serverAdress) throws IOException
	{
		this.serverAdress = serverAdress;
		socket = new DatagramSocket();
		framepaket = new FramePacket();
		keyspaket = new KeysPacket();
		W_VAL = new double[17];
		for (int idx=0; idx<16; idx++ )
		{
			W_VAL[idx] = Math.atan((double) DIR_VAL[idx] / (double) DIR_VAL[16-idx]);
		};
		W_VAL[16] = 1.570796;
		

		
		
	}
	
	void setDiagnosticDisplay(FramepaketDisplay d)
	{
		display = d;
	}
	
	
	GameStatus InterpretScreen()
	{
		GameStatus game = new GameStatus();
		char[] vector_ram; 
		int dx = 0, dy=0, sf=0, vx=0, vy=0, vz=0, vs=0;
		int v1x = 0;
		int v1y = 0;
		int shipdetect = 0;

		vector_ram = framepaket.getVRam();
		if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
			return null; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

		int pc = 1;
		while (pc < 511)
		{
			int op = vector_ram[pc] >> 12;
			switch (op)
			{
			case 0xa: // LABS
				vy = vector_ram[pc] & 0x3ff;
				vx = vector_ram[pc+1] & 0x3ff;
				vs = vector_ram[pc+1] >> 12;
				break;
			case 0xb: // HALT
				return game;
			case 0xc: // JSRL
				switch (vector_ram[pc] & 0xfff)
				{
				case 0x8f3:
					game.addAsteroid(vx, vy, 1, vs);
					break;
				case 0x8ff:
					game.addAsteroid(vx, vy, 2, vs);
					break;
				case 0x90d:
					game.addAsteroid(vx, vy, 3, vs);
					break;
				case 0x91a:
					game.addAsteroid(vx, vy, 4, vs);
					break;
				case 0x929:
					game.saucer_present = true;
					game.ufo = new Ufo(vx,vy,vs);
					break;
				}  
				break;
			case 0xd: // RTSL
				return game;
			case 0xe: // JMPL
				/*
				pc = vector_ram[pc] & 0xfff;
				break;
				*/
				return game;
			case 0xf: // SVEC
				/*
				dy = vector_ram[pc] & 0x300;
				if ((vector_ram[pc] & 0x400) != 0)
					dy = -dy;
				dx = (vector_ram[pc] & 3) << 8;
				if ((vector_ram[pc] & 4) != 0)
					dx = -dx;
				sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
				vz = (vector_ram[pc] & 0xf0) >> 4;
				*/
				break;
			default:
				dy = vector_ram[pc] & 0x3ff;
				if ((vector_ram[pc] & 0x400) != 0)
					dy = -dy;
				dx = vector_ram[pc+1] & 0x3ff;
				if ((vector_ram[pc+1] & 0x400) != 0)
					dx = -dx;
				sf = op;
				vz = vector_ram[pc+1] >> 12;
				if (dx == 0 && dy == 0 && vz == 15)
					game.addShot(vx, vy);
				if (op == 6 && vz == 12 && dx != 0 && dy != 0)
				{
					switch (shipdetect)
					{
					case 0:
						v1x = dx;
						v1y = dy;
						++shipdetect;
						break;
					case 1:
						game.ship_present = true;
						game.ship_x = vx;
						game.ship_y = vy;
						game.ship_dx = v1x - dx;
						game.ship_dy = v1y - dy;
						int dir = 0;
						int testV = Math.abs(game.ship_dx);
						for (int xv:DIR_VAL)
						{
							if (xv == testV) break;
							dir++;
						}
						if (game.ship_dx<0 && game.ship_dy>0) dir = 64-dir;
						else
						if (game.ship_dx<0 && game.ship_dy<=0) dir += 32;
						else
						if (game.ship_dx>=0 && game.ship_dy<0) dir = 32-dir;
						game.ship_dir = dir;
						++shipdetect;
						break;
					}
				}
				else if (shipdetect == 1)
					shipdetect = 0;

				break;
			}
			if (op <= 0xa)
				++pc;
			if (op != 0xe) // JMPL
				++pc;
		}   
		return game;

	}


	public void run() 
	{
		byte prevframe = 0;
		int t = 0;

		do
		{
			++t;         // Zeit
			++keyspaket.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
			send();
			receive();

			if (framepaket.frameno != ++prevframe || framepaket.ping != framepaket.ping)
			{
				System.out.println("Latenz "+ (keyspaket.ping - framepaket.ping) +", "+(framepaket.frameno - prevframe)+" Frames verloren.");
				prevframe = framepaket.frameno;
			}

			GameStatus game = InterpretScreen();
			if (game.ship_present)
			{
				for (VecObject v : game.asteroids)
				{
					v.relocate(game.ship_x, game.ship_y);
				}
				for (VecObject v : game.shots)
				{
					v.relocate(game.ship_x, game.ship_y);
				}
			}
			
				 
			
			game2 = game1;
			game1 = game0;
			game0 = game;
			if (AsteroidMain.DIAG)
			  {
				gameHist.add(game0);
				if (gameHist.size()>20000) gameHist.remove();
			  };
			
			if (game1 != null && game1.saucer_present && game0.saucer_present)
			{
				game0.ufo.relocate(game0.ship_x, game0.ship_y);
				game0.ufo.setVorgaenger(game1.ufo);
			}
			
			if (game2 != null)
				{	
					kalkBewegungsvektoren();
					markAsteroidWhoWillBeHit();
				};

			if (display != null)
			{
				if (gameDiag != null) 
					{ 
					display.setGamestatus(gameDiag);
					}
					else{
						display.setGamestatus(game);
					}
			};
			keyspaket.clear();   // alle Tasten loslassen

			int min_dist = 0x7fffffff;
			Rectangle shipRect = new Rectangle(-18, -18,36,36);
			
			if (game.ship_present)
			{
				VecObject feuerziel = null;
				
				if (game1 != null && game1.feuerziel != null && game1.feuerziel.isAsteroid() && game1.feuerziel.willKollide)
				{
					Asteroid altesFeuerziel = (Asteroid) game1.feuerziel;
					if ( !altesFeuerziel.getWillBeHit() )
					{
						for (Asteroid e: game0.asteroids)
						{
							if (e.oid == altesFeuerziel.oid)
							{
								feuerziel = e;
								berechneVorhalteZiel(feuerziel);
								break;
							}
							
							
						}
					}
				}
				
				
				for (Asteroid a: game.asteroids) {
					if (!a.getWillBeHit()) {
						{
								a.willKollide = (a
										.willKollideWithInFrames(shipRect) > 0);
							if (a.willKollide) {
								// nchstgelegenen Asteroiden suchen
								int dx = a.x;
								int dy = a.y;
								a.distanz = dx * dx + dy * dy; // Quadrat des Abstands zu diesem Asteroiden
								switch (a.sf) { // Abstand um den ungefhren Radius des Asteroiden korrigieren
								case 0: // groer Asteroid
									a.distanz -= 40 * 40;
									break;
								case 15: // mittlerer Asteroid
									a.distanz -= 20 * 20;
									break;
								case 14: // kleiner Asteroid
									a.distanz -= 8 * 8;
									break;
								}

								if (a.distanz < min_dist)
									min_dist = a.distanz;

								Point p = berechneVorhalteZiel(a);
								if (p!= null) {
									int zDir = berechneRichtungFuer(p);
									int frames = Math.abs(game.ship_dir - zDir);
									if (frames > 32)
										frames -= 32;
									a.neededFrames = frames;
									if (a.distanz < MAXIMALE_FD_Q) {
										if (feuerziel == null) {
											feuerziel = a;
										} else {
											if ((a.distanz + (a.neededFrames * 8)) < (feuerziel.distanz + (feuerziel.neededFrames * 8))) {
												feuerziel = a;
											}

										}
									}
								}
							}
						}
					}
				}
				
				if (game.saucer_present)
				{
					Ufo ufo = game.ufo;
					int dx = ufo.x; 
					int dy = ufo.y;
					ufo.distanz = dx*dx+dy*dy;
					switch (ufo.size)
					{	// Abstand um den ungefhren Radius des UFOs korrigieren
					case 15: // groes UFO
						ufo.distanz -= 20*12;
						break;
					case 14: // kleines UFO
						ufo.distanz -= 10*6;
						break;
					}
					
					Point p = berechneVorhalteZiel(ufo);	
					if (p == null)
					{
						p = new Point(ufo.x, ufo.y);
						ufo.vorhalteziel = p;
					}
					
					
						int zDir = berechneRichtungFuer(p);
						int frames = Math.abs(game.ship_dir - zDir);
						if (frames > 32)
							frames -= 32;
						ufo.neededFrames = frames;
						if (ufo.distanz < MAXIMALE_FD_Q) {
							if (feuerziel == null) {
								feuerziel = ufo;
							} else if (ufo.distanz < feuerziel.distanz) {
								feuerziel = ufo;
							}
						}
				}

				
				if (feuerziel == null )
				{
					for (Asteroid a: game.asteroids)
					{   

					// nchstgelegenen Asteroiden suchen
					int dx = a.x;
					int dy = a.y;
					a.distanz = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
					switch (a.sf)
					{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
						case 0:  // groer Asteroid
							a.distanz -= 40*40;
							break;
						case 15: // mittlerer Asteroid
							a.distanz -= 20*20;
							break;
						case 14: // kleiner Asteroid
							a.distanz -= 8*8;
							break;
					}
					Point p = berechneVorhalteZiel(a);	
					if (p!= null) {
					int zDir = berechneRichtungFuer(p);
					int frames = Math.abs(game.ship_dir - zDir);
					if (frames > 32) frames -= 32;
					a.neededFrames = frames;
					if (((a.sf == 14) || (a.distanz > 500)) && a.distanz<MAXIMALE_FD_Q)
					{
					if (feuerziel == null)
					{
						feuerziel = a;
					} else
					{
					if ((a.distanz + (a.neededFrames * 8)) < (feuerziel.distanz + (feuerziel.neededFrames * 8)))
					{
						feuerziel = a;
					}
					}
					}}}
				}
				
				int nDir = game.ship_dir;
				
				// Schiff in Richtung auf das nchstgelegene Objekt drehen
				// mathematisch wird hier das Kreuzprodukt aus den Vektoren 
				// ship_dx/y/0 und min_dx/y/0 berechnet
				if (feuerziel != null)
				{
				if (feuerziel.vorhalteziel == null)
					berechneVorhalteZiel(feuerziel);
				Point p = feuerziel.vorhalteziel;
				int zDir =  berechneRichtungFuer(p);
				
				int min_dx = p.x ;
				int min_dy = p.y ;
				
				
				if (zDir != game.ship_dir)
					{
						if (game.ship_dx * min_dy - game.ship_dy * min_dx > 0)
							{ keyspaket.left(true);
							  nDir -= 1;
							  if (nDir < 0) nDir = 63;
								
							}
						
					else
					{ keyspaket.right(true);
					nDir += 1;
					if (nDir > 63) nDir = 0;
					}
					}};
				
				
				
				for (Shot s:game.shots)
				{
					if (s.q > 3)
					{
						int frames = s.willKollideWithInFrames(shipRect);
					s.willKollide = ( frames > 0);
					if (s.willKollide && frames < 20)
					{
						keyspaket.hyperspace(true);
					}
					}
				}
				
				if (min_dist < 27*27)  // Flucht, wenn Kollision unausweichlich
					keyspaket.hyperspace(true);

				if (display != null)
				{
					if (gameDiag != null) 
						{ 
						display.setGamestatus(gameDiag);
						}
						else{
							game.feuerziel = feuerziel;
							display.setGamestatus(game);
						}
				};				

				boolean wha = (willHitAnything(nDir));
				
				if (	   (wha || feuerziel != null) 
						&& (!lastfire) 
						&& (((feuerziel != null && feuerziel == game.ufo && feuerziel.neededFrames < 2)
								|| (feuerziel != null && feuerziel.willKollide && feuerziel.neededFrames < 5 && feuerziel.distanz < 600)) || wha))  // Feuerknopf drcken, so schnell es geht
				{
					keyspaket.fire(true);
					lastfire = true;
				} else lastfire = false;
			}
		} while (true);
	}
	
	private int berechneRichtungFuer(Point p)
	{
		Point dPoint = new Point(p.x, p.y);
		double px = (double) Math.abs(dPoint.x);
		double py = (double) Math.abs(dPoint.y);
		double w;
		if (py == 0.0)
		{
			w = 1;
		} else
		{
			w = Math.atan(px/py);
		};
		
		double min_dist=Math.abs(W_VAL[0]-w);
		int dir=0;
		for (double tv:W_VAL)
		{
			double dist = Math.abs(tv-w);
			if (dist<min_dist)
			{
				min_dist= dist;
			}
			if (dist>min_dist)
				break;
			dir++;
		}
		dir -= 1;
		if (dPoint.x<0 && dPoint.y>0) dir = 64-dir;
		else
		if (dPoint.x<0 && dPoint.y<=0) dir += 32;
		else
		if (dPoint.x>=0 && dPoint.y<0) dir = 32-dir;
		
		return dir;
		
	}
	
	
	
	private Point berechneVorhalteZiel(VecObject o)
	{
		if (o.oid == 0)
			return null;
		
		int frame = 0;
		
		double rdy = o.dy;
		rdy = rdy / o.q;
		double rdx = o.dx;
		rdx = rdx / o.q;

		double v = 7.97; // Durchschnittgeschwindigkeit der Schsse
		double a,b,c;
		
		a = ( rdx*rdx + rdy*rdy - v*v);
		b = 2 * ( rdx*o.x + rdy*o.y );
		c = (o.x*o.x +o.y*o.y);
		
		double f1 = ((-1 * b + Math.sqrt( (b*b)-4*a*c ))) / (2*a);
		double f2 = ((-1 * b - Math.sqrt( (b*b)-4*a*c ))) / (2*a);
		
		frame = (int) ( Math.max(f1, f2) + 0.7);
		

		if ( frame <= 0 )
			return null;
		
		o.vorhalteziel = new Point((int) Math.round( frame * rdx + o.x   ),(int) Math.round( frame * rdy + o.y ));
		return o.vorhalteziel;
	}
	
	
	private double velocity(int frame, double dx0, int x0, int x1, double dy0, int y0, int y1)
	{
		return (Math.sqrt( Math.pow( frame * dx0 + x0 - x1 , 2) + Math.pow(frame * dy0 +y0 - y1, 2)) / frame);
	}
	
	
	
	private void kalkBewegungsvektoren()
	{
		for (VecObject a:game0.asteroids)
		{
			a.findeVorgaenger(new ArrayList<VecObject>(game1.asteroids),new ArrayList<VecObject>(game2.asteroids));
		}
		
		if (game2.shots.size()>0)
		{
		for (VecObject a:game0.shots)
		{
			a.findeVorgaenger(new ArrayList<VecObject>(game1.shots),new ArrayList<VecObject>(game2.shots));
		}
		}
		if (game2.saucer_present && game1.saucer_present && game0.saucer_present)
		{
			ArrayList<VecObject> vu2 = new ArrayList<VecObject>();
			ArrayList<VecObject> vu1 = new ArrayList<VecObject>();
			vu2.add(game2.ufo);
			vu1.add(game1.ufo);
			game0.ufo.findeVorgaenger(vu1,vu2);
		}
		
		
		
	}
	
	
	
	private void send()
	{
		byte[] ba = keyspaket.toByteArray();
		DatagramPacket packet = new DatagramPacket( ba, ba.length, serverAdress, 1979);
		try {
			socket.send( packet );	
		} catch (IOException e)
		{
			System.out.println("Fehler beim Senden :"+e.getLocalizedMessage());
		}
	}
	
	
	private void receive() {
		DatagramPacket packet = new DatagramPacket(
				new byte[FramePacket.LENGTH], FramePacket.LENGTH);
		try {
			int read = 0;
			do
			{
			socket.receive(packet);
			read += packet.getLength();
			framepaket.setFromBuffer(packet.getData());
			} while (read < FramePacket.LENGTH);
			
			
		} catch (IOException e) {
			System.out.println("Fehler beim Empfangen :"
					+ e.getLocalizedMessage());
		}

	}
	
	
	public void displayFirst()
	{
		if (gameHist.size()>0)
		{
			gameDiag = gameHist.getFirst();
		    display.setGamestatus(gameDiag);
		}
	}
	
	public void displayLast()
	{
		if (gameHist.size()>0)
		{
			gameDiag = null;
			display.setGamestatus(game0);
		}
	}
	
	public void displayPrev(boolean fast)
	{
		int inc = fast?10:1;
		if (gameDiag == null) gameDiag = game0;
		int idx = gameHist.indexOf(gameDiag) - inc;
		if (idx>=0)
		{
			gameDiag = gameHist.get(idx);
			display.setGamestatus(gameDiag);
		}
	}

	public void displayNext(boolean fast)
	{
		int inc = fast?10:1;
		if (gameDiag == null) return;
		int idx = gameHist.indexOf(gameDiag) + inc;
		if (idx<gameHist.size())
		{
			gameDiag = gameHist.get(idx);
			display.setGamestatus(gameDiag);
		}
	}
	
	
	public void markAsteroidWhoWillBeHit()
	{
		for (Shot s: game0.shots )
		{
			s.willHit = false;
			if (s.oid>0 && (s.dx!=0 || s.dy!=0))
			{
				
				double rdy = s.dy;
				rdy = rdy / s.q;
				double rdx = s.dx;
				rdx = rdx / s.q;
				for (int sf = 1; sf < 80; sf ++)
				{
					Point sp = new Point((int) Math.round( sf * rdx + s.x   ),(int) Math.round( sf * rdy + s.y ));
					for (Asteroid a : game0.asteroids)
					{
						if (a.oid>0)
						{
						double ardy = a.dy;
						ardy = ardy / a.q;
						double ardx = a.dx;
						ardx = ardx / a.q;
						Point ap = new Point((int) Math.round( sf * ardx + a.x   ),(int) Math.round( sf * ardy + a.y ));
						if ((ap.distance(sp)) <= a.radius)
							{
								a.willBeHit();
								s.willHit = true;
								break;
							}
						
						}
						
					}
				 if ( s.willHit ) break;	
				}
			}
		}
	}
	
	
	protected boolean willHitAnything(int nDir)
	{
		
		double rdy;
		double rdx;
		if (nDir < 16)
		{
			rdx = DIR_VAL[nDir];
			rdy = DIR_VAL[16-nDir];
			
		} else if (nDir < 32)
		{
			rdx = DIR_VAL[32-nDir];
			rdy = DIR_VAL[nDir-16] * -1;
		} else if (nDir < 48)
		{
			rdx = DIR_VAL[nDir-32] * -1;
			rdy = DIR_VAL[48-nDir] * -1;
		} else
		{
			rdx = DIR_VAL[64-nDir] * -1;
			rdy = DIR_VAL[nDir-48];
		}
		
		double sfak1 = Math.sqrt(rdx*rdx+rdy*rdy) / 7.85; // langsamer schuss
		double sfak2 = Math.sqrt(rdx*rdx+rdy*rdy) / 8.00; // schneller schuss
		
		double rdy1 = rdy / sfak1;
		double rdx1 = rdx / sfak1;
		double rdy2 = rdy / sfak2;
		double rdx2 = rdx / sfak2;

		for (int sf = 1; sf < 80; sf ++)
		{
			Point sp1 = new Point((int) Math.round( sf * rdx1 ),(int) Math.round( sf * rdy1 ));
			Point sp2 = new Point((int) Math.round( sf * rdx2 ),(int) Math.round( sf * rdy2 ));
			for (Asteroid a : game0.asteroids)
			{
				if (a.oid>0 && !a.getWillBeHit() && (a.sf == 14 || a.distanz > 500))
				{
				double ardy = a.dy;
				ardy = ardy / a.q;
				double ardx = a.dx;
				ardx = ardx / a.q;
				Point ap = new Point((int) Math.round( sf * ardx + a.x   ),(int) Math.round( sf * ardy + a.y ));
				if (((ap.distance(sp1)) < a.radius) || ((ap.distance(sp2)) < a.radius))
					{
						return true;
					}
				
				}
			}
		}
		return false;
	}
	
	
	public void repaintDisplay()
	{
		display.repaint();
	}
	
	
	
	
}
