/*
 * Decompiled with CFR 0.152.
 */
package Asteroid;

import Asteroid.Asteroid;
import Asteroid.GameStatus;
import Asteroid.Shot;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class FramepaketDisplay
extends JFrame {
    private static final long serialVersionUID = 1L;
    GameStatus gamestatus;
    static int SCALE = 2;
    static int SIZEX = 1024 / SCALE;
    static int SIZEY = 1024 / SCALE;
    static boolean zeigeAsteroiden = true;
    static boolean zeigeSchuesse = true;
    static boolean zeigeTexte = true;
    static boolean zeigeGitter = true;

    void showDisplay() {
        this.setTitle("Asteroid-Player Diagnostics");
        this.setResizable(false);
        this.setSize(518, 544);
        this.setVisible(true);
    }

    public FramepaketDisplay() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                FramepaketDisplay.this.dispose();
                System.exit(0);
            }
        });
    }

    public void setGamestatus(GameStatus gamestatus) {
        this.gamestatus = gamestatus;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        Insets insts = this.getInsets();
        int iOriginX = insts.left;
        int iOriginY = insts.top;
        if (this.gamestatus != null) {
            g.clearRect(iOriginX, iOriginY, SIZEX, SIZEY);
            if (zeigeGitter) {
                g.setColor(Color.green);
                int x = 100;
                while (x < 1000) {
                    g.drawString("X:" + Integer.toString(x), x / SCALE, SIZEY);
                    g.drawLine(x / SCALE, SIZEY - 30, x / SCALE, 0);
                    x += 100;
                }
                int y = 100;
                while (y < 1000) {
                    g.drawString("Y:" + Integer.toString(y), 10, SIZEY - y / SCALE);
                    g.drawLine(30, SIZEY - y / SCALE, SIZEX, SIZEY - y / SCALE);
                    y += 100;
                }
            }
            if (zeigeAsteroiden) {
                for (Asteroid a : this.gamestatus.asteroids) {
                    a.drawOn(g);
                }
            }
            if (zeigeSchuesse) {
                for (Shot s : this.gamestatus.shots) {
                    s.drawOn(g);
                }
            }
            if (this.gamestatus.ship_present) {
                g.setColor(Color.black);
                Rectangle shipRect = new Rectangle(this.gamestatus.ship_x - 18, this.gamestatus.ship_y - 18, 36, 36);
                g.drawRect(shipRect.x / SCALE, SIZEY - (shipRect.y + shipRect.height) / SCALE, shipRect.width / SCALE, shipRect.height / SCALE);
                g.drawLine(this.gamestatus.ship_x / SCALE, SIZEY - this.gamestatus.ship_y / SCALE, (this.gamestatus.ship_dx + this.gamestatus.ship_x) / SCALE, SIZEY - (this.gamestatus.ship_y + this.gamestatus.ship_dy) / SCALE);
                if (zeigeTexte) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("(").append(Integer.toString(this.gamestatus.ship_x)).append(",").append(Integer.toString(this.gamestatus.ship_y)).append(") - [").append(Integer.toString(this.gamestatus.ship_dx)).append(",").append(Integer.toString(this.gamestatus.ship_dy)).append("] Dir=").append(Integer.toString(this.gamestatus.ship_dir));
                    g.drawString(sb.toString(), this.gamestatus.ship_x / SCALE, SIZEY - this.gamestatus.ship_y / SCALE);
                }
                if (this.gamestatus.feuerziel != null) {
                    this.gamestatus.feuerziel.drawAsTargetOn(g);
                }
            }
            if (this.gamestatus.saucer_present) {
                this.gamestatus.ufo.drawOn(g);
            }
        }
    }
}

