#! /usr/bin/env ruby

require 'socket'
require 'pp'
# require 'fcntl'

#IP   = "asteroids.heise.de"
#IP   = "t2"
#IP   = '127.0.0.1'
#PORT = 1979
#PORT = 1962



# ./mameaster -window -contrast 1.5 -brightness 1.1 -skip_gameinfo
# todo: fxaplay.rb t36000 6150
# - messung: fehlschuesse, Schussnutzung, mittl. Schusslebensdauer
# - shotdir umkehren bei LEAVE
# - tryshot bei coll: auch randschuesse
# + versch modi ECONOMY,WASTING
# - grosse tgts bevorzugen
# + neue ast ungenaue geschw.
# + fire wenn shotdir==0
# - schnelle tgts bevorzugen
# - ufo jagd nicht am rand
# - ast-ansammlungen anfahren, wiele einzel, weniger grosse
# - locking geschichte
# - :COLL alle untersuchen gas, wenn drehwkl zu untersch.
# + check nur typ als return, rest als attrib
# + schuss verfolgung, 
# + ship speed mit beschleunig.
# + sortieren nach klasse u. drehwkl
# + :LEAVE umdrehen wenn distLot > 500
# + bewegung genauer
# + lock zeit verlaengern
# + bsearch geht evtl. nicht bei COLL und dr = neg u. pos 
# + ufo shot timeout bei richtungswechsel
# + bessere mittelung der speed
# + lock target, vermeidet toggeln
# + neue gew. fuer entf.
# + sortierung nach trefferzeitp. 
# + keine sonderschuesse wenn coll droht
# + shotdir: spezial fuer collision
# + enge COMEUPS bevorz.
# + shotdir ohne 2 extra frames
# + debugflg. global
# + shottimeout, shotcount radius-einschr.
# + nohunt auch fuer fire, nur wenn nohunt sinnvoll
# * shotdir bei collision evtl richtungsumkehr
# + drehzeit in shotdir beruecksichtigen
# + schiff bewegen (neben asteroid)
# - freie raeume suchen
# + ufo aus totem winkel anfahren , nicht noetig
# + kp,ip,dxwrap
# + asteroids sofort verfuegbar, ohne speed
# + schiessen auf nearest(falls < min), sonst ufo
# + collision, hit, nearest in einer loop + ufo
#

$debug=false
SHOT_SPEED     = 8.0 # pix pro frame
SHOT_LIFETIME  = 69
WGHT_NONE = 4000
WGHT_NORM = 3000
WGHT_COLL2= 2000
WGHT_UFO  = 1500
WGHT_COLL = 1000

KEY_HYPERSPACE = 1
KEY_FIRE       = 2
KEY_THRUST     = 4
KEY_RIGHT      = 8
KEY_LEFT       = 0x10
KEY_START      = 0x20
#schuss verz: 1 aber  ship + 19 pix
#drehverz:    1  22 fr/90
#
#
H              = 768
H2             = H/2
W              = 1024
W2             = W/2
def key2s(key)
  s=""
  s+="L "          if 0!=key&KEY_LEFT      
  s+="R "          if 0!=key&KEY_RIGHT     
  s+="FIRE "       if 0!=key&KEY_FIRE      
  s+="HYPERSPACE " if 0!=key&KEY_HYPERSPACE
  s+="THRUST "     if 0!=key&KEY_THRUST    
  s+="START "      if 0!=key&KEY_START
  s
end
require "vector2.so"
class Array
  #def mul(f)      [  self[0]*f             ,   self[1]*f             ]   end
  #def norm(f=1)f/=abs();[self[0]*f        ,   self[1]*f             ]   end
  #def sub(a2)     [  self[0]-a2[0]         ,   self[1]-a2[1]         ]   end
  #def add(a2)     [  self[0]+a2[0]         ,   self[1]+a2[1]         ]   end
  #def addmul(a2,f)[  self[0]+a2[0]*f       ,   self[1]+a2[1]*f       ]   end
  #def submul(a2,f)[  self[0]-a2[0]*f       ,   self[1]-a2[1]*f       ]   end
  def submod(a2)  [ (self[0]-a2[0]+W2)%W-W2,  (self[1]-a2[1]+H2)%H-H2]   end
  #def addmod(a2)  [ (self[0]+a2[0]+W2)%W-W2,  (self[1]+a2[1]+H2)%H-H2]   end
  #def sub!(a2)       self[0]-=a2[0]        ;   self[1]-=a2[1]      ;self end
  #def add!(a2)       self[0]+=a2[0]        ;   self[1]+=a2[1]      ;self end
  #def div!(f)        self[0]/=f            ;   self[1]/=f          ;self end
  #def mul!(f)        self[0]*=f            ;   self[1]*=f          ;self end
  #def ip(a2)         self[0]*a2[0]         +   self[1]*a2[1]             end
  #def kp(a2)         self[0]*a2[1]         -   self[1]*a2[0]             end
  #def abs()  Math.sqrt(self[0]*self[0]+self[1]*self[1])               end
  ##def toPol() [self.abs,Math.atan2(self[1],self[0])*180/Math::PI%360] end
  #def ang360() Math.atan2(self[1],self[0])*180/Math::PI%360 end
  def subAng(a2) ((Math.atan2(self[1],self[0]) - Math.atan2(a2[1],a2[0]))*
      180/Math::PI+180) % 360 - 180 
  end
  # rechtwinkliger vektor in uhrz richtg, laenge l
  #def rot90()    [  self[1]*1.0 ,   -self[0]*1.0   ]         end
  def lot(tog) #self=gerade g, tog=punkt->gerade
    f=(tog[1]*self[0]-tog[0]*self[1])/(self[0]*self[0]+self[1]*self[1]).to_f
    [-self[1]*f,self[0]*f]
  end
##    def lotAbst(tog)
##      (tog[1]*self[0]-tog[0]*self[1])/Math.sqrt(self[0]*self[0]+self[1]*self[1])
##    end

  def inSqare?(r)    self[0].abs <= r and self[1].abs <= r               end
  
  def to_s(fmt=nil)
    return "[%#{fmt}.2f,%#{fmt}.2f]"%self if self.length==2 and self[0].is_a? Float
    return "[%#{fmt}d,%#{fmt}d]"%self if self.length==2 and self[0].is_a? Fixnum
    inspect
  end
end

class SlideMean
  def initialize(size)
    @size = size
    @pos  = @lpos = 0
  end
  def push(x,y)
    if ! @arrX
      @arrX=Array.new(@size,x)
      @arrY=Array.new(@size,y)
    end
    @lpos       = @pos
    @arrX[@pos] = x
    @arrY[@pos] = y
    @pos        = (@pos+1) % @size
  end
  def firstlast
    yield @arrX[@pos], @arrY[@pos], @arrX[@lpos], @arrY[@lpos]  if @arrX
  end
  def each
    return if !@arrX
    p=@pos
    n=((@lpos-@pos) % @size + 1)
    n.times{|i|
      yield @arrX[p], @arrY[p]
      p  = (p+1) % @size
    }
  end
end

#############################################################################
class Ship
  ###########################################################################
  ROTPARS=[  # delta 3.5 - 4.9  seg=20pix->r=232pix
    # rot  shipdir-xy     shotofs-xy    shotdir-xy
[  0,  1536,    0,     19,    0,  7.875,0.000], #    8,    0
[  1,  1536,    0,     19,    1,  7.875,0.500], #    8,    0
[  2,  1528,  152,     19,    2,  7.875,1.125], #    8,    1
[  3,  1504,  296,     19,    4,  7.750,1.750], #    8,    2
[  4,  1472,  440,     19,    5,  7.625,2.250], #    7,    2
[  5,  1472,  440,     18,    7,  7.375,2.875], #    7,    3
[  6,  1416,  584,     17,    8,  7.125,3.375], #    7,    3
[  7,  1360,  720,     17,    9,  6.875,3.875], #    7,    4
[  8,  1280,  856,     16,   10,  6.625,4.375], #    7,    5
[  9,  1280,  856,     15,   12,  6.250,4.875], #    6,    5
[ 10,  1192,  976,     14,   13,  5.875,5.250], #    6,    5
[ 11,  1088, 1088,     13,   14,  5.500,5.750], #    6,    6
[ 12,   976, 1192,     12,   15,  5.000,6.125], #    5,    6
[ 13,   976, 1192,     11,   16,  4.500,6.500], #    4,    6
[ 14,   856, 1280,     10,   16,  4.000,6.750], #    4,    7
[ 15,   720, 1360,      8,   17,  3.500,7.000], #    4,    7
[ 16,   584, 1416,      7,   18,  3.000,7.250], #    3,    7
[ 17,   584, 1416,      6,   18,  2.500,7.500], #    2,    8
[ 18,   440, 1472,      4,   19,  1.875,7.625], #    2,    7
[ 19,   296, 1504,      3,   19,  1.375,7.750], #    1,    8
[ 20,   152, 1528,      1,   19,  0.750,7.875], #    1,    8
[ 21,   152, 1528,      0,   19,  0.125,7.875], #    0,    8
[ 22,  -152, 1528,     -1,   19,  -0.375,7.875], #   -1,    8
[ 23,  -296, 1504,     -3,   19,  -1.000,7.875], #   -1,    8
[ 24,  -296, 1504,     -5,   19,  -1.625,7.750], #   -1,    8
[ 25,  -440, 1472,     -6,   19,  -2.125,7.625], #   -2,    7
[ 26,  -584, 1416,     -7,   18,  -2.750,7.500], #   -3,    8
[ 27,  -720, 1360,     -9,   18,  -3.250,7.250], #   -3,    7
[ 28,  -720, 1360,    -10,   17,  -3.750,7.000], #   -4,    7
[ 29,  -856, 1280,    -11,   16,  -4.250,6.625], #   -4,    7
[ 30,  -976, 1192,    -12,   15,  -4.750,6.375], #   -5,    7
[ 31, -1088, 1088,    -14,   15,  -5.250,6.000], #   -5,    6
[ 32, -1088, 1088,    -15,   14,  -5.625,5.625], #   -5,    5
[ 33, -1192,  976,    -15,   12,  -6.000,5.125], #   -6,    5
[ 34, -1280,  856,    -16,   11,  -6.375,4.750], #   -7,    5
[ 35, -1360,  720,    -17,   10,  -6.750,4.250], #   -7,    4
[ 36, -1360,  720,    -18,    9,  -7.000,3.750], #   -7,    4
[ 37, -1416,  584,    -19,    7,  -7.250,3.125], #   -7,    3
[ 38, -1472,  440,    -19,    6,  -7.500,2.625], #   -8,    3
[ 39, -1504,  296,    -20,    5,  -7.625,2.125], #   -7,    2
[ 40, -1504,  296,    -20,    3,  -7.875,1.500], #   -8,    2
[ 41, -1528,  152,    -20,    2,  -7.875,1.000], #   -8,    1
[ 42, -1536,    0,    -20,    0,  -8.000,0.375], #   -8,    1
[ 43, -1536,    0,    -20,   -1,  -8.000,-0.250], #   -8,    0
[ 44, -1528, -152,    -20,   -2,  -7.875,-0.750], #   -8,   -1
[ 45, -1528, -152,    -20,   -4,  -7.875,-1.375], #   -8,   -1
[ 46, -1504, -296,    -20,   -5,  -7.750,-2.000], #   -8,   -2
[ 47, -1472, -440,    -20,   -7,  -7.625,-2.500], #   -7,   -2
[ 48, -1416, -584,    -19,   -8,  -7.375,-3.125], #   -7,   -3
[ 49, -1416, -584,    -18,  -10,  -7.125,-3.625], #   -7,   -3
[ 50, -1360, -720,    -18,  -11,  -6.875,-4.125], #   -7,   -4
[ 51, -1280, -856,    -17,  -12,  -6.500,-4.625], #   -6,   -5
[ 52, -1192, -976,    -16,  -13,  -6.125,-5.125], #   -6,   -5
[ 53, -1192, -976,    -15,  -14,  -5.750,-5.500], #   -6,   -6
[ 54, -1088,-1088,    -14,  -15,  -5.375,-5.875], #   -5,   -6
[ 55,  -976,-1192,    -13,  -16,  -4.875,-6.250], #   -5,   -6
[ 56,  -856,-1280,    -12,  -17,  -4.500,-6.625], #   -4,   -7
[ 57,  -856,-1280,    -10,  -18,  -4.000,-7.000], #   -4,   -7
[ 58,  -720,-1360,     -9,  -19,  -3.375,-7.250], #   -3,   -7
[ 59,  -584,-1416,     -8,  -19,  -2.875,-7.375], #   -3,   -7
[ 60,  -440,-1472,     -6,  -20,  -2.375,-7.625], #   -3,   -7
[ 61,  -440,-1472,     -5,  -20,  -1.750,-7.750], #   -2,   -8
[ 62,  -296,-1504,     -4,  -20,  -1.250,-7.875], #   -1,   -8
[ 63,  -152,-1528,     -2,  -20,  -0.625,-8.000], #   -1,   -8
[ 64,     0,-1536,      0,  -20,  0.000,-8.000], #    0,   -8
[ 65,   152,-1528,      1,  -20,  0.500,-8.000], #    0,   -8
[ 66,   296,-1504,      2,  -20,  1.125,-7.875], #    1,   -8
[ 67,   440,-1472,      4,  -20,  1.750,-7.750], #    2,   -8
[ 68,   440,-1472,      5,  -20,  2.250,-7.625], #    2,   -7
[ 69,   584,-1416,      7,  -19,  2.875,-7.375], #    3,   -7
[ 70,   720,-1360,      8,  -19,  3.375,-7.250], #    3,   -7
[ 71,   856,-1280,      9,  -18,  3.875,-7.000], #    4,   -7
[ 72,   856,-1280,     10,  -17,  4.375,-6.625], #    5,   -7
[ 73,   976,-1192,     12,  -16,  4.875,-6.250], #    5,   -6
[ 74,  1088,-1088,     13,  -15,  5.250,-5.875], #    5,   -6
[ 75,  1192, -976,     14,  -14,  5.750,-5.500], #    6,   -6
[ 76,  1192, -976,     15,  -13,  6.125,-5.125], #    6,   -5
[ 77,  1280, -856,     16,  -12,  6.500,-4.625], #    6,   -5
[ 78,  1360, -720,     16,  -11,  6.750,-4.125], #    7,   -4
[ 79,  1416, -584,     17,  -10,  7.000,-3.625], #    7,   -3
[ 80,  1416, -584,     18,   -8,  7.250,-3.125], #    7,   -3
[ 81,  1472, -440,     18,   -7,  7.500,-2.500], #    8,   -2
[ 82,  1504, -296,     19,   -5,  7.625,-2.000], #    7,   -2
[ 83,  1528, -152,     19,   -4,  7.750,-1.375], #    8,   -1
[ 84,  1528, -152,     19,   -2,  7.875,-0.750], #    8,   -1
[ 85,  1536,    0,     19,   -1,  7.875,-0.250], #    8,    0
[ 86,  1536,    0,     19,    0,  7.875,0.375], #    8,    1
[ 87,  1528,  152,     19,    2,  7.875,1.000], #    8,    1
[ 88,  1504,  296,     19,    3,  7.750,1.500], #    8,    2
[ 89,  1504,  296,     19,    5,  7.625,2.125], #    7,    2
[ 90,  1472,  440,     18,    6,  7.500,2.625], #    8,    3
[ 91,  1416,  584,     18,    7,  7.250,3.125], #    7,    3
[ 92,  1360,  720,     17,    9,  7.000,3.750], #    7,    4
[ 93,  1360,  720,     16,   10,  6.625,4.250], #    7,    4
[ 94,  1280,  856,     15,   11,  6.375,4.750], #    7,    5
[ 95,  1192,  976,     15,   12,  6.000,5.125], #    6,    5
[ 96,  1088, 1088,     14,   14,  5.625,5.625], #    5,    5
[ 97,  1088, 1088,     12,   15,  5.125,6.000], #    5,    6
[ 98,   976, 1192,     11,   15,  4.750,6.375], #    5,    7
[ 99,   856, 1280,     10,   16,  4.250,6.625], #    4,    7
[100,   720, 1360,      9,   17,  3.750,7.000], #    4,    7
[101,   720, 1360,      7,   18,  3.125,7.250], #    3,    7
[102,   584, 1416,      6,   18,  2.625,7.500], #    3,    8
[103,   440, 1472,      5,   19,  2.125,7.625], #    2,    7
[104,   296, 1504,      3,   19,  1.500,7.750], #    2,    8
[105,   296, 1504,      2,   19,  1.000,7.875], #    1,    8
[106,   152, 1528,      0,   19,  0.375,7.875], #    1,    8
[107,  -152, 1528,     -1,   19,  -0.250,7.875], #    0,    8
[108,  -152, 1528,     -2,   19,  -0.750,7.875], #   -1,    8
[109,  -296, 1504,     -4,   19,  -1.375,7.750], #   -1,    8
[110,  -440, 1472,     -5,   19,  -2.000,7.625], #   -2,    7
[111,  -584, 1416,     -7,   18,  -2.500,7.500], #   -2,    8
[112,  -584, 1416,     -8,   18,  -3.125,7.250], #   -3,    7
[113,  -720, 1360,    -10,   17,  -3.625,7.000], #   -3,    7
[114,  -856, 1280,    -11,   16,  -4.125,6.750], #   -4,    7
[115,  -976, 1192,    -12,   16,  -4.625,6.500], #   -5,    6
[116,  -976, 1192,    -13,   15,  -5.125,6.125], #   -5,    6
[117, -1088, 1088,    -14,   14,  -5.500,5.750], #   -6,    6
[118, -1192,  976,    -15,   13,  -5.875,5.250], #   -6,    5
[119, -1280,  856,    -16,   12,  -6.250,4.875], #   -6,    5
[120, -1280,  856,    -17,   10,  -6.625,4.375], #   -7,    5
[121, -1360,  720,    -18,    9,  -7.000,3.875], #   -7,    4
[122, -1416,  584,    -19,    8,  -7.250,3.375], #   -7,    3
[123, -1472,  440,    -19,    7,  -7.375,2.875], #   -7,    3
[124, -1472,  440,    -20,    5,  -7.625,2.250], #   -7,    2
[125, -1504,  296,    -20,    4,  -7.750,1.750], #   -8,    2
[126, -1528,  152,    -20,    2,  -7.875,1.125], #   -8,    1
[127, -1536,    0,    -20,    1,  -8.000,0.500], #   -8,    0
[128, -1536,    0,    -20,    0,  -8.000,0.000], #   -8,    0
[129, -1536,    0,    -20,   -2,  -8.000,-0.625], #   -8,   -1
[130, -1528, -152,    -20,   -4,  -7.875,-1.250], #   -8,   -1
[131, -1504, -296,    -20,   -5,  -7.750,-1.750], #   -8,   -2
[132, -1472, -440,    -20,   -6,  -7.625,-2.375], #   -7,   -3
[133, -1472, -440,    -19,   -8,  -7.375,-2.875], #   -7,   -3
[134, -1416, -584,    -19,   -9,  -7.250,-3.375], #   -7,   -3
[135, -1360, -720,    -18,  -10,  -7.000,-4.000], #   -7,   -4
[136, -1280, -856,    -17,  -12,  -6.625,-4.500], #   -7,   -4
[137, -1280, -856,    -16,  -13,  -6.250,-4.875], #   -6,   -5
[138, -1192, -976,    -15,  -14,  -5.875,-5.375], #   -6,   -5
[139, -1088,-1088,    -14,  -15,  -5.500,-5.750], #   -6,   -6
[140,  -976,-1192,    -13,  -16,  -5.125,-6.125], #   -5,   -6
[141,  -976,-1192,    -12,  -17,  -4.625,-6.500], #   -5,   -6
[142,  -856,-1280,    -11,  -18,  -4.125,-6.875], #   -4,   -7
[143,  -720,-1360,    -10,  -18,  -3.625,-7.125], #   -3,   -7
[144,  -584,-1416,     -8,  -19,  -3.125,-7.375], #   -3,   -7
[145,  -584,-1416,     -7,  -20,  -2.500,-7.625], #   -2,   -7
[146,  -440,-1472,     -5,  -20,  -2.000,-7.750], #   -2,   -8
[147,  -296,-1504,     -4,  -20,  -1.375,-7.875], #   -1,   -8
[148,  -152,-1528,     -2,  -20,  -0.750,-7.875], #   -1,   -8
[149,  -152,-1528,     -1,  -20,  -0.250,-8.000], #    0,   -8
[150,   152,-1528,      0,  -20,  0.375,-8.000], #    1,   -8
[151,   296,-1504,      2,  -20,  1.000,-7.875], #    1,   -8
[152,   296,-1504,      3,  -20,  1.500,-7.875], #    2,   -8
[153,   440,-1472,      5,  -20,  2.125,-7.625], #    2,   -7
[154,   584,-1416,      6,  -19,  2.625,-7.500], #    3,   -8
[155,   720,-1360,      7,  -19,  3.125,-7.250], #    3,   -7
[156,   720,-1360,      9,  -18,  3.750,-7.000], #    4,   -7
[157,   856,-1280,     10,  -17,  4.250,-6.750], #    4,   -7
[158,   976,-1192,     11,  -16,  4.750,-6.375], #    5,   -7
[159,  1088,-1088,     12,  -15,  5.125,-6.000], #    5,   -6
[160,  1088,-1088,     14,  -15,  5.625,-5.625], #    5,   -5
[161,  1192, -976,     15,  -14,  6.000,-5.250], #    6,   -5
[162,  1280, -856,     15,  -12,  6.375,-4.750], #    7,   -5
[163,  1360, -720,     16,  -11,  6.625,-4.250], #    7,   -4
[164,  1360, -720,     17,  -10,  7.000,-3.750], #    7,   -4
[165,  1416, -584,     18,   -9,  7.250,-3.250], #    7,   -3
[166,  1472, -440,     18,   -7,  7.500,-2.750], #    8,   -3
[167,  1504, -296,     19,   -6,  7.625,-2.125], #    7,   -2
[168,  1504, -296,     19,   -5,  7.750,-1.625], #    8,   -1
[169,  1528, -152,     19,   -3,  7.875,-1.000], #    8,   -1
[170,  1536,    0,     19,   -1,  7.875,-0.375], #    8,   -1
[171,  1536,    0,     19,    0,  7.875,0.125], #    8,    0
[172,  1528,  152,     19,    1,  7.875,0.750], #    8,    1
[173,  1528,  152,     19,    3,  7.750,1.375], #    8,    1
[174,  1504,  296,     19,    4,  7.625,1.875], #    7,    2
[175,  1472,  440,     18,    6,  7.500,2.500], #    8,    2
[176,  1416,  584,     18,    7,  7.250,3.000], #    7,    3
[177,  1416,  584,     17,    8,  7.000,3.500], #    7,    4
[178,  1360,  720,     16,   10,  6.750,4.000], #    7,    4
[179,  1280,  856,     16,   11,  6.500,4.500], #    6,    4
[180,  1192,  976,     15,   12,  6.125,5.000], #    6,    5
[181,  1192,  976,     14,   13,  5.750,5.500], #    6,    6
[182,  1088, 1088,     13,   14,  5.250,5.875], #    5,    6
[183,   976, 1192,     12,   15,  4.875,6.250], #    5,    6
[184,   856, 1280,     10,   16,  4.375,6.625], #    5,    7
[185,   856, 1280,      9,   17,  3.875,6.875], #    4,    7
[186,   720, 1360,      8,   17,  3.375,7.125], #    3,    7
[187,   584, 1416,      7,   18,  2.875,7.375], #    3,    7
[188,   440, 1472,      5,   19,  2.250,7.625], #    2,    7
[189,   440, 1472,      4,   19,  1.750,7.750], #    2,    8
[190,   296, 1504,      2,   19,  1.125,7.875], #    1,    8
[191,   152, 1528,      1,   19,  0.500,7.875], #    0,    8
[192,     0, 1536,      0,   19,  0.000,7.875], #    0,    8
[193,  -152, 1528,     -2,   19,  -0.625,7.875], #   -1,    8
[194,  -296, 1504,     -4,   19,  -1.250,7.875], #   -1,    8
[195,  -440, 1472,     -5,   19,  -1.750,7.750], #   -2,    8
[196,  -440, 1472,     -6,   19,  -2.375,7.625], #   -3,    7
[197,  -584, 1416,     -8,   18,  -2.875,7.375], #   -3,    7
[198,  -720, 1360,     -9,   17,  -3.375,7.125], #   -3,    7
[199,  -856, 1280,    -10,   17,  -4.000,6.875], #   -4,    7
[200,  -856, 1280,    -12,   16,  -4.500,6.625], #   -4,    7
[201,  -976, 1192,    -13,   15,  -4.875,6.250], #   -5,    6
[202, -1088, 1088,    -14,   14,  -5.375,5.875], #   -5,    6
[203, -1192,  976,    -15,   13,  -5.750,5.500], #   -6,    6
[204, -1192,  976,    -16,   12,  -6.125,5.000], #   -6,    5
[205, -1280,  856,    -17,   11,  -6.500,4.500], #   -6,    4
[206, -1360,  720,    -18,   10,  -6.875,4.000], #   -7,    4
[207, -1416,  584,    -18,    8,  -7.125,3.500], #   -7,    4
[208, -1416,  584,    -19,    7,  -7.375,3.000], #   -7,    3
[209, -1472,  440,    -20,    6,  -7.625,2.500], #   -7,    2
[210, -1504,  296,    -20,    4,  -7.750,1.875], #   -8,    2
[211, -1528,  152,    -20,    3,  -7.875,1.375], #   -8,    1
[212, -1528,  152,    -20,    1,  -7.875,0.750], #   -8,    1
[213, -1536,    0,    -20,    0,  -8.000,0.125], #   -8,    0
[214, -1536,    0,    -20,   -1,  -8.000,-0.375], #   -8,   -1
[215, -1528, -152,    -20,   -3,  -7.875,-1.000], #   -8,   -1
[216, -1504, -296,    -20,   -5,  -7.875,-1.625], #   -8,   -1
[217, -1504, -296,    -20,   -6,  -7.625,-2.125], #   -7,   -2
[218, -1472, -440,    -19,   -7,  -7.500,-2.750], #   -8,   -3
[219, -1416, -584,    -19,   -9,  -7.250,-3.250], #   -7,   -3
[220, -1360, -720,    -18,  -10,  -7.000,-3.750], #   -7,   -4
[221, -1360, -720,    -17,  -11,  -6.750,-4.250], #   -7,   -4
[222, -1280, -856,    -16,  -12,  -6.375,-4.750], #   -7,   -5
[223, -1192, -976,    -15,  -14,  -6.000,-5.250], #   -6,   -5
[224, -1088,-1088,    -15,  -15,  -5.625,-5.625], #   -5,   -5
[225, -1088,-1088,    -14,  -15,  -5.250,-6.000], #   -5,   -6
[226,  -976,-1192,    -12,  -16,  -4.750,-6.375], #   -5,   -7
[227,  -856,-1280,    -11,  -17,  -4.250,-6.750], #   -4,   -7
[228,  -720,-1360,    -10,  -18,  -3.750,-7.000], #   -4,   -7
[229,  -720,-1360,     -9,  -19,  -3.250,-7.250], #   -3,   -7
[230,  -584,-1416,     -7,  -19,  -2.750,-7.500], #   -3,   -8
[231,  -440,-1472,     -6,  -20,  -2.125,-7.625], #   -2,   -7
[232,  -296,-1504,     -5,  -20,  -1.625,-7.875], #   -1,   -8
[233,  -296,-1504,     -3,  -20,  -1.000,-7.875], #   -1,   -8
[234,  -152,-1528,     -1,  -20,  -0.375,-8.000], #   -1,   -8
[235,   152,-1528,      0,  -20,  0.125,-8.000], #    0,   -8
[236,   152,-1528,      1,  -20,  0.750,-7.875], #    1,   -8
[237,   296,-1504,      3,  -20,  1.375,-7.875], #    1,   -8
[238,   440,-1472,      4,  -20,  1.875,-7.750], #    2,   -8
[239,   584,-1416,      6,  -20,  2.500,-7.625], #    2,   -7
[240,   584,-1416,      7,  -19,  3.000,-7.375], #    3,   -7
[241,   720,-1360,      8,  -18,  3.500,-7.125], #    4,   -7
[242,   856,-1280,     10,  -18,  4.000,-6.875], #    4,   -7
[243,   976,-1192,     11,  -17,  4.500,-6.500], #    4,   -6
[244,   976,-1192,     12,  -16,  5.000,-6.125], #    5,   -6
[245,  1088,-1088,     13,  -15,  5.500,-5.750], #    6,   -6
[246,  1192, -976,     14,  -14,  5.875,-5.375], #    6,   -5
[247,  1280, -856,     15,  -13,  6.250,-4.875], #    6,   -5
[248,  1280, -856,     16,  -12,  6.625,-4.500], #    7,   -4
[249,  1360, -720,     17,  -10,  6.875,-4.000], #    7,   -4
[250,  1416, -584,     17,   -9,  7.125,-3.375], #    7,   -3
[251,  1472, -440,     18,   -8,  7.375,-2.875], #    7,   -3
[252,  1472, -440,     19,   -6,  7.625,-2.375], #    7,   -3
[253,  1504, -296,     19,   -5,  7.750,-1.750], #    8,   -2
[254,  1528, -152,     19,   -4,  7.875,-1.250], #    8,   -1
[255,  1536,    0,     19,   -2,  7.875,-0.625], #    8,   -1
]

  SHIPROT = ROTPARS.map{|line| line[1,2]}
  SHOTPAR = ROTPARS.map{|line| [line[3,2],line[5,2]]}
  SHOTDEG = ROTPARS.map{|line| line[5,2].ang360()}
  DEG2ROT = []
  degi=0
  lastdeg=0
  lastj=0
  SHOTDEG.each_with_index{|deg,j|
    mid=((lastdeg + (deg-lastdeg)%360/2)%360).to_i
    while degi != mid
      #pp [degi,mid]
      DEG2ROT[degi]||=[]
      DEG2ROT[degi]<<lastj
      degi+=1
      degi%=360
    end
    lastdeg,lastj=deg,j
  }
  (degi..359).each{|i|DEG2ROT[i]<<lastj}
  DEG2ROT<<DEG2ROT[0]
  #pp DEG2ROT
  SIGLEN=5
  @@dirstr=SHIPROT.map{|xy| "%5d,%5d " % xy}.join
  @@dirstr+=@@dirstr[0,(SIGLEN-1)*12]

  def initialize(frame)
    @vxy       = [0,0]
    @vtab      = SlideMean.new(9)
    @rot       = nil #128
    @rotCalib  = {}
    @last2keys = nil
    @lastspeed = [0,0]
  end

  # nur fuer load/save  rot(), setRot()
  def rot()    @rotCalib.nil? ? @rot : 1000  end
  def setRot(rot) # Ship
    if rot != 1000
      @rot=rot
      @rotCalib=nil
    end
  end

  def calibrated?() @rotCalib.nil? end # Ship
  def pos()    @xy            end #aktuelle pos
  def speed()  @vxy           end # Ship
  def dir()    @dxy           end # Ship
  def shotParN1(dr) # Ship drehpos im frame n+1 ohne ship-speed 
    SHOTPAR[(@nextrot+dr) % 256]
  end
  def driveTo(keys,sollPos,maxSpd,turnAllow,limit)    
    if limit #ufos und demnaechst neue asts 
      sollPos    = sollPos.dup
      sollPos[0] = 200 if sollPos[0]<200 #TUNE
      sollPos[1] = 200 if sollPos[1]<200
      sollPos[0] = 824 if sollPos[0]>824
      sollPos[1] = 568 if sollPos[1]>568
    end
    #dirsoll = limit ? sollPos.sub(@xy) : sollPos.submod(@xy)    
    dirsoll = sollPos.submod(@xy)    
    #puts  "sollPos=#{sollPos}"
    vsoll   = dirsoll.norm([maxSpd,dirsoll.abs/50].min.to_f) #TUNE
    #dv      = turnAllow ? vsoll.sub(@vxy) : @vxy.mul(-1)
    dv      = vsoll.sub(@vxy)
    dang    = dv.subAng(@dxy)
    puts "driveTo dang=#{dang} dv=#{dv} vsoll=#{vsoll} maxSpd=#{maxSpd}" if $debug
    keys    = dang < 0 ? KEY_RIGHT : KEY_LEFT if turnAllow
    if dang.abs < 45 #TUNE
      #puts "gas"
      keys|= KEY_THRUST
    end
    return keys
  end
  def calcTurn1(deg) # Ship rot-ofs ab naechstem frame
    rots=DEG2ROT[deg] or raise "missing data for #{deg}"
    rot_new=rots[1]
    if @nextrot > rot_new+42
      rot_new = @nextrot > (rots[2] + 42) ? rots[0] : rots[2]
    elsif @nextrot < rot_new-42
      rot_new = @nextrot < (rots[0] - 42) ? rots[2] : rots[0]
    end
    #puts "  calcTurn(deg=#{deg},@rot=#{@rot} rot_new=#{rot_new})"
    (rot_new-@nextrot+128) % 256-128
  end
  def inspect # Ship
    "[Ship xy=#{@xy} vxy=#{@vxy} dxy=#{@dxy}] rot=#{rot}"
  end
  alias to_s inspect
  #def rotIdx() @rotCalib ? nil : @rot end
  def originator?(shotXy) # Ship
    dxy   = shotXy.submod(@xy)
    if @rotCalib
      puts "WARN bad shotguess" if $opt_v>=1
      d   = dxy.abs
      if d > 18.5 and d<21.5 #TUNE
        return  dxy.mul!(SHOT_SPEED/d).add!(@lastspeed)
      end
    else
      #puts "originator? shotXy=#{shotXy} @rot=#{@rot} dxy-ist=#{dxy} dxy0#{SHOTPAR[@rot][0]}"
      if SHOTPAR[@lastrot][0] == dxy
        return SHOTPAR[@lastrot][1].add(@lastspeed)
      end
      #puts "dxy#{dxy} SHOTPAR[@lastrot][0]#{SHOTPAR[@lastrot][0]}"
      ddxy = dxy.sub(SHOTPAR[@lastrot][0])
      vsht = SHOTPAR[@lastrot][1].add(@lastspeed)
      if ddxy.inSqare?(3) #TUNE
        return vsht
      end
      if (ddxy.sub(vsht)).inSqare?(3) #TUNE
        return vsht
      else
        #puts "wrong shot pos #{ddxy} speed=#{@vxy}"
        return nil #SHOTPAR[@rot][1].add(speed)
      end
    end
    return nil
  end
  def update(raw,frame,lastkeys) # Ship
    #xyl      = @xy
    @xy,dxy = raw
    @dxy=dxy.norm(SHOT_SPEED)
dup
    @lastkeys=lastkeys
    @lastrot=@rot
    if @last2keys
      @rot += 1 if (@last2keys&KEY_LEFT)  != 0
      @rot -= 1 if (@last2keys&KEY_RIGHT) != 0
      @rot = @rot % 256
    end
    if @rotCalib
      if @rotCalib.length==0
	@rot =@@dirstr.index("%5d,%5d " % dxy,12*SIGLEN) /12#erste naeherung
	puts "first rot: #{@rot}" if $opt_v>=1
      end
      #puts "rotCalib #{@rot} #{lastkeys} #{dxy}"
      @rotCalib[@rot] = dxy
      if @rotCalib.length > 2
	ks=@rotCalib.keys.sort
	sig=ks.map{|rot| "%5d,%5d " % @rotCalib[rot]}.join
	if pos =@@dirstr.index(sig) 
	  pos2=@@dirstr.index(sig,pos+1)
	  #  or  raise "pos not found \n#{sig} in \n#{@@dirstr}"
	  # and raise "pos found twice #{pos},#{pos2} #{sig} in #{@@dirstr}"
	  if !pos2 or pos2 >= 12*256
	    lastrot=@rot
	    @rot = (@rot + pos/12 - ks.first)%256
	    puts "rot calib #{@rotCalib.length} #{lastrot} -> #{@rot}" if $opt_v>=1
	    @rotCalib = nil
	  elsif @rotCalib.length >= SIGLEN
	    raise "rot calib sig not uniq #{sig} #{pos} #{pos2}"
	  end
	else
	  if @rotCalib.length >= SIGLEN
	    puts "rot calib pos not found \n#{sig}, restarting" if $opt_v>=1
	    @rotCalib={@rot,dxy}
	  end
	end
      end
    else
      if SHIPROT[@rot] != dxy 
	puts "bad rot #{@rot} #{SHIPROT[@rot]} == #{dxy}" if $opt_v>=1
	jj=nil
	(1..4).each{|j|
	  if SHIPROT[(@rot+j)% 256] == dxy
	    jj=j
	    break
	  elsif SHIPROT[(@rot-j)% 256] == dxy
	    jj=-j
	    break
	  end
	}
	if jj
	  @rot=(@rot+jj)% 256
	else
	  raise "bad rot"
	end
      end
    end

    #@vVirt.add!(@dxy.norm(0.065)) if @last2keys&KEY_THRUST
    @last2keys = @lastkeys
    @nextrot  = @rot
    @nextrot += 1 if (@lastkeys&KEY_LEFT)  != 0
    @nextrot -= 1 if (@lastkeys&KEY_RIGHT) != 0
    @nextrot %= 256
   
    # @@dirs << @dxy.dup
    # @dxy.mul!(SHOT_SPEED/@dxy.abs)
    # @dxy.norm!(SHOT_SPEED)
    @vtab.push(frame,[@xy,(@lastkeys&KEY_THRUST)  != 0 ? @dxy.norm(0.055) : nil])
    @lastspeed = @vxy
    @vtab.firstlast{|f0,y0,fn,yn|
      df=(fn-f0) % 256
      #pp [f0,y0,fn,yn,df,yn[0].submod(y0[0]),@vtab] if $debug
      if df!= 0
        @vxy = yn[0].submod(y0[0]).div!(df.to_f)  
        #print "ship @vxy=#{@vxy}" if $debug
        @vtab.each{|fp,yp|
          break if fn==fp
          @vxy.add!(yp[1].mul((fp-f0) % 256 / df.to_f )) if yp[1]
        }
        #puts " korr @vxy=#{@vxy}" if $debug
      end
    }
  end
end
#############################################################################
class Shot
  ###########################################################################
  # @@starts=[]
  attr_reader :typ,:vxy
  def initialize(raw,ship,ufo,frame,target)
    @xy0    = @xy     = raw
    @frame0 = @frame  = frame
    @target = target
    @vxy    = nil #[0,0]
    @typ    = nil
    @lifecnt= 0
    # @orig   = nil
    @cmt    = ""
    if ship
      if @vxy = ship.originator?(@xy)
        @typ  = :SHIP
        # @orig = ship
      end
    end
    if ! @typ
      @typ = :UFO
    end
  end
  def update(raw,frame) # Shot
    @cmt    = ""
    # df      = (frame-@frame) % 256
    # df!=0 or raise
    @lifecnt+=1
    # @vxy    = raw.submod(@xy).div!(df.to_f) if @typ != :SHIP
    @xy     = raw
    @frame  = frame

    df = (@frame-@frame0) % 256
    @vxy=@xy.submod(@xy0).div!(df) if @typ != :SHIP
    #puts "@xy=#{@xy} @xy0=#{@xy0} df=#{df} @vxy=#{@vxy}"
    if df == 8 and @typ == :SHIP
      @cmt = @target.verify(@xy,@vxy) if @target
    end
  end
  def emergency?(ship) # Shot
    return false if @typ==:SHIP
    dxy=ship.pos.submod(@xy)
    if @vxy
      dvxy=@vxy.sub(ship.speed)
      if dxy.ip(dvxy) < 0 #leave
        @cmt    = "leave"
        return false 
      end
      if (r=dxy.kp(dvxy).abs/dvxy.abs) > 20 #TUNE
        @cmt    = "nocoll r#{r}>20"
        return false 
      end
      if dxy.abs/dvxy.abs > 4 #TUNE
        @cmt    = "coll r#{r}"
        return :COLL 
      end
      @cmt    = "emergency r=#{r}"
      return :SHOT
    else
      if (d=dxy.abs) < (4*8)
        @cmt    = "emergency d=#{d}"
        return :SHOT
      end
    end
    return false
  end
  def fit?(raw,frame) # Shot
    xy = raw
    df   = (frame-@frame)&0xff
    if @vxy #from ship
      xy_ = @xy.addmul(@vxy,df)
      ret = (db=xy_.submod(xy).abs/df) < 2 #TUNE
      #puts "fit? xy_#{xy_} ret#{ret} df#{df}"

      if ! ret and db < 5 #TUNE
        puts "large fit #{self.inspect}\n  raw=#{raw.inspect} xy_=#{xy_.inspect} df=#{df} db=#{db} #{ret} #{@lifecnt}" if $opt_v>=1
        ret=true
      end
    else
      ret = (@xy.submod(xy).abs-10*df).abs < 1 #TUNE
    end
    ret
  end
  def inspect # Shot
    vxy=@vxy ? "%4.1f,%4.1f" % @vxy : "?"
    "Shot-#{@typ} xy=#{@xy} vxy=#{vxy} lc=#{@lifecnt} #{@target ? @target.to_ss : "?"} #{@cmt}"
  end
  alias to_s inspect
end

#require "dirs.rb" #ueberschreibt Shot::update im learn mode

#############################################################################
class Target
  ###########################################################################
  #NOWEIGHT=3000
  attr_reader   :r,:size
  attr_reader   :tShot,:dr,:rTreff,:shotKeys
  attr_reader   :dist,:collTyp,:colldt,:rColl
  attr_accessor :sort, :sortWght
#  def saveSolution
#    [ @tShot,@dr,@rTreff,@shotKeys,@distxy,@dist,@collTyp,@colldt,@rColl,@collhit ]
#  end
#  def loadSolution(sol)
#    @tShot,@dr,@rTreff,@shotKeys,@distxy,@dist,@collTyp,@colldt,@rColl,@collhit=sol
#  end
#  def betterAsSolution(sol) #true wenn aktuelle lsg besser
#    return false if !@dr
#    return true  if !sol[1]
#    (@tShot+@dr.abs) <  (sol[0]+sol[1].abs)
#  end
  def initialize(raw,frame) # Target
    @xy            = raw[0,2]
    @scale,@typ    = raw[2],raw[3]
    @f0            = frame
    @vxy           = [0,0]
    @xy0           = @xy
    @collhit       = ""
    @lifeCnt       = 0
    @shotcnt       = 0
    @shotTmo       = 0
    @lastShotTme   = 0
    @sort          = 0
    @sortWght      = WGHT_NONE
    @maxShotsE      = 0
    @maxShotsW      = 0
    @lockTmo       = 0
    @lockWght      = WGHT_NONE
  end
  def maxShots
    $astPlayer.mode==:WASTING ? @maxShotsW : @maxShotsE
  end

  def verify(sxy,svxy)
    dv=svxy.sub(@vxy)
    dx=@xy.submod(sxy)
    r=dx.kp(dv)/dv.abs
    #puts "verify shot miss r=#{r}"
    if r.abs > @r*0.95 #TUNE
      puts "verify shot miss r=#{r}" if $opt_v>=1
      @shotcnt       = 0
      return "shot miss #{r}"
    end
    if (lt=dx.abs/dv.abs) > SHOT_LIFETIME
      return "shot lifetime #{lt}"
    end
    return "shot ok #{r}"
  end
  def sortWght
    @lockTmo > 0 ? @lockWght : @sortWght
  end
  def hitTime
    @dr ? @dr.abs + @tShot : 200 #TUNE
  end
  def hitTime2
    @dr ? @dr.abs*0.7 + @tShot : 200 #TUNE
  end
  def setSortWght2(base)
    @sortWght = base + hitTime2 #+ @r #kleine ast bevorz.
  end
  def lock
    if @sortWght <= @lockWght #immer wieder aufziehen
      @lockWght = @sortWght
    end
    @lockTmo  = @dr.abs+2 #TUNE
  end
  def addCmt(cmt) # Target
    @collhit+=cmt
  end
  def fit?(raw,frame) # Target
    x,y,scale,typ = raw
    return false if typ != @typ ||  scale != @scale 
    b=@xy.add(@vxy).submod([x,y]).abs
    if @vxy != [0,0]
      ret = b <= 2
      return ret
    else
      ret = b <= 5
      return ret
    end
  end
  def pos();   @xy  end #[@x,@y] end # Target
  def speed(); @vxy end # Target
  def speedB();@vxy.abs end # Target
  def to_snears()
    to_ss+" wght#{@sortWght.to_i} lckwght#{@lockWght.to_i} tmo#{@lockTmo} dr=#{dr} tShot=#{@tShot} rTreff=#{@rTreff.to_i}"
  end
  def inspect # Target
    sprintf "%2d xy=#{@xy.to_s(4)} v=#{@vxy.to_s(4)} l=%3d/%3d s%d #%d #{@collhit}",@r,@lifeCnt,@shotTmo,@shotcnt,@sort
  end
  alias to_s inspect
  def check(ship) # Target
    @tryshots={}
    @dist,@collTyp,@colldt,@rColl  = nil
    @rTreff,@tShot,@dr,@shotKeys   = nil

    @dist    = [@distxy.abs.to_i-@r-20,0].max #ohne ast und ship

    if @dvxyAbs == 0
      @collTyp = :PARALEL
      @collhit = "c :PARALEL "
      return 
    end
    ip= @distxy.ip(@dvxy)
    if ip >= 0 #entf 
      if @distxy[0] > W*(8-@dvxy[0])/(8*2) #TUNE
        puts "swap1 x #{@distxy[0]} #{@dvxy[0]}" if $debug
        @distxy[0] -= W
      elsif -@distxy[0] > W*(8+@dvxy[0])/(8*2) #TUNE
        puts "swap2 x #{@distxy[0]} #{@dvxy[0]}" if $debug
        @distxy[0] += W
      end
      if @distxy[1] > H*(8-@dvxy[1])/(8*2) #TUNE
        puts "swap1 y #{@distxy[1]} #{@dvxy[1]}" if $debug
        @distxy[1] -= H
      elsif -@distxy[1] > H*(8+@dvxy[1])/(8*2) #TUNE
        puts "swap2 y #{@distxy[1]} #{@dvxy[1]}" if $debug
        @distxy[1] += H
      end
      @dist    = [@distxy.abs.to_i-@r-20,0].max #ohne ast und ship
      ip= @distxy.ip(@dvxy)
    end
    if ip >= 0 #entf 
      @rColl   =  @distxy.kp(@dvxy)/@dvxyAbs
      @collTyp = :LEAVE
      @collhit =  "c :LEAVE   "
    else # dist u. v-ast gegenlaeufig
      @colldt  = (@dist/@dvxyAbs).to_i
      @rColl   = @distxy.kp(@dvxy)/@dvxyAbs   # a x b = |a| * |b| * sin(alph)
      if @rColl.abs <= @rc
        @collTyp = :COLL
        @collhit = "C1:r%3d dt%3d " %[@rColl.to_i,@colldt]
      else
	if @rColl.abs <= (@rc+80) #TUNE
	  @collTyp = :COLL2
	  @collhit = "c2:r%3d dt%3d " %[@rColl.to_i,@colldt]
	else
	  @collTyp = :COMEUP
	  @collhit = "c3:r%3d dt%3d " %[@rColl.to_i,@colldt]
	end
      end
    end
    #[@dist,@collTyp,@colldt]
  end


  def shotdir(ship) # Target
    puts "shotdir #{self}" if $debug
    if @shotcnt > 0
      if @shotcnt >= maxShots
        @collhit+=  "d:shotcnt>=#{maxShots} "
        puts " >"+@collhit if $debug
        return nil 
      end
      if (@lifeCnt-@lastShotTme)>5 #TUNE
        @collhit+=  "d:to old #{@lifeCnt-@lastShotTme}>5 "
        return nil
      end
    end
    
    dr    = ship.calcTurn1(@distxy.ang360())
    a,b=nil
    rtl_p = rtl_m = tryshot(0,ship).first
    li = 0
    [10,20,30,43].each{|m| #TUNE
      rt_p, = tryshot(m,ship)
      if (rtl_p<0) and (rt_p>=0)
	a,b = li,m 
	break
      end
      rtl_p = rt_p

      rt_m, = tryshot(-m,ship)
      if (rtl_m>=0) and (rt_m<0)
	a,b = -m,-li 
	break
      end
      rtl_m = rt_m
      li=m
    }
    if !a
      @collhit+=  "d:no solution"
      puts  "WARNING no solution" if $opt_v>=1
      return false
    end

    puts "  a=#{a} b=#{b} " if $debug
    while a<b #a=rechts vorbei, b: links vorbei
      m=(a+b)/2
      print "  [#{a},#{b}]" if $debug
      rtreff,ts = tryshot(m,ship)
      if ! ts
        puts "shuss entfernt sich" if $debug
	# return nil
      end
      if rtreff>0 #links vorb
        b = m
      else
        a = m+1
      end
    end
    b2=b-1
    rtreff, ts  = tryshot(b, ship)
    rtreff2,ts2 = tryshot(b2,ship)
    puts "  b=#{b},#{rtreff.to_i},#{ts} b2=#{b2},#{rtreff2.to_i},#{ts2}" if $debug
    if rtreff2.abs < rtreff.abs
      rtreff,ts,b = rtreff2,ts2,b2
    end
    if rtreff.abs < effR() or is_a?(Ufo) #TUNE
      if ! ts
	puts "shuss entfernt sich" if $opt_v>=1
	@collhit+= "d:schuss entf. sich"
        ts = 200 #TUNE
      end
#      if ts > SHOT_LIFETIME trotzdem drehen, + thrust
#	@collhit+= "d:schuss zu weit #{ts}"
#        return false
#      end    
      if  (@collTyp==:COLL or @collTyp==:COLL1) and @colldt<10 #TUNE
        while b != 0
          b2 = b - (b<=>0)
          rtreff2,ts2 = tryshot(b2,ship)
          if rtreff2.abs < effR()*0.9
            puts "shorten from #{b} to #{b2}" if $debug
            rtreff,ts,b = rtreff2,ts2,b2
          else
            break
          end
        end
      end

      ret = dr2cmd(b)
      @rTreff,@tShot,@dr,@shotKeys = rtreff,ts,b,ret
      puts " >"+@collhit+"  rtreff#{rtreff.to_i} ts#{ts}" if $debug
      return b
    end
    @collhit+=  "d:r to large #{rtreff}"
    puts " >"+@collhit if $debug
    return false
  end
  def solve(ship) # Target
    @sort          = 0
    @sortWght      = WGHT_NONE
    if @lockTmo > 0
      @lockTmo-=1
      @lockWght = WGHT_NONE if  @lockTmo==0
    end

    @distxy  = @xy.submod(ship.pos) #vom schiff zum ast
    if @vxy == [0,0]
      @dist    = [@distxy.abs.to_i-@r-20,0].max #ohne ast und ship
      @collTyp = :BADSPEC
      @collhit = "c :BADSPEC "
      return  
    end

    @dvxy    = @vxy.sub(ship.speed) # Vast - Vship 
    @dvxyAbs = @dvxy.abs

    check(ship)   
    shotdir(ship)
=begin
    return if  @collTyp != :LEAVE or (@tShot and @tShot < 68) # TUNE
    #puts "check2"
    sav=saveSolution
    @distxy[0] +=  @distxy[0] > 0 ? -W : W
    check(ship)   
    shotdir(ship)
    if betterAsSolution(sav)
      puts "check2 success" if $debug
      return if @tShot and @tShot < 68 # TUNE
    else
      loadSolution(sav) 
    end

    #puts "check3"
    sav=saveSolution
    @distxy[1] +=  @distxy[1] > 0 ? -H : H
    check(ship)   
    shotdir(ship)
    if  betterAsSolution(sav)
      puts "check3 success" if $debug
    else
      loadSolution(sav) 
    end
=end
  end
  #dr=Anzahl drehsteps, 
  def tryshot(dr,ship) # @distxy,@dvxy
    return @tryshots[dr] if  @tryshots[dr]
    #t1          = [dr.abs,2].max  #+2 #drehung + 2 warten bis fire
    t1          = dr.abs+2  #+2 #drehung + 2 warten bis fire
    shot0,vshot = ship.shotParN1(dr) # ohne ship.speed
    xy          = @distxy.addmul(@dvxy,t1).sub(shot0)
    vs          = vshot.sub(@dvxy) # vshot + ship.speed - @vxy 
    print " tryshot dr#{dr} xy#{xy} vs#{vs}" if $debug
    # return [nil,nil]
    rtreff  = xy.kp(vs)/vs.abs    #trefferradiaus, neg=rechts vorbei
    ts = nil
    if xy.ip(vs) > 0 #schuss fliegt richtg target
      #ts = ((xy.abs-effR())/vs.abs).to_i #schuss flugzeit
      ts = ((xy.abs-@r)/vs.abs).to_i #schuss flugzeit
    else
      rtreff += rtreff>0 ? 10000 :  -10000  #TUNE
    end
    puts " rtreff#{rtreff.to_i} ts#{ts} shot0#{shot0} vshot#{vshot}" if $debug
    @tryshots[dr]=ret=[rtreff,ts]
    ret
  end
  def dr2cmd(dr)
    if dr > 0
      @collhit+=  "D:left #{dr} "
      return KEY_LEFT  
    end
    if dr < 0
      @collhit+=  "D:right #{dr} "
      return KEY_RIGHT
    end
    @collhit+=  "D:straight #{dr} "
    return 0
  end	
  def effR()
    if $astPlayer.mode==:WASTING
      @r*1.2
    else
      @shotcnt >= 1 ? @r2*0.9 : @r*0.9
    end
  end
  def fire(ship,keys) #Target
    return false if ! ship
    if @shotcnt > 0
      if @shotcnt >= maxShots 
        @collhit+=  "f:#{@shotcnt}>=#{maxShots} "
        return false
      end
      if (@lifeCnt-@lastShotTme)>5 #TUNE
        @collhit+=  "f:to old #{@lifeCnt-@lastShotTme}>5 "
        return false
      end
      if (@shotcnt==1 && (@lifeCnt-@lastShotTme)<3)
        @collhit+=  "f:delay s2 "
        return false
      end
    end
    if !@dr or @dr!=0
      @collhit+="f1: bad dr '#{@dr}'"
      return false
    end
    #if  @tShot/@lifeCnt > (@r-@rTreff.abs) #TUNE
    if  @lifeCnt <= 3 and !((@collTyp==:COLL or @collTyp==:COLL1) and @colldt<10)#TUNE
      @collhit+=  "f:inprecise "
      return false
    end
#    @rTreff,@tShot = tryshot(0,ship)
#    if @rTreff.abs > effR()*0.9 #TUNE
#      @collhit+="f1: @rTreff=#{@rTreff.to_i} > #{effR()}"
#      return false
#    end
    if ! @tShot or @tShot > SHOT_LIFETIME #TUNE
      @collhit+="f2: tShot=#{@tShot.to_i} > #{SHOT_LIFETIME}"
      return false
    end

    @collhit+="F:SHOOT rTreff=#{@rTreff.to_i} #{@shotcnt},#{maxShots}"
    @shotcnt +=1
    @shotTmo     = @lifeCnt + @tShot + 4  if @shotcnt==1 #TUNE
    @lastShotTme = @lifeCnt
    return true
  end
end
#############################################################################
class Ufo < Target
  ###########################################################################
  def initialize(raw,frame) # Ufo
    super
    @r=case @scale
       when 15; 25
       when 14; 10
       else; raise "unknown typ  #{@typ}"
       end
    @r2=@r
    @maxShots = 2  #TUNE
    @rc=@r+10 #*5     #TUNE
  end
  def to_ss # Target
    "U "
  end
  def inspect
    " Ufo " + super
  end
  alias to_s inspect
  def update(raw,frame) # Ufo
    @lifeCnt   +=  1
    @shotcnt=0 if @lifeCnt >= @shotTmo #fehlschuss
    @xy  = raw[0,2]
    df   = (frame-@f0) & 0xff
    lvxy = @vxy
    #puts "Ufo update  @xy=#{@xy} @xy0=#{@xy0} df=#{df}"
    @vxy = @xy.submod(@xy0).div!(df.to_f) if df!=0
    @shotcnt=0 if lvxy != @vxy
    #if df >10
    # @x0,@y0,@f0 = @x,@y,frame
    @f0  = frame
    @xy0 = @xy
    #end
  end
end
#############################################################################
class Asteroid < Target
  ###########################################################################
  attr_reader   :r,:size
  @@number=0
  #attr_accessor :shotcnt
  def initialize(raw,frame) # Asteroid
    super raw,frame
    @@number = (@@number+1)%100
    @number  =  @@number
    case @scale
    when 0;  @size,@r,@r2,@maxShotsE,@maxShotsW = 2,40,20,4,4 #TUNE
    when 15; @size,@r,@r2,@maxShotsE,@maxShotsW = 1,20,10,3,3
    when 14; @size,@r,@r2,@maxShotsE,@maxShotsW = 0,10,10,1,2 
    else; raise "unknown typ  #{@typ}"
    end
    @rc=@r+10 #*1.5
  end
  def to_ss # Target
    ("A%02d "% @number)
  end
  def inspect
    ("A%02d "% @number) + super
  end
  alias to_s inspect
  def update(raw,frame) #,number) # Asteroid
    @lifeCnt += 1  
    #@shotcnt -= 0.05 if @shotcnt>0

    @shotcnt=0 if @lifeCnt > @shotTmo #fehlschuss

    #puts "update #{raw.inspect}"
    @xy=raw[0,2]#,raw[1]
    # @number=number
    if @f0 and (df = (frame-@f0)&0xff) !=0
      dxy=@xy.submod(@xy0)
      if dxy[0]==0 and dxy[1]==0
        puts "WARNING sme pos" if $opt_v>=1
        #if df==1 or raise "stillstand bei df=#{df} self=#{self} #{raw}"
        @f0=frame
        @xy0=@xy #offensichtl. war einstieg falsch
        return
      end
      @vxy=dxy.div!(df.to_f)
      if df == 30
        @f0=nil
      end
    end
  end
end

#############################################################################
class AstPlayer
  ###########################################################################
  RECLEN=1026+16
  attr_reader :mode
  def initialize(ip=nil,port=1979)#file=nil,skip=nil,cnt=nil) # AstPlayer
    $astPlayer=self
    @ticks=0
    @asteroids = []
    @asteroidsStat = [0,0,0]
    @emergency=[0,0,0,0]

    @shots=[]
    @score=0
    @lifes=0
    @startTime=Time.now
    @dtmax=@dt=0
    @ufos=0
    #return readFile(file,skip,cnt) if file
    return if !ip #readFile(file,skip,cnt) if file
    @sock=UDPSocket.open
    @sock.connect(@ip=ip,port.to_i)
    # @sock.fcntl(Fcntl::F_SETFL, Fcntl::O_NONBLOCK)
    Thread.new{
      while 1
        case gets.chomp
        when /t(\d+)?/
          sleep 2
          puts "file open" if $opt_v>=1
          startTrace( $1 ? $1.to_i : nil )
        when "t1"
          File.open("t1","w"){|fh|fh.write @dat}
        else
          dump
        end
      end
    }
    @statFile=File.open("stat.dat","w") if $opt_t
    startTrace if $opt_t
    run
  end
  def startTrace(limit= 60*60*10)
    @writeCnt = limit
    @fh=File.open("t#{@writeCnt}","w")
  end
  def dump # AstPlayer
    puts "(#{@nFrame}) @ticks=#{@ticks} @dt=#{(@dt*1000).to_i}ms @dtmax=#{(@dtmax*1000).to_i} S:#{@score} R:#{@lifes} T:#{Time.now-@startTime}
"
    pp @ship||"noShip"
    pp @ufo||"noUfo"
    pp @asteroids
    pp @shots
    pp @emergency
    puts "newkeys #{key2s(@keys)}"
  end
  def connectThus
    @sock.send("ctnamethus"+("\0"*28), 0)#, IP, PORT)
    while 1
      while 1
        @sock.send("ctmame\0\0", 0)
        @dat,add = @sock.recvfrom(1026)
        pp "recvfrom #{add} #{@dat[0,10]}"
        case @dat
        when /busy/, /game/
          #while 1
          #  d,add = @sock.recvfrom(1)
          #  @dat+=d
          #  break if d=="\n"
          #end
          puts @dat if $opt_v>=1
          sleep 1
        else
          puts "standardpck" if $opt_v>=1
          #d,add = @sock.recvfrom(1026-4)
          return
        end
      end
    end
  end
  def run # AstPlayer
    connectThus if @ip=~/heise/

    t00=Time.new
    @tbeforesend=t0=0
    @dtmax=0
    @keys=KEY_START #0 # KEY_LEFT
    ndt=0
    lscore    = 0
    meanscore = 0
    slidescore = SlideMean.new(5)      
    lastufos  = 0
    while true
      @ticks    = @ticks + 1
      puts "@#{@ticks}" if @ticks%100==0 and $opt_v>=1
      @lastKeys = @keys
      
      @tbeforesend  = Time.now-t00
      @dt       = @tbeforesend-t0
      puts "@ticks=#{@ticks} dt=#{@dtmax=@dt} " if @dt > @dtmax and $opt_v>=1
      p256=(@ticks&0xff)
      while 1
        @sock.send("ctmame"+@keys.chr+p256.chr, 0)#, IP1111111111111111111, PORT)
        @dat,add = @sock.recvfrom(1026)
        if @dat.length!=1026 
          puts "bad frame len=#{@dat.length} != 1026" if $opt_v>=1
          next
        end
        @ram=@dat.unpack("v512")
        lf=@nFrame
        @nFrame,@rPing=@dat.unpack("x1024CC")
        @nFrame==(lf+1)%256 or puts "frame lost #{@nFrame}==#{(lf+1)}" if lf and $opt_v>=1

        if @writeCnt and @writeCnt>0
          @writeCnt-=1
          @fh.write(@dat)
          @fh.write([@ticks,Time.new-t00,@tbeforesend,@keys,p256,@ship ? @ship.rot : 1000].pack("VffCCv"))
        else
          if @fh
            @fh.close 
            puts "file closed" if $opt_v>=1
            @fh=nil
          end
        end
        puts "bad ping #{@rPing} != #{p256} dt=#{(@dt*1000).to_i}ms @#{@ticks}" if @rPing != p256 and $opt_v>=1
        break 
      end
      t0=Time.new-t00
      
      decodeRam()
      dt=(Time.now-@startTime)
      if dt > ndt and $opt_s
        ds=@score-lscore
	slidescore.push(dt,@score)
	slidescore.firstlast{|xf,yf,xl,yl|
	  dx=xl-xf
	  meanscore = (yl-yf)/dx if dx != 0
	}
        # meanscore=meanscore*0.9+ds*0.1
        @statFile.printf("%6.1f %6d %6d %6d %3d %2d %2d %2d %2d %3d\n",
                         dt,@score,ds,meanscore,@lifes,@asteroids.length,
                         @asteroidsStat[0],@asteroidsStat[1],@asteroidsStat[2],
                         @ufos-lastufos)
        @statFile.flush
        ndt      = dt+1
        lscore   = @score
        lastufos = @ufos
        if dt>=300 #TUNE
          dump 
          exit
        end
      end
      astUpdate
      @keys = 0
      # learn()
      # test()
      alg2()
    end
  end
  def alg2 # AstPlayer
    @sollPos   = [200,300]
    @maxSpeed  = 0#.4
    return false if ! @ship
    shotLimit = 1000
    shotColl  = false
    hunt      = true
    @shots.each{|shot|
      case shot.emergency?(@ship) 
      when :SHOT
        puts "EMERGENCY1 shot=#{shot} #{@ticks}" if $opt_v>=1
	@emergency[1]+=1
        @keys = KEY_HYPERSPACE
        return
      when :COLL
        shotColl   = shot.vxy
	#puts "shot coll"
	# @keys |= KEY_THRUST
      end
    }
    if !@ship.calibrated?
      @keys = KEY_LEFT
      return
    end
    @mode      =  @asteroids.length < 3 ? :WASTING : :ECONOMY
    #@mode      =  :ECONOMY
    @asteroids.each{|ast| 
      ast.solve(@ship)
      case ast.collTyp
      when :BADSPEC
        if ast.dist <= 20 #TUNE
	  @emergency[2]+=1
          @keys = KEY_HYPERSPACE
	  puts "EMERGENCY2 dist=#{ast.dist} #{@ticks}" if $opt_v>=1
          ast.addCmt(" emergency, no colldt? d#{ast.dist}")
          #dump
          return
        end
        #ast.sortWght=dist/5 if dist < 200 #annahme speed 5 pix/tick
      when :COLL
        if ast.colldt<=3 #TUNE
	  @emergency[3]+=1
          @keys = KEY_HYPERSPACE
	  puts "EMERGENCY3 colldt=#{ast.colldt} #{@ticks}" if $opt_v>=1
          ast.addCmt(" emergency")
          return
        end
        if ast.colldt<=50 or (ast.tShot and ast.tShot < 10 ) #TUNE
          ast.setSortWght2(WGHT_COLL)
        else
          ast.setSortWght2(WGHT_NORM)
        end
      #when :COLL2
      when :COLL2
        if ast.colldt<=40 or (ast.tShot and ast.tShot < 10 ) #TUNE
          ast.setSortWght2(WGHT_COLL2)
        else
          ast.setSortWght2(WGHT_NORM)
        end
	#ast.setSortWght2(WGHT_NORM)
      when :COMEUP
        if hunt
          case ast.r
          when 10
            ast.setSortWght2(WGHT_NORM) 
          when 20,40
            ast.setSortWght2(WGHT_NORM) if ast.dist > 100 #TUNE
          end
        end
      when :LEAVE,:PARALEL
        if hunt # and dist<600
          ast.setSortWght2(WGHT_NORM)
        end
      else
	raise "bad typ #{ast.collTyp}"
      end
    }
    nears=@asteroids.dup

    if @asteroids.length==0
      @maxSpeed,x,y = 2,W-230,H-200
      x           =   230   if @ship.pos[0] < W2 #TUNE
      y           =   200   if @ship.pos[1] < H2
      @maxSpeed   = 4 if @ship.pos[0] < 230 or @ship.pos[0] > W-230 or
                         @ship.pos[1] < 200 or @ship.pos[1] > H-200
      @sollPos      = [x,y]
    end
    #pp @sollPos,@ship,diffSoll
    if @ufo 
      @ufo.solve(@ship)
      nears << @ufo 
      @ufo.sortWght   = WGHT_UFO #collision before
    end
    
    nears.sort!{|a,b| a.sortWght<=>b.sortWght }

    hit=false
    nears.each_with_index{|ast,i| ast.sort=i+1
      next if  ! ast.shotKeys
      ast.lock
      @keys |= ast.shotKeys
      hit    = ast
      break
    }
    if ast = hit
      hit.sort=9 
      if ast.collTyp == :COLL
        shotLimit  = ast.dr.abs
        shotColl   = nil
      else
        if ast.collTyp == :COLL2
          shotLimit  = ast.dr.abs
        end
        if shotColl
          ast = hit = nil
          ausw=shotColl.rot90 #rechtw. zu shuss
          ausw.mul!(-1) if ausw.ip(@ship.dir) < 0
          @sollPos = @ship.pos.addmul(ausw,50)
          @maxSpeed  = 3
          puts "shotColl shotColl=#{shotColl} sollPos=#{@sollPos} " if $opt_v>=1
        end
      end
    else
      ast=@ufo or ast=nears.first
    end
    if ast
      if ! ast.tShot or (ast.tShot > 10 and (ast.r>10 or @asteroids.length<10))
        @sollPos   = ast.pos
        puts "sollPos #{@sollPos}" if $debug
        @maxSpeed  = 3 - @asteroids.length*3.0/30 #TUNE
        if ast.is_a?(Ufo)
          @maxSpeed  = 3 
        end
      end
    end

    pp "nears:",nears.map{|n| n.to_snears } if $debug
    nears.each{|ast|
      if  @ownShots<4             and 
          @lastKeys&KEY_FIRE == 0 and 
          (ast.hitTime < shotLimit or ast.collTyp == :COLL or ast.collTyp == :COLL2) and
          ast.fire(@ship,@keys)
        @keys   |= KEY_FIRE     
        @target  = ast
        break
      end
    }
    @keys=@ship.driveTo(@keys,@sollPos,@maxSpeed,!hit,@asteroids.length <= 7) #TUNE
  end



  def test() # AstPlayer
    return if ! @ship
    @ticks0=@ticks if !@ticks0
    case @state
    when nil 
      @cnt=0
      @state = 0
    when 0
      # @keys  = KEY_RIGHT|KEY_THRUST
      @keys  = KEY_THRUST
      puts "KEY_THRUST"
      @cnt+=1
      if @cnt==16
        @state = 1 
        @cnt   = 0
      end
    when 1
      @cnt+=1
      if @cnt%2==1
        puts "KEY_FIRE"
        @keys= KEY_FIRE
      end
      # @state = :POS #if @ship.rotIdx != Ship.shotDirs.index(nil)
      #puts "shotPar1= #{@ship.shotPar1} #{@ship.rot}"
      # @state = 2
    when 2
      @keys= KEY_RIGHT|KEY_THRUST
      @state = 1
    end
  end


  def astUpdate # AstPlayer
    # 1.neue Asteroidenconstellation
    #   1.1 pos merken      -> @astFirst,@astSig
    #
    # 2.alte Asteroidenconstellation
    #   2.1 geschw berechen -> @asteroids
    #   2.n geschw berechen -> @asteroids
    #   
    #
    if @rawAstSig != @astSig
      #puts "sig mismatch"
      @astSig   = @rawAstSig 
      oldast=@asteroids
      @asteroids=[]
      oldi=0
      @rawAst.each{|raw|
        fit=nil
        3.times{|i| j=oldi+i
          if oldast[j] and oldast[j].fit?(raw,@nFrame)
            fit=j
            break
          end
        }
        if fit
          #puts "fit #{fit}"
          @asteroids<< oldast[fit]
          oldast[fit]=nil
          oldi=fit+1
        else
          #puts "fit new"
          @asteroids<< Asteroid.new(raw,@nFrame)
        end
      }
      if oldast.compact.length >2
        puts "WARNING too many misses #{@nFrame} #{oldast.compact.length}" if $opt_v>=1
      end
      #oldast.compact.length <=1 or raise "too many misses #{oldast.inspect} #{@asteroids.inspect} #{@rawAst.inspect} #{@nFrame}"
    end
    @asteroidsStat=[0,0,0]
    @asteroids.each_with_index{|ast1,i| 
      ast1.update(@rawAst[i],@nFrame) #,i)   
      @asteroidsStat[ast1.size]+=1
    }

    if ! @rawUfo
      @ufo=nil
    else
      if ! @ufo
        @ufo = Ufo.new(@rawUfo,@nFrame)
        @ufos+=1
      end
      @ufo.update(@rawUfo,@nFrame) 
    end
    if ! @shipRaw
      @ship = nil
    else
      @ship ||= Ship.new(@nFrame)
      @ship.update(@shipRaw,@nFrame,@lastKeys) 
    end

    @ownShots=0
    oldshots=@shots
    @shots=[]
    oldi=0
    @shotsRaw.each{|raw|
      fit=nil
      3.times{|i| j=oldi+i
        if oldshots[j] and oldshots[j].fit?(raw,@nFrame)
          fit=j
          break
        end
      }
      if fit
        @shots<< oldshots[fit]
        oldshots[fit]=nil
        oldi=fit+1
        @shots.last.update(raw,@nFrame)
      else
        @shots<< Shot.new(raw,@ship,@ufo,@nFrame,@target)
      end
      @ownShots+=1 if @shots.last.typ==:SHIP
    }
 
    if @scoreRaw!=""
      s=@scoreRaw.to_i
      ds=(s - (@lastRaw||0)) % 100000
      @score = ds < 2000 ? @score+ds : 0 
      @lastRaw=s
    end
  end
  def decodeRam() # AstPlayer
    #pp @ram
    @rawAst    = []
    @rawAstSig = ""
    @shotsRaw  = []
    @rawUfo    = nil
    @shipRaw   = nil
    @scoreRaw  = ""
    @lifes     = 0
    
    xabs,yabs,gsf=nil
    shipdetect=0
    ship1x=nil
    ship1y=nil
    pc=1
    while pc<512
      op=@ram[pc]; pc+=1
      case o=(op >> 12)
      when 0xa #labs strahl positionieren
        op2   = @ram[pc]; pc+=1
        yabs  = (op & 0x3ff) - 128
        yabs >=0 and yabs < H or raise "bad abspos #{yabs} %04x" % op
        xabs  = op2 & 0x3ff
        gsf   = (op2 >> 12)
      when 0xb #halt
        return
      when 0xc #jsrl
        case adr=(op & 0xfff)
        when 0x8f3; @rawAst<< [xabs,yabs,gsf,1]; @rawAstSig+=gsf.chr+"1"
        when 0x8ff; @rawAst<< [xabs,yabs,gsf,2]; @rawAstSig+=gsf.chr+"2"
        when 0x90d; @rawAst<< [xabs,yabs,gsf,3]; @rawAstSig+=gsf.chr+"3"
        when 0x91a; @rawAst<< [xabs,yabs,gsf,4]; @rawAstSig+=gsf.chr+"4"
        when 0x929; @rawUfo=[xabs,yabs,gsf,99] #addUfo(xabs,yabs,gsf)    
        when 0x852 #copyright
        when 0xadd; @scoreRaw+="0" if gsf==1 and xabs==100 and yabs==748
        when 0xb2e; @scoreRaw+="1" if gsf==1 and xabs==100 and yabs==748
        when 0xb32; @scoreRaw+="2" if gsf==1 and xabs==100 and yabs==748
        when 0xb3a; @scoreRaw+="3" if gsf==1 and xabs==100 and yabs==748
        when 0xb41; @scoreRaw+="4" if gsf==1 and xabs==100 and yabs==748
        when 0xb48; @scoreRaw+="5" if gsf==1 and xabs==100 and yabs==748
        when 0xb4f; @scoreRaw+="6" if gsf==1 and xabs==100 and yabs==748
        when 0xb56; @scoreRaw+="7" if gsf==1 and xabs==100 and yabs==748
        when 0xb5b; @scoreRaw+="8" if gsf==1 and xabs==100 and yabs==748
        when 0xb63; @scoreRaw+="9" if gsf==1 and xabs==100 and yabs==748
        when 0xa6d; @lifes+=1 # "raumschiff"
        else
          #raise "unknown adr 0x%x"%adr
        end
      when 0xd #rtsl
        raise
        return
      when 0xe #jmpl
        adr  =  op & 0xfff
      when 0xf
      else #vctr
        op2=@ram[pc]; pc+=1
        dy  =  op & 0x3ff; dy=-dy if (op  & 0x400) != 0
        dx  = op2 & 0x3ff; dx=-dx if (op2 & 0x400) != 0
        sf  =   o
        hell= op2 >> 12
        if dx == 0 && dy == 0 && hell == 15
          #addShot(xabs,yabs)
          @shotsRaw<< [xabs,yabs]
        end
        if o == 6 && hell == 12 && dx != 0 && dy != 0
          #puts "ship dx=#{dx} dy=#{dy}" if show
          case shipdetect
          when 0
            ship1x,ship1y=dx,dy
            shipdetect+=1
          when 1
            @shipRaw=[[xabs,yabs],[ship1x-dx,ship1y-dy]]
            #addShip(xabs,yabs,ship1x-dx,ship1y-dy)
            shipdetect+=1
          end
        elsif (shipdetect == 1)
          shipdetect=0
        end
      end
    end
  end
  
end

if __FILE__ == $0
  require 'optparse'
  begin
    $opt_v=0
    $opt_t=false
    $opt_s=false
    if ENV["USER"]=="thus"
      $opt_v=1
      $opt_t=true
      $opt_s=true
    end

    opts=ARGV.options
    prg=File.basename($0)
    opts.banner = "Usage: #{prg} [ipadr=127.0.0.1] [port=1979]"
    opts.summary_width=20
    opts.on("","Options:")
    opts.on("-h","--help", "show this message") {puts opts; exit}
    opts.on("-q",          "be quiet")   {
      $opt_v  = -1
    }
    opts.on("-v[lev]",     "increase (set) verbose level") { |v| 
      $opt_v += 1
      $opt_v  = v.to_i   if v =~ /^+$/
      $opt_v += v.length if v =~ /^v+$/
    }
    opts.parse!
  rescue OptionParser::ParseError => exc
    puts opts,""
    raise
  end  

  AstPlayer.new(ARGV[0] || '127.0.0.1', ARGV[1] || 1979)
end

