// c't Programmierwettbewerb Asteroids Juni 2008
// Maurer Christoph	christoph_m@gmx.net


#ifndef _PLAYER_H_
#define _PLAYER_H_
#pragma comment( lib, "ws2_32.lib" )

#include <winsock2.h>

#define ADDRESS DWORD

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;

class Asteroid
{
public:
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein
	float vx; // Geschwindigkeitsvektor X
	float vy; // Geschwindigkeitsvektor Y
	float destroyed;
	void set(int x, int y, int type, int sf);
};

class Shot
{
public:
	int x;
	int y;

	void set(int x, int y);
};

// TODO: UFO in eine Klasse packen


class DestroyContext
{
public:
	double angle;
	double a,b,t;
	int ship_x,ship_y;
	Asteroid asteroid;
	int ast_i;
	void print_destroy_context(bool draw);
};

class GameStatus
{
public:
	GameStatus(void);
	void clear(void);
	void calc_vec_2frames(void);
	void calc_vec_ufo_2frames(void);
	bool cmp_2frames(void);
	double turn_to_next_target(bool ufo);
	double calc_coliding_angle(int ast_idx);
	void print_asteroids(bool draw);
	void print_shots(bool draw);
	void print_ufo(bool draw);
	void print_ship(bool draw);
	
	void set_ship_angle(float angle);

	int find_min_dist(void);
	
	bool ship_present;  // Schiff sichtbar
	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;
	float ship_angle;

	bool ufo_present;// UFO sichtbar
	int ufo_x;       // Mittelpunkt des UFOs
	int ufo_y;
	int ufo_size;    // Gre: 15 = gro, 14 = klein
	float ufo_vx;
	float ufo_vy;
	int ufo_p; // Przision der Ufo Vektoren

	int ufo_x_old;       // Mittelpunkt des alten UFOs
	int ufo_y_old;
	int ufo_size_old;    // Gre: 15 = gro, 14 = klein
	
	int nasteroids; // Anzahl Asteroiden
	int nasteroids_alt; // Anzahl der alten Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	Asteroid asteroids_alt[MAX_ASTEROIDS]; // Asteroiden des vorigen Frames
	
	double shot_precision;

	DestroyContext dctx;

	int nshots;     // Anzahl Schsse
	int p; // Przisision der Vektoren
	Shot shots[MAX_SHOTS];
	
};

struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip){};
	void Run(bool log);

private:	
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
	SOCKET sd;
	ADDRESS server_ip;
};
const float wbyte[256]={
0.0f,
3.6f,
8.2f,
12.7f, 
16.5f,
21.2f,
25.2f,
29.5f,
33.5f,
37.8f,
41.7f,
46.2f,
50.8f,
55.3f,
59.4f,
63.4f,
67.5f,
71.6f,
76.1f,
79.9f,
84.5f,
89.1f,
92.8f,
97.2f,
101.8f,
105.5f,
110.2f,
114.1f, 
118.1f,
122.8f, 
126.7f,
131.1f,
135.0f, 
139.4f, 
143.3f, 
147.9f, 
151.9f, 
156.6f, 
160.7f, 
164.5f, 
169.2f, 
172.8f, 
177.3f, 
181.9f, 
185.5f, 
189.9f, 
194.5f, 
198.2f, 
203.0f, 
206.9f, 
211.0f, 
215.4f, 
220.0f, 
223.8f, 
227.5f,
232.2f, 
235.9f, 
240.3f, 
245.1f, 
248.8f, 
252.7f, 
257.3f, 
261.1f, 
265.6f, 
270.0f, 
273.6f,
278.2f, 
282.7f, 
286.5f, 
291.2f, 
295.0f, 
299.0f, 
303.5f, 
307.8f, 
311.7f, 
316.2f, 
320.0f,
324.5f, 
328.6f, 
332.7f, 
336.6f, 
341.6f, 
345.3f, 
349.9f, 
354.5f, 
358.1f, 
2.8f, 
7.2f, 
11.0f, 
15.5f,
19.3f,
23.4f,
28.1f,
32.8f,
36.7f,
40.6f,
45.0f,
49.4f,
53.3f,
57.2f,
 61.9f,
 66.6f,
 70.7f,
 74.5f,
 79.0f,
 82.8f,
 87.2f,
 91.9f,
 95.5f,
 100.1f,
 104.7f,
 108.4f,
 113.4f,
 117.3f,
 121.4f,
 125.6f,
 130.0f,
 133.8f,
 138.3f,
 142.2f,
 146.5f,
 151.0f,
 155.0f,
 158.8f,
 163.6f,
 167.3f, 
 171.8f,
 176.6f,
 180.0f,
 184.4f,
 188.9f,
 192.7f,
 197.3f,
 201.2f,
 205.0f,
 209.7f,
 214.2f,
 217.8f,
 222.5f,
 226.2f,
 230.0f,
 234.6f,
 239.0f,
 243.1f,
 247.0f,
 251.8f,
 255.5f,
 260.1f,
 264.5f,
 268.1f,
 272.7f,
 277.2f,
 280.8f,
 285.5f,
 289.3f,
 293.4f,
 298.1f,
 302.2f,
 306.7f,
 310.6f,
 315.0f,
 318.9f,
 323.3f,
 327.2f,
 331.9f,
 335.9f,
 339.8f,
 344.5f,
 348.2f,
 352.8f,
 357.2f,
 0.9f,
 5.5f,
 10.1f,
 13.9f,
 18.4f,
 22.5f,
 26.6f,
 30.6f,
 34.7f,
 39.2f,
 43.8f,
 48.3f,
 52.2f,
 56.5f,
 60.5f,
 64.7f,
 68.8f,
 73.5f,
 77.3f,
 81.8f,
 86.4f,
 90.0f,
 94.5f,
 98.9f,
 102.7f,
107.3f,
111.2f,
115.3f,
120.2f,
124.2f,
127.8f, 
132.5f,
136.1f,
140.8f,
145.3f,
149.8f,
153.9f,
157.9f,
161.8f,
166.3f,
170.1f,
174.3f,
179.1f,
182.9f,
187.2f,
191.5f,
195.6f,
200.3f,
204.1f,
208.1f,
212.1f, 
216.6f,
221.0f,
225.0f,
228.9f,
233.3f,
237.8f,
241.9f,
245.9f,
249.8f,
254.5f,
258.4f,
262.8f,
267.3f,
270.9f,
275.5f,
279.9f,
283.7f,
288.2f,
292.1f,
296.1f,
300.2f,
304.7f,
309.2f,
313.8f,
317.5f,
322.2f,
325.8f,
329.8f,
334.7f,
338.8f,
342.7f,
347.2f,
351.1f,
355.5f};


#endif