package util;

public class IntAvgBuffer {
	
	private int[] buffer;
	private int ptr;
	private int len;
	
	
	public IntAvgBuffer(int size) {
		buffer = new int[size];
		ptr = 0;
		len = 0;
	}
	
	
	public void addElement(int e) {
		buffer[ptr++] = e;
		if(ptr >= buffer.length) ptr = 0;
		if(len < buffer.length) len++;
	}
	
	
	public int size() {
		return len;
	}
	
	
	public float getAverage() {
		if(len == 0) return 0;
		
		int idx = ptr-len;
		if(idx < 0) idx += buffer.length;

		int sum = 0;
		for(int i=0; i<len; i++) {
			sum += buffer[idx++];
			if(idx >= buffer.length) idx = 0;
		}
		
		return (float)sum / (float)len;
	}
}
