package gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

import javax.swing.JScrollPane;

public class BGScrollPane extends JScrollPane {

	private static final long serialVersionUID = 1L;
	
	private Color bgColor;

	public BGScrollPane(Component component) {
		super(component);
		bgColor = Color.WHITE;
	}
	
	public void paint(Graphics g) {
		super.paint(g);
		
		int height = getHeight() - viewport.getView().getHeight() - columnHeader.getHeight() - horizontalScrollBar.getHeight();
		int width = getWidth() - verticalScrollBar.getWidth();
		g.setColor(bgColor);
		g.fillRect(2, getHeight()-height+1, width-4, height-3);
		
	}
	
	public void setBGColor(Color color) {
		bgColor = color;
	}
}
