// KeysPacket.cpp: Implementierung der Klasse KeysPacket.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "stdafx.h"
#include "KeysPacket.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////


KeysPacket::KeysPacket(void)
{

	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}



void KeysPacket::clear(void)
{
	keys = '@';
}


// Zur Ermittlung und Tracking der Drehung
//  1 = drehung links
//  0 = keine drehung
// -1 = drehung rechts
int KeysPacket::drehung(void) {
  if ((keys & KEY_LEFT) == KEY_LEFT) {
    return 1;
  }
  if ((keys & KEY_RIGHT) == KEY_RIGHT) {
    return -1;
  }
  return 0;
}

// Format HLTRFS
void KeysPacket::getKeysAsString(char  keyString[7])
{
  if ((keys & KEY_HYPERSPACE) == KEY_HYPERSPACE) {
    keyString[0] = 'H';
  } else {
    keyString[0] = ' ';
  }
  if ((keys & KEY_LEFT) == KEY_LEFT) {
    keyString[1] = 'L';
  } else {
    keyString[1] = ' ';
  }
  if ((keys & KEY_THRUST) == KEY_THRUST) {
    keyString[2] = 'T';
  } else {
    keyString[2] = ' ';
  }
  if ((keys & KEY_RIGHT) == KEY_RIGHT) {
    keyString[3] = 'R';
  } else {
    keyString[3] = ' ';
  }
  if ((keys & KEY_FIRE) == KEY_FIRE) {
    keyString[4] = 'F';
  } else {
    keyString[4] = ' ';
  }
  if ((keys & KEY_START) == KEY_START) {
    keyString[5] = 'S';
  } else {
    keyString[5] = ' ';
  }
  keyString[6] = '\0';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}



void KeysPacket::fire(bool b)
{
 // return; // DISABLED
  if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void KeysPacket::start(bool b)
{
	if (b)
	{
		keys |= KEY_START;
	}
	else
		keys &= ~KEY_START;
}


// liest Zustand der Feuertaste
bool KeysPacket::getFire()
{
  return (keys & KEY_FIRE) == KEY_FIRE;
}
