// FlyingObject.cpp: Implementierung der Klasse FlyingObject.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "stdafx.h"
#include "FlyingObject.h"
#include "global.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

FlyingObject::FlyingObject()
{
  target = 0;
  targetTimeToLive = 0;
  x = 0;
  y = 0;
  dx = 0;
  dy = 0;
}

FlyingObject::~FlyingObject()
{

}

int FlyingObject::getTarget()
{
  return target;
}

void FlyingObject::incTarget(int ttl)
{
  target++;
  targetTimeToLive = max(targetTimeToLive,ttl);
}

void FlyingObject::setTarget(int target)
{
  this->target = target;
}

void FlyingObject::decTargetTimeToLive()
{
  if (targetTimeToLive > 0) {
    targetTimeToLive--;
  } else {
    target = 0;
  }
}

void FlyingObject::setTargetTimeToLive(int t)
{
  targetTimeToLive = t;
}

int FlyingObject::getTargetTimeToLive()
{
  return targetTimeToLive;
}

void FlyingObject::calcRelativePos(int x1, int y1)
{
  relX8 = normalizeX(x - x1) << 3;
  relY8 = normalizeY(y - y1) << 3;
}

// liefert true, wenn maxtargets erreicht ist
bool FlyingObject::maxTargets()
{
  switch (sf)
  {	// Asteroiden siehe dort
  case 15: // mittleres/Grosses UFO
    if (getTarget() < 1) {
      return false;
    }
    break;
  case 14: // kleines UFO
    if (getTarget() < 1) {
      return false;
    }
  }
  return true;
}