// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
// changed by Reno Granzow

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#define ONLINE_PLAY

#define round(x)	(((x)-floor(x))>0.5 ? ceil(x) : floor(x))
#define EPSILON		0.0002
#define EPSILON2	0.0001
#define PI2			6.283185307

// (70*8)^2
#define MAX_SHOTRANGE 313600
#define MAX_SHOTRANGE_FRAMES 110

//#define FULL_TRACE
// #define MEDIUM_TRACE


//#define LATENZ 3 
int LATENZ=5;

//int shot_points[256][2];


int shot_points[256][2] =
{
19, 0,
19, 1,
19, 2,
19, 4,
19, 5,
18, 7,
17, 8,
17, 9,
16, 10,
15, 12,
14, 13,
13, 14,
12, 15,
11, 16,
10, 16,
8, 17,
7, 18,
6, 18,
4, 19,
3, 19,
1, 19,
0, 19,
-1, 19,
-3, 19,
-5, 19,
-6, 19,
-7, 18,
-9, 18,
-10, 17,
-11, 16,
-12, 15,
-14, 15,
-15, 14,
-15, 12,
-16, 11,
-17, 10,
-18, 9,
-19, 7,
-19, 6,
-20, 5,
-20, 3,
-20, 2,
-20, 0,
-20, -1,
-20, -2,
-20, -4,
-20, -5,
-20, -7,
-19, -8,
-18, -10,
-18, -11,
-17, -12,
-16, -13,
-15, -14,
-14, -15,
-13, -16,
-12, -17,
-10, -18,
-9, -19,
-8, -19,
-6, -20,
-5, -20,
-4, -20,
-2, -20,
0, -20,
1, -20,
2, -20,
4, -20,
5, -20,
7, -19,
8, -19,
9, -18,
10, -17,
12, -16,
13, -15,
14, -14,
15, -13,
16, -12,
16, -11,
17, -10,
18, -8,
18, -7,
19, -5,
19, -4,
19, -2,
19, -1,
19, 0,
19, 2,
19, 3,
19, 5,
18, 6,
18, 7,
17, 9,
16, 10,
15, 11,
15, 12,
14, 14,
12, 15,
11, 15,
10, 16,
9, 17,
7, 18,
6, 18,
5, 19,
3, 19,
2, 19,
0, 19,
-1, 19,
-2, 19,
-4, 19,
-5, 19,
-7, 18,
-8, 18,
-10, 17,
-11, 16,
-12, 16,
-13, 15,
-14, 14,
-15, 13,
-16, 12,
-17, 10,
-18, 9,
-19, 8,
-19, 7,
-20, 5,
-20, 4,
-20, 2,
-20, 1,
-20, 0,
-20, -2,
-20, -4,
-20, -5,
-20, -6,
-19, -8,
-19, -9,
-18, -10,
-17, -12,
-16, -13,
-15, -14,
-14, -15,
-13, -16,
-12, -17,
-11, -18,
-10, -18,
-8, -19,
-7, -20,
-5, -20,
-4, -20,
-2, -20,
-1, -20,
0, -20,
2, -20,
3, -20,
5, -20,
6, -19,
7, -19,
9, -18,
10, -17,
11, -16,
12, -15,
14, -15,
15, -14,
15, -12,
16, -11,
17, -10,
18, -9,
18, -7,
19, -6,
19, -5,
19, -3,
19, -1,
19, 0,
19, 1,
19, 3,
19, 4,
18, 6,
18, 7,
17, 8,
16, 10,
16, 11,
15, 12,
14, 13,
13, 14,
12, 15,
10, 16,
9, 17,
8, 17,
7, 18,
5, 19,
4, 19,
2, 19,
1, 19,
0, 19,
-2, 19,
-4, 19,
-5, 19,
-6, 19,
-8, 18,
-9, 17,
-10, 17,
-12, 16,
-13, 15,
-14, 14,
-15, 13,
-16, 12,
-17, 11,
-18, 10,
-18, 8,
-19, 7,
-20, 6,
-20, 4,
-20, 3,
-20, 1,
-20, 0,
-20, -1,
-20, -3,
-20, -5,
-20, -6,
-19, -7,
-19, -9,
-18, -10,
-17, -11,
-16, -12,
-15, -14,
-15, -15,
-14, -15,
-12, -16,
-11, -17,
-10, -18,
-9, -19,
-7, -19,
-6, -20,
-5, -20,
-3, -20,
-1, -20,
0, -20,
1, -20,
3, -20,
4, -20,
6, -20,
7, -19,
8, -18,
10, -18,
11, -17,
12, -16,
13, -15,
14, -14,
15, -13,
16, -12,
17, -10,
17, -9,
18, -8,
19, -6,
19, -5,
19, -4,
19, -2
};

float ship_dir[256][2] =
{
1.000000, 0.000000,
0.998274, 0.058722,
0.990712, 0.135980,
0.976645, 0.214862,
0.961524, 0.274721,
0.933857, 0.357647,
0.909688, 0.415292,
0.869457, 0.494009,
0.837998, 0.545673,
0.790415, 0.612572,
0.745241, 0.666795,
0.687200, 0.726468,
0.634317, 0.773073,
0.568191, 0.822897,
0.517419, 0.855732,
0.439210, 0.898384,
0.374789, 0.927110,
0.316228, 0.948683,
0.237869, 0.971297,
0.157991, 0.987441,
0.078191, 0.996938,
0.000000, 1.000000,
-0.058722, 0.998274,
-0.135980, 0.990712,
-0.214862, 0.976645,
-0.274721, 0.961524,
-0.351123, 0.936329,
-0.423940, 0.905690,
-0.485643, 0.874157,
-0.545673, 0.837998,
-0.603108, 0.797659,
-0.667910, 0.744242,
-0.716726, 0.697355,
-0.763386, 0.645942,
-0.813733, 0.581238,
-0.852323, 0.523016,
-0.886585, 0.462566,
-0.923077, 0.384615,
-0.944757, 0.327773,
-0.967822, 0.251634,
-0.985351, 0.170541,
-0.993409, 0.114624,
-0.999261, 0.038433,
-0.999261, -0.038433,
-0.995409, -0.095712,
-0.985351, -0.170541,
-0.969015, -0.247004,
-0.946773, -0.321903,
-0.916157, -0.400819,
-0.890605, -0.454777,
-0.857493, -0.514496,
-0.811176, -0.584802,
-0.761939, -0.647648,
-0.725953, -0.687745,
-0.667910, -0.744242,
-0.615271, -0.788316,
-0.563337, -0.826227,
-0.492057, -0.870563,
-0.416655, -0.909065,
-0.368048, -0.929807,
-0.304776, -0.952424,
-0.229039, -0.973417,
-0.170541, -0.985351,
-0.095712, -0.995409,
0.000000, -1.000000,
0.057597, -0.998340,
0.133412, -0.991061,
0.210838, -0.977521,
0.269630, -0.962964,
0.351123, -0.936329,
0.400819, -0.916157,
0.477513, -0.878624,
0.536875, -0.843661,
0.603108, -0.797659,
0.657135, -0.753773,
0.716726, -0.697355,
0.753773, -0.657135,
0.804574, -0.593852,
0.846890, -0.531768,
0.882353, -0.470588,
0.913009, -0.407940,
0.942627, -0.333847,
0.966562, -0.256435,
0.984183, -0.177153,
0.995229, -0.097571,
0.999232, -0.039186,
0.999232, 0.039186,
0.993151, 0.116841,
0.984183, 0.177153,
0.966562, 0.256435,
0.942627, 0.333847,
0.920155, 0.391555,
0.882353, 0.470588,
0.846890, 0.531768,
0.807030, 0.590510,
0.763386, 0.645942,
0.707107, 0.707107,
0.645942, 0.763386,
0.590510, 0.807030,
0.531768, 0.846890,
0.470588, 0.882353,
0.391555, 0.920155,
0.333847, 0.942627,
0.256435, 0.966562,
0.177153, 0.984183,
0.116841, 0.993151,
0.039186, 0.999232,
-0.039186, 0.999232,
-0.097571, 0.995229,
-0.177153, 0.984183,
-0.256435, 0.966562,
-0.333847, 0.942627,
-0.407940, 0.913009,
-0.470588, 0.882353,
-0.531768, 0.846890,
-0.593852, 0.804574,
-0.657135, 0.753773,
-0.697355, 0.716726,
-0.753773, 0.657135,
-0.797659, 0.603108,
-0.843661, 0.536875,
-0.878624, 0.477513,
-0.916157, 0.400819,
-0.936329, 0.351123,
-0.962964, 0.269630,
-0.977521, 0.210838,
-0.991061, 0.133412,
-0.998340, 0.057597,
-1.000000, 0.000000,
-0.995409, -0.095712,
-0.985351, -0.170541,
-0.973417, -0.229039,
-0.952424, -0.304776,
-0.929807, -0.368048,
-0.909065, -0.416655,
-0.870563, -0.492057,
-0.826227, -0.563337,
-0.788316, -0.615271,
-0.744242, -0.667910,
-0.687745, -0.725953,
-0.647648, -0.761939,
-0.584802, -0.811176,
-0.514496, -0.857493,
-0.454777, -0.890605,
-0.400819, -0.916157,
-0.321903, -0.946773,
-0.247004, -0.969015,
-0.170541, -0.985351,
-0.095712, -0.995409,
-0.038433, -0.999261,
0.038433, -0.999261,
0.114624, -0.993409,
0.170541, -0.985351,
0.251634, -0.967822,
0.327773, -0.944757,
0.384615, -0.923077,
0.462566, -0.886585,
0.523016, -0.852323,
0.581238, -0.813733,
0.645942, -0.763386,
0.697355, -0.716726,
0.744242, -0.667910,
0.797659, -0.603108,
0.837998, -0.545673,
0.874157, -0.485643,
0.905690, -0.423940,
0.936329, -0.351123,
0.961524, -0.274721,
0.976645, -0.214862,
0.990712, -0.135980,
0.998274, -0.058722,
1.000000, 0.000000,
0.996938, 0.078191,
0.987441, 0.157991,
0.971297, 0.237869,
0.948683, 0.316228,
0.927110, 0.374789,
0.898384, 0.439210,
0.855732, 0.517419,
0.822897, 0.568191,
0.773073, 0.634317,
0.726468, 0.687200,
0.666795, 0.745241,
0.612572, 0.790415,
0.545673, 0.837998,
0.494009, 0.869457,
0.415292, 0.909688,
0.357647, 0.933857,
0.274721, 0.961524,
0.214862, 0.976645,
0.135980, 0.990712,
0.058722, 0.998274,
0.000000, 1.000000,
-0.097571, 0.995229,
-0.173785, 0.984784,
-0.233373, 0.972387,
-0.310402, 0.950605,
-0.374789, 0.927110,
-0.431455, 0.902134,
-0.508729, 0.860927,
-0.572182, 0.820127,
-0.624695, 0.780869,
-0.677476, 0.735545,
-0.735545, 0.677476,
-0.780869, 0.624695,
-0.829072, 0.559142,
-0.865865, 0.500278,
-0.905690, 0.423940,
-0.929807, 0.368048,
-0.952424, 0.304776,
-0.973417, 0.229039,
-0.988372, 0.152057,
-0.997055, 0.076697,
-1.000000, 0.000000,
-0.998340, -0.057597,
-0.991061, -0.133412,
-0.978350, -0.206959,
-0.962964, -0.269630,
-0.938670, -0.344817,
-0.909065, -0.416655,
-0.878624, -0.477513,
-0.843661, -0.536875,
-0.804574, -0.593852,
-0.744242, -0.667910,
-0.707107, -0.707107,
-0.667910, -0.744242,
-0.593852, -0.804574,
-0.536875, -0.843661,
-0.477513, -0.878624,
-0.416655, -0.909065,
-0.344817, -0.938670,
-0.269630, -0.962964,
-0.206959, -0.978350,
-0.133412, -0.991061,
-0.057597, -0.998340,
0.000000, -1.000000,
0.076697, -0.997055,
0.152057, -0.988372,
0.229039, -0.973417,
0.304776, -0.952424,
0.368048, -0.929807,
0.423940, -0.905690,
0.500278, -0.865865,
0.559142, -0.829072,
0.624695, -0.780869,
0.677476, -0.735545,
0.735545, -0.677476,
0.780869, -0.624695,
0.820127, -0.572182,
0.860927, -0.508729,
0.902134, -0.431455,
0.927110, -0.374789,
0.950605, -0.310402,
0.972387, -0.233373,
0.984784, -0.173785,
0.995229, -0.097571
};


int dx_dy[256][2] =
{
1536,   0,
1536,   0,
1528,   152,
1504,   296,
1472,   440,
1472,   440,
1416,   584,
1360,   720,
1280,   856,
1280,   856,
1192,   976,
1088,   1088,
976,   1192,
976,   1192,
856,   1280,
720,   1360,
584,   1416,
584,   1416,
440,   1472,
296,   1504,
152,   1528,
152,   1528,
-152,   1528,
-296,   1504,
-296,   1504,
-440,   1472,
-584,   1416,
-720,   1360,
-720,   1360,
-856,   1280,
-976,   1192,
-1088,   1088,
-1088,   1088,
-1192,   976,
-1280,   856,
-1360,   720,
-1360,   720,
-1416,   584,
-1472,   440,
-1504,   296,
-1504,   296,
-1528,   152,
-1536,   0,
-1536,   0,
-1528,   -152,
-1528,   -152,
-1504,   -296,
-1472,   -440,
-1416,   -584,
-1416,   -584,
-1360,   -720,
-1280,   -856,
-1192,   -976,
-1192,   -976,
-1088,   -1088,
-976,   -1192,
-856,   -1280,
-856,   -1280,
-720,   -1360,
-584,   -1416,
-440,   -1472,
-440,   -1472,
-296,   -1504,
-152,   -1528,
0,   -1536,
152,   -1528,
296,   -1504,
440,   -1472,
440,   -1472,
584,   -1416,
720,   -1360,
856,   -1280,
856,   -1280,
976,   -1192,
1088,   -1088,
1192,   -976,
1192,   -976,
1280,   -856,
1360,   -720,
1416,   -584,
1416,   -584,
1472,   -440,
1504,   -296,
1528,   -152,
1528,   -152,
1536,   0,
1536,   0,
1528,   152,
1504,   296,
1504,   296,
1472,   440,
1416,   584,
1360,   720,
1360,   720,
1280,   856,
1192,   976,
1088,   1088,
1088,   1088,
976,   1192,
856,   1280,
720,   1360,
720,   1360,
584,   1416,
440,   1472,
296,   1504,
296,   1504,
152,   1528,
-152,   1528,
-152,   1528,
-296,   1504,
-440,   1472,
-584,   1416,
-584,   1416,
-720,   1360,
-856,   1280,
-976,   1192,
-976,   1192,
-1088,   1088,
-1192,   976,
-1280,   856,
-1280,   856,
-1360,   720,
-1416,   584,
-1472,   440,
-1472,   440,
-1504,   296,
-1528,   152,
-1536,   0,
-1536,   0,
-1536,   0,
-1528,   -152,
-1504,   -296,
-1472,   -440,
-1472,   -440,
-1416,   -584,
-1360,   -720,
-1280,   -856,
-1280,   -856,
-1192,   -976,
-1088,   -1088,
-976,   -1192,
-976,   -1192,
-856,   -1280,
-720,   -1360,
-584,   -1416,
-584,   -1416,
-440,   -1472,
-296,   -1504,
-152,   -1528,
-152,   -1528,
152,   -1528,
296,   -1504,
296,   -1504,
440,   -1472,
584,   -1416,
720,   -1360,
720,   -1360,
856,   -1280,
976,   -1192,
1088,   -1088,
1088,   -1088,
1192,   -976,
1280,   -856,
1360,   -720,
1360,   -720,
1416,   -584,
1472,   -440,
1504,   -296,
1504,   -296,
1528,   -152,
1536,   0,
1536,   0,
1528,   152,
1528,   152,
1504,   296,
1472,   440,
1416,   584,
1416,   584,
1360,   720,
1280,   856,
1192,   976,
1192,   976,
1088,   1088,
976,   1192,
856,   1280,
856,   1280,
720,   1360,
584,   1416,
440,   1472,
440,   1472,
296,   1504,
152,   1528,
0,   1536,
-152,   1528,
-296,   1504,
-440,   1472,
-440,   1472,
-584,   1416,
-720,   1360,
-856,   1280,
-856,   1280,
-976,   1192,
-1088,   1088,
-1192,   976,
-1192,   976,
-1280,   856,
-1360,   720,
-1416,   584,
-1416,   584,
-1472,   440,
-1504,   296,
-1528,   152,
-1528,   152,
-1536,   0,
-1536,   0,
-1528,   -152,
-1504,   -296,
-1504,   -296,
-1472,   -440,
-1416,   -584,
-1360,   -720,
-1360,   -720,
-1280,   -856,
-1192,   -976,
-1088,   -1088,
-1088,   -1088,
-976,   -1192,
-856,   -1280,
-720,   -1360,
-720,   -1360,
-584,   -1416,
-440,   -1472,
-296,   -1504,
-296,   -1504,
-152,   -1528,
152,   -1528,
152,   -1528,
296,   -1504,
440,   -1472,
584,   -1416,
584,   -1416,
720,   -1360,
856,   -1280,
976,   -1192,
976,   -1192,
1088,   -1088,
1192,   -976,
1280,   -856,
1280,   -856,
1360,   -720,
1416,   -584,
1472,   -440,
1472,   -440,
1504,   -296,
1528,   -152,
1536,   0
};

char prev_latenz=0;
float foo = 1;
int average_latenz=0;
char frame_error=0;

unsigned char fut_dx_dy_index = 0;


#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "player.h"

KeysPacket keys_array[3]; 


int l_max = 0;
int l_min = 0;




bool DistToFutureShipPosition(float Sx, float Sy, float Ax, float Ay, float speed_x, float speed_y, int& x, int& y, float& tp)
{
	// suche Lsung fr t^2 + 2vt + w^2 = 0
	float AMovePerFrameX = speed_x;
	float AMovePerFrameY = speed_y;
	float dist_x = Ax - Sx;
	float dist_y = Ay - Sy;
	while (dist_x < -512) dist_x += 1024;
	while (dist_x > 511) dist_x -= 1024;
	while (dist_y < -384) dist_y += 768;
	while (dist_y > 383) dist_y -= 768;


	float asquare = AMovePerFrameX*AMovePerFrameX + AMovePerFrameY*AMovePerFrameY;
	float a = sqrt(asquare);
	if (a > 8.0)
	{
		printf("a=%f\n",a);
		return false;
	}
	float b = 8.0;
	float bsquare = 64.0;
	float k = AMovePerFrameX/a;
	float ksquare = k*k;
	float i = AMovePerFrameY/a;

	float v =  (2.0 *a*((float)(dist_x)*k + (float)(dist_y)*i)/(asquare*i*i - bsquare + asquare*ksquare));
	float w = (float)((dist_y)*(dist_y) + (dist_x)*(dist_x))/(asquare*i*i - bsquare + asquare*ksquare);

	// solution for a^2 + 2ab + b^2 + c = 0
	float t = sqrt(v*v/4.0 - w) - v/2.0;
	tp = t;

//#ifdef FULL_TRACE
	if((v*v/4.0 - w) < 0.0)
	{
		printf("v=%f  w=%f sqrt=%f\n",v,w,(v*v/4.0 - w));
		printf("a=%f  b=%f  k=%f  i=%f\n",a,b,k,i);
	}
//#endif FULL_TRACE

	// eigentlich so, aber besser  nicht normalisieren (x^2 + y^2 = 1)
//	x = round(( ((float)(dist_x) +  t*a*k)/(t*b) ));
//	y = round(( ((float)(dist_y) +  t*a*i)/(t*b) ));

	x = (int)round(((float)(dist_x) +  t*a*k));
	y = (int)round(((float)(dist_y) +  t*a*i));

	return true;
}

void Player::Run(void)
{
	FramePacket frame;
	KeysPacket keys;
	NamePacket name;
	GameStatus game;
	char prevframe = 0;
	int t = 0;
	float kreuzprodukt;
	float prev_kreuzprodukt = 0.0;
	int prev_saucer_x = 0; 
	int prev_saucer_y = 0;
	int hyperspace_flag = 0;
	unsigned char dx_dy_index = 0;
	unsigned char prev_dx_dy_index = 0;
	unsigned char prev_prev_dx_dy_index = 0;


	char latenz=0;
	char frame_error=0;
	char prev_frame_error=0;
	int out_of_sync = 0;
	int frame_count_s = 0;
	int current_saucer_dist_x = 0;
	int current_saucer_dist_y = 0;
	float current_saucer_speed_x = 0;
	float current_saucer_speed_y = 0;
	int initial_saucer_x = 0;
	int initial_saucer_y = 0;
	int prev_nasteroids = 0;

	int saucer_num_shots = 0;
	int saucer_timeout = 0;
	int saucer_look_for_shot = 0;
	unsigned char saucer_dx_dy_index = 0;

	prev_latenz=0;
	average_latenz=0;

	long l = 0;

	bool shot_allowed = true;

	int keys_count = 0; 
	KeysPacket last_keys;

	rot_queue r_queue;

	int k = 0;
	r_queue.empty();


	printf("START GAME\n");
#ifdef ONLINE_PLAY
	printf("Send Key\n");
	SendPacket(keys);
	printf("get frame\n");
	ReceivePacket(frame);
	printf("Send Name\n");
	SendPacket(name);
	printf("get frame\n");
	ReceivePacket(frame);
#endif //ONLINE_PLAY
	printf("PLAY\n");
	


	for (;;)
	{
		++t;         // Zeit
		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung

		/*
		if( keys_count >= LATENZ) 
				SendPacket( keys_array[ (keys_count - LATENZ ) % LATENZ ] ); 

		keys_array[keys_count % LATENZ] = keys; 
		keys_count++; 
		*/


		SendPacket(keys);
		ReceivePacket(frame);


		prev_latenz = latenz;
		prev_frame_error = frame_error;

		if(frame_error || latenz )
		{
			latenz = 0;
			frame_error = 0;
		}
		if (frame.frameno != ++prevframe || frame.ping != keys.ping)
		{
#ifdef MEDIUM_TRACE
			printf("Latenz %d. %d Frames verloren. t=%d, %d %d %d %d\n", keys.ping - frame.ping, frame.frameno - prevframe,t, keys.ping, frame.ping,frame.frameno,prevframe);
#endif MEDIUM_TRACE

			if(frame.frameno != prevframe)
				frame_error = (frame.frameno - prevframe);
			prevframe = frame.frameno;

			if(keys.ping != frame.ping)
				latenz = (unsigned char)(keys.ping - frame.ping);
		}

		if(frame_error)
//		if(false)
		{
//				prev_dx_dy_index=dx_dy_index;
			if(frame_error < 0)
			{
				printf("??? %d\n",latenz);
				prev_dx_dy_index=prev_prev_dx_dy_index;
				dx_dy_index+=(frame_error * r_queue.get(0));
			}
			else
			{
				prev_dx_dy_index+=(frame_error * r_queue.get(1));
				dx_dy_index+=(frame_error * r_queue.get(1));
			}
		}


//		if(false)
		if(latenz)
		{
			if(!(frame_error < 0))
			{
				dx_dy_index-=(r_queue.top());
				dx_dy_index+=(r_queue.get(latenz));
			}

		}


		float l_tmp;
		if((t%30) == 0)
		{
			l = 0;
			l_tmp = (float)latenz;
		}
		else
		{
			l += latenz;
			l_tmp = (float)l/(float)((t%30));
		}
		if(l_tmp - (int)l_tmp < 0.1)
		{
			l_min = floor(l_tmp);
			l_max = l_min;
		}
		else if(l_tmp - (int)l_tmp > 0.9)
		{
			l_min = ceil(l_tmp);
			l_max = l_min;
		}
		else
		{
			l_min = floor(l_tmp);
			l_max = ceil(l_tmp);
		}

		foo = (float)l_max - 0.5;
		
		average_latenz= (l_max == 0 ? 0 : l_max);

			

		InterpretScreen(frame, game);
		CopyAsteroids(game);

		keys.clear();   // alle Tasten loslassen
		int min_dist = MAX_SHOTRANGE;
		float mp_approx_wo_to = (float)MAX_SHOTRANGE_FRAMES;
		float min_dist_collision = 8100.0; // 90.0^2
		int av_min_dist = 0x7fffffff;
		int saucer_min_dist = MAX_SHOTRANGE;
		int saucer_min_dx = 0;
		int saucer_min_dy = 0;
		int asteroids_id = -2;
		int asteroids_id_shot = -2;
		int av_asteroids_id = -2;
		bool go_hyperspace = false;

		unsigned char winkel;
		if (game.ship_present)
		{
			fut_dx_dy_index = dx_dy_index + r_queue.sum(latenz);
			winkel = dx_dy_index + r_queue.sum(l_max);
			int collision_asteroid = -2;

			if(!latenz)
			{	
				// "Schutzschild" mit Lcke (geht so nicht bei Latenz)
				go_hyperspace = false;
				for(int j=game.nshots;j>0;j--)
				{
					int dsx = game.shots[j-1].x - game.ship_x;
					while (dsx < -512) dsx += 1024;
					while (dsx > 511) dsx -= 1024;
					int dsy = game.shots[j-1].y - game.ship_y;
					while (dsy < -384) dsy += 768;
					while (dsy > 383) dsy -= 768;
					float shot_dist = sqrt((float)(dsx*dsx + dsy*dsy));
					if(shot_dist < 33.0)
					{
						float nx = (float)dsx/shot_dist;
						float ny = (float)dsy/shot_dist;
						// nicht prev_dx_dy_index, sondern besser die Richtungen der letzten beiden Schsse!
						if(abs(nx*ship_dir[prev_dx_dy_index][0] + ny*ship_dir[prev_dx_dy_index][1] - 1.0) > 0.01 &&
						abs(nx*ship_dir[prev_prev_dx_dy_index][0] + ny*ship_dir[prev_prev_dx_dy_index][1] - 1.0) > 0.01)
						{
							go_hyperspace = true;
						}
					}
				}
			}


			for (int i=0; i<game.nasteroids; ++i)
			{   
				// nchstgelegenen Asteroiden suchen
				int dx = game.asteroids[i].x - game.ship_x;
				while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
				while (dx > 511) dx -= 1024;
				int dy = game.asteroids[i].y - game.ship_y;
				while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
				while (dy > 383) dy -= 768;
				int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
				int rsquare;
				switch (game.asteroids[i].sf)
				{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
					case 0:  // groer Asteroid
						rsquare = 31*31;
						game.asteroids[i].w = sqrt(1.0 - (double)dist/(double)(dist+rsquare));
						dist -= 40*40;
						break;
					case 15: // mittlerer Asteroid
						rsquare = 15*15;
						game.asteroids[i].w = sqrt(1.0 - (double)dist/(double)(dist+rsquare));
						dist -= 20*20;
						break;
					case 14: // kleiner Asteroid
						rsquare = 7*7;
////						game.asteroids[i].w = EPSILON;
						game.asteroids[i].w = sqrt(1.0 - (double)dist/(double)(dist+rsquare));
						dist -= 8*8;
						break;
				}
				game.asteroids[i].dist = dist;
				game.asteroids[i].dx = dx;
				game.asteroids[i].dy = dy;
				if(!game.asteroids[i].look_for_shot)
					game.asteroids[i].dx_dy_index = fut_dx_dy_index; // Winkel sichern fr sptere berprfung, ob der Schuss erfolgte
					
				// berechne optimale Ausrichtung Schiff zu Asteroiden und anschlieend Kreuzprodukt Schiffrichtung und Vektor zwischen Schiff/Asteroid
				game.asteroids[i].compute_kreuzprodukt(game.ship_x,game.ship_y,ship_dir[winkel][0],ship_dir[winkel][1],foo);
				
				// anstatt nchstliegenden Asteroiden zu suchen, suche einen aus,  der schnell getroffen wird und der Winkel des Schiffs zum Asteroiden klein ist
				float mp_approx = abs(game.asteroids[i].approx_mp(game.asteroids[i].dx,game.asteroids[i].dy,ship_dir[winkel][0],ship_dir[winkel][1],dist));
//				mp_approx = sqrt((float)dist)/8.0;
				

				// Approximaton des Abstands Asteroid zum Schiif nach Ablauf Latenzzeit
				if(average_latenz && game.asteroids[i].yl_avail)
				{
					int dxl = game.asteroids[i].xl - game.ship_x;
					while (dxl < -512) dxl += 1024; // dx normalisieren auf -512 ... 511
					while (dxl > 511) dxl -= 1024;
					int dyl = game.asteroids[i].yl - game.ship_y;
					while (dyl < -384) dyl += 768;  // dy normalisieren auf -384 ... 383
					while (dyl > 383) dyl -= 768;
					int av_dist = dxl*dxl+dyl*dyl;  // Quadrat des Abstands zu diesem Asteroiden
					switch (game.asteroids[i].sf)
					{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
						case 0:  // groer Asteroid
							av_dist -= 40*40;
							break;
						case 15: // mittlerer Asteroid
							av_dist -= 20*20;
							break;
						case 14: // kleiner Asteroid
							av_dist -= 8*8;
							break;
					}
					if (av_dist < av_min_dist)
					{
						av_asteroids_id = i;
						av_min_dist = av_dist;
					}
				}



				// prfe, ob ein bestimmter Schuss auf Asteroiden abgegeben wurde, damit der Timeout, der einen Asteroiden von weiteren Schssen ausschliet, 
				// ggf. zurckgesetzt werden kann
				if (game.asteroids[i].look_for_shot)
				{
//					if((t - game.asteroids[i].look_for_shot) == (2+l_max))
					if( (t - game.asteroids[i].look_for_shot) >= (2+l_min) && (t - game.asteroids[i].look_for_shot) <= (2+l_max) )
					{
						bool shot_successful = false;
						for(int j=game.nshots;j>0;j--)
						{
							int dsx = game.shots[j-1].x - game.ship_x;
							while (dsx < -512) dsx += 1024;
							while (dsx > 511) dsx -= 1024;
							int dsy = game.shots[j-1].y - game.ship_y;
							while (dsy < -384) dsy += 768;
							while (dsy > 383) dsy -= 768;
							int shot_dist = dsx*dsx + dsy*dsy;
//							if (shot_points[game.asteroids[i].dx_dy_index][0] == dsx && shot_points[game.asteroids[i].dx_dy_index][1] == dsy)
							if (shot_dist < 450)
							{
								shot_successful = true;
								
								game.asteroids[i].timeout=(int)round(game.asteroids[i].tp);
								
								game.asteroids[i].look_for_shot = 0;
								break;
							}
						}
						if(!shot_successful && (t - game.asteroids[i].look_for_shot) == (2+l_max))
						{
							game.asteroids[i].look_for_shot = 0;
							game.asteroids[i].dx_dy_index = fut_dx_dy_index;
							game.asteroids[i].timeout=0;
						}
					}
					else if((t - game.asteroids[i].look_for_shot) > (2+l_max))
					{
						game.asteroids[i].look_for_shot = 0;
						game.asteroids[i].dx_dy_index = fut_dx_dy_index;
//						game.asteroids[i].timeout=0;
					}
				}

				// immer schieen, wenn nur ein Asteroid, sonst mglichen Timeout reduzieren
				if(game.nasteroids < 2)
				{
					game.asteroids[i].look_for_shot = 0;
					game.asteroids[i].dx_dy_index = fut_dx_dy_index;
					game.asteroids[i].timeout=0;
				}
				else
					if(game.asteroids[i].timeout)
						game.asteroids[i].timeout--;


				// nach Asteroiden Ausschau halten, die das Schiff treffen knnten - diese werden "bevorzugt"								
//////				if(!game.asteroids[i].timeout && game.asteroids[i].approx_collision(game.ship_x,game.ship_y))
				if((!game.asteroids[i].timeout || game.asteroids[i].num_shots) && game.asteroids[i].approx_collision(game.ship_x,game.ship_y))
				{
					float frame_dist=(float)game.asteroids[i].dist/(game.asteroids[i].current_asteroid_speed_x*game.asteroids[i].current_asteroid_speed_x + game.asteroids[i].current_asteroid_speed_y * game.asteroids[i].current_asteroid_speed_y);
					if(frame_dist < min_dist_collision)
					{
						min_dist_collision = frame_dist;
						collision_asteroid=i;
						asteroids_id=collision_asteroid;
					}
				}

				if (mp_approx < mp_approx_wo_to && ((!game.asteroids[i].timeout && !game.asteroids[i].look_for_shot)  || game.asteroids[i].num_shots) && collision_asteroid == -2)
				{ 
						asteroids_id = i; 
						mp_approx_wo_to = mp_approx; 
				} 
				// min_dist nur noch fr Kollisionskontrolle
				if (dist < min_dist)
				{
						min_dist = dist;
				}
			}


			if (game.saucer_present)
			{
				int dx = game.saucer_x - game.ship_x;
				while (dx < -512) dx += 1024;	
				while (dx > 511) dx -= 1024;
				int dy = game.saucer_y - game.ship_y;
				while (dy < -384) dy += 768;
				while (dy > 383) dy -= 768;
				int dist = dx*dx+dy*dy;
				switch (game.saucer_size)
				{	// Abstand um den ungefhren Radius des UFOs korrigieren
				case 15: // groes UFO
					dist -= 20*12;
					break;
				case 14: // kleines UFO
					dist -= 10*6;
					break;
				}

				if(!game.nasteroids)
				{
					saucer_look_for_shot = 0;
					saucer_timeout=0;
					saucer_num_shots = 0;
				}

				saucer_min_dist = dist;

				// prfe, ob ein bestimmter Schuss auf UFO abgegeben wurde, damit der Timeout, der das UFO von weiteren Schssen ausschliet, 
				// ggf. zurckgesetzt werden kann
				if (saucer_look_for_shot)
				{
					if( (t - saucer_look_for_shot) >= (2+l_min) && (t - saucer_look_for_shot) <= (2+l_max) )
					{
						bool shot_successful = false;
						for(int j=game.nshots;j>0;j--)
						{
							int dsx = game.shots[j-1].x - game.ship_x;
							while (dsx < -512) dsx += 1024;
							while (dsx > 511) dsx -= 1024;
							int dsy = game.shots[j-1].y - game.ship_y;
							while (dsy < -384) dsy += 768;
							while (dsy > 383) dsy -= 768;
							int shot_dist = dsx*dsx + dsy*dsy;
	//						if (shot_points[saucer_dx_dy_index][0] == dsx && shot_points[saucer_dx_dy_index][1] == dsy)
							if (shot_dist < 450)
							{
								shot_successful = true;
								saucer_look_for_shot = 0;
								break;
							}
						}
						if(!shot_successful && (t - saucer_look_for_shot) == (2+l_max))
						{
							saucer_look_for_shot = 0;
							saucer_timeout=0;
						}
					}
					else if((t - saucer_look_for_shot) > (2+l_max))
					{
						saucer_look_for_shot = 0;
					}
				}


				if(saucer_timeout)
					saucer_timeout--;
				if(!saucer_timeout && collision_asteroid == -2)
				{
					asteroids_id = -1;
				}
				saucer_min_dx = dx;
				saucer_min_dy = dy;
			}
			else
			{
				prev_saucer_x = 0;
				prev_saucer_y = 0;
				saucer_timeout = 0;
				saucer_num_shots = 0;
				saucer_dx_dy_index = 0;
				saucer_look_for_shot = 0;
				frame_count_s = 0;
			}

			// Schiff in Richtung auf das nchstgelegene Objekt drehen
			// mathematisch wird hier das Kreuzprodukt aus den Vektoren 
			// ship_dx/y/0 und min_dx/y/0 berechnet


			kreuzprodukt = 100.0;



			if (game.saucer_present)
			{

				// Geschwindigkeit und Richtungsnderungen vom UFO bestimmen
				if(frame_error || frame_count_s > 200 ||
					(frame_count_s > 0 && (abs(game.saucer_x - prev_saucer_x) > 500 || abs(game.saucer_y - prev_saucer_y) > 380) ))
				{

					frame_count_s = 0;
				}

				if(frame_count_s > 1)
				{
					if(current_saucer_dist_x == 0 && (game.saucer_x - initial_saucer_x) != 0)
						frame_count_s = 0;
					else if(current_saucer_dist_y == 0 && (game.saucer_y - initial_saucer_y) != 0)
						frame_count_s = 0;
					else 
					{
						// check direction change
						float tmp = (float)(game.saucer_x - initial_saucer_x)/current_saucer_speed_x - (float)(game.saucer_y - initial_saucer_y)/current_saucer_speed_y;
						if(tmp > EPSILON || tmp < -EPSILON)
							frame_count_s = 0;
					}
					if(frame_count_s == 0)
					{
						saucer_timeout = 0;
						saucer_look_for_shot = 0;
						saucer_num_shots = 0;
					}
				}

				if(!frame_count_s)
				{
					initial_saucer_x = game.saucer_x;
					initial_saucer_y = game.saucer_y;
					prev_saucer_x = game.saucer_x;
					prev_saucer_y = game.saucer_y;
					current_saucer_dist_x = 0;
					current_saucer_dist_y = 0;
					frame_count_s++;
					kreuzprodukt = kreuznorm(ship_dir[winkel][0],ship_dir[winkel][1],(float)saucer_min_dy,(float)saucer_min_dx);
				}
				else
				{
					current_saucer_dist_x = game.saucer_x - initial_saucer_x;
					current_saucer_dist_y = game.saucer_y - initial_saucer_y;
					current_saucer_speed_x = (float)current_saucer_dist_x/(float)frame_count_s;
					current_saucer_speed_y = (float)current_saucer_dist_y/(float)frame_count_s;
					int dx = 0;
					int dy = 0;


					float dummi;
					if( DistToFutureShipPosition(
						(float)game.ship_x, 
						(float)game.ship_y, 
						(float)game.saucer_x + (float)foo*(current_saucer_speed_x),
						(float)game.saucer_y + (float)foo*(current_saucer_speed_y), 
						current_saucer_speed_x,
						current_saucer_speed_y,
						dx,
						dy,
						dummi) )
					{
						kreuzprodukt = kreuznorm(ship_dir[winkel][0],ship_dir[winkel][1],(float)dy,(float)dx);
					}
					else
					{
						kreuzprodukt = kreuznorm(ship_dir[winkel][0],ship_dir[winkel][1],(float)saucer_min_dy,(float)saucer_min_dx);
					}
					prev_saucer_x = game.saucer_x;
					prev_saucer_y = game.saucer_y;
					frame_count_s++;
				}
			}
			else
			{
				frame_count_s = 0;
			}

			// vorab schauen, ob Schuss erfolgen kann. Wenn Schuss, dann auch gleich zum nchsten Asteroiden ausrichten
			if (asteroids_id >= 0) 
			{
				kreuzprodukt = game.asteroids[asteroids_id].kreuzprodukt;
				if(collision_asteroid >= 0)
				{
//////					if( kreuzprodukt <  game.asteroids[asteroids_id].w && kreuzprodukt > -game.asteroids[asteroids_id].w && game.asteroids[asteroids_id].vp > 0.0)
					if( (!game.asteroids[asteroids_id].look_for_shot || game.asteroids[asteroids_id].num_shots) && kreuzprodukt <  game.asteroids[asteroids_id].w && kreuzprodukt > -game.asteroids[asteroids_id].w && game.asteroids[asteroids_id].vp > 0.0)
					{
						asteroids_id_shot = asteroids_id;
					}
					else
					{
						asteroids_id_shot = -2;
					}
				}
				else
				{
//////					if( kreuzprodukt <  EPSILON && kreuzprodukt > -EPSILON && game.asteroids[asteroids_id].vp > 0.0)
					if( (!game.asteroids[asteroids_id].look_for_shot || game.asteroids[asteroids_id].num_shots) && kreuzprodukt <  EPSILON && kreuzprodukt > -EPSILON && game.asteroids[asteroids_id].vp > 0.0)
					{
						asteroids_id_shot = asteroids_id;
					}
					else
					{
						asteroids_id_shot = -2;
					}

				}

			} 
			else 
			{
				if(asteroids_id == -1)
				{
					if(kreuzprodukt <  EPSILON && kreuzprodukt > -EPSILON)
					{
						asteroids_id_shot = -1;
					}
					else
					{
						asteroids_id_shot = -2;
					}
				}
			}




			// bei Gefahr in den Hyperspace flchten
			if(hyperspace_flag)
				keys.hyperspace(true);

			if(!hyperspace_flag)
			{
				if (min_dist < 27*27 || saucer_min_dist < 27*27 || (average_latenz && av_min_dist < 27*27) || go_hyperspace)  // Flucht, wenn Kollision unausweichlich
				{
					if(average_latenz && av_min_dist < 27*27)
					{
						printf("hyperspace av_min_dist\n");
					}
					else
						printf("hyperspace\n");
					keys.hyperspace(true);
					hyperspace_flag++;
#ifdef FULL_TRACE
					printf("hyperspace\n");
#endif FULL_TRACE
				}
			}

#ifdef FULL_TRACE
			if(hyperspace_flag)
			{
				printf("hyperspace %d\n",hyperspace_flag);	
			}
#endif FULL_TRACE

			// evtl. neu synchronisieren mit der Winkeltabelle
			if (dx_dy[prev_dx_dy_index][0] != game.ship_dx || dx_dy[prev_dx_dy_index][1] != game.ship_dy)
			{

#ifdef MEDIUM_TRACE
				printf("%d %d   %d   %d   %d - %d %d outOfSync\n",prev_dx_dy_index,dx_dy[prev_dx_dy_index][0],game.ship_dx,dx_dy[prev_dx_dy_index][1],game.ship_dy,prev_latenz, prev_frame_error);
#endif MEDIUM_TRACE
				out_of_sync = 1;
			}

#ifdef MEDIUM_TRACE
			if (latenz || frame_error)
			{
				printf("%d %d   %d   %d   %d in Latenz\n",prev_dx_dy_index,dx_dy[prev_dx_dy_index][0],game.ship_dx,dx_dy[prev_dx_dy_index][1],game.ship_dy);
			}
#endif MEDIUM_TRACE

			prev_prev_dx_dy_index=prev_dx_dy_index;
			prev_prev_dx_dy_index=prev_dx_dy_index;
			prev_dx_dy_index=dx_dy_index;

#ifdef FULL_TRACE
			if(latenz && (hyperspace_flag == 2))
				printf("NO hyperspace\n");
#endif FULL_TRACE

			if(!hyperspace_flag && asteroids_id != -2)
			{
				if (out_of_sync)
				{
					unsigned char index;
					printf("OUT OF SYNC\n");
					out_of_sync = sync(game.ship_dx, game.ship_dy,t,latenz,frame_error,index);
					if(!out_of_sync)
					{
						printf("Back from SYNC index=%d\n",index);
						prev_dx_dy_index=index+1;
						dx_dy_index=prev_dx_dy_index;
						r_queue.push(0);
					}
					else
					{
						keys.left(true);
						dx_dy_index++;
						r_queue.push(1);
					}

				}
				else
				{
					if (kreuzprodukt > EPSILON2)
					{
						keys.left(true);
						dx_dy_index++;
						r_queue.push(1);
					}
					else if (kreuzprodukt < -EPSILON2)
					{
						keys.right(true);
						dx_dy_index--;
						r_queue.push(-1);
					}
					else
					{
						r_queue.push(0);
					}

				}
			}
			else
			{
				r_queue.push(0);
			}




			if (!hyperspace_flag && shot_allowed && !out_of_sync)  // Feuerknopf drcken
			{
				if( asteroids_id_shot >= -1)
				{
					if(asteroids_id_shot >= 0 )
					{
						if(!game.asteroids[asteroids_id_shot].num_shots)
						{
							switch (game.asteroids[asteroids_id_shot].sf)
							{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
								case 0:  // groer Asteroid
									game.asteroids[asteroids_id_shot].num_shots = 7;
									break;
								case 15: // mittlerer Asteroid
									game.asteroids[asteroids_id_shot].num_shots = 3;
									break;
								case 14: // kleiner Asteroid
									game.asteroids[asteroids_id_shot].num_shots = 1;
									break;
							}
						}
//////						if(!game.asteroids[asteroids_id_shot].timeout)
						if(!game.asteroids[asteroids_id_shot].timeout && !game.asteroids[asteroids_id_shot].look_for_shot)
						{
							game.asteroids[asteroids_id_shot].look_for_shot = t;
						}
						keys.fire(true);
						shot_allowed = false;
					}
					else
					{
						if(asteroids_id_shot == -1)
						{
							saucer_num_shots++;
							saucer_look_for_shot = t;
							if(saucer_num_shots > 1)
							{
								saucer_dx_dy_index = fut_dx_dy_index;
								saucer_timeout = (int)round(sqrt((double)saucer_min_dist/64.0));
							}
							keys.fire(true);
							shot_allowed = false;
						}
					}
				}
				else if(asteroids_id != -2)
				{
					for (int i=0; i<game.nasteroids; ++i)
					{
//////						if(game.asteroids[i].dist > (MAX_SHOTRANGE/2) || game.asteroids[i].timeout)
						if(game.asteroids[i].dist > (MAX_SHOTRANGE/2) || game.asteroids[i].timeout || game.asteroids[i].look_for_shot)
							continue;

						if((float)game.asteroids[i].dx*ship_dir[winkel][0] + (float)game.asteroids[i].dy*ship_dir[winkel][1] <= 0.0) //macht das Sinn ???
							kreuzprodukt=100.0;
						else
							kreuzprodukt = game.asteroids[i].kreuzprodukt;
						if(kreuzprodukt <  EPSILON && kreuzprodukt > -EPSILON && game.asteroids[i].vp > 0.0)
						{
							keys.fire(true);

							game.asteroids[i].look_for_shot = t;
							game.asteroids[i].num_shots = 0;
							shot_allowed = false;
							break;
						}
					}
				}
			}
			else
				shot_allowed = true;
		}
		else
		{
			for (int i=0; i<game.nasteroids; ++i)
			{   // Daten lschen
				game.asteroids[i].frame_count_a = 0;
			}
			frame_count_s = 0;
			shot_allowed = true;

			if(hyperspace_flag)
			{
#ifdef FULL_TRACE
				printf("hyperspace_flag = %d,  %d %d\n",hyperspace_flag,r_queue.get(1),r_queue.top());
#endif FULL_TRACE

				hyperspace_flag = 0;
			}
			if(latenz)
			{
				for(int i=1; i<=latenz;i++)
					dx_dy_index-=(r_queue.get(i));
				// fehlt noch die Bercksichtigung frame errors (top?), aber hier wird dann bei Bedarf synchronisiert
			}
			else
			{
				dx_dy_index-=(r_queue.top());
				dx_dy_index-=(r_queue.get(1));
			}
			prev_dx_dy_index=dx_dy_index;
			r_queue.empty();
		}
		prev_nasteroids = game.nasteroids;
	}
}

void Player::InterpretScreen(FramePacket &packet, GameStatus& game)
{
	unsigned short vector_ram[512];
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	int found;

	game.clear();

	/* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
	Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
	Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
	for (int i=0; i<512; ++i)
		vector_ram[i] = (unsigned char)packet.vectorram[2*i] | (unsigned char)packet.vectorram[2*i+1] << 8;

	if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	while (pc < 512)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				found = game.findMatchingAsteroid(game.nasteroids_new,vx, vy, 1, vs);
				if(found > -1)
				{
					game.asteroids_new[game.nasteroids_new]=game.asteroids[found];
				}
				game.asteroids_new[game.nasteroids_new++].set(vx, vy, 1, vs, average_latenz, found);
				break;
			case 0x8ff:
				found = game.findMatchingAsteroid(game.nasteroids_new,vx, vy, 2, vs);
				if(found > -1)
				{
					game.asteroids_new[game.nasteroids_new]=game.asteroids[found];
				}
				game.asteroids_new[game.nasteroids_new++].set(vx, vy, 2, vs, average_latenz, found);
				break;
			case 0x90d:
				found = game.findMatchingAsteroid(game.nasteroids_new,vx, vy, 3, vs);
				if(found > -1)
					game.asteroids_new[game.nasteroids_new]=game.asteroids[found];
				game.asteroids_new[game.nasteroids_new++].set(vx, vy, 3, vs, average_latenz, found);
				break;
			case 0x91a:
				found = game.findMatchingAsteroid(game.nasteroids_new,vx, vy, 4, vs);
				if(found > -1)
					game.asteroids_new[game.nasteroids_new]=game.asteroids[found];
				game.asteroids_new[game.nasteroids_new++].set(vx, vy, 4, vs, average_latenz, found);
				break;
			case 0x929:
				game.saucer_present = true;
				game.saucer_x = vx;
				game.saucer_y = vy;
				game.saucer_size = vs;
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				game.shots[game.nshots++].set(vx, vy);
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					game.ship_present = true;
					game.ship_x = vx;
					game.ship_y = vy;
					game.ship_dx = v1x - dx;
					game.ship_dy = v1y - dy;
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}  
}


void Player::CopyAsteroids(GameStatus& game)
{
	game.nasteroids = game.nasteroids_new;
	for(int i = 0; i < game.nasteroids_new; i++)
	{
		game.asteroids[i] = game.asteroids_new[i];
	}
	for(int i = game.nasteroids; i < MAX_ASTEROIDS; i++)
	{
		if(game.asteroids[i].sf == 100)
			break;
		game.asteroids[i].set(0, 0, 100, 100, 0, -1);
	}
}


void Asteroid::set(int x, int y, int type, int sf, int latenz, int found)
{
	if(found > -1)
	{
		if(latenz)
		{
			// zuknftige Position ermitteln nach latenzzeit
			this->xl = this->x + latenz*(x - this->x);
			this->yl = this->y + latenz*(y - this->y);
			yl_avail = true;
		}
		else
			yl_avail = false;

		if(num_shots)
			num_shots--;
	}
	else
	{
		this->frame_count_a = 0;
		this->num_shots = 0;
		this->timeout = 0;
		this->look_for_shot = 0;
		this->dx_dy_index = 0;
		yl_avail = false;
	}

	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
}

void Asteroid::compute_kreuzprodukt(int ship_x, int ship_y, float ship_dir_x, float ship_dir_y, float foo)
{
	if(frame_error || this->frame_count_a > 400 ||
		(this->frame_count_a > 0 && (abs(this->x - this->prev_asteroid_x) > 500 || abs(this->y - this->prev_asteroid_y) > 380) ))
		this->frame_count_a = 0;


	if(!this->frame_count_a)
	{
		this->initial_asteroid_x = this->x;
		this->initial_asteroid_y = this->y;
		this->prev_asteroid_x = this->x;
		this->prev_asteroid_y = this->y;
		this->current_asteroid_dist_x = 0;
		this->current_asteroid_dist_y = 0;
		this->tp = -1.0;
		this->frame_count_a++;
		this->kreuzprodukt = kreuznorm(ship_dir_x,ship_dir_y,(float)this->dy,(float)this->dx);
		this->bad = true;
		return;
	}

	if(this->frame_count_a < 200)
	{
		this->current_asteroid_dist_x = this->x - this->initial_asteroid_x;
		this->current_asteroid_dist_y = this->y - this->initial_asteroid_y;
		this->current_asteroid_speed_x = (float)this->current_asteroid_dist_x/(float)this->frame_count_a;
		this->current_asteroid_speed_y = (float)this->current_asteroid_dist_y/(float)this->frame_count_a;


		this->prev_asteroid_x = this->x;
		this->prev_asteroid_y = this->y;

		this->frame_count_a++;
	}


	if( DistToFutureShipPosition(
		(float)ship_x, 
		(float)ship_y, 
		(float)this->x + (float)foo*(this->current_asteroid_speed_x),
		(float)this->y + (float)foo*(this->current_asteroid_speed_y), 
		this->current_asteroid_speed_x,
		this->current_asteroid_speed_y,
		this->dx,
		this->dy,
		this->tp) )
	{
		this->bad = false;
	}
	else
	{
		this->bad = true;
	}
	this->kreuzprodukt = kreuznorm(ship_dir_x,ship_dir_y,(float)this->dy,(float)this->dx);
}

bool Asteroid::approx_collision(int ship_x, int ship_y)
{
	if(this->frame_count_a < 2)
		return false;

	float r;

	float a = this->current_asteroid_speed_y;
	float c = this->current_asteroid_speed_x;
	float l = sqrt(a*a+c*c);
	a /= l;
	c /= l;
	float b = -c;
	float d = a;



	int dsa_x = ship_x - this->x;
	int dsa_y = ship_y - this->y;
	while (dsa_x < -512) dsa_x += 1024;
	while (dsa_x > 511) dsa_x -= 1024;
	while (dsa_y < -384) dsa_y += 768;
	while (dsa_y > 383) dsa_y -= 768;

	if(((float)dsa_x*this->current_asteroid_speed_x + (float)dsa_y*this->current_asteroid_speed_y) < 0.0)
	{
		return false;
	}

	float t_dsa_x = a * (float)dsa_x + b * (float)dsa_y;
	float t_dsa_y = c * (float)dsa_x + d * (float)dsa_y;

	switch (this->sf)
	{	
			case 0:  // groer Asteroid
				r = 40.0;
				break;
			case 15: // mittlerer Asteroid
				r = 20.0;
				break;
			case 14: // kleiner Asteroid
				r = 8.0;
				break;
	}

	if(t_dsa_x > 0.0 && (t_dsa_x-30.0) > r)
	{
		return false;
	}
	else if(t_dsa_x <= 0.0 && (t_dsa_x+30.0) < -r)
	{
		return false;
	}

	return true;
}


void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y;
}

GameStatus::GameStatus()
{
	for(int i = 0; i < MAX_ASTEROIDS; i++)
	{
		asteroids[i].set(0, 0, 100, 100, 0, -1);
	}
}


void GameStatus::clear(void)
{
	ship_present = false;
	saucer_present = false;
	nasteroids = 0;
	nasteroids_new = 0;
	nshots = 0;
}

int GameStatus::findMatchingAsteroid(int start_index, int x, int y, int type, int sf)
{
	int found = -1;
	
	for(int i = start_index; i < MAX_ASTEROIDS; i++)
	{
		if(asteroids[i].type == 100)
		{
			found = -1;
			break;
		}
		int dist_x = x - asteroids[i].x;
		int dist_y = y - asteroids[i].y;
		if(asteroids[i].type == type && asteroids[i].sf == sf && (dist_x*dist_x +dist_y*dist_y) < 64)
		{
			found = i;
			break;
		}
	}
	if(found == -1)
	{
		for(int i = 0; i < start_index; i++)
		{
			int dist_x = x - asteroids[i].x;
			int dist_y = y - asteroids[i].y;
			if(asteroids[i].type == type && asteroids[i].sf == sf && (dist_x*dist_x +dist_y*dist_y) < 64)
			{
				found = i;
				break;
			}
		}
	}

	
	return found;
	
}

NamePacket::NamePacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'n';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	signature[6] = 'R';
	signature[7] = '.';
	signature[8] = 'G';
	signature[9] = '.';
	for (int i=10; i<38; i++)
		signature[i] = 0;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}

void Player::SendPacket(NamePacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}




int Player::sync(int dx, int dy, int t, char latenz, char frame_error, unsigned char &index)
{
	static unsigned char c = 0;
	static int prev_t;
	static unsigned char initial = 0;
	static char wait = 0;
	static bool	waiting = false;
	static int x_y[10][2];

	x_y[initial][0] = dx;
	x_y[initial][1] = dy;
	initial++;

	// das geht alles eleganter und schneller, aber wird ja nur selten aufgerufen

	if(frame_error)
	{
		initial=0;
		c = 0;
		return 1;
	}

	if (initial==1)
	{
		if(latenz && !waiting)
		{
			wait = latenz;
			waiting = true;
			initial=0;
			c = 0;
			return 1;
		}
		else if (waiting && wait)
		{
			wait--;
			initial=0;
			c = 0;
			return 1;
		}
		else
		{
			prev_t = t;
			return 1;
		}
	}

	if(++prev_t != t)
	{
		initial=0;
		wait=0;
		waiting=false;
		c = 0;
		return 1;
	}

	if (initial==2)
	{
		return 1;
	}

	if (initial==3)
	{
		while(dx_dy[c][0] != dx && dx_dy[c][1] != dy)
			c++;
		return 1;
	}


	unsigned char new_index = c+initial-3;

	if(dx_dy[new_index][0] == dx && dx_dy[new_index][1] == dy)
	{
		if(initial == 8)
		{
			index = new_index;
			initial = 0;
			c = 0;
			wait=0;
			waiting=false;
			return 0;
		}
		else
		{
			return 1;
		}
	}

	int found = 0;
	unsigned char i;
	unsigned char next_i;
	while(!found)
	{
		c++;
		while(dx_dy[c][0] != x_y[2][0] && dx_dy[c][1] != x_y[2][1])
			c++;

		for(i=3; i<initial; i++)
		{
			next_i=c+i-2;
			if(dx_dy[next_i][0] != x_y[i][0] || dx_dy[next_i][1] != x_y[i][1])
				break;
		}
		if(i == initial)
			found = 1;
	}


	return 1;
}


void Player::find(float x, float y, float& xneu, float& yneu)
{
	xneu = x;
	yneu = y;
	float min = 100.0;
	int min_i;

	unsigned char start_index = fut_dx_dy_index - 18;
	for (int i = 0; i < 36; i++)
	{
		float a = ship_dir[start_index][0] - x;
		float b = ship_dir[start_index][1] - y;
		float c = a*a + b*b;
		if(c < min)
		{
			min = c;
			min_i = start_index;
		}
		start_index++;
	}
	xneu = ship_dir[min_i][0];
	yneu = ship_dir[min_i][1];

	return;
}



void Asteroid::find(float x, float y, float& xneu, float& yneu)
{
	xneu = x;
	yneu = y;
	float min = 100.0;
	int min_i,mm;

	unsigned char start_index = fut_dx_dy_index - 18;
	for (int i = 0; i < 36; i++)
	{
		float a = ship_dir[start_index][0] - x;
		float b = ship_dir[start_index][1] - y;
		float c = a*a + b*b;
		if(c < min)
		{
			min = c;
			min_i = start_index;
			mm = i;
		}
		start_index++;
	}
	xneu = ship_dir[min_i][0];
	yneu = ship_dir[min_i][1];

	return;
}


float Asteroid::approx_mp(int dx, int dy, float ship_dir_x, float ship_dir_y, int dist)
{
	float l = sqrt((float)(this->dx*this->dx + this->dy*this->dy));
	float dxn = (float)this->dx/l;
	float dyn = (float)this->dy/l;


	this->vp = ship_dir_x * dxn + ship_dir_y * dyn;
	if(this->vp > 1.0)
		this->vp = 1.0;
	else if(this->vp < -1.0)
		this->vp = -1.0;
		
	float w = acos(this->vp);
	if(this->tp > 0.0)
	{
		return(this->tp + w/0.073631);
	}
	this->tp = sqrt((float)dist)/8.0;
	return(this->tp);
}

void Asteroid::print_asteroid(int id)
{
	printf("Asteroid-ID %d Type %d SF %d\n",id,type,sf);
	printf("x\t%d\ty\t%d\n",x,y);
	printf("px\t%d\tpy\t%d\n",prev_asteroid_x,prev_asteroid_y);
	printf("dx\t%d\tdy\t%d\n",dx,dy);
	printf("ix\t%d\tiy\t%d\n",initial_asteroid_x,initial_asteroid_y);
	printf("cdx\t%d\tcdy\t%d\n",current_asteroid_dist_x,current_asteroid_dist_y);
	printf("sx\t%f\tsy\t%f\n",current_asteroid_speed_x,current_asteroid_speed_y);
	printf("kreuzprodukt %f\n",kreuzprodukt);
	printf("dist %d\n",dist);
	printf("framecount %d\t timeout %d\n",frame_count_a,timeout);


}