#pragma once

#define PI 3.141592653589793 
#define C_ALL 0
#define C_ANGLE 1
#define C_LENGTH 2

class Vector
{
public:
	double x,y,z;

	Vector(void) { x=y=z=0.0; }
	Vector(double _x, double _y, double _z=0.0) { x=_x; y=_y; z=_z; }

	bool isAbout(double dPercentage, Vector& v, int Compare=0);
	void Set(double _x, double _y, double _z=0.0) { x=_x; y=_y; z=_z; }
	double GetLength();
	double GetAngle();
	double GetSqrLength() const;
	Vector Negate();
	Vector Normalize();
	double DistanceToRay(Vector RayPos, Vector RayDir);
	double AngleWith(Vector &v);
	void Difference (const Vector &u, const Vector &v);

	void operator += (const Vector &v);
	void operator -= (const Vector &v);
	void operator *= (double d);
	void operator /= (double d);

	double		operator * (const Vector &v) const;
	Vector		operator * (const double d) const;
	Vector		operator / (const double d) const;
	Vector		operator + (const Vector &v) const;
	Vector		operator - (const Vector &v) const;

	void Cross(const Vector &u, const Vector &v);
};
