﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.Windows;
using System.Diagnostics;


namespace ct.Asteroid
{
   public class TPlayer
   {
       const int VCTR = 0x9;   // long vector 0-9
       const int LABS = 0xa;   // set vector position
       const int HALT = 0xb;   // halt application
       const int JSRL = 0xc;   // push subroutine 
       const int RTSL = 0xd;   // pop subroutine
       const int JMPL = 0xe;   // jump
       const int SVEC = 0xf;   // short vector

       private TraceSource TSPlayer = new TraceSource("TraceSourcePlayer");

	   Socket mySocket;
	   IPAddress server_ip;
        
       public TPlayer(Socket aSocket, IPAddress aServer)
       {
           mySocket = aSocket;
           server_ip = aServer;
       }

       ~TPlayer()
       {
           TSPlayer.Close();
           TSPlayer.Flush();
       }

       private int getRadiusOfDist(TOrb aOrb)
       {
           int r = 1;
           if (aOrb.LastDistanceTo > 400) r = 1;
           else if (aOrb.LastDistanceTo > 300) r = 1;
           else if (aOrb.LastDistanceTo > 200) r = 2;
           else if (aOrb.LastDistanceTo > 100) r = 2;
           else if (aOrb.LastDistanceTo > 75) r = 3;
           else if (aOrb.LastDistanceTo > 50) r = 3;
           else if (aOrb.LastDistanceTo > 25) r = 4;
           else r = 5;

           if (aOrb.Size() > 16)
               r = 2 * r;

           return r;
       }

       public void Run()
       {
          TFramePacket frame = new TFramePacket();
          TKeysPacket keys = new TKeysPacket();
          TOrbit orbit = new TOrbit();
          char prevFrameNo = (char)0;
          SortedList<double, TOrb> al = new SortedList<double, TOrb>();
          TOrb targetOrb = null;
          TOrb lastTargetOrb = null;
          int t = 0;
          int lastT = 0;
          int tu = 0;
          bool fire = false;
          Random rnd = new Random();

          for (;;)
          {
            Thread.Sleep(1);
            keys.IncPingNo();   // jedes gesendete Päckchen erhält eine individuelle Nummer zur Latenzmessung
            SendPacket(keys);
            frame = ReceivePacket();
            if (frame == null) continue;

            if (frame.FrameNo != ++prevFrameNo || frame.PingNo != keys.PingNo)
            {
                orbit.Latenz = keys.PingNo - frame.PingNo;
                prevFrameNo = frame.FrameNo;
            }

            InterpretScreen(frame, orbit);

            if ( (orbit.AsteroidsCnt <= 0) && (orbit.ShotsCnt <= 0) && (!orbit.Ufo.Visible) ) continue;

            keys.Clear();   // alle Tasten loslassen
            al.Clear();
		        
            ++t;                    // Zeit
		        
            if (orbit.Ship.Visible)
            {
              double min_dist = 0x7fffffff;
              double vs = 0;

              if (orbit.Ufo.Visible)
              {
                ++tu;
                for (int i = 0; i < orbit.AsteroidsCnt; ++i) {
                  // nächstgelegenen Asteroiden suchen
                  double dist2 = orbit.Ship.DistanceTo(orbit.Asteroids[i], ref vs);
                  if ( al.IndexOfKey(dist2) < 0 ) {
                    al.Add (dist2, orbit.Asteroids[i]);
                    if (dist2 < min_dist)
                      min_dist = dist2;
                  }
                }
                if (min_dist > 3 * orbit.ShotSpeed)
                {
                    if (orbit.Ufo.Size() <= 20)
                        al.Clear();
                    double dist = orbit.Ship.DistanceTo(orbit.Ufo, ref vs);
                    al.Add(dist, orbit.Ufo);
                    if (dist < min_dist)
                        min_dist = dist;
                }
              }
              else {
                tu = 0;
                for (int i = 0; i < orbit.AsteroidsCnt; ++i) {
                  // nächstgelegenen Asteroiden suchen
                  double dist = orbit.Ship.DistanceTo(orbit.Asteroids[i], ref vs);
                  if ( al.IndexOfKey(dist) < 0 ) {
                    al.Add (dist, orbit.Asteroids[i]);
                    if (dist < min_dist) 
                        min_dist = dist;
                  }
                }
              }

              int found = -1;
              for (int i = 0; i < al.Count; i++)
              {
                  if ((al.Values[i].Size() > 16) || (!orbit.CheckDangerShots(al.Values[i])) || (!orbit.CheckVirtualDangerShots(al.Values[i])))
                  //                  if ((!orbit.CheckDangerShots(al.Values[i])) || (!orbit.CheckVirtualDangerShots(al.Values[i])))
                  {
                      found = i;
                      break;
                  }
              }
              if (found != -1)
                  targetOrb = al.Values[found];
              else if (al.Count > 0)
                  targetOrb = al.Values[0];

              if (min_dist <= orbit.ShotSpeed)
              { // Flucht, wenn Kollision unausweichlich
                  keys.Hyperspace(true);
                  continue;
              }

              if (orbit.DangerShot() && (orbit.Ufo.Visible))
              {  // gefährlicher schuss im Anflug...
                  keys.Hyperspace(true);
                  continue;
              }

              // Schiff in Richtung auf das nächstgelegene Objekt drehen
              if ( (al.Count > 0) && ((orbit.Asteroids.Count > 0) || (orbit.Ufo.Visible)) ) 
              {
                double wt = orbit.TargetAngle(targetOrb);
              
                int wp = 0;
                double wd = 0.0;
                wp = orbit.TurnDirection(wt, ref wd);
                if ((Math.Abs(wd) >= 10) || (t % 2 == 0))
                if (wp > 0)
                {
                    keys.Left(true);
                }
                else
                {
                    keys.Right(true);
                }

                if ((Math.Abs(wd) < getRadiusOfDist(targetOrb)) || (min_dist <= 2 * orbit.ShotSpeed))
                    if ((lastTargetOrb != targetOrb) || (t >= lastT + 2))
                        fire = true;
                    else
                        lastTargetOrb = null;

                if (fire && (t >= lastT + 2) && (min_dist < TOrbit.CMaxShotDist)) // Feuerknopf drücken, so schnell es geht
                {
                     lastT = t;
                     lastTargetOrb = targetOrb;
                     fire = false;
                     keys.Fire(true);
                }
                else if ((!fire) && (t >= lastT + 2))
                {
                    double sa = orbit.ShipAngle;
                    for (int i = 0; i < al.Count; i++)
                    {
                        if (al.Values[i] != targetOrb)
                        {
                            double ta = orbit.TargetAngle(al.Values[i]);
                            if ((al.Values[i].LastDistanceTo < TOrbit.CMaxShotDist) &&
                                (Math.Abs(ta - sa) < (getRadiusOfDist(al.Values[i]))))
                            {
                                lastT = t;
                                lastTargetOrb = al.Values[i];
                                keys.Fire(true);
                                break;
                            }
                        }
                    }

                }
              }

              // beschleunigen um ufo zu erreichen
              //if (((tu > 0) && (tu % 5 == 0)) || ((orbit.AsteroidsCnt > 0) && (t % 65 == 0)))
              //    keys.Thrust(true);

            }
          }
       }

       unsafe void InterpretScreen(TFramePacket aPacket, TOrbit aOrbit)
       {
          ushort[] vector_ram = aPacket.vectorram2;
          Vector direction = new Vector { X = 0, Y = 0 }; 
          int sf;
          int vz = 0, vs = 0;
          Vector v = new Vector { X = 0, Y = 0 };
          Vector v1 = new Vector { X = 0, Y = 0 };
          int shipdetect = 0;

	        aOrbit.BeginUpdate();
	        try
	        {
	          if (aPacket.vectorram[1] != 0xe0 && aPacket.vectorram[1] != 0xe2)
		          return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	          int pc = 1;
              for (; pc < 513; )
	          {
              int op = vector_ram[pc] >> 12; ;
		          switch (op)
		          {
		          case LABS: 
			          v.Y = vector_ram[pc] & 0x3ff;
			          v.X = vector_ram[pc+1] & 0x3ff;
			          vs = vector_ram[pc+1] >> 12;
                      break;
		          case HALT: 
			          return;
		          case JSRL:  
			          switch (vector_ram[pc] & 0xfff)
			          {
                case 0x880: // Explosion groß (3)
                    break;
                case 0x896: // 	Explosion (2)
                    break;
                case 0x8B5: // 	Explosion (1)
                    break;
                case 0x8D0: // 	Explosion klein (0)
                    break;
                case 0x8f3:
                  aOrbit.UpdateAsteroid(v, vs, 1);
				          break;
			          case 0x8ff:
                  aOrbit.UpdateAsteroid(v, vs, 2);
				          break;
			          case 0x90d:
                  aOrbit.UpdateAsteroid(v, vs, 3);
				          break;
			          case 0x91a:
                  aOrbit.UpdateAsteroid(v, vs, 4);
				          break;
			          case 0x929:
                  aOrbit.UpdateUfo(v, vs, true);
				          break;
			          }  
			          break;
		          case RTSL: 
			          return;
		          case JMPL: 
			          /*
			          pc = vector_ram[pc] & 0xfff;
			          break;
			          */
			          return;
		          case SVEC: 
                      /*
                      direction.Y = vector_ram[pc] & 0x300;
                      if ((vector_ram[pc] & 0x400) != 0)
                          direction.Y = -direction.Y;
                      direction.X = (vector_ram[pc] & 3) << 8;
                      if ((vector_ram[pc] & 4) != 0)
                          direction.X = -direction.X;
                      sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
                      vz = (vector_ram[pc] & 0xf0) >> 4;
                      */
                      break;
		          default: // VCTR 0-9
                direction.Y = vector_ram[pc] & 0x3ff;
			          if ((vector_ram[pc] & 0x400) != 0)
				          direction.Y = -direction.Y;
  				        
			          direction.X = vector_ram[pc+1] & 0x3ff;
			          if ((vector_ram[pc+1] & 0x400) != 0)
                        direction.X = -direction.X;
                  
                sf = op;
			          vz = vector_ram[pc+1] >> 12;

                if (direction.X == 0 && direction.Y == 0 && vz == 15)
                {
                    aOrbit.UpdateShot(v);
                }
  				        
			          if (op == 6 && vz == 12 && direction.X != 0 && direction.Y != 0)
			          {
				          switch (shipdetect)
				          {
				          case 0:
					          v1 = direction;
					          ++shipdetect;
					          break;
				          case 1:
                    aOrbit.UpdateShip(v, vz, true, v1 - direction);
					          ++shipdetect;
					          break;
				          }
			          }
			          else if (shipdetect == 1)
				          shipdetect = 0;

			          break;
		          }
		          if (op <= 0xa)
			          ++pc;
		          if (op != 0xe) // JMPL
			          ++pc;
	          }   
	        }
	        finally
	        {
	          aOrbit.EndUpdate();
	        }  
       }

       void SendPacket(TKeysPacket aPacket)
       {
            byte[] bytCommand = aPacket.ToByteArray();

            int pret = mySocket.SendTo(bytCommand, bytCommand.Length, SocketFlags.None, new IPEndPoint(server_ip, 1979));
       }

       public TFramePacket ReceivePacket()
       {
            if (mySocket.Available == 0) return null;

            int received = 0;

            EndPoint myRemoteEndpoint = new IPEndPoint(server_ip, 1979);
            
            byte[] receiveBytes = new byte[mySocket.Available];

            try
            {
                received = mySocket.ReceiveFrom(receiveBytes, ref myRemoteEndpoint);
            }
            catch (Exception e)
            {
                Console.WriteLine("Exception in ReceivePacket():" + e.Message);
                
            }

            if (received > 0)
                return TFramePacket.FromByteArray(receiveBytes);
            else
                return null;
       }     
    }
}
